/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormatterImpl;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.CompositeLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PlainTextTokenTypes;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.FormattingModeAwareIndentAdjuster;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.autodetect.DetectedIndentOptionsNotificationProvider;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerRunnable;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.psi.impl.source.codeStyle.IndentImpl;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleManagerImpl
extends CodeStyleManager
implements FormattingModeAwareIndentAdjuster {
    private static final Logger LOG = Logger.getInstance(CodeStyleManagerImpl.class);
    private static final ThreadLocal<ProcessingUnderProgressInfo> SEQUENTIAL_PROCESSING_ALLOWED = ThreadLocal.withInitial(() -> new ProcessingUnderProgressInfo());
    private final ThreadLocal<FormattingMode> myCurrentFormattingMode = ThreadLocal.withInitial(() -> FormattingMode.REFORMAT);
    private final FormatterTagHandler myTagHandler;
    private final Project myProject;
    @NonNls
    private static final String DUMMY_IDENTIFIER = "xxx";

    public CodeStyleManagerImpl(Project project2) {
        this.myProject = project2;
        this.myTagHandler = new FormatterTagHandler(this.getSettings());
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(0);
        }
        return project2;
    }

    @NotNull
    public PsiElement reformat(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = this.reformat(element, false);
        if (psiElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement reformat(@NotNull PsiElement element, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(3);
        }
        CheckUtil.checkWritable(element);
        if (!SourceTreeToPsiMap.hasTreeElement(element)) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        ASTNode treeElement = element.getNode();
        PsiElement formatted = new CodeFormatterFacade(this.getSettings(), element.getLanguage()).processElement(treeElement).getPsi();
        if (!canChangeWhiteSpacesOnly) {
            PsiElement psiElement = this.postProcessElement(formatted);
            if (psiElement == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        PsiElement psiElement = formatted;
        if (psiElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    private PsiElement postProcessElement(@NotNull PsiElement formatted) {
        if (formatted == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(7);
        }
        PsiElement result2 = formatted;
        if (this.getSettings().FORMATTER_TAGS_ENABLED && formatted instanceof PsiFile) {
            this.postProcessEnabledRanges((PsiFile)formatted, formatted.getTextRange(), this.getSettings());
        } else {
            for (PostFormatProcessor postFormatProcessor : (PostFormatProcessor[])Extensions.getExtensions(PostFormatProcessor.EP_NAME)) {
                result2 = postFormatProcessor.processElement(result2, this.getSettings());
            }
        }
        return result2;
    }

    private void postProcessText(@NotNull PsiFile file2, @NotNull TextRange textRange) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(8);
        }
        if (textRange == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(9);
        }
        if (!this.getSettings().FORMATTER_TAGS_ENABLED) {
            TextRange currentRange = textRange;
            for (PostFormatProcessor myPostFormatProcessor : (PostFormatProcessor[])Extensions.getExtensions(PostFormatProcessor.EP_NAME)) {
                currentRange = myPostFormatProcessor.processText(file2, currentRange, this.getSettings());
            }
        } else {
            this.postProcessEnabledRanges(file2, textRange, this.getSettings());
        }
    }

    public PsiElement reformatRange(@NotNull PsiElement element, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(10);
        }
        return this.reformatRangeImpl(element, startOffset, endOffset, canChangeWhiteSpacesOnly);
    }

    public PsiElement reformatRange(@NotNull PsiElement element, int startOffset, int endOffset) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(11);
        }
        return this.reformatRangeImpl(element, startOffset, endOffset, false);
    }

    private static void transformAllChildren(ASTNode file2) {
        ((TreeElement)file2).acceptTree(new RecursiveTreeElementWalkingVisitor(){});
    }

    public void reformatText(@NotNull PsiFile file2, int startOffset, int endOffset) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(12);
        }
        this.reformatText(file2, Collections.singleton(new TextRange(startOffset, endOffset)));
    }

    public void reformatText(@NotNull PsiFile file2, @NotNull Collection<TextRange> ranges) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(13);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(14);
        }
        this.reformatText(file2, ranges, null);
    }

    public void reformatTextWithContext(@NotNull PsiFile file2, @NotNull ChangedRangesInfo info) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(15);
        }
        if (info == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(16);
        }
        FormatTextRanges formatRanges = new FormatTextRanges(info);
        this.reformatText(file2, formatRanges, null, true);
    }

    public void reformatText(@NotNull PsiFile file2, @NotNull Collection<TextRange> ranges, @Nullable Editor editor) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(17);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(18);
        }
        FormatTextRanges formatRanges = new FormatTextRanges();
        ranges.forEach(range -> formatRanges.add((TextRange)range, true));
        this.reformatText(file2, formatRanges, editor, false);
    }

    private void reformatText(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges, @Nullable Editor editor, boolean reformatContext) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(19);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(20);
        }
        if (ranges.isEmpty()) {
            return;
        }
        boolean isFullReformat = ranges.isFullReformat(file2);
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        CheckUtil.checkWritable((PsiElement)file2);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file2)) {
            return;
        }
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)file2);
        CodeStyleManagerImpl.transformAllChildren(treeElement);
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(this.getSettings(), file2.getLanguage());
        codeFormatter.setReformatContext(reformatContext);
        LOG.assertTrue(file2.isValid(), (Object)("File name: " + file2.getName() + " , class: " + file2.getClass().getSimpleName()));
        if (editor == null) {
            editor = PsiUtilBase.findEditor((PsiElement)file2);
        }
        CaretPositionKeeper caretKeeper = null;
        if (editor != null) {
            caretKeeper = new CaretPositionKeeper(editor, this.getSettings(), file2.getLanguage());
        }
        if (FormatterUtil.isFormatterCalledExplicitly()) {
            CodeStyleManagerImpl.removeEndingWhiteSpaceFromEachRange(file2, ranges);
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.getProject());
        ArrayList<RangeFormatInfo> infos = new ArrayList<RangeFormatInfo>();
        for (TextRange range : ranges.getTextRanges()) {
            PsiElement start = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, range.getStartOffset());
            PsiElement end = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, range.getEndOffset());
            if (start != null && !start.isValid()) {
                LOG.error("start=" + start + "; file=" + file2);
            }
            if (end != null && !end.isValid()) {
                LOG.error("end=" + start + "; end=" + file2);
            }
            boolean formatFromStart = range.getStartOffset() == 0;
            boolean formatToEnd = range.getEndOffset() == file2.getTextLength();
            infos.add(new RangeFormatInfo(start == null ? null : smartPointerManager.createSmartPsiElementPointer(start), end == null ? null : smartPointerManager.createSmartPsiElementPointer(end), formatFromStart, formatToEnd));
        }
        codeFormatter.processText(file2, ranges, true);
        for (RangeFormatInfo info : infos) {
            PsiElement endElement;
            PsiElement startElement = info.startPointer == null ? null : info.startPointer.getElement();
            PsiElement psiElement = endElement = info.endPointer == null ? null : info.endPointer.getElement();
            if ((startElement != null || info.fromStart) && (endElement != null || info.toEnd)) {
                this.postProcessText(file2, new TextRange(info.fromStart ? 0 : startElement.getTextRange().getStartOffset(), info.toEnd ? file2.getTextLength() : endElement.getTextRange().getEndOffset()));
            }
            if (info.startPointer != null) {
                smartPointerManager.removePointer(info.startPointer);
            }
            if (info.endPointer == null) continue;
            smartPointerManager.removePointer(info.endPointer);
        }
        if (caretKeeper != null) {
            caretKeeper.restoreCaretPosition();
        }
        if (editor instanceof EditorEx && isFullReformat) {
            ((EditorEx)editor).reinitSettings();
            DetectedIndentOptionsNotificationProvider.updateIndentNotification(file2, true);
        }
    }

    private static void removeEndingWhiteSpaceFromEachRange(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(21);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(22);
        }
        for (FormatTextRange formatRange : ranges.getRanges()) {
            PsiElement prev;
            TextRange range = formatRange.getTextRange();
            int rangeStart = range.getStartOffset();
            int rangeEnd = range.getEndOffset();
            PsiElement lastElementInRange = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, rangeEnd);
            if (!(lastElementInRange instanceof PsiWhiteSpace) || rangeStart >= lastElementInRange.getTextRange().getStartOffset() || (prev = lastElementInRange.getPrevSibling()) == null) continue;
            int newEnd = prev.getTextRange().getEndOffset();
            formatRange.setTextRange(new TextRange(rangeStart, newEnd));
        }
    }

    private PsiElement reformatRangeImpl(@NotNull PsiElement element, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(23);
        }
        LOG.assertTrue(element.isValid());
        CheckUtil.checkWritable(element);
        if (!SourceTreeToPsiMap.hasTreeElement(element)) {
            return element;
        }
        ASTNode treeElement = element.getNode();
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(this.getSettings(), element.getLanguage());
        PsiElement formatted = codeFormatter.processRange(treeElement, startOffset, endOffset).getPsi();
        return canChangeWhiteSpacesOnly ? formatted : this.postProcessElement(formatted);
    }

    public void reformatNewlyAddedElement(@NotNull ASTNode parent, @NotNull ASTNode addedElement) throws IncorrectOperationException {
        FormattingModelBuilder builder;
        if (parent == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(24);
        }
        if (addedElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(25);
        }
        LOG.assertTrue(addedElement.getTreeParent() == parent, (Object)"addedElement must be added to parent");
        PsiElement psiElement = parent.getPsi();
        PsiFile containingFile = psiElement.getContainingFile();
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (fileViewProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            containingFile = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        }
        TextRange textRange = addedElement.getTextRange();
        Document document = fileViewProvider.getDocument();
        if (document instanceof DocumentWindow) {
            containingFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getTopLevelFile((PsiElement)containingFile);
            textRange = ((DocumentWindow)document).injectedToHost(textRange);
        }
        if ((builder = LanguageFormatting.INSTANCE.forContext((PsiElement)containingFile)) != null) {
            FormattingModel model = CoreFormatterUtil.buildModel(builder, (PsiElement)containingFile, this.getSettings(), FormattingMode.REFORMAT);
            FormatterEx.getInstanceEx().formatAroundRange(model, this.getSettings(), containingFile, textRange);
        }
        this.adjustLineIndent(containingFile, textRange);
    }

    public int adjustLineIndent(@NotNull PsiFile file2, int offset) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(26);
        }
        DetectedIndentOptionsNotificationProvider.updateIndentNotification(file2, false);
        return (Integer)PostprocessReformattingAspect.getInstance(file2.getProject()).disablePostprocessFormattingInside(() -> {
            if (file2 == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(57);
            }
            return this.doAdjustLineIndentByOffset(file2, offset, FormattingMode.ADJUST_INDENT);
        });
    }

    @Nullable
    static PsiElement findElementInTreeWithFormatterEnabled(PsiFile file2, int offset) {
        PsiElement bottomost = file2.findElementAt(offset);
        if (bottomost != null && LanguageFormatting.INSTANCE.forContext(bottomost) != null) {
            return bottomost;
        }
        Language fileLang = file2.getLanguage();
        if (fileLang instanceof CompositeLanguage) {
            return file2.getViewProvider().findElementAt(offset, fileLang);
        }
        return bottomost;
    }

    public int adjustLineIndent(@NotNull Document document, int offset, FormattingMode mode) {
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(27);
        }
        return (Integer)PostprocessReformattingAspect.getInstance(this.getProject()).disablePostprocessFormattingInside(() -> {
            if (document == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(56);
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            documentManager.commitDocument(document);
            PsiFile file2 = documentManager.getPsiFile(document);
            if (file2 == null) {
                return offset;
            }
            return this.doAdjustLineIndentByOffset(file2, offset, mode);
        });
    }

    public int adjustLineIndent(@NotNull Document document, int offset) {
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(28);
        }
        return this.adjustLineIndent(document, offset, FormattingMode.ADJUST_INDENT);
    }

    private int doAdjustLineIndentByOffset(@NotNull PsiFile file2, int offset, FormattingMode mode) {
        Integer result2;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(29);
        }
        return (result2 = (Integer)new CodeStyleManagerRunnable<Integer>(this, mode){

            @Override
            protected Integer doPerform(int offset, TextRange range) {
                return FormatterEx.getInstanceEx().adjustLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }

            @Override
            protected Integer computeValueInsidePlainComment(PsiFile file2, int offset, Integer defaultValue) {
                return CharArrayUtil.shiftForward((CharSequence)file2.getViewProvider().getContents(), (int)offset, (String)" \t");
            }

            @Override
            protected Integer adjustResultForInjected(Integer result2, DocumentWindow documentWindow) {
                return result2 != null ? Integer.valueOf(documentWindow.hostToInjected(result2.intValue())) : null;
            }
        }.perform(file2, offset, null, null)) != null ? result2 : offset;
    }

    public void adjustLineIndent(@NotNull PsiFile file2, TextRange rangeToAdjust) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(30);
        }
        new CodeStyleManagerRunnable<Object>(this, FormattingMode.ADJUST_INDENT){

            @Override
            protected Object doPerform(int offset, TextRange range) {
                FormatterEx.getInstanceEx().adjustLineIndentsForRange(this.myModel, this.mySettings, this.myIndentOptions, range);
                return null;
            }
        }.perform(file2, -1, rangeToAdjust, null);
    }

    @Nullable
    public String getLineIndent(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(31);
        }
        return new CodeStyleManagerRunnable<String>(this, FormattingMode.ADJUST_INDENT){

            @Override
            protected boolean useDocumentBaseFormattingModel() {
                return false;
            }

            @Override
            protected String doPerform(int offset, TextRange range) {
                return FormatterEx.getInstanceEx().getLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }
        }.perform(file2, offset, null, null);
    }

    @Nullable
    public String getLineIndent(@NotNull Document document, int offset) {
        PsiFile file2;
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(32);
        }
        if ((file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document)) == null) {
            return "";
        }
        return this.getLineIndent(file2, offset);
    }

    public boolean isLineToBeIndented(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(33);
        }
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file2)) {
            return false;
        }
        CharSequence chars = file2.getViewProvider().getContents();
        int start = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (start > 0 && chars.charAt(start) != '\n' && chars.charAt(start) != '\r') {
            return false;
        }
        int end = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
        if (end >= chars.length()) {
            return false;
        }
        ASTNode element = SourceTreeToPsiMap.psiElementToTree(CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, end));
        if (element == null) {
            return false;
        }
        if (element.getElementType() == TokenType.WHITE_SPACE) {
            return false;
        }
        if (element.getElementType() == PlainTextTokenTypes.PLAIN_TEXT) {
            return false;
        }
        return !this.getSettings().KEEP_FIRST_COLUMN_COMMENT || !CodeStyleManagerImpl.isCommentToken(element) || IndentHelper.getInstance().getIndent(this.myProject, file2.getFileType(), element, true) != 0;
    }

    private static boolean isCommentToken(ASTNode element) {
        Language language = element.getElementType().getLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter instanceof CodeDocumentationAwareCommenter) {
            CodeDocumentationAwareCommenter documentationAwareCommenter = (CodeDocumentationAwareCommenter)commenter;
            return element.getElementType() == documentationAwareCommenter.getBlockCommentTokenType() || element.getElementType() == documentationAwareCommenter.getLineCommentTokenType();
        }
        return false;
    }

    private static boolean isWhiteSpaceSymbol(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    @Nullable
    public static TextRange insertNewLineIndentMarker(@NotNull PsiFile file2, @NotNull Document document, int offset) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(34);
        }
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(35);
        }
        CharSequence text2 = document.getImmutableCharSequence();
        if (offset <= 0 || offset >= text2.length() || !CodeStyleManagerImpl.isWhiteSpaceSymbol(text2.charAt(offset))) {
            return null;
        }
        if (!CodeStyleManagerImpl.isWhiteSpaceSymbol(text2.charAt(offset - 1))) {
            return null;
        }
        for (int end = offset; end < text2.length() && text2.charAt(end) != '\n'; ++end) {
            if (CodeStyleManagerImpl.isWhiteSpaceSymbol(text2.charAt(end))) continue;
            return null;
        }
        CodeStyleManagerImpl.setSequentialProcessingAllowed(false);
        String dummy = CodeStyleManagerImpl.createDummy(file2);
        document.insertString(offset, (CharSequence)dummy);
        return new TextRange(offset, offset + dummy.length());
    }

    @NotNull
    private static String createDummy(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(36);
        }
        Language language = file2.getLanguage();
        PsiComment comment = null;
        try {
            comment = PsiParserFacade.SERVICE.getInstance((Project)file2.getProject()).createLineOrBlockCommentFromText(language, "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String text2 = comment != null ? comment.getText() : null;
        String string = text2 != null ? text2 : DUMMY_IDENTIFIER;
        if (string == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(37);
        }
        return string;
    }

    @Nullable
    public static PsiElement findWhiteSpaceNode(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(38);
        }
        return (PsiElement)CodeStyleManagerImpl.doFindWhiteSpaceNode((PsiFile)file2, (int)offset).first;
    }

    @NotNull
    private static Pair<PsiElement, CharTable> doFindWhiteSpaceNode(@NotNull PsiFile file2, int offset) {
        ASTNode astNode;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(39);
        }
        if (!((astNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)file2)) instanceof FileElement)) {
            Pair pair2 = new Pair(null, null);
            if (pair2 == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(40);
            }
            return pair2;
        }
        PsiElement elementAt = InjectedLanguageUtil.findInjectedElementNoCommit(file2, offset);
        CharTable charTable = ((FileElement)astNode).getCharTable();
        if (elementAt == null) {
            elementAt = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, offset);
        }
        if (elementAt == null) {
            Pair pair3 = new Pair(null, (Object)charTable);
            if (pair3 == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(41);
            }
            return pair3;
        }
        ASTNode node = elementAt.getNode();
        if (node == null || node.getElementType() != TokenType.WHITE_SPACE) {
            Pair pair4 = new Pair(null, (Object)charTable);
            if (pair4 == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(42);
            }
            return pair4;
        }
        Pair pair5 = Pair.create((Object)elementAt, (Object)charTable);
        if (pair5 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(43);
        }
        return pair5;
    }

    public Indent getIndent(String text2, FileType fileType) {
        int indent = IndentHelperImpl.getIndent(this.myProject, fileType, text2, true);
        int indentLevel = indent / 10000;
        int spaceCount = indent - indentLevel * 10000;
        return new IndentImpl(this.getSettings(), indentLevel, spaceCount, fileType);
    }

    public String fillIndent(Indent indent, FileType fileType) {
        IndentImpl indent1 = (IndentImpl)indent;
        int indentLevel = indent1.getIndentLevel();
        int spaceCount = indent1.getSpaceCount();
        if (indentLevel < 0) {
            spaceCount += indentLevel * this.getSettings().getIndentSize(fileType);
            indentLevel = 0;
            if (spaceCount < 0) {
                spaceCount = 0;
            }
        } else if (spaceCount < 0) {
            int v = (-spaceCount + this.getSettings().getIndentSize(fileType) - 1) / this.getSettings().getIndentSize(fileType);
            spaceCount += v * this.getSettings().getIndentSize(fileType);
            if ((indentLevel -= v) < 0) {
                indentLevel = 0;
            }
        }
        return IndentHelperImpl.fillIndent(this.myProject, fileType, indentLevel * 10000 + spaceCount);
    }

    public Indent zeroIndent() {
        return new IndentImpl(this.getSettings(), 0, 0, null);
    }

    @NotNull
    private CodeStyleSettings getSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
        if (codeStyleSettings == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(44);
        }
        return codeStyleSettings;
    }

    public boolean isSequentialProcessingAllowed() {
        return SEQUENTIAL_PROCESSING_ALLOWED.get().isAllowed();
    }

    public static void setSequentialProcessingAllowed(boolean allowed) {
        ProcessingUnderProgressInfo info = SEQUENTIAL_PROCESSING_ALLOWED.get();
        if (allowed) {
            info.decrement();
        } else {
            info.increment();
        }
    }

    public void performActionWithFormatterDisabled(Runnable r) {
        this.performActionWithFormatterDisabled(() -> {
            r.run();
            return null;
        });
    }

    public <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> r) throws T {
        Throwable[] throwable = new Throwable[1];
        this.performActionWithFormatterDisabled(() -> {
            try {
                r.run();
            }
            catch (Throwable t) {
                throwable[0] = t;
            }
            return null;
        });
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    public <T> T performActionWithFormatterDisabled(Computable<T> r) {
        return ((FormatterImpl)FormatterEx.getInstance()).runWithFormattingDisabled(() -> {
            PostprocessReformattingAspect component = PostprocessReformattingAspect.getInstance(this.getProject());
            return component.disablePostprocessFormattingInside(r);
        });
    }

    private void postProcessEnabledRanges(@NotNull PsiFile file2, @NotNull TextRange range, CodeStyleSettings settings) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(45);
        }
        if (range == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(46);
        }
        List<TextRange> enabledRanges = this.myTagHandler.getEnabledRanges((ASTNode)file2.getNode(), range);
        int delta = 0;
        for (TextRange enabledRange : enabledRanges) {
            enabledRange = enabledRange.shiftRight(delta);
            for (PostFormatProcessor processor2 : (PostFormatProcessor[])Extensions.getExtensions(PostFormatProcessor.EP_NAME)) {
                TextRange processedRange = processor2.processText(file2, enabledRange, settings);
                delta += processedRange.getLength() - enabledRange.getLength();
            }
        }
    }

    public FormattingMode getCurrentFormattingMode() {
        return this.myCurrentFormattingMode.get();
    }

    void setCurrentFormattingMode(@NotNull FormattingMode mode) {
        if (mode == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(47);
        }
        this.myCurrentFormattingMode.set(mode);
    }

    public int getSpacing(@NotNull PsiFile file2, int offset) {
        FormattingModel model;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(48);
        }
        return (model = CodeStyleManagerImpl.createFormattingModel(file2)) == null ? -1 : FormatterEx.getInstance().getSpacingForBlockAtOffset(model, offset);
    }

    public int getMinLineFeeds(@NotNull PsiFile file2, int offset) {
        FormattingModel model;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(49);
        }
        return (model = CodeStyleManagerImpl.createFormattingModel(file2)) == null ? -1 : FormatterEx.getInstance().getMinLineFeedsBeforeBlockAtOffset(model, offset);
    }

    @Nullable
    private static FormattingModel createFormattingModel(@NotNull PsiFile file2) {
        FormattingModelBuilder builder;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(50);
        }
        if ((builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file2)) == null) {
            return null;
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)file2.getProject());
        return builder.createModel((PsiElement)file2, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithDocCommentFormattingDisabled(@NotNull PsiFile file2, @NotNull Runnable runnable2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(51);
        }
        if (runnable2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(52);
        }
        DocCommentSettings docSettings = this.getDocCommentSettings(file2);
        boolean currDocFormattingEnabled = docSettings.isDocFormattingEnabled();
        docSettings.setDocFormattingEnabled(false);
        try {
            runnable2.run();
        }
        finally {
            docSettings.setDocFormattingEnabled(currDocFormattingEnabled);
        }
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull PsiFile file2) {
        Language language;
        LanguageCodeStyleSettingsProvider settingsProvider;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(53);
        }
        if ((settingsProvider = LanguageCodeStyleSettingsProvider.forLanguage((Language)(language = file2.getLanguage()))) != null) {
            DocCommentSettings docCommentSettings = settingsProvider.getDocCommentSettings(file2);
            if (docCommentSettings == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(54);
            }
            return docCommentSettings;
        }
        DocCommentSettings docCommentSettings = DocCommentSettings.DEFAULTS;
        if (docCommentSettings == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(55);
        }
        return docCommentSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 57: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 57: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatted";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 14: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedElement";
                break;
            }
            case 27: 
            case 28: 
            case 32: 
            case 35: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "reformat";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummy";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindWhiteSpaceNode";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocCommentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "postProcessElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "postProcessText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reformatRange";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "reformatText";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reformatTextWithContext";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeEndingWhiteSpaceFromEachRange";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "reformatRangeImpl";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "reformatNewlyAddedElement";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "adjustLineIndent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doAdjustLineIndentByOffset";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isLineToBeIndented";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "insertNewLineIndentMarker";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createDummy";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findWhiteSpaceNode";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "doFindWhiteSpaceNode";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "postProcessEnabledRanges";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentFormattingMode";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getMinLineFeeds";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createFormattingModel";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "runWithDocCommentFormattingDisabled";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentSettings";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$adjustLineIndent$4";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$adjustLineIndent$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 57: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CaretPositionKeeper {
        Editor myEditor;
        Document myDocument;
        CaretModel myCaretModel;
        RangeMarker myBeforeCaretRangeMarker;
        String myCaretIndentToRestore;
        int myVisualColumnToRestore;
        boolean myBlankLineIndentPreserved;

        CaretPositionKeeper(@NotNull Editor editor, @NotNull CodeStyleSettings settings, @NotNull Language language) {
            if (editor == null) {
                CaretPositionKeeper.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                CaretPositionKeeper.$$$reportNull$$$0(1);
            }
            if (language == null) {
                CaretPositionKeeper.$$$reportNull$$$0(2);
            }
            this.myVisualColumnToRestore = -1;
            this.myBlankLineIndentPreserved = true;
            this.myEditor = editor;
            this.myCaretModel = editor.getCaretModel();
            this.myDocument = editor.getDocument();
            this.myBlankLineIndentPreserved = CaretPositionKeeper.isBlankLineIndentPreserved(settings, language);
            int caretOffset = this.getCaretOffset();
            int lineStartOffset = this.getLineStartOffsetByTotalOffset(caretOffset);
            int lineEndOffset = this.getLineEndOffsetByTotalOffset(caretOffset);
            boolean shouldFixCaretPosition = CaretPositionKeeper.rangeHasWhiteSpaceSymbolsOnly(this.myDocument.getCharsSequence(), lineStartOffset, lineEndOffset);
            if (shouldFixCaretPosition) {
                this.initRestoreInfo(caretOffset);
            }
        }

        private static boolean isBlankLineIndentPreserved(@NotNull CodeStyleSettings settings, @NotNull Language language) {
            CommonCodeStyleSettings langSettings;
            if (settings == null) {
                CaretPositionKeeper.$$$reportNull$$$0(3);
            }
            if (language == null) {
                CaretPositionKeeper.$$$reportNull$$$0(4);
            }
            if ((langSettings = settings.getCommonSettings(language)) != null) {
                CommonCodeStyleSettings.IndentOptions indentOptions = langSettings.getIndentOptions();
                return indentOptions != null && indentOptions.KEEP_INDENTS_ON_EMPTY_LINES;
            }
            return false;
        }

        private void initRestoreInfo(int caretOffset) {
            int lineStartOffset = this.getLineStartOffsetByTotalOffset(caretOffset);
            this.myVisualColumnToRestore = this.myCaretModel.getVisualPosition().column;
            this.myCaretIndentToRestore = this.myDocument.getText(TextRange.create((int)lineStartOffset, (int)caretOffset));
            this.myBeforeCaretRangeMarker = this.myDocument.createRangeMarker(0, lineStartOffset);
        }

        public void restoreCaretPosition() {
            if (this.isVirtualSpaceEnabled()) {
                this.restoreVisualPosition();
            } else {
                this.restorePositionByIndentInsertion();
            }
        }

        private void restorePositionByIndentInsertion() {
            if (this.myBeforeCaretRangeMarker == null || !this.myBeforeCaretRangeMarker.isValid() || this.myCaretIndentToRestore == null || this.myBlankLineIndentPreserved) {
                return;
            }
            int newCaretLineStartOffset = this.myBeforeCaretRangeMarker.getEndOffset();
            this.myBeforeCaretRangeMarker.dispose();
            if (this.myCaretModel.getVisualPosition().column == this.myVisualColumnToRestore) {
                return;
            }
            Project project2 = this.myEditor.getProject();
            if (project2 == null || PsiDocumentManager.getInstance((Project)project2).isDocumentBlockedByPsi(this.myDocument)) {
                return;
            }
            this.insertWhiteSpaceIndentIfNeeded(newCaretLineStartOffset);
        }

        private void restoreVisualPosition() {
            if (this.myVisualColumnToRestore < 0) {
                EditorUtil.runWithAnimationDisabled(this.myEditor, () -> this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE));
                return;
            }
            VisualPosition position = this.myCaretModel.getVisualPosition();
            if (this.myVisualColumnToRestore != position.column) {
                this.myCaretModel.moveToVisualPosition(new VisualPosition(position.line, this.myVisualColumnToRestore));
            }
        }

        private void insertWhiteSpaceIndentIfNeeded(int caretLineOffset) {
            int lineToInsertIndent = this.myDocument.getLineNumber(caretLineOffset);
            if (!this.lineContainsWhiteSpaceSymbolsOnly(lineToInsertIndent)) {
                return;
            }
            int lineToInsertStartOffset = this.myDocument.getLineStartOffset(lineToInsertIndent);
            if (lineToInsertIndent != this.getCurrentCaretLine()) {
                this.myCaretModel.moveToOffset(lineToInsertStartOffset);
            }
            this.myDocument.replaceString(lineToInsertStartOffset, caretLineOffset, (CharSequence)this.myCaretIndentToRestore);
        }

        private static boolean rangeHasWhiteSpaceSymbolsOnly(CharSequence text2, int lineStartOffset, int lineEndOffset) {
            for (int i = lineStartOffset; i < lineEndOffset; ++i) {
                char c = text2.charAt(i);
                if (c == ' ' || c == '\t' || c == '\n') continue;
                return false;
            }
            return true;
        }

        private boolean isVirtualSpaceEnabled() {
            return this.myEditor.getSettings().isVirtualSpace();
        }

        private int getLineStartOffsetByTotalOffset(int offset) {
            int line = this.myDocument.getLineNumber(offset);
            return this.myDocument.getLineStartOffset(line);
        }

        private int getLineEndOffsetByTotalOffset(int offset) {
            int line = this.myDocument.getLineNumber(offset);
            return this.myDocument.getLineEndOffset(line);
        }

        private int getCaretOffset() {
            int caretOffset = this.myCaretModel.getOffset();
            caretOffset = Math.max(Math.min(caretOffset, this.myDocument.getTextLength() - 1), 0);
            return caretOffset;
        }

        private boolean lineContainsWhiteSpaceSymbolsOnly(int lineNumber) {
            int startOffset = this.myDocument.getLineStartOffset(lineNumber);
            int endOffset = this.myDocument.getLineEndOffset(lineNumber);
            return CaretPositionKeeper.rangeHasWhiteSpaceSymbolsOnly(this.myDocument.getCharsSequence(), startOffset, endOffset);
        }

        private int getCurrentCaretLine() {
            return this.myDocument.getLineNumber(this.myCaretModel.getOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl$CaretPositionKeeper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isBlankLineIndentPreserved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RangeFormatInfo {
        private final SmartPsiElementPointer startPointer;
        private final SmartPsiElementPointer endPointer;
        private final boolean fromStart;
        private final boolean toEnd;

        RangeFormatInfo(@Nullable SmartPsiElementPointer startPointer, @Nullable SmartPsiElementPointer endPointer, boolean fromStart, boolean toEnd) {
            this.startPointer = startPointer;
            this.endPointer = endPointer;
            this.fromStart = fromStart;
            this.toEnd = toEnd;
        }
    }

    private static class ProcessingUnderProgressInfo {
        private static final long DURATION_TIME = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
        private int myCount;
        private long myEndTime;

        private ProcessingUnderProgressInfo() {
        }

        public void increment() {
            if (this.myCount > 0 && System.currentTimeMillis() > this.myEndTime) {
                this.myCount = 0;
            }
            ++this.myCount;
            this.myEndTime = System.currentTimeMillis() + DURATION_TIME;
        }

        public void decrement() {
            if (this.myCount <= 0) {
                return;
            }
            --this.myCount;
        }

        public boolean isAllowed() {
            return this.myCount <= 0 || System.currentTimeMillis() >= this.myEndTime;
        }
    }
}

