/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.codeInsight.ImportFilter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaJspElementType;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspSpiUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.NotNullList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.ImportHelper");
    private final JavaCodeStyleSettings mySettings;
    @NonNls
    private static final String JAVA_LANG_PACKAGE = "java.lang";

    public ImportHelper(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ImportHelper.$$$reportNull$$$0(0);
        }
        this.mySettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
    }

    @Nullable(value="null means no need to replace the import list because they are the same")
    PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile file2) {
        PsiImportList oldList;
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(1);
        }
        if ((oldList = file2.getImportList()) == null) {
            return null;
        }
        NotNullList nonImports = new NotNullList();
        ArrayList<Pair<String, Boolean>> names = new ArrayList<Pair<String, Boolean>>(ImportHelper.collectNamesToImport(file2, (List<PsiElement>)nonImports));
        Collections.sort(names, Comparator.comparing(o -> (String)o.getFirst()));
        List<Pair<String, Boolean>> resultList = ImportHelper.sortItemsAccordingToSettings(names, this.mySettings);
        THashMap classesOrPackagesToImportOnDemand = new THashMap();
        ImportHelper.collectOnDemandImports(resultList, this.mySettings, (Map<String, Boolean>)classesOrPackagesToImportOnDemand);
        MultiMap conflictingMemberNames = new MultiMap();
        for (Pair<String, Boolean> pair2 : resultList) {
            if (!((Boolean)pair2.second).booleanValue()) continue;
            conflictingMemberNames.putValue((Object)StringUtil.getShortName((String)((String)pair2.first)), (Object)StringUtil.getPackageName((String)((String)pair2.first)));
        }
        for (String methodName : conflictingMemberNames.keySet()) {
            Collection collection = conflictingMemberNames.get((Object)methodName);
            if (classesOrPackagesToImportOnDemand.keySet().containsAll(collection)) continue;
            for (String name2 : collection) {
                classesOrPackagesToImportOnDemand.remove(name2);
            }
        }
        Set<String> classesToUseSingle = ImportHelper.findSingleImports(file2, resultList, classesOrPackagesToImportOnDemand.keySet());
        THashSet toReimport = new THashSet();
        ImportHelper.calcClassesConflictingViaOnDemandImports(file2, (Map<String, Boolean>)classesOrPackagesToImportOnDemand, file2.getResolveScope(), (Set<String>)toReimport);
        classesToUseSingle.addAll((Collection<String>)toReimport);
        try {
            StringBuilder text2 = ImportHelper.buildImportListText(resultList, classesOrPackagesToImportOnDemand.keySet(), classesToUseSingle);
            for (PsiElement nonImport : nonImports) {
                text2.append("\n").append(nonImport.getText());
            }
            String ext = StdFileTypes.JAVA.getDefaultExtension();
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)file2.getProject());
            PsiJavaFile dummyFile = (PsiJavaFile)factory.createFileFromText("_Dummy_." + ext, (FileType)StdFileTypes.JAVA, (CharSequence)text2);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)file2.getProject());
            codeStyleManager.reformat((PsiElement)dummyFile);
            PsiImportList newImportList = dummyFile.getImportList();
            assert (newImportList != null) : dummyFile.getText();
            PsiImportList result2 = (PsiImportList)newImportList.copy();
            if (oldList.isReplaceEquivalent(result2)) {
                return null;
            }
            if (!nonImports.isEmpty()) {
                PsiElement element;
                for (PsiElement firstPrevious = newImportList.getPrevSibling(); firstPrevious != null && firstPrevious.getPrevSibling() != null; firstPrevious = firstPrevious.getPrevSibling()) {
                }
                for (element = firstPrevious; element != null && element != newImportList; element = element.getNextSibling()) {
                    result2.add(element.copy());
                }
                for (element = newImportList.getNextSibling(); element != null; element = element.getNextSibling()) {
                    result2.add(element.copy());
                }
            }
            return result2;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static void collectOnDemandImports(@NotNull List<Pair<String, Boolean>> resultList, final @NotNull JavaCodeStyleSettings settings, final @NotNull Map<String, Boolean> outClassesOrPackagesToImportOnDemand) {
        if (resultList == null) {
            ImportHelper.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            ImportHelper.$$$reportNull$$$0(3);
        }
        if (outClassesOrPackagesToImportOnDemand == null) {
            ImportHelper.$$$reportNull$$$0(4);
        }
        TObjectIntHashMap packageToCountMap = new TObjectIntHashMap();
        TObjectIntHashMap classToCountMap = new TObjectIntHashMap();
        for (Pair<String, Boolean> pair2 : resultList) {
            int count;
            String name2 = (String)pair2.getFirst();
            Boolean isStatic = (Boolean)pair2.getSecond();
            String packageOrClassName = ImportHelper.getPackageOrClassName(name2);
            if (packageOrClassName.isEmpty()) continue;
            if (isStatic.booleanValue()) {
                count = classToCountMap.get((Object)packageOrClassName);
                classToCountMap.put((Object)packageOrClassName, count + 1);
                continue;
            }
            count = packageToCountMap.get((Object)packageOrClassName);
            packageToCountMap.put((Object)packageOrClassName, count + 1);
        }
        class MyVisitorProcedure
        implements TObjectIntProcedure<String> {
            private final boolean myIsVisitingPackages;

            MyVisitorProcedure(boolean isVisitingPackages) {
                this.myIsVisitingPackages = isVisitingPackages;
            }

            public boolean execute(String packageOrClassName, int count) {
                if (ImportHelper.isToUseImportOnDemand(packageOrClassName, count, !this.myIsVisitingPackages, settings)) {
                    boolean isStatic = !this.myIsVisitingPackages;
                    outClassesOrPackagesToImportOnDemand.put(packageOrClassName, isStatic);
                }
                return true;
            }
        }
        classToCountMap.forEachEntry((TObjectIntProcedure)new MyVisitorProcedure(false));
        packageToCountMap.forEachEntry((TObjectIntProcedure)new MyVisitorProcedure(true));
    }

    public static List<Pair<String, Boolean>> sortItemsAccordingToSettings(List<Pair<String, Boolean>> names, JavaCodeStyleSettings settings) {
        int[] entryForName = ArrayUtil.newIntArray((int)names.size());
        PackageEntry[] entries = settings.IMPORT_LAYOUT_TABLE.getEntries();
        for (int i = 0; i < names.size(); ++i) {
            Pair<String, Boolean> pair2 = names.get(i);
            String packageName = (String)pair2.getFirst();
            Boolean isStatic = (Boolean)pair2.getSecond();
            entryForName[i] = ImportHelper.findEntryIndex(packageName, isStatic, entries);
        }
        ArrayList<Pair<String, Boolean>> resultList = new ArrayList<Pair<String, Boolean>>(names.size());
        for (int i = 0; i < entries.length; ++i) {
            for (int j = 0; j < names.size(); ++j) {
                if (entryForName[j] != i) continue;
                resultList.add(names.get(j));
                names.set(j, null);
            }
        }
        for (Pair<String, Boolean> name2 : names) {
            if (name2 == null) continue;
            resultList.add(name2);
        }
        return resultList;
    }

    @NotNull
    private static Set<String> findSingleImports(@NotNull PsiJavaFile file2, @NotNull Collection<Pair<String, Boolean>> names, @NotNull Set<String> onDemandImports) {
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(5);
        }
        if (names == null) {
            ImportHelper.$$$reportNull$$$0(6);
        }
        if (onDemandImports == null) {
            ImportHelper.$$$reportNull$$$0(7);
        }
        GlobalSearchScope resolveScope = file2.getResolveScope();
        String thisPackageName = file2.getPackageName();
        THashSet implicitlyImportedPackages = new THashSet(Arrays.asList(file2.getImplicitlyImportedPackages()));
        PsiManager manager = file2.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        ArrayList<String> onDemandImportsList = new ArrayList<String>(onDemandImports);
        List onDemandElements = onDemandImportsList.stream().map(onDemandName -> facade.findClass(onDemandName, resolveScope)).collect(Collectors.toList());
        THashSet namesToUseSingle = new THashSet();
        for (Pair<String, Boolean> pair2 : names) {
            String langPackageClass;
            String thisPackageClass;
            String name2 = (String)pair2.getFirst();
            Boolean isStatic = (Boolean)pair2.getSecond();
            String prefix = ImportHelper.getPackageOrClassName(name2);
            if (prefix.isEmpty()) continue;
            boolean isImplicitlyImported = implicitlyImportedPackages.contains(prefix);
            if (!onDemandImports.contains(prefix) && !isImplicitlyImported) continue;
            String shortName = PsiNameHelper.getShortClassName((String)name2);
            String string = thisPackageClass = !thisPackageName.isEmpty() ? thisPackageName + "." + shortName : shortName;
            if (JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(thisPackageClass, resolveScope) != null) {
                namesToUseSingle.add(name2);
                continue;
            }
            if (!isImplicitlyImported && facade.findClass(langPackageClass = "java.lang." + shortName, resolveScope) != null) {
                namesToUseSingle.add(name2);
                continue;
            }
            PsiResolveHelper resolveHelper = facade.getResolveHelper();
            for (int i = 0; i < onDemandImportsList.size(); ++i) {
                PsiClass aClass;
                String onDemandName2 = (String)onDemandImportsList.get(i);
                if (prefix.equals(onDemandName2)) continue;
                if (isStatic.booleanValue()) {
                    PsiMethod[] methods;
                    aClass = (PsiClass)onDemandElements.get(i);
                    if (aClass == null) continue;
                    PsiField field = aClass.findFieldByName(shortName, true);
                    if (field != null && field.hasModifierProperty("static") && resolveHelper.isAccessible((PsiMember)field, (PsiElement)file2, null)) {
                        namesToUseSingle.add(name2);
                        continue;
                    }
                    PsiClass inner = aClass.findInnerClassByName(shortName, true);
                    if (inner != null && inner.hasModifierProperty("static") && resolveHelper.isAccessible((PsiMember)inner, (PsiElement)file2, null)) {
                        namesToUseSingle.add(name2);
                        continue;
                    }
                    for (PsiMethod method : methods = aClass.findMethodsByName(shortName, true)) {
                        if (!method.hasModifierProperty("static") || !resolveHelper.isAccessible((PsiMember)method, (PsiElement)file2, null)) continue;
                        namesToUseSingle.add(name2);
                    }
                    continue;
                }
                aClass = facade.findClass(onDemandName2 + "." + shortName, resolveScope);
                if (aClass == null) continue;
                namesToUseSingle.add(name2);
            }
        }
        THashSet tHashSet = namesToUseSingle;
        if (tHashSet == null) {
            ImportHelper.$$$reportNull$$$0(8);
        }
        return tHashSet;
    }

    private static void calcClassesConflictingViaOnDemandImports(@NotNull PsiJavaFile file2, @NotNull Map<String, Boolean> onDemandImports, @NotNull GlobalSearchScope resolveScope, @NotNull Set<String> outNamesToUseSingle) {
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(9);
        }
        if (onDemandImports == null) {
            ImportHelper.$$$reportNull$$$0(10);
        }
        if (resolveScope == null) {
            ImportHelper.$$$reportNull$$$0(11);
        }
        if (outNamesToUseSingle == null) {
            ImportHelper.$$$reportNull$$$0(12);
        }
        ArrayList<String> onDemands = new ArrayList<String>(Arrays.asList(file2.getImplicitlyImportedPackages()));
        for (String onDemand : onDemandImports.keySet()) {
            if (onDemands.contains(onDemand)) continue;
            onDemands.add(onDemand);
        }
        if (onDemands.size() < 2) {
            return;
        }
        THashMap classNames = new THashMap();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)file2.getProject());
        for (int i = onDemands.size() - 1; i >= 0; --i) {
            String onDemand = (String)onDemands.get(i);
            PsiPackage aPackage = facade.findPackage(onDemand);
            boolean isStatic = (Boolean)ObjectUtils.notNull((Object)onDemandImports.get(onDemand), (Object)Boolean.FALSE);
            if (aPackage != null) {
                Set set2 = Arrays.stream(aPackage.getClasses(resolveScope)).map(PsiQualifiedNamedElement::getName).collect(Collectors.toSet());
                classNames.put(onDemand, set2);
                continue;
            }
            PsiClass aClass = facade.findClass(onDemand, resolveScope);
            if (aClass != null) {
                if (isStatic) {
                    PsiMember[][] membersArray = new PsiMember[][]{aClass.getInnerClasses(), aClass.getMethods(), aClass.getFields()};
                    Set set3 = Arrays.stream(membersArray).flatMap(Arrays::stream).filter(member -> member.hasModifierProperty("static")).map(NavigationItem::getName).collect(Collectors.toSet());
                    classNames.put(onDemand, set3);
                    continue;
                }
                classNames.put(onDemand, Arrays.stream(aClass.getInnerClasses()).map(PsiQualifiedNamedElement::getName).collect(Collectors.toSet()));
                continue;
            }
            onDemands.remove(i);
        }
        THashSet conflicts = new THashSet();
        for (int i = 0; i < onDemands.size(); ++i) {
            String on1 = (String)onDemands.get(i);
            for (int j = i + 1; j < onDemands.size(); ++j) {
                String on2 = (String)onDemands.get(j);
                THashSet intersection = new THashSet((Collection)classNames.get(on1));
                intersection.retainAll((Collection)classNames.get(on2));
                conflicts.addAll(intersection);
            }
        }
        if (!conflicts.isEmpty() && !(file2 instanceof PsiCompiledElement)) {
            file2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((Set)conflicts, outNamesToUseSingle){
                final /* synthetic */ Set val$conflicts;
                final /* synthetic */ Set val$outNamesToUseSingle;
                {
                    this.val$conflicts = set2;
                    this.val$outNamesToUseSingle = set3;
                }

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    if (reference.getQualifier() != null) {
                        return;
                    }
                    PsiElement element = reference.resolve();
                    if (element instanceof PsiClass && this.val$conflicts.contains(((PsiClass)element).getName())) {
                        String fqn = ((PsiClass)element).getQualifiedName();
                        this.val$outNamesToUseSingle.add(fqn);
                    }
                }
            });
        }
    }

    @NotNull
    private static StringBuilder buildImportListText(@NotNull List<Pair<String, Boolean>> names, @NotNull Set<String> packagesOrClassesToImportOnDemand, @NotNull Set<String> namesToUseSingle) {
        if (names == null) {
            ImportHelper.$$$reportNull$$$0(13);
        }
        if (packagesOrClassesToImportOnDemand == null) {
            ImportHelper.$$$reportNull$$$0(14);
        }
        if (namesToUseSingle == null) {
            ImportHelper.$$$reportNull$$$0(15);
        }
        THashSet importedPackagesOrClasses = new THashSet();
        StringBuilder buffer = new StringBuilder();
        for (Pair<String, Boolean> pair2 : names) {
            boolean useOnDemand;
            String name2 = (String)pair2.getFirst();
            Boolean isStatic = (Boolean)pair2.getSecond();
            String packageOrClassName = ImportHelper.getPackageOrClassName(name2);
            boolean implicitlyImported = JAVA_LANG_PACKAGE.equals(packageOrClassName);
            boolean bl = useOnDemand = implicitlyImported || packagesOrClassesToImportOnDemand.contains(packageOrClassName);
            if (useOnDemand && namesToUseSingle.remove(name2)) {
                useOnDemand = false;
            }
            Pair current = Pair.create((Object)packageOrClassName, (Object)isStatic);
            if (useOnDemand && (importedPackagesOrClasses.contains(current) || implicitlyImported)) continue;
            buffer.append("import ");
            if (isStatic.booleanValue()) {
                buffer.append("static ");
            }
            if (useOnDemand) {
                importedPackagesOrClasses.add(current);
                buffer.append(packageOrClassName);
                buffer.append(".*");
            } else {
                buffer.append(name2);
            }
            buffer.append(";\n");
        }
        for (String remainingSingle : namesToUseSingle) {
            buffer.append("import ");
            buffer.append(remainingSingle);
            buffer.append(";\n");
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            ImportHelper.$$$reportNull$$$0(16);
        }
        return stringBuilder;
    }

    public boolean addImport(@NotNull PsiJavaFile file2, @NotNull PsiClass refClass) {
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(17);
        }
        if (refClass == null) {
            ImportHelper.$$$reportNull$$$0(18);
        }
        return this.addImport(file2, refClass, false);
    }

    private boolean addImport(@NotNull PsiJavaFile file2, @NotNull PsiClass refClass, boolean forceReimport) {
        PsiPackage conflictPackageRef;
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(19);
        }
        if (refClass == null) {
            ImportHelper.$$$reportNull$$$0(20);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)file2.getProject());
        PsiElementFactory factory = facade.getElementFactory();
        PsiResolveHelper helper = facade.getResolveHelper();
        String className = refClass.getQualifiedName();
        if (className == null) {
            return true;
        }
        if (!ImportFilter.shouldImport((PsiFile)file2, (String)className)) {
            return false;
        }
        String packageName = ImportHelper.getPackageOrClassName(className);
        String shortName = PsiNameHelper.getShortClassName((String)className);
        PsiClass conflictSingleRef = ImportHelper.findSingleImportByShortName(file2, shortName);
        if (conflictSingleRef != null && !forceReimport) {
            return className.equals(conflictSingleRef.getQualifiedName());
        }
        PsiClass curRefClass = helper.resolveReferencedClass(shortName, (PsiElement)file2);
        if (file2.getManager().areElementsEquivalent((PsiElement)refClass, (PsiElement)curRefClass)) {
            return true;
        }
        boolean useOnDemand = true;
        if (packageName.isEmpty()) {
            useOnDemand = false;
        }
        if ((conflictPackageRef = ImportHelper.findImportOnDemand(file2, packageName)) != null) {
            useOnDemand = false;
        }
        ArrayList<PsiClass> classesToReimport = new ArrayList<PsiClass>();
        List<PsiJavaCodeReferenceElement> importRefs = ImportHelper.getImportsFromPackage(file2, packageName);
        if (useOnDemand) {
            if (this.mySettings.USE_SINGLE_CLASS_IMPORTS && importRefs.size() + 1 < this.mySettings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND && !this.mySettings.PACKAGES_TO_USE_IMPORT_ON_DEMAND.contains(packageName)) {
                useOnDemand = false;
            }
            if (ImportHelper.containsInCurrentPackage(file2, curRefClass)) {
                useOnDemand = true;
            }
            if (useOnDemand) {
                PsiElement[] onDemandRefs = file2.getOnDemandImports(false, true);
                ArrayList<String> refTexts = new ArrayList<String>(onDemandRefs.length);
                for (PsiElement ref : onDemandRefs) {
                    String refName = ref instanceof PsiClass ? ((PsiClass)ref).getQualifiedName() : ((PsiPackage)ref).getQualifiedName();
                    refTexts.add(refName);
                }
                ImportHelper.calcClassesToReimport(file2, facade, helper, packageName, refTexts, classesToReimport);
            }
        }
        if (useOnDemand && refClass.getContainingClass() != null && this.mySettings.INSERT_INNER_CLASS_IMPORTS && ImportHelper.containsInCurrentPackage(file2, curRefClass)) {
            return false;
        }
        if (curRefClass != null) {
            if (!classesToReimport.isEmpty()) {
                return false;
            }
            useOnDemand = false;
        }
        try {
            PsiImportList importList = file2.getImportList();
            assert (importList != null) : file2;
            PsiImportStatement statement2 = useOnDemand ? factory.createImportStatementOnDemand(packageName) : factory.createImportStatement(refClass);
            importList.add((PsiElement)statement2);
            if (useOnDemand) {
                for (PsiJavaCodeReferenceElement ref : importRefs) {
                    PsiImportStatement importStatement;
                    LOG.assertTrue(ref.getParent() instanceof PsiImportStatement);
                    if (!ref.isValid() || (importStatement = (PsiImportStatement)ref.getParent()).isForeignFileImport()) continue;
                    classesToReimport.add((PsiClass)ref.resolve());
                    importStatement.delete();
                }
            }
            for (PsiClass aClass : classesToReimport) {
                if (aClass == null) continue;
                this.addImport(file2, aClass, true);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    private static boolean containsInCurrentPackage(@NotNull PsiJavaFile file2, PsiClass curRefClass) {
        String curRefClassQualifiedName;
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(21);
        }
        return curRefClass != null && (curRefClassQualifiedName = curRefClass.getQualifiedName()) != null && ArrayUtil.find((Object[])file2.getImplicitlyImportedPackages(), (Object)StringUtil.getPackageName((String)curRefClassQualifiedName)) < 0;
    }

    private static void calcClassesToReimport(@NotNull PsiJavaFile file2, @NotNull JavaPsiFacade facade, @NotNull PsiResolveHelper helper, @NotNull String packageName, @NotNull Collection<String> onDemandRefs, @NotNull List<PsiClass> outClassesToReimport) {
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(22);
        }
        if (facade == null) {
            ImportHelper.$$$reportNull$$$0(23);
        }
        if (helper == null) {
            ImportHelper.$$$reportNull$$$0(24);
        }
        if (packageName == null) {
            ImportHelper.$$$reportNull$$$0(25);
        }
        if (onDemandRefs == null) {
            ImportHelper.$$$reportNull$$$0(26);
        }
        if (outClassesToReimport == null) {
            ImportHelper.$$$reportNull$$$0(27);
        }
        if (onDemandRefs.isEmpty()) {
            return;
        }
        PsiPackage aPackage = facade.findPackage(packageName);
        if (aPackage == null) {
            return;
        }
        PsiDirectory[] dirs = aPackage.getDirectories();
        GlobalSearchScope resolveScope = file2.getResolveScope();
        for (PsiDirectory dir : dirs) {
            PsiFile[] files;
            for (PsiFile aFile : files = dir.getFiles()) {
                if (!(aFile instanceof PsiJavaFile)) continue;
                String name2 = aFile.getVirtualFile().getNameWithoutExtension();
                for (String refName : onDemandRefs) {
                    String conflictClassName2;
                    PsiClass conflictClass2;
                    String conflictClassName = refName + "." + name2;
                    PsiClass conflictClass = facade.findClass(conflictClassName, resolveScope);
                    if (conflictClass == null || !helper.isAccessible((PsiMember)conflictClass, (PsiElement)file2, null) || (conflictClass2 = facade.findClass(conflictClassName2 = packageName + "." + name2, resolveScope)) == null || !helper.isAccessible((PsiMember)conflictClass2, (PsiElement)file2, null) || ReferencesSearch.search((PsiElement)conflictClass, (SearchScope)new LocalSearchScope((PsiElement)file2), (boolean)false).findFirst() == null) continue;
                    outClassesToReimport.add(conflictClass);
                }
            }
        }
    }

    @NotNull
    private static List<PsiJavaCodeReferenceElement> getImportsFromPackage(@NotNull PsiJavaFile file2, @NotNull String packageName) {
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(28);
        }
        if (packageName == null) {
            ImportHelper.$$$reportNull$$$0(29);
        }
        PsiClass[] refs = file2.getSingleClassImports(true);
        ArrayList<PsiJavaCodeReferenceElement> array = new ArrayList<PsiJavaCodeReferenceElement>();
        for (PsiClass ref1 : refs) {
            PsiJavaCodeReferenceElement ref;
            String className = ref1.getQualifiedName();
            if (!ImportHelper.getPackageOrClassName(className).equals(packageName) || (ref = file2.findImportReferenceTo(ref1)) == null) continue;
            array.add(ref);
        }
        ArrayList<PsiJavaCodeReferenceElement> arrayList = array;
        if (arrayList == null) {
            ImportHelper.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    private static PsiClass findSingleImportByShortName(final @NotNull PsiJavaFile file2, @NotNull String shortClassName) {
        String className;
        PsiClass[] refs;
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(31);
        }
        if (shortClassName == null) {
            ImportHelper.$$$reportNull$$$0(32);
        }
        for (PsiClass ref : refs = file2.getSingleClassImports(true)) {
            className = ref.getQualifiedName();
            if (className == null || !PsiNameHelper.getShortClassName((String)className).equals(shortClassName)) continue;
            return ref;
        }
        for (PsiClass aClass : file2.getClasses()) {
            className = aClass.getQualifiedName();
            if (className == null || !PsiNameHelper.getShortClassName((String)className).equals(shortClassName)) continue;
            return aClass;
        }
        String packageName = file2.getPackageName();
        if (!StringUtil.isEmptyOrSpaces((String)packageName)) {
            String fqn = packageName + "." + shortClassName;
            final PsiClass aClass = JavaPsiFacade.getInstance((Project)file2.getProject()).findClass(fqn, file2.getResolveScope());
            if (aClass != null) {
                final boolean[] foundRef = new boolean[]{false};
                file2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitElement(PsiElement element) {
                        if (foundRef[0]) {
                            return;
                        }
                        super.visitElement(element);
                    }

                    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                        if (file2.getManager().areElementsEquivalent(reference.resolve(), (PsiElement)aClass)) {
                            foundRef[0] = true;
                        }
                        super.visitReferenceElement(reference);
                    }
                });
                if (foundRef[0]) {
                    return aClass;
                }
            }
        }
        return null;
    }

    private static PsiPackage findImportOnDemand(@NotNull PsiJavaFile file2, @NotNull String packageName) {
        PsiElement[] refs;
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(33);
        }
        if (packageName == null) {
            ImportHelper.$$$reportNull$$$0(34);
        }
        for (PsiElement ref : refs = file2.getOnDemandImports(false, true)) {
            if (!(ref instanceof PsiPackage) || !((PsiPackage)ref).getQualifiedName().equals(packageName)) continue;
            return (PsiPackage)ref;
        }
        return null;
    }

    public static boolean isAlreadyImported(@NotNull PsiJavaFile file2, @NotNull String fullyQualifiedName) {
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(35);
        }
        if (fullyQualifiedName == null) {
            ImportHelper.$$$reportNull$$$0(36);
        }
        String className = ImportHelper.extractClassName(file2, fullyQualifiedName);
        Project project2 = file2.getProject();
        PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)project2);
        PsiClass psiClass = resolveHelper.resolveReferencedClass(className, (PsiElement)file2);
        return psiClass != null && fullyQualifiedName.equals(psiClass.getQualifiedName());
    }

    @NotNull
    private static String extractClassName(@NotNull PsiJavaFile file2, @NotNull String fullyQualifiedName) {
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(37);
        }
        if (fullyQualifiedName == null) {
            ImportHelper.$$$reportNull$$$0(38);
        }
        for (PsiClass aClass : file2.getClasses()) {
            String outerClassName = aClass.getQualifiedName();
            if (outerClassName == null || !fullyQualifiedName.startsWith(outerClassName)) continue;
            String string = fullyQualifiedName.substring(outerClassName.lastIndexOf(46) + 1);
            if (string == null) {
                ImportHelper.$$$reportNull$$$0(39);
            }
            return string;
        }
        String string = ClassUtil.extractClassName((String)fullyQualifiedName);
        if (string == null) {
            ImportHelper.$$$reportNull$$$0(40);
        }
        return string;
    }

    public ASTNode getDefaultAnchor(@NotNull PsiImportList list2, @NotNull PsiImportStatementBase statement2) {
        PsiJavaCodeReferenceElement ref;
        if (list2 == null) {
            ImportHelper.$$$reportNull$$$0(41);
        }
        if (statement2 == null) {
            ImportHelper.$$$reportNull$$$0(42);
        }
        if ((ref = statement2.getImportReference()) == null) {
            return null;
        }
        int entryIndex = this.findEntryIndex(statement2);
        PsiImportStatementBase[] allStatements = list2.getAllImportStatements();
        int[] entries = ArrayUtil.newIntArray((int)allStatements.length);
        ArrayList<PsiImportStatementBase> statements = new ArrayList<PsiImportStatementBase>();
        for (int i = 0; i < allStatements.length; ++i) {
            int entryIndex1;
            PsiImportStatementBase statement1 = allStatements[i];
            entries[i] = entryIndex1 = this.findEntryIndex(statement1);
            if (entryIndex1 != entryIndex) continue;
            statements.add(statement1);
        }
        if (statements.isEmpty()) {
            int index;
            for (index = entries.length - 1; index >= 0 && entries[index] >= entryIndex; --index) {
            }
            return ++index < entries.length ? SourceTreeToPsiMap.psiElementToTree((PsiElement)allStatements[index]) : null;
        }
        String refText = ref.getCanonicalText();
        if (statement2.isOnDemand()) {
            refText = refText + ".";
        }
        PsiImportStatementBase insertBefore = null;
        PsiImportStatementBase insertAfter = null;
        for (PsiImportStatementBase statement1 : statements) {
            int comp;
            PsiJavaCodeReferenceElement ref1 = statement1.getImportReference();
            if (ref1 == null) continue;
            String refTextThis = ref1.getCanonicalText();
            if (statement1.isOnDemand()) {
                refTextThis = refTextThis + ".";
            }
            if ((comp = Comparing.compare((Comparable)((Object)refText), (Comparable)((Object)refTextThis))) < 0 && insertBefore == null) {
                insertBefore = statement1;
            }
            if (comp <= 0) continue;
            insertAfter = statement1;
        }
        if (insertBefore != null) {
            return insertBefore.getNode();
        }
        if (insertAfter != null) {
            return insertAfter.getNode().getTreeNext();
        }
        return null;
    }

    public int getEmptyLinesBetween(@NotNull PsiImportStatementBase statement1, @NotNull PsiImportStatementBase statement2) {
        int index2;
        int index1;
        if (statement1 == null) {
            ImportHelper.$$$reportNull$$$0(43);
        }
        if (statement2 == null) {
            ImportHelper.$$$reportNull$$$0(44);
        }
        if ((index1 = this.findEntryIndex(statement1)) == (index2 = this.findEntryIndex(statement2))) {
            return 0;
        }
        if (index1 > index2) {
            int t = index1;
            index1 = index2;
            index2 = t;
        }
        PackageEntry[] entries = this.mySettings.IMPORT_LAYOUT_TABLE.getEntries();
        int maxSpace = 0;
        for (int i = index1 + 1; i < index2; ++i) {
            if (entries[i] != PackageEntry.BLANK_LINE_ENTRY) continue;
            int space = 0;
            do {
                ++space;
            } while (entries[++i] == PackageEntry.BLANK_LINE_ENTRY);
            maxSpace = Math.max(maxSpace, space);
        }
        return maxSpace;
    }

    private static boolean isToUseImportOnDemand(@NotNull String packageName, int classCount, boolean isStaticImportNeeded, @NotNull JavaCodeStyleSettings settings) {
        int limitCount;
        if (packageName == null) {
            ImportHelper.$$$reportNull$$$0(45);
        }
        if (settings == null) {
            ImportHelper.$$$reportNull$$$0(46);
        }
        if (!settings.USE_SINGLE_CLASS_IMPORTS) {
            return true;
        }
        int n = limitCount = isStaticImportNeeded ? settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND : settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
        if (classCount >= limitCount) {
            return true;
        }
        if (packageName.isEmpty()) {
            return false;
        }
        PackageEntryTable table = settings.PACKAGES_TO_USE_IMPORT_ON_DEMAND;
        return table.contains(packageName);
    }

    private static int findEntryIndex(@NotNull String packageName, boolean isStatic, @NotNull PackageEntry[] entries) {
        if (packageName == null) {
            ImportHelper.$$$reportNull$$$0(47);
        }
        if (entries == null) {
            ImportHelper.$$$reportNull$$$0(48);
        }
        PackageEntry bestEntry = null;
        int bestEntryIndex = -1;
        int allOtherStaticIndex = -1;
        int allOtherIndex = -1;
        for (int i = 0; i < entries.length; ++i) {
            PackageEntry entry = entries[i];
            if (entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) {
                allOtherStaticIndex = i;
            }
            if (entry == PackageEntry.ALL_OTHER_IMPORTS_ENTRY) {
                allOtherIndex = i;
            }
            if (!entry.isBetterMatchForPackageThan(bestEntry, packageName, isStatic)) continue;
            bestEntry = entry;
            bestEntryIndex = i;
        }
        if (bestEntryIndex == -1 && isStatic && allOtherStaticIndex == -1 && allOtherIndex != -1) {
            bestEntryIndex = allOtherIndex;
        }
        return bestEntryIndex;
    }

    int findEntryIndex(@NotNull PsiImportStatementBase statement2) {
        String packageName;
        PsiJavaCodeReferenceElement ref;
        if (statement2 == null) {
            ImportHelper.$$$reportNull$$$0(49);
        }
        if ((ref = statement2.getImportReference()) == null) {
            return -1;
        }
        if (statement2.isOnDemand()) {
            packageName = ref.getCanonicalText();
        } else {
            String className = ref.getCanonicalText();
            packageName = ImportHelper.getPackageOrClassName(className);
        }
        return ImportHelper.findEntryIndex(packageName, statement2 instanceof PsiImportStaticStatement, this.mySettings.IMPORT_LAYOUT_TABLE.getEntries());
    }

    public static boolean hasConflictingOnDemandImport(@NotNull PsiJavaFile file2, @NotNull PsiClass psiClass, @NotNull String referenceName) {
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(50);
        }
        if (psiClass == null) {
            ImportHelper.$$$reportNull$$$0(51);
        }
        if (referenceName == null) {
            ImportHelper.$$$reportNull$$$0(52);
        }
        Collection<Pair<String, Boolean>> resultList = ImportHelper.collectNamesToImport(file2, new ArrayList<PsiElement>());
        String qualifiedName = psiClass.getQualifiedName();
        for (Pair<String, Boolean> pair2 : resultList) {
            if (!((Boolean)pair2.second).booleanValue() || !referenceName.equals(StringUtil.getShortName((String)((String)pair2.first))) || StringUtil.getPackageName((String)((String)pair2.first)).equals(qualifiedName)) continue;
            return true;
        }
        PsiImportList importList = file2.getImportList();
        if (importList == null) {
            return false;
        }
        Set<String> onDemandImportedClasses = Arrays.stream(importList.getImportStaticStatements()).filter(statement2 -> statement2.isOnDemand()).map(statement2 -> statement2.resolveTargetClass()).filter(aClass -> aClass != null).map(aClass -> aClass.getQualifiedName()).collect(Collectors.toSet());
        String newImport = StringUtil.getQualifiedName((String)qualifiedName, (String)referenceName);
        Set<String> singleImports = ImportHelper.findSingleImports(file2, Collections.singletonList(Pair.create((Object)newImport, (Object)true)), onDemandImportedClasses);
        return singleImports.contains(newImport);
    }

    @NotNull
    private static Collection<Pair<String, Boolean>> collectNamesToImport(@NotNull PsiJavaFile file2, List<PsiElement> comments) {
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(53);
        }
        THashSet names = new THashSet();
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file2);
        ImportHelper.collectNamesToImport((Set<Pair<String, Boolean>>)names, comments, file2, (PsiFile)jspFile);
        if (jspFile != null) {
            PsiFile[] files;
            for (PsiFile includingFile : files = (PsiFile[])ArrayUtil.mergeArrays((Object[])JspSpiUtil.getIncludingFiles(jspFile), (Object[])JspSpiUtil.getIncludedFiles(jspFile))) {
                PsiFile javaRoot = includingFile.getViewProvider().getPsi((Language)JavaLanguage.INSTANCE);
                if (!(javaRoot instanceof PsiJavaFile) || file2 == javaRoot) continue;
                ImportHelper.collectNamesToImport((Set<Pair<String, Boolean>>)names, comments, (PsiJavaFile)javaRoot, (PsiFile)jspFile);
            }
        }
        ImportHelper.addUnresolvedImportNames((Set<Pair<String, Boolean>>)names, file2);
        THashSet tHashSet = names;
        if (tHashSet == null) {
            ImportHelper.$$$reportNull$$$0(54);
        }
        return tHashSet;
    }

    private static void collectNamesToImport(@NotNull Set<Pair<String, Boolean>> names, @NotNull List<PsiElement> comments, @NotNull PsiJavaFile file2, PsiFile context) {
        if (names == null) {
            ImportHelper.$$$reportNull$$$0(55);
        }
        if (comments == null) {
            ImportHelper.$$$reportNull$$$0(56);
        }
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(57);
        }
        String packageName = file2.getPackageName();
        List roots = file2.getViewProvider().getAllFiles();
        for (PsiElement root : roots) {
            ImportHelper.addNamesToImport(names, comments, root, packageName, context);
        }
    }

    private static void addNamesToImport(@NotNull Set<Pair<String, Boolean>> names, @NotNull List<PsiElement> comments, @NotNull PsiElement scope, @NotNull String thisPackageName, PsiFile context) {
        if (names == null) {
            ImportHelper.$$$reportNull$$$0(58);
        }
        if (comments == null) {
            ImportHelper.$$$reportNull$$$0(59);
        }
        if (scope == null) {
            ImportHelper.$$$reportNull$$$0(60);
        }
        if (thisPackageName == null) {
            ImportHelper.$$$reportNull$$$0(61);
        }
        if (scope instanceof PsiImportList) {
            return;
        }
        LinkedList<PsiElement> stack = new LinkedList<PsiElement>();
        stack.add(scope);
        while (!stack.isEmpty()) {
            PsiElement child = (PsiElement)stack.removeFirst();
            if (child instanceof PsiImportList) {
                for (PsiElement psiElement : child.getChildren()) {
                    IElementType elementType;
                    ASTNode node;
                    if (psiElement == null || (node = psiElement.getNode()) == null || ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(elementType = node.getElementType()) || JavaJspElementType.WHITE_SPACE_BIT_SET.contains(elementType)) continue;
                    comments.add(psiElement);
                }
                continue;
            }
            if (child instanceof PsiLiteralExpression) continue;
            ContainerUtil.addAll(stack, (Object[])child.getChildren());
            for (PsiElement psiElement : child.getReferences()) {
                String qName;
                PsiElement currentFileResolveScope;
                PsiJavaReference javaReference;
                if (!(psiElement instanceof PsiJavaReference) || (javaReference = (PsiJavaReference)psiElement) instanceof JavaClassReference && ((JavaClassReference)javaReference).getContextReference() != null) continue;
                PsiJavaCodeReferenceElement referenceElement = null;
                if (psiElement instanceof PsiJavaCodeReferenceElement && ((referenceElement = (PsiJavaCodeReferenceElement)child).getQualifier() != null || psiElement instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)psiElement).getKind(((PsiJavaCodeReferenceElementImpl)psiElement).getContainingFile()) == 6)) continue;
                JavaResolveResult resolveResult = javaReference.advancedResolve(true);
                PsiElement refElement = resolveResult.getElement();
                if (refElement == null && referenceElement != null) {
                    refElement = ResolveClassUtil.resolveClass(referenceElement, referenceElement.getContainingFile());
                }
                if (refElement == null || !((currentFileResolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) || context != null && (!currentFileResolveScope.isValid() || currentFileResolveScope instanceof JspxImportStatement && context != ((JspxImportStatement)currentFileResolveScope).getDeclarationFile())) continue;
                if (referenceElement != null && currentFileResolveScope instanceof PsiImportStaticStatement) {
                    String refName;
                    PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)currentFileResolveScope;
                    String name2 = importStaticStatement.getImportReference().getCanonicalText();
                    if (importStaticStatement.isOnDemand() && (refName = referenceElement.getReferenceName()) != null) {
                        name2 = name2 + "." + refName;
                    }
                    names.add((Pair<String, Boolean>)Pair.create((Object)name2, (Object)Boolean.TRUE));
                    continue;
                }
                if (!(refElement instanceof PsiClass) || ImportHelper.hasPackage(qName = ((PsiClass)refElement).getQualifiedName(), thisPackageName)) continue;
                names.add((Pair<String, Boolean>)Pair.create((Object)qName, (Object)Boolean.FALSE));
            }
        }
    }

    private static void addUnresolvedImportNames(@NotNull Set<Pair<String, Boolean>> namesToImport, @NotNull PsiJavaFile file2) {
        PsiImportList importList;
        if (namesToImport == null) {
            ImportHelper.$$$reportNull$$$0(62);
        }
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(63);
        }
        PsiImportStatementBase[] imports2 = (importList = file2.getImportList()) == null ? PsiImportStatementBase.EMPTY_ARRAY : importList.getAllImportStatements();
        THashMap unresolvedNames = new THashMap();
        THashSet unresolvedOnDemand = new THashSet();
        for (PsiImportStatementBase anImport : imports2) {
            JavaResolveResult[] results;
            PsiJavaCodeReferenceElement ref = anImport.getImportReference();
            if (ref == null || (results = ref.multiResolve(false)).length != 0) continue;
            String text2 = ref.getCanonicalText();
            if (anImport.isOnDemand()) {
                text2 = text2 + ".*";
            }
            Pair pair2 = Pair.create((Object)text2, (Object)(anImport instanceof PsiImportStaticStatement));
            if (anImport.isOnDemand()) {
                unresolvedOnDemand.add(pair2);
                continue;
            }
            unresolvedNames.put(ref.getReferenceName(), pair2);
        }
        if (file2.getViewProvider().getLanguages().size() > 1 && file2.getViewProvider().getBaseLanguage() != JavaLanguage.INSTANCE) {
            namesToImport.addAll((Collection<Pair<String, Boolean>>)unresolvedOnDemand);
            namesToImport.addAll(unresolvedNames.values());
            return;
        }
        boolean[] hasResolveProblem = new boolean[]{false};
        for (PsiClass aClass : file2.getClasses()) {
            if (aClass instanceof PsiCompiledElement) continue;
            aClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Map)unresolvedNames, hasResolveProblem, namesToImport){
                final /* synthetic */ Map val$unresolvedNames;
                final /* synthetic */ boolean[] val$hasResolveProblem;
                final /* synthetic */ Set val$namesToImport;
                {
                    this.val$unresolvedNames = map;
                    this.val$hasResolveProblem = blArray;
                    this.val$namesToImport = set2;
                }

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    String name2 = reference.getReferenceName();
                    Pair pair2 = (Pair)this.val$unresolvedNames.get(name2);
                    if (reference.multiResolve(false).length == 0) {
                        this.val$hasResolveProblem[0] = true;
                        if (pair2 != null) {
                            this.val$namesToImport.add(pair2);
                            this.val$unresolvedNames.remove(name2);
                        }
                    }
                    super.visitReferenceElement(reference);
                }
            });
        }
        if (hasResolveProblem[0]) {
            namesToImport.addAll((Collection<Pair<String, Boolean>>)unresolvedOnDemand);
        }
    }

    static boolean isImplicitlyImported(@NotNull String className, @NotNull PsiJavaFile file2) {
        String[] packageNames;
        if (className == null) {
            ImportHelper.$$$reportNull$$$0(64);
        }
        if (file2 == null) {
            ImportHelper.$$$reportNull$$$0(65);
        }
        for (String packageName : packageNames = file2.getImplicitlyImportedPackages()) {
            if (!ImportHelper.hasPackage(className, packageName)) continue;
            return true;
        }
        return false;
    }

    static boolean hasPackage(@NotNull String className, @NotNull String packageName) {
        if (className == null) {
            ImportHelper.$$$reportNull$$$0(66);
        }
        if (packageName == null) {
            ImportHelper.$$$reportNull$$$0(67);
        }
        if (!className.startsWith(packageName)) {
            return false;
        }
        if (className.length() == packageName.length()) {
            return false;
        }
        if (!packageName.isEmpty() && className.charAt(packageName.length()) != '.') {
            return false;
        }
        return className.indexOf(46, packageName.length() + 1) < 0;
    }

    @NotNull
    private static String getPackageOrClassName(@NotNull String className) {
        int dotIndex;
        if (className == null) {
            ImportHelper.$$$reportNull$$$0(68);
        }
        String string = (dotIndex = className.lastIndexOf(46)) < 0 ? "" : className.substring(0, dotIndex);
        if (string == null) {
            ImportHelper.$$$reportNull$$$0(69);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 16: 
            case 30: 
            case 39: 
            case 40: 
            case 54: 
            case 69: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 16: 
            case 30: 
            case 39: 
            case 40: 
            case 54: 
            case 69: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 50: 
            case 53: 
            case 57: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outClassesOrPackagesToImportOnDemand";
                break;
            }
            case 6: 
            case 13: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDemandImports";
                break;
            }
            case 8: 
            case 16: 
            case 30: 
            case 39: 
            case 40: 
            case 54: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/ImportHelper";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outNamesToUseSingle";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagesOrClassesToImportOnDemand";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToUseSingle";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 25: 
            case 29: 
            case 34: 
            case 45: 
            case 47: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDemandRefs";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outClassesToReimport";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortClassName";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyQualifiedName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 42: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement1";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement2";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisPackageName";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToImport";
                break;
            }
            case 64: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/ImportHelper";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findSingleImports";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildImportListText";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportsFromPackage";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "extractClassName";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNamesToImport";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageOrClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareOptimizeImportsResult";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectOnDemandImports";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSingleImports";
                break;
            }
            case 8: 
            case 16: 
            case 30: 
            case 39: 
            case 40: 
            case 54: 
            case 69: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calcClassesConflictingViaOnDemandImports";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildImportListText";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "containsInCurrentPackage";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calcClassesToReimport";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getImportsFromPackage";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findSingleImportByShortName";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findImportOnDemand";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyImported";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "extractClassName";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultAnchor";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getEmptyLinesBetween";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isToUseImportOnDemand";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findEntryIndex";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "hasConflictingOnDemandImport";
                break;
            }
            case 53: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "collectNamesToImport";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addNamesToImport";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addUnresolvedImportNames";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitlyImported";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "hasPackage";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getPackageOrClassName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 16: 
            case 30: 
            case 39: 
            case 40: 
            case 54: 
            case 69: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

