/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.IndentCalculator;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaLikeLangLineIndentProvider
implements LineIndentProvider {
    @Nullable
    public String getLineIndent(@NotNull Project project2, @NotNull Editor editor, @Nullable Language language, int offset) {
        if (project2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(1);
        }
        if (offset > 0) {
            IndentCalculator indentCalculator = this.getIndent(project2, editor, language, offset - 1);
            if (indentCalculator != null) {
                return indentCalculator.getIndentString(language, this.getPosition(editor, offset - 1));
            }
        } else {
            return "";
        }
        return null;
    }

    @Nullable
    protected IndentCalculator getIndent(@NotNull Project project2, @NotNull Editor editor, @Nullable Language language, int offset) {
        if (project2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(3);
        }
        IndentCalculatorFactory myFactory = new IndentCalculatorFactory(project2, editor);
        if (this.getPosition(editor, offset).matchesRule(position -> position.isAt(JavaLikeElement.Whitespace) && position.isAtMultiline())) {
            if (this.getPosition(editor, offset).before().isAt(JavaLikeElement.Comma)) {
                SemanticEditorPosition position2 = this.getPosition(editor, offset);
                if (position2.hasEmptyLineAfter(offset) && !position2.after().isAtAnyOf(JavaLikeElement.ArrayClosingBracket, JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace, JavaLikeElement.RightParenthesis) && !position2.isAtEnd() && position2.findLeftParenthesisBackwardsSkippingNested(JavaLikeElement.LeftParenthesis, JavaLikeElement.RightParenthesis, (Condition<SemanticEditorPosition.SyntaxElement>)((Condition)element -> element == JavaLikeElement.BlockClosingBrace || element == JavaLikeElement.BlockOpeningBrace || element == JavaLikeElement.Semicolon)).isAt(JavaLikeElement.LeftParenthesis)) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_AFTER);
                }
            } else {
                if (this.getPosition(editor, offset + 1).matchesRule(position -> position.isAt(JavaLikeElement.BlockClosingBrace) && !position.after().afterOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.Comma))) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, position -> {
                        position.findLeftParenthesisBackwardsSkippingNested(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                        if (!position.isAtEnd()) {
                            return this.getBlockStatementStartOffset(position);
                        }
                        return -1;
                    });
                }
                if (this.getPosition(editor, offset).matchesRule(position -> position.before().beforeOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.BlockClosingBrace))) {
                    return myFactory.createIndentCalculator(JavaLikeLangLineIndentProvider.getBlockIndentType(project2, language), IndentCalculator.LINE_BEFORE);
                }
                if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.Semicolon))) {
                    int statementStart;
                    SemanticEditorPosition atStatementStart;
                    SemanticEditorPosition beforeSemicolon = this.getPosition(editor, offset).before().beforeOptional(JavaLikeElement.Semicolon);
                    if (beforeSemicolon.isAt(JavaLikeElement.BlockClosingBrace)) {
                        beforeSemicolon.beforeParentheses(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                    }
                    if (!this.isInsideForLikeConstruction(atStatementStart = this.getPosition(editor, statementStart = this.getStatementStartOffset(beforeSemicolon)))) {
                        return myFactory.createIndentCalculator(Indent.Type.NONE, position -> statementStart);
                    }
                } else {
                    if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.ArrayOpeningBracket))) {
                        return myFactory.createIndentCalculator(this.getIndentTypeInBrackets(), IndentCalculator.LINE_BEFORE);
                    }
                    if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.LeftParenthesis))) {
                        return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
                    }
                    if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.BlockOpeningBrace) && !position.before().beforeOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.LeftParenthesis))) {
                        SemanticEditorPosition position3 = this.getPosition(editor, offset).before();
                        return myFactory.createIndentCalculator(this.getIndentTypeInBlock(project2, language, position3), this::getBlockStatementStartOffset);
                    }
                    if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.Colon) && position.isAfterOnSameLine(JavaLikeElement.SwitchCase, JavaLikeElement.SwitchDefault)) || this.getPosition(editor, offset).matchesRule(position -> position.before().isAtAnyOf(JavaLikeElement.ElseKeyword, JavaLikeElement.DoKeyword))) {
                        return myFactory.createIndentCalculator(Indent.Type.NORMAL, IndentCalculator.LINE_BEFORE);
                    }
                    if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.BlockComment) && position.before().isAt(JavaLikeElement.Whitespace) && position.isAtMultiline())) {
                        return myFactory.createIndentCalculator(Indent.Type.NONE, position -> position.findStartOf(JavaLikeElement.BlockComment));
                    }
                    if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.DocBlockEnd))) {
                        return myFactory.createIndentCalculator(Indent.Type.NONE, position -> position.findStartOf(JavaLikeElement.DocBlockStart));
                    }
                    SemanticEditorPosition position4 = this.getPosition(editor, offset);
                    if ((position4 = position4.before().beforeOptionalMix(JavaLikeElement.LineComment, JavaLikeElement.BlockComment, JavaLikeElement.Whitespace)).isAt(JavaLikeElement.RightParenthesis)) {
                        int offsetAfterParen = position4.getStartOffset() + 1;
                        position4.beforeParentheses(JavaLikeElement.LeftParenthesis, JavaLikeElement.RightParenthesis);
                        if (!position4.isAtEnd()) {
                            position4.beforeOptional(JavaLikeElement.Whitespace);
                            if (position4.isAt(JavaLikeElement.IfKeyword) || position4.isAt(JavaLikeElement.ForKeyword)) {
                                SemanticEditorPosition.SyntaxElement element2 = position4.getCurrElement();
                                assert (element2 != null);
                                int controlKeywordOffset = position4.getStartOffset();
                                Indent.Type indentType = this.getPosition(editor, offsetAfterParen).afterOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.BlockOpeningBrace) ? Indent.Type.NONE : Indent.Type.NORMAL;
                                return myFactory.createIndentCalculator(indentType, baseLineOffset -> controlKeywordOffset);
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    protected boolean isInsideForLikeConstruction(SemanticEditorPosition position) {
        return position.isAfterOnSameLine(JavaLikeElement.ForKeyword);
    }

    private int getBlockStatementStartOffset(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(4);
        }
        position.before().beforeOptional(JavaLikeElement.BlockOpeningBrace);
        if (position.isAt(JavaLikeElement.Whitespace)) {
            if (position.isAtMultiline()) {
                return position.after().getStartOffset();
            }
            position.before();
        }
        return this.getStatementStartOffset(position);
    }

    private int getStatementStartOffset(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(5);
        }
        Language currLanguage = position.getLanguage();
        while (!position.isAtEnd()) {
            if (currLanguage == Language.ANY || currLanguage == null) {
                currLanguage = position.getLanguage();
            }
            if (position.isAt(JavaLikeElement.Colon)) {
                SemanticEditorPosition afterColon = this.getPosition(position.getEditor(), position.getStartOffset()).after().afterOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.LineComment);
                if (this.getPosition(position.getEditor(), position.getStartOffset()).isAfterOnSameLine(JavaLikeElement.SwitchCase, JavaLikeElement.SwitchDefault)) {
                    return afterColon.getStartOffset();
                }
            } else {
                if (position.isAt(JavaLikeElement.RightParenthesis)) {
                    position.beforeParentheses(JavaLikeElement.LeftParenthesis, JavaLikeElement.RightParenthesis);
                    continue;
                }
                if (position.isAt(JavaLikeElement.BlockClosingBrace)) {
                    position.beforeParentheses(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                    continue;
                }
                if (position.isAt(JavaLikeElement.ArrayClosingBracket)) {
                    position.beforeParentheses(JavaLikeElement.ArrayOpeningBracket, JavaLikeElement.ArrayClosingBracket);
                    continue;
                }
                if (position.isAtAnyOf(JavaLikeElement.Semicolon, JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockComment, JavaLikeElement.DocBlockEnd, JavaLikeElement.LeftParenthesis, JavaLikeElement.LanguageStartDelimiter) || position.getLanguage() != Language.ANY && !position.isAtLanguage(currLanguage)) {
                    SemanticEditorPosition statementStart = this.getPosition(position.getEditor(), position.getStartOffset());
                    statementStart.after().afterOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.LineComment);
                    if (!statementStart.isAtEnd()) {
                        return statementStart.getStartOffset();
                    }
                }
            }
            position.before();
        }
        return 0;
    }

    protected SemanticEditorPosition getPosition(@NotNull Editor editor, int offset) {
        if (editor == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(6);
        }
        return new SemanticEditorPosition((EditorEx)editor, offset){

            @Override
            public SemanticEditorPosition.SyntaxElement map(@NotNull IElementType elementType) {
                if (elementType == null) {
                    1.$$$reportNull$$$0(0);
                }
                return JavaLikeLangLineIndentProvider.this.mapType(elementType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider$1", "map"));
            }
        };
    }

    @Nullable
    protected abstract SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType var1);

    @Nullable
    protected Indent.Type getIndentTypeInBlock(@NotNull Project project2, @Nullable Language language, @NotNull SemanticEditorPosition blockStartPosition) {
        if (project2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(7);
        }
        if (blockStartPosition == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(8);
        }
        if (language != null) {
            CommonCodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project2).getCommonSettings(language);
            if (settings.BRACE_STYLE == 3) {
                return settings.METHOD_BRACE_STYLE == 3 ? Indent.Type.NONE : null;
            }
        }
        return Indent.Type.NORMAL;
    }

    @Nullable
    private static Indent.Type getBlockIndentType(@NotNull Project project2, @Nullable Language language) {
        if (project2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(9);
        }
        if (language != null) {
            CommonCodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project2).getCommonSettings(language);
            if (settings.BRACE_STYLE == 2 || settings.BRACE_STYLE == 1) {
                return Indent.Type.NONE;
            }
        }
        return null;
    }

    public final boolean isSuitableFor(@Nullable Language language) {
        return language != null && this.isSuitableForLanguage(language);
    }

    public abstract boolean isSuitableForLanguage(@NotNull Language var1);

    protected Indent.Type getIndentTypeInBrackets() {
        return Indent.Type.CONTINUATION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStartPosition";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineIndent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockStatementStartOffset";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getStatementStartOffset";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPosition";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentTypeInBlock";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockIndentType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class IndentCalculatorFactory {
        private Project myProject;
        private Editor myEditor;

        public IndentCalculatorFactory(Project project2, Editor editor) {
            this.myProject = project2;
            this.myEditor = editor;
        }

        @Nullable
        public IndentCalculator createIndentCalculator(@Nullable Indent.Type indentType, @Nullable IndentCalculator.BaseLineOffsetCalculator baseLineOffsetCalculator) {
            return indentType != null ? new IndentCalculator(this.myProject, this.myEditor, baseLineOffsetCalculator != null ? baseLineOffsetCalculator : IndentCalculator.LINE_BEFORE, indentType) : null;
        }
    }

    public static enum JavaLikeElement implements SemanticEditorPosition.SyntaxElement
    {
        Whitespace,
        Semicolon,
        BlockOpeningBrace,
        BlockClosingBrace,
        ArrayOpeningBracket,
        ArrayClosingBracket,
        RightParenthesis,
        LeftParenthesis,
        Colon,
        SwitchCase,
        SwitchDefault,
        ElseKeyword,
        IfKeyword,
        ForKeyword,
        TryKeyword,
        DoKeyword,
        BlockComment,
        DocBlockStart,
        DocBlockEnd,
        LineComment,
        Comma,
        LanguageStartDelimiter;

    }
}

