/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaResolveCache {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.JavaResolveCache");
    private static final NotNullLazyKey<JavaResolveCache, Project> INSTANCE_KEY = ServiceManager.createLazyKey(JavaResolveCache.class);
    private final ConcurrentMap<PsiExpression, PsiType> myCalculatedTypes = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private final Map<PsiVariable, Object> myVarToConstValueMapPhysical = ContainerUtil.createConcurrentWeakMap();
    private final Map<PsiVariable, Object> myVarToConstValueMapNonPhysical = ContainerUtil.createConcurrentWeakMap();
    private static final Object NULL = Key.create((String)"NULL");

    public static JavaResolveCache getInstance(Project project2) {
        return (JavaResolveCache)INSTANCE_KEY.getValue((UserDataHolder)project2);
    }

    public JavaResolveCache(@Nullable(value="can be null in com.intellij.core.JavaCoreApplicationEnvironment.JavaCoreApplicationEnvironment") MessageBus messageBus) {
        if (messageBus != null) {
            messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener.Adapter(){

                @Override
                public void beforePsiChanged(boolean isPhysical) {
                    JavaResolveCache.this.clearCaches(isPhysical);
                }
            });
        }
    }

    private void clearCaches(boolean isPhysical) {
        this.myCalculatedTypes.clear();
        if (isPhysical) {
            this.myVarToConstValueMapPhysical.clear();
        }
        this.myVarToConstValueMapNonPhysical.clear();
    }

    @Nullable
    public <T extends PsiExpression> PsiType getType(@NotNull T expr, @NotNull Function<T, PsiType> f) {
        PsiType type2;
        if (expr == null) {
            JavaResolveCache.$$$reportNull$$$0(0);
        }
        if (f == null) {
            JavaResolveCache.$$$reportNull$$$0(1);
        }
        boolean isOverloadCheck = MethodCandidateInfo.isOverloadCheck() || LambdaUtil.isLambdaParameterCheck();
        boolean polyExpression = PsiPolyExpressionUtil.isPolyExpression(expr);
        PsiType psiType = type2 = isOverloadCheck && polyExpression ? null : (PsiType)this.myCalculatedTypes.get(expr);
        if (type2 == null) {
            RecursionGuard.StackStamp dStackStamp = PsiDiamondType.ourDiamondGuard.markStack();
            type2 = (PsiType)f.fun(expr);
            if (!dStackStamp.mayCacheNow()) {
                return type2;
            }
            if (isOverloadCheck && polyExpression) {
                return type2;
            }
            if (type2 == null) {
                type2 = TypeConversionUtil.NULL_TYPE;
            }
            this.myCalculatedTypes.put(expr, type2);
            if (type2 instanceof PsiClassReferenceType) {
                PsiClassType.ClassResolveResult result2 = ((PsiClassReferenceType)type2).resolveGenerics();
                PsiClass psiClass = result2.getElement();
                Object object = type2 = psiClass == null ? type2 : new PsiImmediateClassType(psiClass, result2.getSubstitutor(), ((PsiClassReferenceType)type2).getLanguageLevel(), type2.getAnnotationProvider());
            }
        }
        if (!type2.isValid()) {
            if (expr.isValid()) {
                PsiJavaCodeReferenceElement refInside = type2 instanceof PsiClassReferenceType ? ((PsiClassReferenceType)type2).getReference() : null;
                String typeinfo = type2 + " (" + type2.getClass() + ")" + (refInside == null ? "" : "; ref inside: " + refInside + " (" + refInside.getClass() + ") valid:" + refInside.isValid());
                LOG.error("Type is invalid: " + typeinfo + "; expr: '" + expr + "' (" + expr.getClass() + ") is valid");
            } else {
                LOG.error("Expression: '" + expr + "' is invalid, must not be used for getType()");
            }
        }
        return type2 == TypeConversionUtil.NULL_TYPE ? null : type2;
    }

    @Nullable
    public Object computeConstantValueWithCaching(@NotNull PsiVariable variable, @NotNull ConstValueComputer computer, Set<PsiVariable> visitedVars) {
        boolean physical;
        Map<PsiVariable, Object> map;
        Object cached;
        if (variable == null) {
            JavaResolveCache.$$$reportNull$$$0(2);
        }
        if (computer == null) {
            JavaResolveCache.$$$reportNull$$$0(3);
        }
        if ((cached = (map = (physical = variable.isPhysical()) ? this.myVarToConstValueMapPhysical : this.myVarToConstValueMapNonPhysical).get(variable)) == NULL) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        Object result2 = computer.execute(variable, visitedVars);
        map.put(variable, result2 == null ? NULL : result2);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/resolve/JavaResolveCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "computeConstantValueWithCaching";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ConstValueComputer {
        public Object execute(@NotNull PsiVariable var1, Set<PsiVariable> var2);
    }
}

