/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.GenericReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassKind;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassReferenceProvider
extends GenericReferenceProvider
implements CustomizableReferenceProvider {
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> RESOLVE_QUALIFIED_CLASS_NAME = new CustomizableReferenceProvider.CustomizationKey(PsiBundle.message((String)"qualified.resolve.class.reference.provider.option", (Object[])new Object[0]));
    public static final CustomizableReferenceProvider.CustomizationKey<List<String>> SUPER_CLASSES = new CustomizableReferenceProvider.CustomizationKey("SUPER_CLASSES");
    public static final CustomizableReferenceProvider.CustomizationKey<List<String>> IMPORTS = new CustomizableReferenceProvider.CustomizationKey("IMPORTS");
    public static final CustomizableReferenceProvider.CustomizationKey<String> CLASS_TEMPLATE = new CustomizableReferenceProvider.CustomizationKey("CLASS_TEMPLATE");
    public static final CustomizableReferenceProvider.CustomizationKey<ClassKind> CLASS_KIND = new CustomizableReferenceProvider.CustomizationKey("CLASS_KIND");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> INSTANTIATABLE = new CustomizableReferenceProvider.CustomizationKey("INSTANTIATABLE");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> CONCRETE = new CustomizableReferenceProvider.CustomizationKey("CONCRETE");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> NOT_INTERFACE = new CustomizableReferenceProvider.CustomizationKey("NOT_INTERFACE");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> NOT_ENUM = new CustomizableReferenceProvider.CustomizationKey("NOT_ENUM");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> ADVANCED_RESOLVE = new CustomizableReferenceProvider.CustomizationKey("RESOLVE_ONLY_CLASSES");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> JVM_FORMAT = new CustomizableReferenceProvider.CustomizationKey("JVM_FORMAT");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> ALLOW_DOLLAR_NAMES = new CustomizableReferenceProvider.CustomizationKey("ALLOW_DOLLAR_NAMES");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> ALLOW_WILDCARDS = new CustomizableReferenceProvider.CustomizationKey("ALLOW_WILDCARDS");
    public static final CustomizableReferenceProvider.CustomizationKey<String[]> EXTEND_CLASS_NAMES = new CustomizableReferenceProvider.CustomizationKey("EXTEND_CLASS_NAMES");
    public static final CustomizableReferenceProvider.CustomizationKey<String> DEFAULT_PACKAGE = new CustomizableReferenceProvider.CustomizationKey("DEFAULT_PACKAGE");
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;
    private boolean myAllowEmpty;
    private final ParameterizedCachedValueProvider<List<PsiPackage>, Project> myPackagesProvider = new ParameterizedCachedValueProvider<List<PsiPackage>, Project>(){

        public CachedValueProvider.Result<List<PsiPackage>> compute(Project project2) {
            PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)project2);
            List psiPackages = JBIterable.of((Object)"").append((Iterable)IMPORTS.getValue(JavaClassReferenceProvider.this.myOptions)).filterMap(o -> o == null ? null : JavaPsiFacade.getInstance((Project)project2).findPackage(o)).flatten(o -> JBIterable.of((Object[])o.getSubPackages())).filter(o -> nameHelper.isIdentifier(o.getName(), PsiUtil.getLanguageLevel((PsiElement)o))).toList();
            return CachedValueProvider.Result.createSingleDependency((Object)psiPackages, (Object)PsiModificationTracker.MODIFICATION_COUNT);
        }
    };
    private static final Key<ParameterizedCachedValue<List<PsiPackage>, Project>> PACKAGES_KEY = Key.create((String)"default packages");

    public <T> void setOption(CustomizableReferenceProvider.CustomizationKey<T> option, T value2) {
        if (this.myOptions == null) {
            this.myOptions = new THashMap();
        }
        if (option == EXTEND_CLASS_NAMES) {
            SUPER_CLASSES.putValue(this.myOptions, (List<String>)ContainerUtil.immutableList((Object[])((String[])value2)));
        } else if (option == DEFAULT_PACKAGE) {
            IMPORTS.putValue(this.myOptions, Collections.singletonList((String)value2));
        } else {
            option.putValue(this.myOptions, value2);
        }
    }

    @Nullable
    public <T> T getOption(@NotNull CustomizableReferenceProvider.CustomizationKey<T> option) {
        if (option == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(0);
        }
        return this.myOptions == null ? null : (T)option.getValue(this.myOptions);
    }

    @Nullable
    public GlobalSearchScope getScope(@NotNull Project project2) {
        if (project2 == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(1);
        }
        return null;
    }

    @NotNull
    public PsiFile getContextFile(@NotNull PsiElement element) {
        if (element == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(3);
        }
        return psiFile;
    }

    @Nullable
    public PsiClass getContextClass(@NotNull PsiElement element) {
        if (element == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(6);
        }
        PsiReference[] psiReferenceArray = this.getReferencesByElement(element);
        if (psiReferenceArray == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(7);
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(8);
        }
        int offsetInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
        String text2 = ElementManipulators.getValueText((PsiElement)element);
        PsiReference[] psiReferenceArray = this.getReferencesByString(text2, element, offsetInElement);
        if (psiReferenceArray == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(9);
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] getReferencesByString(String str, @NotNull PsiElement position, int offsetInPosition) {
        if (position == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(10);
        }
        if (this.myAllowEmpty && StringUtil.isEmpty((String)str)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JavaClassReferenceProvider.$$$reportNull$$$0(11);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        boolean allowDollars = Boolean.TRUE.equals(this.getOption(ALLOW_DOLLAR_NAMES));
        PsiReference[] psiReferenceArray = new JavaClassReferenceSet(str, position, offsetInPosition, allowDollars, this).getAllReferences();
        if (psiReferenceArray == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(12);
        }
        return psiReferenceArray;
    }

    @Override
    public void handleEmptyContext(PsiScopeProcessor processor2, PsiElement position) {
        ElementClassHint hint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if (position == null) {
            return;
        }
        if (hint == null || hint.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE) || hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            List<PsiPackage> cachedPackages = this.getDefaultPackages(position.getProject());
            for (PsiElement psiElement : cachedPackages) {
                if (processor2.execute(psiElement, ResolveState.initial())) continue;
                return;
            }
        }
    }

    @NotNull
    protected List<PsiPackage> getDefaultPackages(@NotNull Project project2) {
        if (project2 == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(13);
        }
        List list2 = (List)CachedValuesManager.getManager((Project)project2).getParameterizedCachedValue((UserDataHolder)project2, PACKAGES_KEY, this.myPackagesProvider, false, (Object)project2);
        if (list2 == null) {
            JavaClassReferenceProvider.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @Override
    public void setOptions(@Nullable Map<CustomizableReferenceProvider.CustomizationKey, Object> options) {
        this.myOptions = options;
    }

    @Override
    @Nullable
    public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myOptions;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.myAllowEmpty = allowEmpty;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReferenceProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReferenceProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextFile";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByString";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOption";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContextFile";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContextClass";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByString";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPackages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

