/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.text;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.ASTShallowComparator;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IReparseableElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.diff.DiffTree;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSupportImpl
extends BlockSupport {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.text.BlockSupportImpl");

    public BlockSupportImpl(Project project2) {
        project2.getMessageBus().connect().subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateStarted(@NotNull Document doc) {
                if (doc == null) {
                    1.$$$reportNull$$$0(0);
                }
                doc.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)Boolean.TRUE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/source/text/BlockSupportImpl$1", "updateStarted"));
            }
        });
    }

    @Override
    public void reparseRange(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull CharSequence newText) throws IncorrectOperationException {
        if (file2 == null) {
            BlockSupportImpl.$$$reportNull$$$0(0);
        }
        if (newText == null) {
            BlockSupportImpl.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(file2.isValid());
        PsiFileImpl psiFile = (PsiFileImpl)file2;
        Document document = psiFile.getViewProvider().getDocument();
        assert (document != null);
        document.replaceString(startOffset, endOffset, newText);
        PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitDocument(document);
    }

    @Override
    @NotNull
    public DiffLog reparseRange(@NotNull PsiFile file2, @NotNull FileASTNode oldFileNode, @NotNull TextRange changedPsiRange, @NotNull CharSequence newFileText, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        PsiFileImpl fileImpl;
        Couple<ASTNode> reparseableRoots;
        if (file2 == null) {
            BlockSupportImpl.$$$reportNull$$$0(2);
        }
        if (oldFileNode == null) {
            BlockSupportImpl.$$$reportNull$$$0(3);
        }
        if (changedPsiRange == null) {
            BlockSupportImpl.$$$reportNull$$$0(4);
        }
        if (newFileText == null) {
            BlockSupportImpl.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            BlockSupportImpl.$$$reportNull$$$0(6);
        }
        if (lastCommittedText == null) {
            BlockSupportImpl.$$$reportNull$$$0(7);
        }
        DiffLog diffLog = (reparseableRoots = this.findReparseableRoots(fileImpl = (PsiFileImpl)file2, oldFileNode, changedPsiRange, newFileText)) != null ? BlockSupportImpl.mergeTrees(fileImpl, (ASTNode)reparseableRoots.first, (ASTNode)reparseableRoots.second, indicator, lastCommittedText) : BlockSupportImpl.makeFullParse(fileImpl, oldFileNode, newFileText, indicator, lastCommittedText);
        if (diffLog == null) {
            BlockSupportImpl.$$$reportNull$$$0(8);
        }
        return diffLog;
    }

    @Nullable
    public Couple<ASTNode> findReparseableRoots(@NotNull PsiFileImpl file2, @NotNull FileASTNode oldFileNode, @NotNull TextRange changedPsiRange, @NotNull CharSequence newFileText) {
        if (file2 == null) {
            BlockSupportImpl.$$$reportNull$$$0(9);
        }
        if (oldFileNode == null) {
            BlockSupportImpl.$$$reportNull$$$0(10);
        }
        if (changedPsiRange == null) {
            BlockSupportImpl.$$$reportNull$$$0(11);
        }
        if (newFileText == null) {
            BlockSupportImpl.$$$reportNull$$$0(12);
        }
        Project project2 = file2.getProject();
        FileElement fileElement = (FileElement)oldFileNode;
        CharTable charTable = fileElement.getCharTable();
        int lengthShift = newFileText.length() - fileElement.getTextLength();
        if (fileElement.getElementType() instanceof ITemplateDataElementType || BlockSupportImpl.isTooDeep((UserDataHolder)file2)) {
            return null;
        }
        LeafElement leafAtStart = fileElement.findLeafElementAt(Math.max(0, changedPsiRange.getStartOffset() - 1));
        LeafElement leafAtEnd = fileElement.findLeafElementAt(Math.min(changedPsiRange.getEndOffset(), fileElement.getTextLength() - 1));
        Language baseLanguage = file2.getViewProvider().getBaseLanguage();
        for (FileElement node = leafAtStart != null && leafAtEnd != null ? TreeUtil.findCommonParent(leafAtStart, leafAtEnd) : fileElement; node != null && !(node instanceof FileElement); node = node.getTreeParent()) {
            ASTNode chameleon;
            IElementType elementType = node.getElementType();
            if (!(elementType instanceof IReparseableElementType)) continue;
            TextRange textRange = node.getTextRange();
            IReparseableElementType reparseable = (IReparseableElementType)elementType;
            if (!baseLanguage.isKindOf(reparseable.getLanguage()) || textRange.getLength() + lengthShift <= 0) continue;
            int start = textRange.getStartOffset();
            int end = start + textRange.getLength() + lengthShift;
            if (end > newFileText.length()) {
                BlockSupportImpl.reportInconsistentLength(file2, newFileText, node, start, end);
                break;
            }
            CharSequence newTextStr = newFileText.subSequence(start, end);
            if (!reparseable.isParsable(node.getTreeParent(), newTextStr, baseLanguage, project2) || (chameleon = reparseable.createNode(newTextStr)) == null) continue;
            DummyHolder holder = DummyHolderFactory.createHolder(file2.getManager(), null, node.getPsi(), charTable);
            holder.getTreeElement().rawAddChildren((TreeElement)chameleon);
            if (holder.getTextLength() != newTextStr.length()) {
                String details = ApplicationManager.getApplication().isInternal() ? "text=" + newTextStr + "; treeText=" + holder.getText() + ";" : "";
                LOG.error("Inconsistent reparse: " + details + " type=" + elementType);
            }
            return Couple.of((Object)node, (Object)chameleon);
        }
        return null;
    }

    private static void reportInconsistentLength(PsiFile file2, CharSequence newFileText, ASTNode node, int start, int end) {
        String message2 = "Index out of bounds: type=" + node.getElementType() + "; file=" + file2 + "; file.class=" + file2.getClass() + "; start=" + start + "; end=" + end + "; length=" + node.getTextLength();
        String newTextBefore = newFileText.subSequence(0, start).toString();
        String oldTextBefore = file2.getText().subSequence(0, start).toString();
        if (oldTextBefore.equals(newTextBefore)) {
            message2 = message2 + "; oldTextBefore==newTextBefore";
        }
        LOG.error(message2, new Attachment[]{new Attachment(file2.getName() + "_oldNodeText.txt", node.getText()), new Attachment(file2.getName() + "_oldFileText.txt", file2.getText()), new Attachment(file2.getName() + "_newFileText.txt", newFileText.toString())});
    }

    @NotNull
    public static DiffLog makeFullParse(@NotNull PsiFileImpl fileImpl, @NotNull FileASTNode oldFileNode, @NotNull CharSequence newFileText, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        if (fileImpl == null) {
            BlockSupportImpl.$$$reportNull$$$0(13);
        }
        if (oldFileNode == null) {
            BlockSupportImpl.$$$reportNull$$$0(14);
        }
        if (newFileText == null) {
            BlockSupportImpl.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            BlockSupportImpl.$$$reportNull$$$0(16);
        }
        if (lastCommittedText == null) {
            BlockSupportImpl.$$$reportNull$$$0(17);
        }
        if (fileImpl instanceof PsiCodeFragment) {
            FileElement parent = fileImpl.getTreeElement();
            FileElement holderElement = new DummyHolder(fileImpl.getManager(), fileImpl.getContext()).getTreeElement();
            holderElement.rawAddChildren(fileImpl.createContentLeafElement(holderElement.getCharTable().intern(newFileText, 0, newFileText.length())));
            DiffLog diffLog = new DiffLog();
            diffLog.appendReplaceFileElement(parent, (FileElement)holderElement.getFirstChildNode());
            DiffLog diffLog2 = diffLog;
            if (diffLog2 == null) {
                BlockSupportImpl.$$$reportNull$$$0(18);
            }
            return diffLog2;
        }
        FileViewProvider viewProvider = fileImpl.getViewProvider();
        viewProvider.getLanguages();
        FileType fileType = viewProvider.getVirtualFile().getFileType();
        String fileName = fileImpl.getName();
        LightVirtualFile lightFile = new LightVirtualFile(fileName, fileType, newFileText, viewProvider.getVirtualFile().getCharset(), fileImpl.getViewProvider().getModificationStamp());
        lightFile.setOriginalFile(viewProvider.getVirtualFile());
        FileViewProvider copy = viewProvider.createCopy((VirtualFile)lightFile);
        if (copy.isEventSystemEnabled()) {
            throw new AssertionError((Object)("Copied view provider must be non-physical for reparse to deliver correct events: " + viewProvider));
        }
        copy.getLanguages();
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)lightFile);
        PsiFileImpl newFile = BlockSupportImpl.getFileCopy(fileImpl, copy);
        newFile.setOriginalFile(fileImpl);
        FileElement newFileElement = (FileElement)newFile.getNode();
        FileElement oldFileElement = (FileElement)oldFileNode;
        if (lastCommittedText.length() != oldFileElement.getTextLength()) {
            throw new IncorrectOperationException(viewProvider.toString());
        }
        DiffLog diffLog = BlockSupportImpl.mergeTrees(fileImpl, oldFileElement, newFileElement, indicator, lastCommittedText);
        ((PsiManagerEx)fileImpl.getManager()).getFileManager().setViewProvider((VirtualFile)lightFile, null);
        DiffLog diffLog3 = diffLog;
        if (diffLog3 == null) {
            BlockSupportImpl.$$$reportNull$$$0(19);
        }
        return diffLog3;
    }

    @NotNull
    public static PsiFileImpl getFileCopy(@NotNull PsiFileImpl originalFile, @NotNull FileViewProvider providerCopy) {
        if (originalFile == null) {
            BlockSupportImpl.$$$reportNull$$$0(20);
        }
        if (providerCopy == null) {
            BlockSupportImpl.$$$reportNull$$$0(21);
        }
        FileViewProvider viewProvider = originalFile.getViewProvider();
        Language language = originalFile.getLanguage();
        PsiFile file2 = providerCopy.getPsi(language);
        if (file2 != null && !(file2 instanceof PsiFileImpl)) {
            throw new RuntimeException("View provider " + viewProvider + " refused to provide PsiFileImpl for " + language + BlockSupportImpl.details(providerCopy, viewProvider));
        }
        PsiFileImpl newFile = (PsiFileImpl)file2;
        if (newFile == null && language == PlainTextLanguage.INSTANCE && originalFile == viewProvider.getPsi(viewProvider.getBaseLanguage())) {
            newFile = (PsiFileImpl)providerCopy.getPsi(providerCopy.getBaseLanguage());
        }
        if (newFile == null) {
            throw new RuntimeException("View provider " + viewProvider + " refused to parse text with " + language + BlockSupportImpl.details(providerCopy, viewProvider));
        }
        PsiFileImpl psiFileImpl = newFile;
        if (psiFileImpl == null) {
            BlockSupportImpl.$$$reportNull$$$0(22);
        }
        return psiFileImpl;
    }

    private static String details(FileViewProvider providerCopy, FileViewProvider viewProvider) {
        return "; languages: " + viewProvider.getLanguages() + "; base: " + viewProvider.getBaseLanguage() + "; copy: " + providerCopy + "; copy.base: " + providerCopy.getBaseLanguage() + "; vFile: " + viewProvider.getVirtualFile() + "; copy.vFile: " + providerCopy.getVirtualFile() + "; fileType: " + viewProvider.getVirtualFile().getFileType() + "; copy.original(): " + (providerCopy.getVirtualFile() instanceof LightVirtualFile ? ((LightVirtualFile)providerCopy.getVirtualFile()).getOriginalFile() : null);
    }

    @NotNull
    private static DiffLog replaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
        if (oldRoot == null) {
            BlockSupportImpl.$$$reportNull$$$0(23);
        }
        if (newRoot == null) {
            BlockSupportImpl.$$$reportNull$$$0(24);
        }
        DiffLog diffLog = new DiffLog();
        diffLog.appendReplaceElementWithEvents(oldRoot, newRoot);
        DiffLog diffLog2 = diffLog;
        if (diffLog2 == null) {
            BlockSupportImpl.$$$reportNull$$$0(25);
        }
        return diffLog2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static DiffLog mergeTrees(@NotNull PsiFileImpl fileImpl, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        block17: {
            DiffLog diffLog;
            block16: {
                if (fileImpl == null) {
                    BlockSupportImpl.$$$reportNull$$$0(26);
                }
                if (oldRoot == null) {
                    BlockSupportImpl.$$$reportNull$$$0(27);
                }
                if (newRoot == null) {
                    BlockSupportImpl.$$$reportNull$$$0(28);
                }
                if (indicator == null) {
                    BlockSupportImpl.$$$reportNull$$$0(29);
                }
                if (lastCommittedText == null) {
                    BlockSupportImpl.$$$reportNull$$$0(30);
                }
                if (newRoot instanceof FileElement) {
                    ((FileElement)newRoot).setCharTable(fileImpl.getTreeElement().getCharTable());
                }
                try {
                    newRoot.putUserData(TREE_TO_BE_REPARSED, (Object)Pair.create((Object)oldRoot, (Object)lastCommittedText));
                    if (BlockSupportImpl.isReplaceWholeNode(fileImpl, newRoot)) {
                        DiffLog treeChangeEvent = BlockSupportImpl.replaceElementWithEvents((CompositeElement)oldRoot, (CompositeElement)newRoot);
                        fileImpl.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
                        DiffLog diffLog2 = treeChangeEvent;
                        diffLog = diffLog2;
                        break block16;
                    }
                    newRoot.getFirstChildNode();
                    break block17;
                }
                catch (BlockSupport.ReparsedSuccessfullyException e) {
                    DiffLog diffLog3 = e.getDiffLog();
                    DiffLog diffLog4 = diffLog3;
                    if (diffLog4 == null) {
                        BlockSupportImpl.$$$reportNull$$$0(32);
                    }
                    return diffLog4;
                }
            }
            if (diffLog == null) {
                BlockSupportImpl.$$$reportNull$$$0(31);
            }
            return diffLog;
            finally {
                newRoot.putUserData(TREE_TO_BE_REPARSED, null);
            }
        }
        ASTShallowComparator comparator2 = new ASTShallowComparator(indicator);
        ASTStructure treeStructure = BlockSupportImpl.createInterruptibleASTStructure(newRoot, indicator);
        DiffLog diffLog = new DiffLog();
        BlockSupportImpl.diffTrees(oldRoot, diffLog, comparator2, treeStructure, indicator, lastCommittedText);
        DiffLog diffLog5 = diffLog;
        if (diffLog5 == null) {
            BlockSupportImpl.$$$reportNull$$$0(33);
        }
        return diffLog5;
    }

    public static <T> void diffTrees(@NotNull ASTNode oldRoot, @NotNull DiffTreeChangeBuilder<ASTNode, T> builder, @NotNull ShallowNodeComparator<ASTNode, T> comparator2, @NotNull FlyweightCapableTreeStructure<T> newTreeStructure, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        if (oldRoot == null) {
            BlockSupportImpl.$$$reportNull$$$0(34);
        }
        if (builder == null) {
            BlockSupportImpl.$$$reportNull$$$0(35);
        }
        if (comparator2 == null) {
            BlockSupportImpl.$$$reportNull$$$0(36);
        }
        if (newTreeStructure == null) {
            BlockSupportImpl.$$$reportNull$$$0(37);
        }
        if (indicator == null) {
            BlockSupportImpl.$$$reportNull$$$0(38);
        }
        if (lastCommittedText == null) {
            BlockSupportImpl.$$$reportNull$$$0(39);
        }
        TreeUtil.ensureParsedRecursivelyCheckingProgress(oldRoot, indicator);
        DiffTree.diff((FlyweightCapableTreeStructure)BlockSupportImpl.createInterruptibleASTStructure(oldRoot, indicator), newTreeStructure, comparator2, builder, (CharSequence)lastCommittedText);
    }

    private static ASTStructure createInterruptibleASTStructure(@NotNull ASTNode oldRoot, final @NotNull ProgressIndicator indicator) {
        if (oldRoot == null) {
            BlockSupportImpl.$$$reportNull$$$0(40);
        }
        if (indicator == null) {
            BlockSupportImpl.$$$reportNull$$$0(41);
        }
        return new ASTStructure(oldRoot){

            @Override
            public int getChildren(@NotNull ASTNode astNode, @NotNull Ref<ASTNode[]> into) {
                if (astNode == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (into == null) {
                    2.$$$reportNull$$$0(1);
                }
                indicator.checkCanceled();
                return super.getChildren(astNode, into);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "astNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "into";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/impl/source/text/BlockSupportImpl$2";
                objectArray[2] = "getChildren";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isReplaceWholeNode(@NotNull PsiFileImpl fileImpl, @NotNull ASTNode newRoot) throws BlockSupport.ReparsedSuccessfullyException {
        boolean explicitlyMarkedDeep;
        Boolean data;
        if (fileImpl == null) {
            BlockSupportImpl.$$$reportNull$$$0(42);
        }
        if (newRoot == null) {
            BlockSupportImpl.$$$reportNull$$$0(43);
        }
        if ((data = (Boolean)fileImpl.getUserData(DO_NOT_REPARSE_INCREMENTALLY)) != null) {
            fileImpl.putUserData(DO_NOT_REPARSE_INCREMENTALLY, null);
        }
        if ((explicitlyMarkedDeep = Boolean.TRUE.equals(data)) || BlockSupportImpl.isTooDeep((UserDataHolder)fileImpl)) {
            return true;
        }
        ASTNode childNode = newRoot.getFirstChildNode();
        boolean childTooDeep = BlockSupportImpl.isTooDeep((UserDataHolder)childNode);
        if (childTooDeep) {
            childNode.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, null);
            fileImpl.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
        }
        return childTooDeep;
    }

    public static void sendBeforeChildrenChangeEvent(@NotNull PsiManagerImpl manager, @NotNull PsiElement scope, boolean isGenericChange) {
        if (manager == null) {
            BlockSupportImpl.$$$reportNull$$$0(44);
        }
        if (scope == null) {
            BlockSupportImpl.$$$reportNull$$$0(45);
        }
        if (!scope.isPhysical()) {
            manager.beforeChange(false);
            return;
        }
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(manager);
        event.setParent(scope);
        event.setFile(scope.getContainingFile());
        TextRange range = scope.getTextRange();
        event.setOffset(range == null ? 0 : range.getStartOffset());
        event.setOldLength(scope.getTextLength());
        event.setGenericChange(isGenericChange);
        manager.beforeChildrenChange(event);
    }

    public static void sendAfterChildrenChangedEvent(@NotNull PsiManagerImpl manager, @NotNull PsiFile scope, int oldLength, boolean isGenericChange) {
        if (manager == null) {
            BlockSupportImpl.$$$reportNull$$$0(46);
        }
        if (scope == null) {
            BlockSupportImpl.$$$reportNull$$$0(47);
        }
        if (!scope.isPhysical()) {
            manager.afterChange(false);
            return;
        }
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(manager);
        event.setParent((PsiElement)scope);
        event.setFile(scope);
        event.setOffset(0);
        event.setOldLength(oldLength);
        event.setGenericChange(isGenericChange);
        manager.childrenChanged(event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 31: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 3: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFileNode";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedPsiRange";
                break;
            }
            case 5: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileText";
                break;
            }
            case 6: 
            case 16: 
            case 29: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: 
            case 17: 
            case 30: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastCommittedText";
                break;
            }
            case 8: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/text/BlockSupportImpl";
                break;
            }
            case 13: 
            case 26: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileImpl";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerCopy";
                break;
            }
            case 23: 
            case 27: 
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 24: 
            case 28: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTreeStructure";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/text/BlockSupportImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "reparseRange";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFullParse";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileCopy";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceElementWithEvents";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeTrees";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reparseRange";
                break;
            }
            case 8: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findReparseableRoots";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "makeFullParse";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFileCopy";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "replaceElementWithEvents";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "mergeTrees";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "diffTrees";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createInterruptibleASTStructure";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isReplaceWholeNode";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "sendBeforeChildrenChangeEvent";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "sendAfterChildrenChangedEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

