/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.html.ScriptSupportUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class XmlFileImpl
extends PsiFileImpl
implements XmlFile {
    private FileType myType = null;

    public XmlFileImpl(FileViewProvider viewProvider, IElementType elementType) {
        super(elementType, elementType, viewProvider);
    }

    public XmlDocument getDocument() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof XmlDocument)) continue;
            return (XmlDocument)child;
        }
        return null;
    }

    public XmlTag getRootTag() {
        XmlDocument document = this.getDocument();
        return document == null ? null : document.getRootTag();
    }

    public boolean processElements(PsiElementProcessor processor2, PsiElement place) {
        XmlDocument document = this.getDocument();
        return document == null || document.processElements(processor2, place);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlFileImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlFile((XmlFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @Override
    public String toString() {
        return "XmlFile:" + this.getName();
    }

    @NotNull
    public FileType getFileType() {
        if (this.myType == null) {
            this.myType = this.getLanguage().getAssociatedFileType();
            if (this.myType == null) {
                VirtualFile virtualFile = this.getOriginalFile().getVirtualFile();
                this.myType = virtualFile == null ? FileTypeRegistry.getInstance().getFileTypeByFileName(this.getName()) : virtualFile.getFileType();
            }
        }
        FileType fileType = this.myType;
        if (fileType == null) {
            XmlFileImpl.$$$reportNull$$$0(1);
        }
        return fileType;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        if (this.isWebFileType()) {
            ScriptSupportUtil.clearCaches(this);
        }
    }

    private boolean isWebFileType() {
        return this.getLanguage() == XHTMLLanguage.INSTANCE || this.getLanguage() == HTMLLanguage.INSTANCE;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            XmlFileImpl.$$$reportNull$$$0(2);
        }
        if (state == null) {
            XmlFileImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            XmlFileImpl.$$$reportNull$$$0(4);
        }
        return super.processDeclarations(processor2, state, lastParent, place) && (!this.isWebFileType() || ScriptSupportUtil.processDeclarations(this, processor2, state, lastParent, place));
    }

    @NotNull
    public GlobalSearchScope getFileResolveScope() {
        GlobalSearchScope globalSearchScope = ProjectScope.getAllScope((Project)this.getProject());
        if (globalSearchScope == null) {
            XmlFileImpl.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    public boolean ignoreReferencedElementAccessibility() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlFileImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlFileImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileResolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

