/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.stubsHierarchy.impl.IncompleteHierarchyException;
import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.psi.stubsHierarchy.impl.StubResolver;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.impl.Symbols;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class StubHierarchyConnector {
    private final StubResolver myResolve;

    protected StubHierarchyConnector(Symbols symbols) {
        this.myResolve = new StubResolver(symbols, this);
    }

    void connect(Symbol sym) {
        Object supers;
        Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
        if (c.myOwner instanceof Symbol.ClassSymbol) {
            ((Symbol.ClassSymbol)c.myOwner).connect(this);
        }
        if ((supers = c.mySuperClasses) == null) {
            c.setSupers(Collections.emptySet());
            return;
        }
        HashSet<Symbol.ClassSymbol> supertypes = new HashSet<Symbol.ClassSymbol>();
        try {
            if (supers instanceof QualifiedName[]) {
                for (QualifiedName name2 : (QualifiedName[])supers) {
                    name2.resolveCandidates(this.myResolve, c, supertypes);
                }
            } else {
                ((QualifiedName)supers).resolveCandidates(this.myResolve, c, supertypes);
            }
        }
        catch (IncompleteHierarchyException ignore) {
            c.markHierarchyIncomplete();
            return;
        }
        Iterator iterator = supertypes.iterator();
        while (iterator.hasNext()) {
            if (!StubHierarchyConnector.isJavaLangObject((Symbol)iterator.next())) continue;
            iterator.remove();
        }
        c.setSupers(supertypes);
    }

    private static boolean isJavaLangObject(Symbol s) {
        return s.myShortName == NameEnvironment.OBJECT_NAME && s.myOwner instanceof Symbol.PackageSymbol && ((Symbol.PackageSymbol)s.myOwner).myQualifiedName == NameEnvironment.java_lang;
    }
}

