/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceHandlerBase
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.IntroduceHandlerBase");

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        PsiElement[] elements;
        if (editor == null) {
            IntroduceHandlerBase.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            IntroduceHandlerBase.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            IntroduceHandlerBase.$$$reportNull$$$0(2);
        }
        if ((elements = ExtractMethodHandler.getElements(file2.getProject(), editor, file2)) != null && elements.length > 0) {
            return true;
        }
        return this.acceptLocalVariable() && PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), PsiLocalVariable.class) != null;
    }

    protected boolean acceptLocalVariable() {
        return true;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        Editor editor;
        if (project2 == null) {
            IntroduceHandlerBase.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            IntroduceHandlerBase.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(elements.length >= 1 && elements[0] instanceof PsiExpression, (Object)"incorrect invoke() parameters");
        PsiElement tempExpr = elements[0];
        if (dataContext != null) {
            PsiFile cachedPsiFile;
            Editor editorFromDC = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            PsiFile psiFile = cachedPsiFile = editorFromDC != null ? PsiDocumentManager.getInstance((Project)project2).getCachedPsiFile(editorFromDC.getDocument()) : null;
            editor = cachedPsiFile != null && PsiTreeUtil.isAncestor((PsiElement)cachedPsiFile, (PsiElement)tempExpr, (boolean)false) ? editorFromDC : null;
        } else {
            editor = null;
        }
        this.invoke(project2, tempExpr, editor);
    }

    public void invoke(@NotNull Project project2, PsiElement element, @Nullable Editor editor) {
        if (project2 == null) {
            IntroduceHandlerBase.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiExpression) {
            this.invokeImpl(project2, (PsiExpression)element, editor);
        } else if (element instanceof PsiLocalVariable) {
            this.invokeImpl(project2, (PsiLocalVariable)element, editor);
        } else {
            LOG.error("elements[0] should be PsiExpression or PsiLocalVariable");
        }
    }

    protected abstract boolean invokeImpl(Project var1, PsiExpression var2, Editor var3);

    protected abstract boolean invokeImpl(Project var1, PsiLocalVariable var2, Editor var3);

    public abstract AbstractInplaceIntroducer getInplaceIntroducer();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/IntroduceHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

