/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallReferenceUsageInfo;
import com.intellij.refactoring.changeSignature.CallerUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureParameterUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.changeSignature.DefaultValueChooser;
import com.intellij.refactoring.changeSignature.FunctionalInterfaceChangedUsageInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageSearcher;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.MethodCallUsageInfo;
import com.intellij.refactoring.changeSignature.MethodReferenceUsageInfo;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.siyeh.IntentionPowerPackBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageProcessor");

    private static boolean isJavaUsage(UsageInfo info) {
        PsiElement element = info.getElement();
        if (element == null) {
            return false;
        }
        return element.getLanguage() == StdLanguages.JAVA;
    }

    public UsageInfo[] findUsages(ChangeInfo info) {
        if (info instanceof JavaChangeInfo) {
            return new JavaChangeSignatureUsageSearcher((JavaChangeInfo)info).findUsages();
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    public MultiMap<PsiElement, String> findConflicts(ChangeInfo info, Ref<UsageInfo[]> refUsages) {
        if (info instanceof JavaChangeInfo) {
            return new ConflictSearcher((JavaChangeInfo)info).findConflicts(refUsages);
        }
        return new MultiMap();
    }

    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usage, boolean beforeMethodChange, UsageInfo[] usages) {
        if (!JavaChangeSignatureUsageProcessor.isJavaUsage(usage)) {
            return false;
        }
        if (!(changeInfo instanceof JavaChangeInfo)) {
            return false;
        }
        if (beforeMethodChange) {
            if (usage instanceof CallerUsageInfo) {
                CallerUsageInfo callerUsageInfo = (CallerUsageInfo)usage;
                JavaChangeSignatureUsageProcessor.processCallerMethod((JavaChangeInfo)changeInfo, callerUsageInfo.getMethod(), null, callerUsageInfo.isToInsertParameter(), callerUsageInfo.isToInsertException());
                return true;
            }
            if (usage instanceof OverriderUsageInfo) {
                OverriderUsageInfo info = (OverriderUsageInfo)usage;
                PsiMethod method = info.getOverridingMethod();
                PsiMethod baseMethod = info.getBaseMethod();
                if (info.isOriginalOverrider()) {
                    JavaChangeSignatureUsageProcessor.processPrimaryMethod((JavaChangeInfo)changeInfo, method, baseMethod, false);
                } else {
                    JavaChangeSignatureUsageProcessor.processCallerMethod((JavaChangeInfo)changeInfo, method, baseMethod, info.isToInsertArgs(), info.isToCatchExceptions());
                }
                return true;
            }
            if (usage instanceof MethodReferenceUsageInfo && MethodReferenceUsageInfo.needToExpand((JavaChangeInfo)changeInfo)) {
                PsiExpression expression2;
                PsiElement element = usage.getElement();
                if (element instanceof PsiMethodReferenceExpression && (expression2 = LambdaRefactoringUtil.convertToMethodCallInLambdaBody((PsiMethodReferenceExpression)element)) instanceof PsiCallExpression) {
                    ((MethodReferenceUsageInfo)usage).setCallExpression((PsiCallExpression)expression2);
                    return true;
                }
            } else if (usage instanceof FunctionalInterfaceChangedUsageInfo) {
                PsiLambdaExpression lambdaExpression;
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)usage.getProject());
                PsiElement element = usage.getElement();
                PsiMethod interfaceMethod = ((FunctionalInterfaceChangedUsageInfo)usage).getMethod();
                if (element instanceof PsiLambdaExpression) {
                    JavaChangeSignatureUsageProcessor.processMethodParams((JavaChangeInfo)changeInfo, interfaceMethod, elementFactory, PsiSubstitutor.EMPTY, ((PsiLambdaExpression)element).getParameterList(), ((PsiLambdaExpression)element).getBody());
                } else if (element instanceof PsiMethodReferenceExpression && (lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)element, false, true)) != null) {
                    JavaChangeSignatureUsageProcessor.processMethodParams((JavaChangeInfo)changeInfo, interfaceMethod, elementFactory, PsiSubstitutor.EMPTY, lambdaExpression.getParameterList(), lambdaExpression.getBody());
                }
                return true;
            }
        } else {
            PsiElement element = usage.getElement();
            LOG.assertTrue(element != null);
            if (usage instanceof DefaultConstructorImplicitUsageInfo) {
                DefaultConstructorImplicitUsageInfo defConstructorUsage = (DefaultConstructorImplicitUsageInfo)usage;
                PsiMethod constructor = defConstructorUsage.getConstructor();
                if (!constructor.isPhysical()) {
                    boolean toPropagate = changeInfo instanceof JavaChangeInfoImpl && ((JavaChangeInfoImpl)changeInfo).propagateParametersMethods.remove(constructor);
                    PsiClass containingClass = defConstructorUsage.getContainingClass();
                    constructor = (PsiMethod)containingClass.add((PsiElement)constructor);
                    PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)containingClass.getModifierList()), (boolean)true);
                    if (toPropagate) {
                        ((JavaChangeInfoImpl)changeInfo).propagateParametersMethods.add(constructor);
                    }
                }
                JavaChangeSignatureUsageProcessor.addSuperCall((JavaChangeInfo)changeInfo, constructor, defConstructorUsage.getBaseConstructor(), usages);
                return true;
            }
            if (usage instanceof NoConstructorClassUsageInfo) {
                JavaChangeSignatureUsageProcessor.addDefaultConstructor((JavaChangeInfo)changeInfo, ((NoConstructorClassUsageInfo)usage).getPsiClass(), usages);
                return true;
            }
            if (usage instanceof MethodReferenceUsageInfo && MethodReferenceUsageInfo.needToExpand((JavaChangeInfo)changeInfo)) {
                MethodCallUsageInfo methodCallInfo = ((MethodReferenceUsageInfo)usage).createMethodCallInfo();
                if (methodCallInfo != null) {
                    JavaChangeSignatureUsageProcessor.processMethodUsage(methodCallInfo.getElement(), (JavaChangeInfo)changeInfo, methodCallInfo.isToChangeArguments(), methodCallInfo.isToCatchExceptions(), methodCallInfo.getReferencedMethod(), methodCallInfo.getSubstitutor(), usages);
                    return true;
                }
            } else {
                if (usage instanceof MethodCallUsageInfo) {
                    MethodCallUsageInfo methodCallInfo = (MethodCallUsageInfo)usage;
                    JavaChangeSignatureUsageProcessor.processMethodUsage(methodCallInfo.getElement(), (JavaChangeInfo)changeInfo, methodCallInfo.isToChangeArguments(), methodCallInfo.isToCatchExceptions(), methodCallInfo.getReferencedMethod(), methodCallInfo.getSubstitutor(), usages);
                    return true;
                }
                if (usage instanceof ChangeSignatureParameterUsageInfo) {
                    String newName = ((ChangeSignatureParameterUsageInfo)usage).newParameterName;
                    String oldName = ((ChangeSignatureParameterUsageInfo)usage).oldParameterName;
                    JavaChangeSignatureUsageProcessor.processParameterUsage((PsiReferenceExpression)element, oldName, newName);
                    return true;
                }
                if (usage instanceof CallReferenceUsageInfo) {
                    ((CallReferenceUsageInfo)usage).getReference().handleChangeSignature(changeInfo);
                    return true;
                }
                if (element instanceof PsiEnumConstant) {
                    JavaChangeSignatureUsageProcessor.fixActualArgumentsList(((PsiEnumConstant)element).getArgumentList(), (JavaChangeInfo)changeInfo, true, PsiSubstitutor.EMPTY);
                    return true;
                }
                if (!(usage instanceof OverriderUsageInfo)) {
                    PsiElement target2;
                    PsiReference reference;
                    PsiReference psiReference = reference = usage instanceof MoveRenameUsageInfo ? usage.getReference() : element.getReference();
                    if (reference != null && (target2 = changeInfo.getMethod()) != null) {
                        reference.bindToElement(target2);
                    }
                }
            }
        }
        return false;
    }

    private static void processParameterUsage(PsiReferenceExpression ref, String oldName, String newName) throws IncorrectOperationException {
        PsiElement last = ref.getReferenceNameElement();
        if (last instanceof PsiIdentifier && last.getText().equals(oldName)) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)ref.getProject()).getElementFactory();
            PsiIdentifier newNameIdentifier = factory.createIdentifier(newName);
            last.replace((PsiElement)newNameIdentifier);
        }
    }

    private static void addDefaultConstructor(JavaChangeInfo changeInfo, PsiClass aClass, UsageInfo[] usages) throws IncorrectOperationException {
        if (!(aClass instanceof PsiAnonymousClass)) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
            PsiMethod defaultConstructor = factory.createMethodFromText(aClass.getName() + "(){}", (PsiElement)aClass);
            defaultConstructor = (PsiMethod)CodeStyleManager.getInstance((Project)aClass.getProject()).reformat((PsiElement)defaultConstructor);
            defaultConstructor = (PsiMethod)aClass.add((PsiElement)defaultConstructor);
            PsiUtil.setModifierProperty((PsiModifierListOwner)defaultConstructor, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList()), (boolean)true);
            JavaChangeSignatureUsageProcessor.addSuperCall(changeInfo, defaultConstructor, null, usages);
        } else {
            PsiElement parent = aClass.getParent();
            if (parent instanceof PsiNewExpression) {
                PsiExpressionList argumentList = ((PsiNewExpression)parent).getArgumentList();
                PsiClass baseClass = changeInfo.getMethod().getContainingClass();
                PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                JavaChangeSignatureUsageProcessor.fixActualArgumentsList(argumentList, changeInfo, true, substitutor);
            }
        }
    }

    private static void addSuperCall(JavaChangeInfo changeInfo, PsiMethod constructor, PsiMethod callee, UsageInfo[] usages) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)constructor.getProject());
        PsiExpressionStatement superCall = (PsiExpressionStatement)factory.createStatementFromText("super();", (PsiElement)constructor);
        PsiCodeBlock body2 = constructor.getBody();
        assert (body2 != null);
        PsiStatement[] statements = body2.getStatements();
        superCall = statements.length > 0 ? (PsiExpressionStatement)body2.addBefore((PsiElement)superCall, (PsiElement)statements[0]) : (PsiExpressionStatement)body2.add((PsiElement)superCall);
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)superCall.getExpression();
        PsiClass aClass = constructor.getContainingClass();
        PsiClass baseClass = changeInfo.getMethod().getContainingClass();
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        JavaChangeSignatureUsageProcessor.processMethodUsage((PsiElement)callExpression.getMethodExpression(), changeInfo, true, false, callee, substitutor, usages);
    }

    private static void processMethodUsage(PsiElement ref, JavaChangeInfo changeInfo, boolean toChangeArguments, boolean toCatchExceptions, PsiMethod callee, PsiSubstitutor substitutor, UsageInfo[] usages) throws IncorrectOperationException {
        PsiElement last;
        if (changeInfo.isNameChanged() && ref instanceof PsiJavaCodeReferenceElement && (last = ((PsiJavaCodeReferenceElement)ref).getReferenceNameElement()) instanceof PsiIdentifier && last.getText().equals(changeInfo.getOldName())) {
            last.replace((PsiElement)changeInfo.getNewNameIdentifier());
        }
        PsiMethod caller = RefactoringUtil.getEnclosingMethod(ref);
        if (toChangeArguments) {
            PsiExpression qualifierExpression2;
            PsiExpressionList list2 = RefactoringUtil.getArgumentListByMethodReference(ref);
            LOG.assertTrue(list2 != null);
            boolean toInsertDefaultValue = JavaChangeSignatureUsageProcessor.needDefaultValue(changeInfo, caller);
            if (toInsertDefaultValue && ref instanceof PsiReferenceExpression && (qualifierExpression2 = ((PsiReferenceExpression)ref).getQualifierExpression()) instanceof PsiSuperExpression && caller != null && JavaChangeSignatureUsageProcessor.callerSignatureIsAboutToChangeToo(caller, usages)) {
                toInsertDefaultValue = false;
            }
            JavaChangeSignatureUsageProcessor.fixActualArgumentsList(list2, changeInfo, toInsertDefaultValue, substitutor);
        }
        if (toCatchExceptions && (!(ref instanceof PsiReferenceExpression) || !JavaHighlightUtil.isSuperOrThisCall((PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiStatement.class), true, false)) && JavaChangeSignatureUsageProcessor.needToCatchExceptions(changeInfo, caller)) {
            PsiClassType[] newExceptions = callee != null ? JavaChangeSignatureUsageProcessor.getCalleeChangedExceptionInfo(callee) : JavaChangeSignatureUsageProcessor.getPrimaryChangedExceptionInfo(changeInfo);
            JavaChangeSignatureUsageProcessor.fixExceptions(ref, newExceptions);
        }
    }

    private static boolean callerSignatureIsAboutToChangeToo(@NotNull PsiMethod caller, UsageInfo[] usages) {
        if (caller == null) {
            JavaChangeSignatureUsageProcessor.$$$reportNull$$$0(0);
        }
        for (UsageInfo usage : usages) {
            if (!(usage instanceof MethodCallUsageInfo) || !MethodSignatureUtil.isSuperMethod((PsiMethod)((MethodCallUsageInfo)usage).getReferencedMethod(), (PsiMethod)caller)) continue;
            return true;
        }
        return false;
    }

    private static PsiClassType[] getCalleeChangedExceptionInfo(PsiMethod callee) {
        return callee.getThrowsList().getReferencedTypes();
    }

    private static void fixExceptions(PsiElement ref, PsiClassType[] newExceptions) throws IncorrectOperationException {
        newExceptions = JavaChangeSignatureUsageProcessor.filterCheckedExceptions(newExceptions);
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiTryStatement.class, PsiMethod.class, PsiLambdaExpression.class});
        if (context instanceof PsiTryStatement) {
            PsiParameter[] catchParameters;
            PsiTryStatement tryStatement = (PsiTryStatement)context;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            Collection<PsiClassType> classes2 = ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock);
            for (PsiParameter parameter2 : catchParameters = tryStatement.getCatchBlockParameters()) {
                PsiType caughtType = parameter2.getType();
                if (!(caughtType instanceof PsiClassType) || ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)caughtType) || !JavaChangeSignatureUsageProcessor.isCatchParameterRedundant((PsiClassType)caughtType, classes2)) continue;
                parameter2.getParent().delete();
            }
            PsiClassType[] exceptionsToAdd = JavaChangeSignatureUsageProcessor.filterUnhandledExceptions(newExceptions, (PsiElement)tryBlock);
            JavaChangeSignatureUsageProcessor.addExceptions(exceptionsToAdd, tryStatement);
            JavaChangeSignatureUsageProcessor.adjustPossibleEmptyTryStatement(tryStatement);
        } else if ((newExceptions = JavaChangeSignatureUsageProcessor.filterUnhandledExceptions(newExceptions, ref)).length > 0) {
            PsiStatement anchor;
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)ref.getProject());
            PsiTryStatement tryStatement = (PsiTryStatement)elementFactory.createStatementFromText("try {} catch (Exception e) {}", null);
            if (context instanceof PsiLambdaExpression) {
                PsiCodeBlock codeBlock = RefactoringUtil.expandExpressionLambdaToCodeBlock((PsiLambdaExpression)context);
                LOG.assertTrue(codeBlock != null);
                anchor = codeBlock.getStatements()[0];
            } else {
                anchor = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiStatement.class);
            }
            LOG.assertTrue(anchor != null);
            PsiElement container = anchor.getParent();
            PsiElement[] elements = SurroundWithUtil.moveDeclarationsOut(container, new PsiElement[]{anchor}, true);
            tryStatement = (PsiTryStatement)container.addAfter((PsiElement)tryStatement, elements[elements.length - 1]);
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            LOG.assertTrue(tryBlock != null);
            tryBlock.addRange(elements[0], elements[elements.length - 1]);
            JavaChangeSignatureUsageProcessor.addExceptions(newExceptions, tryStatement);
            container.deleteChildRange(elements[0], elements[elements.length - 1]);
            tryStatement.getCatchSections()[0].delete();
        }
    }

    public static boolean hasNewCheckedExceptions(JavaChangeInfo changeInfo) {
        return JavaChangeSignatureUsageProcessor.filterCheckedExceptions(JavaChangeSignatureUsageProcessor.getPrimaryChangedExceptionInfo(changeInfo)).length > 0;
    }

    private static PsiClassType[] filterCheckedExceptions(PsiClassType[] exceptions) {
        ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
        for (PsiClassType exceptionType : exceptions) {
            if (ExceptionUtil.isUncheckedException(exceptionType)) continue;
            result2.add(exceptionType);
        }
        return result2.toArray(new PsiClassType[result2.size()]);
    }

    private static void adjustPossibleEmptyTryStatement(PsiTryStatement tryStatement) throws IncorrectOperationException {
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock != null && tryStatement.getCatchSections().length == 0 && tryStatement.getFinallyBlock() == null) {
            PsiElement firstBodyElement = tryBlock.getFirstBodyElement();
            if (firstBodyElement != null) {
                tryStatement.getParent().addRangeAfter(firstBodyElement, tryBlock.getLastBodyElement(), (PsiElement)tryStatement);
            }
            tryStatement.delete();
        }
    }

    private static void addExceptions(PsiClassType[] exceptionsToAdd, PsiTryStatement tryStatement) throws IncorrectOperationException {
        for (PsiClassType type2 : exceptionsToAdd) {
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)tryStatement.getProject());
            String name2 = styleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)type2).names[0];
            name2 = styleManager.suggestUniqueVariableName(name2, (PsiElement)tryStatement, false);
            PsiCatchSection catchSection = JavaPsiFacade.getInstance((Project)tryStatement.getProject()).getElementFactory().createCatchSection((PsiType)type2, name2, (PsiElement)tryStatement);
            tryStatement.add((PsiElement)catchSection);
        }
    }

    private static PsiClassType[] filterUnhandledExceptions(PsiClassType[] exceptions, PsiElement place) {
        ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
        for (PsiClassType exception : exceptions) {
            if (ExceptionUtil.isHandled(exception, place)) continue;
            result2.add(exception);
        }
        return result2.toArray(new PsiClassType[result2.size()]);
    }

    private static boolean isCatchParameterRedundant(PsiClassType catchParamType, Collection<PsiClassType> thrownTypes) {
        for (PsiType psiType : thrownTypes) {
            if (!psiType.isConvertibleFrom((PsiType)catchParamType)) continue;
            return false;
        }
        return true;
    }

    private static void fixActualArgumentsList(PsiExpressionList list2, JavaChangeInfo changeInfo, boolean toInsertDefaultValue, PsiSubstitutor substitutor) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)list2.getProject()).getElementFactory();
        if (changeInfo.isParameterSetOrOrderChanged()) {
            if (changeInfo instanceof JavaChangeInfoImpl && ((JavaChangeInfoImpl)changeInfo).isPropagationEnabled) {
                ParameterInfoImpl[] createdParmsInfo;
                for (ParameterInfoImpl info : createdParmsInfo = ((JavaChangeInfoImpl)changeInfo).getCreatedParmsInfoWithoutVarargs()) {
                    PsiExpression newArg = toInsertDefaultValue ? JavaChangeSignatureUsageProcessor.createDefaultValue(changeInfo, factory, info, list2, substitutor) : factory.createExpressionFromText(info.getName(), (PsiElement)list2);
                    if (newArg == null) continue;
                    JavaCodeStyleManager.getInstance((Project)list2.getProject()).shortenClassReferences(list2.add((PsiElement)newArg));
                }
            } else {
                int newArgsLength;
                int newNonVarargCount;
                int nonVarargCount;
                PsiExpression[] args = list2.getExpressions();
                int varargCount = args.length - (nonVarargCount = JavaChangeSignatureUsageProcessor.getNonVarargCount(changeInfo, args));
                if (varargCount < 0) {
                    return;
                }
                PsiExpression[] newVarargInitializers = null;
                JavaParameterInfo[] newParms = changeInfo.getNewParameters();
                if (changeInfo.isArrayToVarargs()) {
                    PsiNewExpression expression2;
                    PsiArrayInitializerExpression arrayInitializer;
                    newNonVarargCount = newParms.length - 1;
                    JavaParameterInfo lastNewParm = newParms[newParms.length - 1];
                    PsiExpression arrayToConvert = args[lastNewParm.getOldIndex()];
                    if (arrayToConvert instanceof PsiNewExpression && (arrayInitializer = (expression2 = (PsiNewExpression)arrayToConvert).getArrayInitializer()) != null) {
                        newVarargInitializers = arrayInitializer.getInitializers();
                    }
                    newArgsLength = newVarargInitializers == null ? newParms.length : newNonVarargCount + newVarargInitializers.length;
                } else if (changeInfo.isRetainsVarargs()) {
                    newNonVarargCount = newParms.length - 1;
                    newArgsLength = newNonVarargCount + varargCount;
                } else if (changeInfo.isObtainsVarags()) {
                    newArgsLength = newNonVarargCount = newParms.length - 1;
                } else {
                    newNonVarargCount = newParms.length;
                    newArgsLength = newParms.length;
                }
                String[] oldVarargs = null;
                if (changeInfo.wasVararg() && !changeInfo.isRetainsVarargs()) {
                    oldVarargs = new String[varargCount];
                    for (int i = nonVarargCount; i < args.length; ++i) {
                        oldVarargs[i - nonVarargCount] = args[i].getText();
                    }
                }
                PsiExpression[] newArgs = new PsiExpression[newArgsLength];
                for (int i = 0; i < newNonVarargCount; ++i) {
                    PsiType type2;
                    if (newParms[i].getOldIndex() == nonVarargCount && oldVarargs != null && (type2 = newParms[i].createType((PsiElement)changeInfo.getMethod(), list2.getManager())) instanceof PsiArrayType) {
                        type2 = substitutor.substitute(type2);
                        type2 = TypeConversionUtil.erasure((PsiType)type2);
                        String typeText = type2.getCanonicalText();
                        if (type2 instanceof PsiEllipsisType) {
                            typeText = typeText.replace("...", "[]");
                        }
                        String text2 = "new " + typeText + "{" + StringUtil.join((String[])oldVarargs, (String)",") + "}";
                        newArgs[i] = factory.createExpressionFromText(text2, (PsiElement)changeInfo.getMethod());
                        continue;
                    }
                    newArgs[i] = JavaChangeSignatureUsageProcessor.createActualArgument(changeInfo, list2, newParms[i], toInsertDefaultValue, args, substitutor);
                }
                if (changeInfo.isArrayToVarargs()) {
                    if (newVarargInitializers == null) {
                        newArgs[newNonVarargCount] = JavaChangeSignatureUsageProcessor.createActualArgument(changeInfo, list2, newParms[newNonVarargCount], toInsertDefaultValue, args, substitutor);
                    } else {
                        System.arraycopy(newVarargInitializers, 0, newArgs, newNonVarargCount, newVarargInitializers.length);
                    }
                } else {
                    int newVarargCount = newArgsLength - newNonVarargCount;
                    LOG.assertTrue(newVarargCount == 0 || newVarargCount == varargCount);
                    for (int i = newNonVarargCount; i < newArgsLength; ++i) {
                        int oldIndex = newParms[newNonVarargCount].getOldIndex();
                        if (oldIndex < 0 || oldIndex == nonVarargCount) {
                            System.arraycopy(args, nonVarargCount, newArgs, newNonVarargCount, newVarargCount);
                            break;
                        }
                        newArgs[i] = JavaChangeSignatureUsageProcessor.createActualArgument(changeInfo, list2, newParms[newNonVarargCount], toInsertDefaultValue, args, substitutor);
                    }
                }
                ChangeSignatureUtil.synchronizeList(list2, Arrays.asList(newArgs), ExpressionList.INSTANCE, changeInfo.toRemoveParm());
            }
        }
    }

    private static int getNonVarargCount(JavaChangeInfo changeInfo, PsiExpression[] args) {
        if (!changeInfo.wasVararg()) {
            return args.length;
        }
        return changeInfo.getOldParameterTypes().length - 1;
    }

    @Nullable
    private static PsiExpression createActualArgument(JavaChangeInfo changeInfo, PsiExpressionList list2, JavaParameterInfo info, boolean toInsertDefaultValue, PsiExpression[] args, PsiSubstitutor substitutor) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)list2.getProject()).getElementFactory();
        int index = info.getOldIndex();
        if (index >= 0 && index < args.length) {
            return args[index];
        }
        if (toInsertDefaultValue) {
            return JavaChangeSignatureUsageProcessor.createDefaultValue(changeInfo, factory, info, list2, substitutor);
        }
        return factory.createExpressionFromText(info.getName(), (PsiElement)list2);
    }

    @Nullable
    private static PsiExpression createDefaultValue(JavaChangeInfo changeInfo, PsiElementFactory factory, JavaParameterInfo info, final PsiExpressionList list2, PsiSubstitutor substitutor) throws IncorrectOperationException {
        if (info.isUseAnySingleVariable()) {
            PsiClass parentClass;
            final PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)list2.getProject()).getResolveHelper();
            final PsiType type2 = info.getTypeWrapper().getType((PsiElement)changeInfo.getMethod(), list2.getManager());
            VariablesProcessor processor2 = new VariablesProcessor(false){

                @Override
                protected boolean check(PsiVariable var, ResolveState state) {
                    if (var instanceof PsiField && !resolveHelper.isAccessible((PsiMember)((PsiField)var), (PsiElement)list2, null)) {
                        return false;
                    }
                    if (var instanceof PsiLocalVariable && list2.getTextRange().getStartOffset() <= var.getTextRange().getStartOffset()) {
                        return false;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)var, (PsiElement)list2, (boolean)false)) {
                        return false;
                    }
                    PsiType varType = ((PsiSubstitutor)state.get(PsiSubstitutor.KEY)).substitute(var.getType());
                    return type2.isAssignableFrom(varType);
                }

                @Override
                public boolean execute(@NotNull PsiElement pe, @NotNull ResolveState state) {
                    if (pe == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.execute(pe, state);
                    return this.size() < 2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "pe";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor$1";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            PsiScopesUtil.treeWalkUp(processor2, (PsiElement)list2, null);
            if (processor2.size() == 1) {
                PsiVariable result2 = processor2.getResult(0);
                return factory.createExpressionFromText(result2.getName(), (PsiElement)list2);
            }
            if (processor2.size() == 0 && (parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)list2, PsiClass.class)) != null) {
                PsiClass containingClass = parentClass;
                HashSet containingClasses = new HashSet();
                while (containingClass != null) {
                    if (type2.isAssignableFrom((PsiType)factory.createType(containingClass, PsiSubstitutor.EMPTY))) {
                        containingClasses.add(containingClass);
                    }
                    containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class);
                }
                if (containingClasses.size() == 1) {
                    return RefactoringChangeUtil.createThisExpression(parentClass.getManager(), containingClasses.contains(parentClass) ? null : (PsiClass)containingClasses.iterator().next());
                }
            }
        }
        PsiCallExpression callExpression = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)list2, PsiCallExpression.class);
        String defaultValue = info.getDefaultValue();
        return callExpression != null ? (PsiExpression)info.getActualValue((PsiElement)callExpression, substitutor) : (!StringUtil.isEmpty((String)defaultValue) ? factory.createExpressionFromText(defaultValue, (PsiElement)list2) : null);
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        if (!StdLanguages.JAVA.equals(changeInfo.getLanguage()) || !(changeInfo instanceof JavaChangeInfo)) {
            return false;
        }
        PsiElement element = changeInfo.getMethod();
        LOG.assertTrue(element instanceof PsiMethod);
        if (!JavaLanguage.INSTANCE.equals(element.getLanguage())) {
            return false;
        }
        if (changeInfo.isGenerateDelegate()) {
            JavaChangeSignatureUsageProcessor.generateDelegate((JavaChangeInfo)changeInfo);
        }
        JavaChangeSignatureUsageProcessor.processPrimaryMethod((JavaChangeInfo)changeInfo, (PsiMethod)element, null, true);
        return true;
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages) {
        return false;
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project2) {
        if (!(changeInfo instanceof JavaChangeInfo)) {
            return true;
        }
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            ParameterInfo[] parameters2;
            PsiMethod caller;
            boolean needDefaultValue;
            PsiElement element;
            MethodCallUsageInfo methodCallUsageInfo;
            if (!(usageInfo instanceof MethodCallUsageInfo) || !(methodCallUsageInfo = (MethodCallUsageInfo)usageInfo).isToChangeArguments() || (element = methodCallUsageInfo.getElement()) == null || !(needDefaultValue = JavaChangeSignatureUsageProcessor.needDefaultValue(changeInfo, caller = RefactoringUtil.getEnclosingMethod(element))) || caller != null && MethodSignatureUtil.isSuperMethod((PsiMethod)methodCallUsageInfo.getReferencedMethod(), (PsiMethod)caller)) continue;
            for (ParameterInfo parameter2 : parameters2 = changeInfo.getNewParameters()) {
                String defaultValue = parameter2.getDefaultValue();
                if (defaultValue != null || parameter2.getOldIndex() != -1) continue;
                ((ParameterInfoImpl)parameter2).setDefaultValue("");
                if (ApplicationManager.getApplication().isUnitTestMode()) continue;
                PsiType type2 = ((ParameterInfoImpl)parameter2).getTypeWrapper().getType(element);
                DefaultValueChooser chooser = new DefaultValueChooser(project2, parameter2.getName(), PsiTypesUtil.getDefaultValueOfType((PsiType)type2));
                if (chooser.showAndGet()) {
                    if (chooser.feelLucky()) {
                        parameter2.setUseAnySingleVariable(true);
                        continue;
                    }
                    ((ParameterInfoImpl)parameter2).setDefaultValue(chooser.getDefaultValue());
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    public void registerConflictResolvers(List<ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages, ChangeInfo changeInfo) {
        if (resolveSnapshotProvider == null) {
            JavaChangeSignatureUsageProcessor.$$$reportNull$$$0(1);
        }
        snapshots.add(resolveSnapshotProvider.createSnapshot(changeInfo.getMethod()));
        for (UsageInfo usage : usages) {
            if (!(usage instanceof OverriderUsageInfo)) continue;
            snapshots.add(resolveSnapshotProvider.createSnapshot((PsiElement)((OverriderUsageInfo)usage).getOverridingMethod()));
        }
    }

    private static boolean needDefaultValue(ChangeInfo changeInfo, @Nullable PsiMethod method) {
        if (!(changeInfo instanceof JavaChangeInfoImpl)) {
            return true;
        }
        if (method != null) {
            Set<PsiMethod> parametersMethods = ((JavaChangeInfoImpl)changeInfo).propagateParametersMethods;
            if (parametersMethods.contains(method)) {
                return false;
            }
            for (PsiMethod superMethod : method.findDeepestSuperMethods()) {
                if (!parametersMethods.contains(superMethod)) continue;
                return false;
            }
        }
        return true;
    }

    public static void generateDelegate(JavaChangeInfo changeInfo) throws IncorrectOperationException {
        PsiMethod delegate = JavaChangeSignatureUsageProcessor.generateDelegatePrototype(changeInfo);
        PsiClass targetClass = changeInfo.getMethod().getContainingClass();
        LOG.assertTrue(targetClass != null);
        targetClass.addBefore((PsiElement)delegate, (PsiElement)changeInfo.getMethod());
    }

    public static PsiMethod generateDelegatePrototype(JavaChangeInfo changeInfo) {
        PsiMethod delegate = (PsiMethod)changeInfo.getMethod().copy();
        PsiClass targetClass = changeInfo.getMethod().getContainingClass();
        LOG.assertTrue(targetClass != null);
        if (targetClass.isInterface() && delegate.getBody() == null) {
            delegate.getModifierList().setModifierProperty("default", true);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)targetClass.getProject());
        ChangeSignatureProcessor.makeEmptyBody(factory, delegate);
        PsiCallExpression callExpression = ChangeSignatureProcessor.addDelegatingCallTemplate(delegate, changeInfo.getNewName());
        JavaChangeSignatureUsageProcessor.addDelegateArguments(changeInfo, factory, callExpression);
        return delegate;
    }

    private static void addDelegateArguments(JavaChangeInfo changeInfo, PsiElementFactory factory, PsiCallExpression callExpression) throws IncorrectOperationException {
        JavaParameterInfo[] newParms = changeInfo.getNewParameters();
        String[] oldParameterNames = changeInfo.getOldParameterNames();
        for (JavaParameterInfo newParm : newParms) {
            PsiExpression actualArg = newParm.getOldIndex() >= 0 ? factory.createExpressionFromText(oldParameterNames[newParm.getOldIndex()], (PsiElement)callExpression) : (PsiExpression)newParm.getActualValue((PsiElement)callExpression, PsiSubstitutor.EMPTY);
            PsiExpressionList argumentList = callExpression.getArgumentList();
            if (actualArg == null || argumentList == null) continue;
            JavaCodeStyleManager.getInstance((Project)callExpression.getProject()).shortenClassReferences(argumentList.add((PsiElement)actualArg));
        }
    }

    private static void processPrimaryMethod(JavaChangeInfo changeInfo, PsiMethod method, PsiMethod baseMethod, boolean isOriginal) throws IncorrectOperationException {
        PsiAnnotation annotation;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        if (changeInfo.isVisibilityChanged()) {
            PsiModifierList modifierList = method.getModifierList();
            String highestVisibility = isOriginal ? changeInfo.getNewVisibility() : VisibilityUtil.getHighestVisibility((String)changeInfo.getNewVisibility(), (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList));
            VisibilityUtil.setVisibility((PsiModifierList)modifierList, (String)highestVisibility);
        }
        if (changeInfo.isNameChanged()) {
            String newName;
            String string = newName = baseMethod == null ? changeInfo.getNewName() : RefactoringUtil.suggestNewOverriderName(method.getName(), baseMethod.getName(), changeInfo.getNewName());
            if (newName != null && !newName.equals(method.getName())) {
                PsiIdentifier nameId = method.getNameIdentifier();
                assert (nameId != null) : method;
                nameId.replace((PsiElement)JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createIdentifier(newName));
            }
        }
        PsiSubstitutor substitutor = baseMethod == null ? PsiSubstitutor.EMPTY : ChangeSignatureProcessor.calculateSubstitutor(method, baseMethod);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)method.getProject());
        if (changeInfo.isReturnTypeChanged()) {
            PsiTypeElement typeElement;
            PsiType newTypeElement = changeInfo.getNewReturnType().getType((PsiElement)changeInfo.getMethod().getParameterList(), method.getManager());
            PsiType returnType = substitutor.substitute(newTypeElement);
            if (method.getName().equals(changeInfo.getNewName()) && (typeElement = method.getReturnTypeElement()) != null) {
                javaCodeStyleManager.shortenClassReferences(typeElement.replace((PsiElement)factory.createTypeElement(returnType)));
            }
        }
        PsiParameterList list2 = method.getParameterList();
        int newParamsLength = JavaChangeSignatureUsageProcessor.processMethodParams(changeInfo, baseMethod, factory, substitutor, list2, (PsiElement)method.getBody());
        JavaChangeSignatureUsageProcessor.fixJavadocsForChangedMethod(method, changeInfo, newParamsLength);
        if (changeInfo.isExceptionSetOrOrderChanged()) {
            PsiClassType[] newExceptions = JavaChangeSignatureUsageProcessor.getPrimaryChangedExceptionInfo(changeInfo);
            JavaChangeSignatureUsageProcessor.fixPrimaryThrowsLists(method, newExceptions);
        }
        if (baseMethod == null && method.findSuperMethods().length == 0 && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (boolean)true, (String[])new String[]{Override.class.getName()})) != null) {
            annotation.delete();
        }
    }

    private static int processMethodParams(JavaChangeInfo changeInfo, PsiMethod baseMethod, PsiElementFactory factory, PsiSubstitutor substitutor, PsiParameterList list2, PsiElement methodBody2) {
        PsiParameter[] parameters2 = list2.getParameters();
        JavaParameterInfo[] parameterInfos = changeInfo.getNewParameters();
        int delta = baseMethod != null ? baseMethod.getParameterList().getParametersCount() - list2.getParametersCount() : 0;
        PsiParameter[] newParms = new PsiParameter[Math.max(parameterInfos.length - delta, 0)];
        String[] oldParameterNames = changeInfo.getOldParameterNames();
        String[] oldParameterTypes = changeInfo.getOldParameterTypes();
        for (int i = 0; i < newParms.length; ++i) {
            JavaParameterInfo info = parameterInfos[i];
            int index = info.getOldIndex();
            if (index >= 0) {
                PsiTypeElement typeElement;
                PsiParameter parameter2;
                newParms[i] = parameter2 = parameters2[index];
                String oldName = oldParameterNames[index];
                if (!oldName.equals(info.getName()) && oldName.equals(parameter2.getName())) {
                    PsiIdentifier newIdentifier = factory.createIdentifier(info.getName());
                    parameter2.getNameIdentifier().replace((PsiElement)newIdentifier);
                }
                if ((typeElement = parameter2.getTypeElement()) == null) continue;
                parameter2.normalizeDeclaration();
                typeElement = parameter2.getTypeElement();
                String oldType = oldParameterTypes[index];
                if (oldType.equals(info.getTypeText())) continue;
                PsiType newType = substitutor.substitute(info.createType((PsiElement)changeInfo.getMethod().getParameterList(), changeInfo.getMethod().getManager()));
                typeElement.replace((PsiElement)factory.createTypeElement(newType));
                continue;
            }
            newParms[i] = JavaChangeSignatureUsageProcessor.createNewParameter(changeInfo, info, substitutor);
        }
        JavaChangeSignatureUsageProcessor.resolveParameterVsFieldsConflicts(newParms, list2, changeInfo.toRemoveParm(), methodBody2);
        return newParms.length;
    }

    private static PsiClassType[] getPrimaryChangedExceptionInfo(JavaChangeInfo changeInfo) throws IncorrectOperationException {
        ThrownExceptionInfo[] newExceptionInfos = changeInfo.getNewExceptions();
        PsiClassType[] newExceptions = new PsiClassType[newExceptionInfos.length];
        PsiMethod method = changeInfo.getMethod();
        for (int i = 0; i < newExceptions.length; ++i) {
            newExceptions[i] = (PsiClassType)newExceptionInfos[i].createType((PsiElement)method, method.getManager());
        }
        return newExceptions;
    }

    private static void processCallerMethod(JavaChangeInfo changeInfo, PsiMethod caller, PsiMethod baseMethod, boolean toInsertParams, boolean toInsertThrows) throws IncorrectOperationException {
        LOG.assertTrue(toInsertParams || toInsertThrows);
        if (toInsertParams) {
            ArrayList<PsiParameter> newParameters = new ArrayList<PsiParameter>();
            ContainerUtil.addAll(newParameters, (Object[])caller.getParameterList().getParameters());
            JavaParameterInfo[] primaryNewParms = changeInfo.getNewParameters();
            PsiSubstitutor substitutor = baseMethod == null ? PsiSubstitutor.EMPTY : ChangeSignatureProcessor.calculateSubstitutor(caller, baseMethod);
            PsiClass aClass = changeInfo.getMethod().getContainingClass();
            PsiClass callerContainingClass = caller.getContainingClass();
            PsiSubstitutor psiSubstitutor = aClass != null && callerContainingClass != null && callerContainingClass.isInheritor(aClass, true) ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)callerContainingClass, (PsiSubstitutor)substitutor) : PsiSubstitutor.EMPTY;
            for (JavaParameterInfo info : primaryNewParms) {
                if (info.getOldIndex() >= 0) continue;
                newParameters.add(JavaChangeSignatureUsageProcessor.createNewParameter(changeInfo, info, psiSubstitutor, substitutor));
            }
            PsiParameter[] arrayed = newParameters.toArray(new PsiParameter[newParameters.size()]);
            boolean[] toRemoveParm = new boolean[arrayed.length];
            Arrays.fill(toRemoveParm, false);
            JavaChangeSignatureUsageProcessor.resolveParameterVsFieldsConflicts(arrayed, caller.getParameterList(), toRemoveParm, (PsiElement)caller.getBody());
        }
        if (toInsertThrows) {
            PsiClass primaryNewExns;
            ArrayList<PsiJavaCodeReferenceElement> newThrowns = new ArrayList<PsiJavaCodeReferenceElement>();
            PsiReferenceList throwsList = caller.getThrowsList();
            ContainerUtil.addAll(newThrowns, (Object[])throwsList.getReferenceElements());
            for (PsiClass thrownExceptionInfo : primaryNewExns = changeInfo.getNewExceptions()) {
                if (thrownExceptionInfo.getOldIndex() >= 0) continue;
                PsiClassType type2 = (PsiClassType)thrownExceptionInfo.createType((PsiElement)caller, caller.getManager());
                PsiJavaCodeReferenceElement ref = JavaPsiFacade.getInstance((Project)caller.getProject()).getElementFactory().createReferenceElementByType(type2);
                newThrowns.add(ref);
            }
            PsiJavaCodeReferenceElement[] arrayed = newThrowns.toArray(new PsiJavaCodeReferenceElement[newThrowns.size()]);
            boolean[] toRemoveParm = new boolean[arrayed.length];
            Arrays.fill(toRemoveParm, false);
            ChangeSignatureUtil.synchronizeList(throwsList, Arrays.asList(arrayed), ThrowsList.INSTANCE, toRemoveParm);
        }
    }

    private static void fixPrimaryThrowsLists(PsiMethod method, PsiClassType[] newExceptions) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[newExceptions.length];
        for (int i = 0; i < refs.length; ++i) {
            refs[i] = elementFactory.createReferenceElementByType(newExceptions[i]);
        }
        PsiReferenceList throwsList = elementFactory.createReferenceList(refs);
        PsiReferenceList methodThrowsList = (PsiReferenceList)method.getThrowsList().replace((PsiElement)throwsList);
        methodThrowsList = (PsiReferenceList)JavaCodeStyleManager.getInstance((Project)method.getProject()).shortenClassReferences((PsiElement)methodThrowsList);
        CodeStyleManager.getInstance((Project)method.getManager().getProject()).reformatRange((PsiElement)method, method.getParameterList().getTextRange().getEndOffset(), methodThrowsList.getTextRange().getEndOffset());
    }

    private static void fixJavadocsForChangedMethod(PsiMethod method, JavaChangeInfo changeInfo, int newParamsLength) throws IncorrectOperationException {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        JavaParameterInfo[] newParms = changeInfo.getNewParameters();
        LOG.assertTrue(parameters2.length <= newParamsLength);
        HashSet newParameters = new HashSet();
        String[] oldParameterNames = changeInfo.getOldParameterNames();
        for (int i = 0; i < newParamsLength; ++i) {
            JavaParameterInfo newParm = newParms[i];
            if (newParm.getOldIndex() >= 0 && (newParm.getOldIndex() != i || newParm.getName().equals(oldParameterNames[newParm.getOldIndex()]) && newParm.getTypeText().equals(changeInfo.getOldParameterTypes()[newParm.getOldIndex()]))) continue;
            newParameters.add(parameters2[i]);
        }
        RefactoringUtil.fixJavadocsForParams(method, (Set<PsiParameter>)newParameters, (Condition<Pair<PsiParameter, String>>)((Condition)pair2 -> {
            PsiParameter parameter2 = (PsiParameter)pair2.first;
            String oldParamName = (String)pair2.second;
            int oldIdx = ArrayUtil.find((Object[])oldParameterNames, (Object)oldParamName);
            int newIndex = method.getParameterList().getParameterIndex(parameter2);
            return oldIdx >= 0 && newIndex >= 0 && changeInfo.getNewParameters()[newIndex].getOldIndex() == oldIdx;
        }), (Condition<String>)((Condition)paramName -> ArrayUtil.find((Object[])oldParameterNames, (Object)paramName) >= 0));
    }

    private static PsiParameter createNewParameter(JavaChangeInfo changeInfo, JavaParameterInfo newParm, PsiSubstitutor ... substitutor) throws IncorrectOperationException {
        PsiParameterList list2 = changeInfo.getMethod().getParameterList();
        Project project2 = list2.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiType type2 = newParm.createType((PsiElement)list2);
        for (PsiSubstitutor psiSubstitutor : substitutor) {
            type2 = psiSubstitutor.substitute(type2);
        }
        PsiParameter parameter2 = factory.createParameter(newParm.getName(), type2, (PsiElement)list2);
        if (((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_PARAMETERS) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)parameter2, (String)"final", (boolean)true);
        }
        return parameter2;
    }

    private static void resolveParameterVsFieldsConflicts(PsiParameter[] newParms, PsiParameterList list2, boolean[] toRemoveParm, PsiElement methodBody2) throws IncorrectOperationException {
        ArrayList<FieldConflictsResolver> conflictResolvers = new ArrayList<FieldConflictsResolver>();
        for (PsiParameter parameter2 : newParms) {
            conflictResolvers.add(new FieldConflictsResolver(parameter2.getName(), methodBody2));
        }
        ChangeSignatureUtil.synchronizeList(list2, Arrays.asList(newParms), ParameterList.INSTANCE, toRemoveParm);
        JavaCodeStyleManager.getInstance((Project)list2.getProject()).shortenClassReferences((PsiElement)list2);
        for (FieldConflictsResolver fieldConflictsResolver : conflictResolvers) {
            fieldConflictsResolver.fix();
        }
    }

    private static boolean needToCatchExceptions(JavaChangeInfo changeInfo, PsiMethod caller) {
        return changeInfo.isExceptionSetOrOrderChanged() && (!(changeInfo instanceof JavaChangeInfoImpl) || !((JavaChangeInfoImpl)changeInfo).propagateExceptionsMethods.contains(caller));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveSnapshotProvider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "callerSignatureIsAboutToChangeToo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerConflictResolvers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExpressionList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiExpressionList, PsiExpression> {
        public static final ExpressionList INSTANCE = new ExpressionList();

        private ExpressionList() {
        }

        @Override
        public List<PsiExpression> getChildren(PsiExpressionList psiExpressionList) {
            return Arrays.asList(psiExpressionList.getExpressions());
        }
    }

    public static class ConflictSearcher {
        private final JavaChangeInfo myChangeInfo;

        private ConflictSearcher(@NotNull JavaChangeInfo changeInfo) {
            if (changeInfo == null) {
                ConflictSearcher.$$$reportNull$$$0(0);
            }
            this.myChangeInfo = changeInfo;
        }

        public MultiMap<PsiElement, String> findConflicts(Ref<UsageInfo[]> refUsages) {
            MultiMap conflictDescriptions = new MultiMap();
            PsiMethod prototype = this.addMethodConflicts((MultiMap<PsiElement, String>)conflictDescriptions);
            HashSet usagesSet = new HashSet(Arrays.asList((Object[])refUsages.get()));
            RenameUtil.removeConflictUsages((Set<UsageInfo>)usagesSet);
            if (this.myChangeInfo.isVisibilityChanged()) {
                try {
                    this.addInaccessibilityDescriptions((Set<UsageInfo>)usagesSet, (MultiMap<PsiElement, String>)conflictDescriptions);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            boolean[] toRemove2 = this.myChangeInfo.toRemoveParm();
            boolean checkUnusedParameter = this.myChangeInfo.checkUnusedParameter();
            if (checkUnusedParameter) {
                ConflictSearcher.checkParametersToDelete(this.myChangeInfo.getMethod(), toRemove2, (MultiMap<PsiElement, String>)conflictDescriptions);
            }
            ConflictSearcher.checkContract((MultiMap<PsiElement, String>)conflictDescriptions, this.myChangeInfo.getMethod());
            for (UsageInfo usageInfo : usagesSet) {
                PsiExpressionList argumentList;
                PsiElement parent;
                PsiElement element = usageInfo.getElement();
                if (usageInfo instanceof OverriderUsageInfo) {
                    PsiMethod method = ((OverriderUsageInfo)usageInfo).getOverridingMethod();
                    PsiMethod baseMethod = ((OverriderUsageInfo)usageInfo).getBaseMethod();
                    int delta = baseMethod.getParameterList().getParametersCount() - method.getParameterList().getParametersCount();
                    if (delta > 0) {
                        if (toRemove2.length > 0 && toRemove2[toRemove2.length - 1]) {
                            conflictDescriptions.putValue((Object)baseMethod, (Object)"Implicit last parameter should not be deleted");
                        }
                    } else if (prototype != null && baseMethod == this.myChangeInfo.getMethod()) {
                        ConflictsUtil.checkMethodConflicts(method.getContainingClass(), method, prototype, (MultiMap<PsiElement, String>)conflictDescriptions);
                        if (checkUnusedParameter) {
                            ConflictSearcher.checkParametersToDelete(method, toRemove2, (MultiMap<PsiElement, String>)conflictDescriptions);
                        }
                    }
                    ConflictSearcher.checkContract((MultiMap<PsiElement, String>)conflictDescriptions, method);
                    continue;
                }
                if (element instanceof PsiMethodReferenceExpression && MethodReferenceUsageInfo.needToExpand(this.myChangeInfo)) {
                    conflictDescriptions.putValue((Object)element, (Object)RefactoringBundle.message((String)"expand.method.reference.warning"));
                    continue;
                }
                if (!(element instanceof PsiJavaCodeReferenceElement) || !((parent = element.getParent()) instanceof PsiCallExpression) || (argumentList = ((PsiCallExpression)parent).getArgumentList()) == null) continue;
                PsiExpression[] args = argumentList.getExpressions();
                for (int i = 0; i < toRemove2.length; ++i) {
                    if (!toRemove2[i] || i >= args.length || !RemoveUnusedVariableUtil.checkSideEffects(args[i], null, new ArrayList<PsiElement>())) continue;
                    conflictDescriptions.putValue((Object)args[i], (Object)("Parameter '" + this.myChangeInfo.getOldParameterNames()[i] + "' has usage that is not safe to delete"));
                }
            }
            return conflictDescriptions;
        }

        private static void checkParametersToDelete(PsiMethod method, boolean[] toRemove2, MultiMap<PsiElement, String> conflictDescriptions) {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiCodeBlock body2 = method.getBody();
            if (body2 != null) {
                LocalSearchScope searchScope = new LocalSearchScope((PsiElement)body2);
                for (int i = 0; i < toRemove2.length; ++i) {
                    if (!toRemove2[i] || ReferencesSearch.search((PsiElement)parameters2[i], (SearchScope)searchScope).findFirst() == null) continue;
                    conflictDescriptions.putValue((Object)parameters2[i], (Object)(StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)parameters2[i], true)) + " is used in method body"));
                }
            }
        }

        private static void checkContract(MultiMap<PsiElement, String> conflictDescriptions, PsiMethod method) {
            PsiAnnotation contract = ControlFlowAnalyzer.findContractAnnotation(method);
            if (contract != null && !AnnotationUtil.isInferredAnnotation((PsiAnnotation)contract)) {
                conflictDescriptions.putValue((Object)method, (Object)"@Contract annotation will have to be changed manually");
            }
        }

        private boolean needToChangeCalls() {
            return this.myChangeInfo.isNameChanged() || this.myChangeInfo.isParameterSetOrOrderChanged() || this.myChangeInfo.isExceptionSetOrOrderChanged();
        }

        private void addInaccessibilityDescriptions(Set<UsageInfo> usages, MultiMap<PsiElement, String> conflictDescriptions) throws IncorrectOperationException {
            PsiMethod method = this.myChangeInfo.getMethod();
            PsiModifierList modifierList = (PsiModifierList)method.getModifierList().copy();
            String visibility = this.myChangeInfo.getNewVisibility();
            VisibilityUtil.setVisibility((PsiModifierList)modifierList, (String)visibility);
            ConflictSearcher.searchForHierarchyConflicts(method, conflictDescriptions, visibility);
            Iterator<UsageInfo> iterator = usages.iterator();
            while (iterator.hasNext()) {
                UsageInfo usageInfo = iterator.next();
                PsiElement element = usageInfo.getElement();
                if (element == null || !(element instanceof PsiQualifiedReference)) continue;
                PsiClass accessObjectClass = null;
                PsiElement qualifier = ((PsiQualifiedReference)element).getQualifier();
                if (qualifier instanceof PsiExpression) {
                    accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)((PsiExpression)qualifier)).getElement();
                }
                if (JavaPsiFacade.getInstance((Project)element.getProject()).getResolveHelper().isAccessible((PsiMember)method, modifierList, element, accessObjectClass, null)) continue;
                String message2 = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)method, true), VisibilityUtil.toPresentableText((String)visibility), RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(element), true)});
                conflictDescriptions.putValue((Object)method, (Object)message2);
                if (this.needToChangeCalls()) continue;
                iterator.remove();
            }
        }

        public static void searchForHierarchyConflicts(PsiMethod method, MultiMap<PsiElement, String> conflicts, String modifier) {
            SuperMethodsSearch.search((PsiMethod)method, (PsiClass)((PsiClass)ReadAction.compute(() -> method.getContainingClass())), (boolean)true, (boolean)false).forEach(methodSignature -> {
                PsiMethod superMethod = methodSignature.getMethod();
                if (!ConflictSearcher.hasCompatibleVisibility(superMethod, true, modifier)) {
                    conflicts.putValue((Object)superMethod, (Object)IntentionPowerPackBundle.message("0.will.have.incompatible.access.privileges.with.super.1", RefactoringUIUtil.getDescription((PsiElement)method, false), RefactoringUIUtil.getDescription((PsiElement)superMethod, true)));
                }
                return true;
            });
            OverridingMethodsSearch.search((PsiMethod)method).forEach(overridingMethod -> {
                if (!ConflictSearcher.isVisibleFromOverridingMethod(method, overridingMethod, modifier)) {
                    conflicts.putValue(overridingMethod, (Object)IntentionPowerPackBundle.message("0.will.no.longer.be.visible.from.overriding.1", RefactoringUIUtil.getDescription((PsiElement)method, false), RefactoringUIUtil.getDescription((PsiElement)overridingMethod, true)));
                } else if (!ConflictSearcher.hasCompatibleVisibility(overridingMethod, false, modifier)) {
                    conflicts.putValue(overridingMethod, (Object)IntentionPowerPackBundle.message("0.will.have.incompatible.access.privileges.with.overriding.1", RefactoringUIUtil.getDescription((PsiElement)method, false), RefactoringUIUtil.getDescription((PsiElement)overridingMethod, true)));
                }
                return false;
            });
        }

        private static boolean hasCompatibleVisibility(PsiMethod method, boolean isSuper, String modifier) {
            if (modifier.equals("private")) {
                return false;
            }
            if (modifier.equals("packageLocal")) {
                if (isSuper) {
                    return !method.hasModifierProperty("public") && !method.hasModifierProperty("protected");
                }
                return true;
            }
            if (modifier.equals("protected")) {
                if (isSuper) {
                    return !method.hasModifierProperty("public");
                }
                return method.hasModifierProperty("protected") || method.hasModifierProperty("public");
            }
            if (modifier.equals("public")) {
                if (!isSuper) {
                    return method.hasModifierProperty("public");
                }
                return true;
            }
            throw new AssertionError();
        }

        private static boolean isVisibleFromOverridingMethod(PsiMethod method, PsiMethod overridingMethod, String modifier) {
            PsiModifierList modifierListCopy = (PsiModifierList)method.getModifierList().copy();
            modifierListCopy.setModifierProperty(modifier, true);
            return JavaResolveUtil.isAccessible((PsiMember)method, method.getContainingClass(), modifierListCopy, (PsiElement)overridingMethod, null, null);
        }

        private PsiMethod addMethodConflicts(MultiMap<PsiElement, String> conflicts) {
            String newMethodName = this.myChangeInfo.getNewName();
            try {
                JavaParameterInfo[] parameters2;
                PsiMethod prototype;
                PsiMethod method = this.myChangeInfo.getMethod();
                if (!StdLanguages.JAVA.equals(method.getLanguage())) {
                    return null;
                }
                PsiManager manager = method.getManager();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
                CanonicalTypes.Type returnType = this.myChangeInfo.getNewReturnType();
                if (returnType != null) {
                    prototype = factory.createMethod(newMethodName, returnType.getType((PsiElement)method, manager));
                } else {
                    prototype = factory.createConstructor();
                    prototype.setName(newMethodName);
                }
                for (JavaParameterInfo info : parameters2 = this.myChangeInfo.getNewParameters()) {
                    PsiType parameterType = info.createType((PsiElement)method, manager);
                    if (parameterType == null) {
                        parameterType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createTypeFromText("java.lang.Object", (PsiElement)method);
                    }
                    PsiParameter param = factory.createParameter(info.getName(), parameterType, (PsiElement)method);
                    if (((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)manager.getProject()).getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_PARAMETERS) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)param, (String)"final", (boolean)true);
                    }
                    prototype.getParameterList().add((PsiElement)param);
                }
                ConflictsUtil.checkMethodConflicts(method.getContainingClass(), this.myChangeInfo.isGenerateDelegate() ? null : method, prototype, conflicts);
                return prototype;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeInfo", "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor$ConflictSearcher", "<init>"));
        }
    }

    private static class ThrowsList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiReferenceList, PsiJavaCodeReferenceElement> {
        public static final ThrowsList INSTANCE = new ThrowsList();

        private ThrowsList() {
        }

        @Override
        public List<PsiJavaCodeReferenceElement> getChildren(PsiReferenceList throwsList) {
            return Arrays.asList(throwsList.getReferenceElements());
        }
    }

    private static class ParameterList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiParameterList, PsiParameter> {
        public static final ParameterList INSTANCE = new ParameterList();

        private ParameterList() {
        }

        @Override
        public List<PsiParameter> getChildren(PsiParameterList psiParameterList) {
            return Arrays.asList(psiParameterList.getParameters());
        }
    }
}

