/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inCallers;

import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class JavaMemberNode<M extends PsiMember>
extends MemberNodeBase<M> {
    protected JavaMemberNode(M member, Set<M> called, Project project2, Runnable cancelCallback) {
        super(member, called, project2, cancelCallback);
    }

    @Override
    protected void customizeRendererText(ColoredTreeCellRenderer renderer) {
        StringBuilder buffer = new StringBuilder(128);
        PsiClass containingClass = ((PsiMember)this.getMember()).getContainingClass();
        if (containingClass != null) {
            buffer.append(ClassPresentationUtil.getNameForClass(containingClass, false));
            buffer.append('.');
        }
        buffer.append(JavaMemberNode.formatMember((PsiMember)this.getMember()));
        SimpleTextAttributes attributes = this.isEnabled() ? new SimpleTextAttributes(0, UIUtil.getTreeForeground()) : SimpleTextAttributes.EXCLUDED_ATTRIBUTES;
        renderer.append(buffer.toString(), attributes);
        if (containingClass != null) {
            String packageName = JavaHierarchyUtil.getPackageName(containingClass);
            renderer.append("  (" + packageName + ")", new SimpleTextAttributes(2, (Color)JBColor.GRAY));
        }
    }

    private static String formatMember(@NotNull PsiMember member) {
        if (member == null) {
            JavaMemberNode.$$$reportNull$$$0(0);
        }
        if (member instanceof PsiMethod) {
            return PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)member), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
        }
        assert (member instanceof PsiField);
        return PsiFormatUtil.formatVariable((PsiVariable)((PsiField)member), (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/refactoring/changeSignature/inCallers/JavaMemberNode", "formatMember"));
    }
}

