/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass.usageInfo;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ReplaceInstanceVariableAssignment
extends FixableUsageInfo {
    private final String setterName;
    private final PsiAssignmentExpression assignment;
    private final String getterName;
    private final String delegateName;
    private final String fieldName;

    public ReplaceInstanceVariableAssignment(PsiAssignmentExpression assignment, String delegateName, String setterName, String getterName, String name2) {
        super((PsiElement)assignment);
        this.assignment = assignment;
        this.getterName = getterName;
        this.setterName = setterName;
        this.delegateName = delegateName;
        this.fieldName = name2;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        String newExpression;
        PsiReferenceExpression lhs = (PsiReferenceExpression)this.assignment.getLExpression();
        PsiExpression rhs = this.assignment.getRExpression();
        assert (rhs != null);
        PsiElement qualifier = lhs.getQualifier();
        PsiJavaToken sign = this.assignment.getOperationSign();
        String operator2 = sign.getText();
        String rhsText = rhs.getText();
        if (qualifier != null) {
            String qualifierText = qualifier.getText();
            if ("=".equals(operator2)) {
                newExpression = qualifierText + '.' + this.delegateName + '.' + this.callSetter(rhsText);
            } else {
                String strippedOperator = ReplaceInstanceVariableAssignment.getStrippedOperator(operator2);
                newExpression = qualifierText + '.' + this.delegateName + '.' + this.callSetter(qualifierText + '.' + this.delegateName + '.' + this.callGetter() + strippedOperator + rhsText);
            }
        } else if ("=".equals(operator2)) {
            newExpression = this.delegateName + '.' + this.callSetter(rhsText);
        } else {
            String strippedOperator = ReplaceInstanceVariableAssignment.getStrippedOperator(operator2);
            newExpression = this.delegateName + '.' + this.callSetter(this.delegateName + '.' + this.callGetter() + strippedOperator + rhsText);
        }
        MutationUtils.replaceExpression(newExpression, (PsiExpression)this.assignment);
    }

    private String callSetter(String rhsText) {
        return this.setterName != null ? this.setterName + "( " + rhsText + ")" : this.fieldName + "=" + rhsText;
    }

    private String callGetter() {
        return this.getterName != null ? this.getterName + "()" : this.fieldName;
    }

    private static String getStrippedOperator(String operator2) {
        return operator2.substring(0, operator2.length() - 1);
    }
}

