/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.util.ui.JBUI;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class IntroduceParameterSettingsUI {
    protected final boolean myIsInvokedOnDeclaration;
    protected final boolean myHasInitializer;
    protected StateRestoringCheckBox myCbDeleteLocalVariable;
    protected StateRestoringCheckBox myCbUseInitializer;
    protected JRadioButton myReplaceFieldsWithGettersNoneRadio;
    protected JRadioButton myReplaceFieldsWithGettersInaccessibleRadio;
    protected JRadioButton myReplaceFieldsWithGettersAllRadio;
    protected final ButtonGroup myReplaceFieldsWithGettersButtonGroup = new ButtonGroup();
    protected final PsiParameter[] myParametersToRemove;
    protected final boolean[] myParametersToRemoveChecked;
    protected final boolean myIsLocalVariable;
    protected JCheckBox myCbReplaceAllOccurences;
    protected JCheckBox myCbGenerateDelegate;

    public IntroduceParameterSettingsUI(PsiLocalVariable onLocalVariable, PsiExpression onExpression, PsiMethod methodToReplaceIn, TIntArrayList parametersToRemove) {
        this.myHasInitializer = onLocalVariable != null && onLocalVariable.getInitializer() != null;
        this.myIsInvokedOnDeclaration = onExpression == null;
        PsiParameter[] parameters2 = methodToReplaceIn.getParameterList().getParameters();
        this.myParametersToRemove = new PsiParameter[parameters2.length];
        this.myParametersToRemoveChecked = new boolean[parameters2.length];
        parametersToRemove.forEach(paramNum -> {
            this.myParametersToRemove[paramNum] = parameters2[paramNum];
            return true;
        });
        this.myIsLocalVariable = onLocalVariable != null;
    }

    protected boolean isDeleteLocalVariable() {
        return this.myIsInvokedOnDeclaration || this.myCbDeleteLocalVariable != null && this.myCbDeleteLocalVariable.isSelected();
    }

    protected boolean isUseInitializer() {
        if (this.myIsInvokedOnDeclaration) {
            return this.myHasInitializer;
        }
        return this.myCbUseInitializer != null && this.myCbUseInitializer.isSelected();
    }

    protected int getReplaceFieldsWithGetters() {
        if (this.myReplaceFieldsWithGettersAllRadio != null && this.myReplaceFieldsWithGettersAllRadio.isSelected()) {
            return 2;
        }
        if (this.myReplaceFieldsWithGettersInaccessibleRadio != null && this.myReplaceFieldsWithGettersInaccessibleRadio.isSelected()) {
            return 1;
        }
        if (this.myReplaceFieldsWithGettersNoneRadio != null && this.myReplaceFieldsWithGettersNoneRadio.isSelected()) {
            return 0;
        }
        return 1;
    }

    public boolean isReplaceAllOccurences() {
        return this.myIsInvokedOnDeclaration || this.myCbReplaceAllOccurences != null && this.myCbReplaceAllOccurences.isSelected();
    }

    public boolean isGenerateDelegate() {
        return this.myCbGenerateDelegate != null && this.myCbGenerateDelegate.isSelected();
    }

    protected JPanel createReplaceFieldsWithGettersPanel() {
        JPanel radioButtonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insets((int)4, (int)8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        radioButtonPanel.add((Component)new JLabel(RefactoringBundle.message((String)"replace.fields.used.in.expressions.with.their.getters")), gbConstraints);
        this.myReplaceFieldsWithGettersNoneRadio = new JRadioButton();
        this.myReplaceFieldsWithGettersNoneRadio.setText(RefactoringBundle.message((String)"do.not.replace"));
        this.myReplaceFieldsWithGettersInaccessibleRadio = new JRadioButton();
        this.myReplaceFieldsWithGettersInaccessibleRadio.setText(RefactoringBundle.message((String)"replace.fields.inaccessible.in.usage.context"));
        this.myReplaceFieldsWithGettersAllRadio = new JRadioButton();
        this.myReplaceFieldsWithGettersAllRadio.setText(RefactoringBundle.message((String)"replace.all.fields"));
        ++gbConstraints.gridy;
        radioButtonPanel.add((Component)this.myReplaceFieldsWithGettersNoneRadio, gbConstraints);
        ++gbConstraints.gridy;
        radioButtonPanel.add((Component)this.myReplaceFieldsWithGettersInaccessibleRadio, gbConstraints);
        ++gbConstraints.gridy;
        radioButtonPanel.add((Component)this.myReplaceFieldsWithGettersAllRadio, gbConstraints);
        int currentSetting = JavaRefactoringSettings.getInstance().INTRODUCE_PARAMETER_REPLACE_FIELDS_WITH_GETTERS;
        this.myReplaceFieldsWithGettersButtonGroup.add(this.myReplaceFieldsWithGettersNoneRadio);
        this.myReplaceFieldsWithGettersButtonGroup.add(this.myReplaceFieldsWithGettersInaccessibleRadio);
        this.myReplaceFieldsWithGettersButtonGroup.add(this.myReplaceFieldsWithGettersAllRadio);
        if (currentSetting == 2) {
            this.myReplaceFieldsWithGettersAllRadio.setSelected(true);
        } else if (currentSetting == 1) {
            this.myReplaceFieldsWithGettersInaccessibleRadio.setSelected(true);
        } else if (currentSetting == 0) {
            this.myReplaceFieldsWithGettersNoneRadio.setSelected(true);
        }
        return radioButtonPanel;
    }

    protected void saveSettings(JavaRefactoringSettings settings) {
        if (this.myCbDeleteLocalVariable != null) {
            settings.INTRODUCE_PARAMETER_DELETE_LOCAL_VARIABLE = this.myCbDeleteLocalVariable.isSelectedWhenSelectable();
        }
        if (this.myCbUseInitializer != null) {
            settings.INTRODUCE_PARAMETER_USE_INITIALIZER = this.myCbUseInitializer.isSelectedWhenSelectable();
        }
    }

    protected TIntArrayList getParametersToRemove() {
        TIntArrayList parameters2 = new TIntArrayList();
        for (int i = 0; i < this.myParametersToRemoveChecked.length; ++i) {
            if (!this.myParametersToRemoveChecked[i]) continue;
            parameters2.add(i);
        }
        return parameters2;
    }

    protected void updateControls(JCheckBox[] removeParamsCb) {
        if (this.myCbReplaceAllOccurences != null) {
            for (JCheckBox box : removeParamsCb) {
                if (box == null) continue;
                box.setEnabled(this.myCbReplaceAllOccurences.isSelected());
                box.setSelected(this.myCbReplaceAllOccurences.isSelected());
            }
            if (this.myCbReplaceAllOccurences.isSelected()) {
                if (this.myCbDeleteLocalVariable != null) {
                    this.myCbDeleteLocalVariable.makeSelectable();
                }
            } else if (this.myCbDeleteLocalVariable != null) {
                this.myCbDeleteLocalVariable.makeUnselectable(false);
            }
        }
    }

    protected void updateTypeSelector() {
        if (this.myCbReplaceAllOccurences != null) {
            this.getTypeSelectionManager().setAllOccurrences(this.myCbReplaceAllOccurences.isSelected());
        } else {
            this.getTypeSelectionManager().setAllOccurrences(this.myIsInvokedOnDeclaration);
        }
    }

    protected abstract TypeSelectorManager getTypeSelectionManager();

    protected void createRemoveParamsPanel(GridBagConstraints gbConstraints, JPanel panel2) {
        final JCheckBox[] removeParamsCb = new JCheckBox[this.myParametersToRemove.length];
        for (int i = 0; i < this.myParametersToRemove.length; ++i) {
            PsiParameter parameter2 = this.myParametersToRemove[i];
            if (parameter2 == null) continue;
            final NonFocusableCheckBox cb = new NonFocusableCheckBox(RefactoringBundle.message((String)"remove.parameter.0.no.longer.used", (Object[])new Object[]{parameter2.getName()}));
            removeParamsCb[i] = cb;
            cb.setSelected(true);
            ++gbConstraints.gridy;
            panel2.add((Component)cb, gbConstraints);
            final int i1 = i;
            cb.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    IntroduceParameterSettingsUI.this.myParametersToRemoveChecked[i1] = cb.isSelected();
                }
            });
            this.myParametersToRemoveChecked[i] = true;
        }
        this.updateControls(removeParamsCb);
        if (this.myCbReplaceAllOccurences != null) {
            this.myCbReplaceAllOccurences.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    IntroduceParameterSettingsUI.this.updateControls(removeParamsCb);
                }
            });
        }
    }

    public boolean isParamToRemove(PsiParameter param) {
        if (this.myCbReplaceAllOccurences != null && !this.myCbReplaceAllOccurences.isSelected()) {
            return false;
        }
        if (param.isVarArgs()) {
            return this.myParametersToRemove[this.myParametersToRemove.length - 1] != null;
        }
        int parameterIndex = ((PsiMethod)param.getDeclarationScope()).getParameterList().getParameterIndex(param);
        return this.myParametersToRemove[parameterIndex] != null;
    }

    protected void createLocalVariablePanel(GridBagConstraints gbConstraints, JPanel panel2, JavaRefactoringSettings settings) {
        if (this.myIsLocalVariable && !this.myIsInvokedOnDeclaration) {
            this.myCbDeleteLocalVariable = new StateRestoringCheckBox();
            this.myCbDeleteLocalVariable.setText(RefactoringBundle.message((String)"delete.variable.declaration"));
            this.myCbDeleteLocalVariable.setFocusable(false);
            ++gbConstraints.gridy;
            panel2.add((Component)this.myCbDeleteLocalVariable, gbConstraints);
            this.myCbDeleteLocalVariable.setSelected(settings.INTRODUCE_PARAMETER_DELETE_LOCAL_VARIABLE);
            gbConstraints.insets = JBUI.insets((int)0, (int)0, (int)4, (int)8);
            if (this.myHasInitializer) {
                this.myCbUseInitializer = new StateRestoringCheckBox();
                this.myCbUseInitializer.setText(RefactoringBundle.message((String)"use.variable.initializer.to.initialize.parameter"));
                this.myCbUseInitializer.setSelected(settings.INTRODUCE_PARAMETER_USE_INITIALIZER);
                this.myCbUseInitializer.setFocusable(false);
                ++gbConstraints.gridy;
                panel2.add((Component)this.myCbUseInitializer, gbConstraints);
            }
        }
    }

    protected void createDelegateCb(GridBagConstraints gbConstraints, JPanel panel2) {
        this.myCbGenerateDelegate = new NonFocusableCheckBox(RefactoringBundle.message((String)"delegation.panel.delegate.via.overloading.method"));
        panel2.add((Component)this.myCbGenerateDelegate, gbConstraints);
    }

    protected void createOccurrencesCb(GridBagConstraints gbConstraints, JPanel panel2, int occurenceNumber) {
        this.myCbReplaceAllOccurences = new NonFocusableCheckBox();
        this.myCbReplaceAllOccurences.setText(RefactoringBundle.message((String)"replace.all.occurences", (Object[])new Object[]{occurenceNumber}));
        panel2.add((Component)this.myCbReplaceAllOccurences, gbConstraints);
        this.myCbReplaceAllOccurences.setSelected(false);
    }

    public void setReplaceAllOccurrences(boolean replaceAll) {
        if (this.myCbReplaceAllOccurences != null) {
            this.myCbReplaceAllOccurences.setSelected(replaceAll);
        }
    }
}

