/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.move.MoveCallback;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class MoveHandlerDelegate {
    public static final ExtensionPointName<MoveHandlerDelegate> EP_NAME = ExtensionPointName.create((String)"com.intellij.refactoring.moveHandler");

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        return this.isValidTarget(targetContainer, elements);
    }

    public boolean canMove(DataContext dataContext) {
        return false;
    }

    public boolean isValidTarget(@Nullable PsiElement targetElement, PsiElement[] sources) {
        return false;
    }

    public void doMove(Project project2, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
    }

    public PsiElement adjustTargetForMove(DataContext dataContext, PsiElement targetContainer) {
        return targetContainer;
    }

    @Nullable
    public PsiElement[] adjustForMove(Project project2, PsiElement[] sourceElements, PsiElement targetElement) {
        return sourceElements;
    }

    public boolean tryToMove(PsiElement element, Project project2, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        return false;
    }

    public void collectFilesOrDirsFromContext(DataContext dataContext, Set<PsiElement> filesOrDirs) {
    }

    public boolean isMoveRedundant(PsiElement source, PsiElement target2) {
        return false;
    }
}

