/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInner;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveInner.MoveInnerClassUsagesHandler;
import com.intellij.refactoring.move.moveInner.MoveInnerHandler;
import com.intellij.refactoring.move.moveInner.MoveInnerOptions;
import com.intellij.refactoring.move.moveInner.MoveInnerViewDescriptor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveInnerProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveInner.MoveInnerProcessor");
    private MoveCallback myMoveCallback;
    private PsiClass myInnerClass;
    private PsiClass myOuterClass;
    private PsiElement myTargetContainer;
    private String myParameterNameOuterClass;
    private String myFieldNameOuterClass;
    private String myDescriptiveName = "";
    private String myNewClassName;
    private boolean mySearchInComments;
    private boolean mySearchInNonJavaFiles;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private boolean myOpenInEditor;

    public MoveInnerProcessor(Project project2, MoveCallback moveCallback) {
        super(project2);
        this.myMoveCallback = moveCallback;
    }

    public MoveInnerProcessor(Project project2, PsiClass innerClass, String name2, boolean passOuterClass, String parameterName, PsiElement targetContainer) {
        super(project2);
        this.setup(innerClass, name2, passOuterClass, parameterName, true, true, targetContainer);
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"move.inner.class.command", (Object[])new Object[]{this.myDescriptiveName});
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            MoveInnerProcessor.$$$reportNull$$$0(0);
        }
        MoveInnerViewDescriptor moveInnerViewDescriptor = new MoveInnerViewDescriptor(this.myInnerClass);
        if (moveInnerViewDescriptor == null) {
            MoveInnerProcessor.$$$reportNull$$$0(1);
        }
        return moveInnerViewDescriptor;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        String newQName;
        LOG.assertTrue(this.myTargetContainer != null);
        Collection innerClassRefs = ReferencesSearch.search((PsiElement)this.myInnerClass).findAll();
        ArrayList<UsageInfo> usageInfos = new ArrayList<UsageInfo>(innerClassRefs.size());
        for (PsiReference innerClassRef : innerClassRefs) {
            PsiElement ref = innerClassRef.getElement();
            if (PsiTreeUtil.isAncestor((PsiElement)this.myInnerClass, (PsiElement)ref, (boolean)true)) continue;
            usageInfos.add(new UsageInfo(ref));
        }
        if (this.myTargetContainer instanceof PsiDirectory) {
            PsiDirectory targetDirectory = (PsiDirectory)this.myTargetContainer;
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(targetDirectory);
            LOG.assertTrue(aPackage != null);
            newQName = aPackage.getQualifiedName() + "." + this.myNewClassName;
        } else {
            String qName;
            newQName = this.myTargetContainer instanceof PsiClass ? ((qName = ((PsiClass)this.myTargetContainer).getQualifiedName()) != null ? qName + "." + this.myNewClassName : this.myNewClassName) : this.myNewClassName;
        }
        MoveClassesOrPackagesUtil.findNonCodeUsages(this.mySearchInComments, this.mySearchInNonJavaFiles, (PsiElement)this.myInnerClass, newQName, usageInfos);
        UsageInfo[] usageInfoArray = usageInfos.toArray(new UsageInfo[usageInfos.size()]);
        if (usageInfoArray == null) {
            MoveInnerProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            MoveInnerProcessor.$$$reportNull$$$0(3);
        }
        boolean condition2 = elements.length == 1 && elements[0] instanceof PsiClass;
        LOG.assertTrue(condition2);
        this.myInnerClass = (PsiClass)elements[0];
    }

    public boolean isSearchInComments() {
        return this.mySearchInComments;
    }

    public void setSearchInComments(boolean searchInComments) {
        this.mySearchInComments = searchInComments;
    }

    public boolean isSearchInNonJavaFiles() {
        return this.mySearchInNonJavaFiles;
    }

    public void setSearchInNonJavaFiles(boolean searchInNonJavaFiles) {
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            MoveInnerProcessor.$$$reportNull$$$0(4);
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        RefactoringElementListener elementListener = this.getTransaction().getElementListener((PsiElement)this.myInnerClass);
        try {
            PsiClass newClass;
            PsiField field = null;
            if (this.myParameterNameOuterClass != null) {
                field = factory.createField(this.myFieldNameOuterClass, (PsiType)factory.createType(this.myOuterClass));
                field = this.addOuterField(field);
                this.myInnerClass = field.getContainingClass();
                this.addFieldInitializationToConstructors(this.myInnerClass, field, this.myParameterNameOuterClass);
            }
            ChangeContextUtil.encodeContextInfo((PsiElement)this.myInnerClass, false);
            this.myInnerClass = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(this.myInnerClass);
            MoveInnerOptions moveInnerOptions = new MoveInnerOptions(this.myInnerClass, this.myOuterClass, this.myTargetContainer, this.myNewClassName);
            MoveInnerHandler handler2 = (MoveInnerHandler)MoveInnerHandler.EP_NAME.forLanguage(this.myInnerClass.getLanguage());
            try {
                newClass = handler2.copyClass(moveInnerOptions);
            }
            catch (IncorrectOperationException e) {
                RefactoringUIUtil.processIncorrectOperation(this.myProject, e);
                return;
            }
            for (Object ref : ReferencesSearch.search((PsiElement)this.myInnerClass, (SearchScope)new LocalSearchScope((PsiElement)newClass), (boolean)true)) {
                PsiReferenceList referenceList;
                PsiJavaCodeReferenceElement parentRef;
                PsiElement parentRefElement;
                PsiElement element = ref.getElement();
                if (element.getParent() instanceof PsiJavaCodeReferenceElement && (parentRefElement = (parentRef = (PsiJavaCodeReferenceElement)element.getParent()).resolve()) instanceof PsiClass && ((referenceList = (PsiReferenceList)PsiTreeUtil.getTopmostParentOfType((PsiElement)parentRef, PsiReferenceList.class)) == null || referenceList.getParent() != newClass)) {
                    parentRef.getQualifier().delete();
                    continue;
                }
                ref.bindToElement((PsiElement)newClass);
            }
            ArrayList<PsiReference> referencesToRebind = new ArrayList<PsiReference>();
            for (Object usage : usages) {
                PsiReference[] references;
                if (usage.isNonCodeUsage) continue;
                PsiElement refElement = usage.getElement();
                for (PsiReference reference : references = refElement.getReferences()) {
                    if (!reference.isReferenceTo((PsiElement)this.myInnerClass)) continue;
                    referencesToRebind.add(reference);
                }
            }
            this.myInnerClass.delete();
            for (Object usage : usages) {
                MoveInnerClassUsagesHandler usagesHandler;
                if (usage.isNonCodeUsage || this.myParameterNameOuterClass == null || (usagesHandler = (MoveInnerClassUsagesHandler)MoveInnerClassUsagesHandler.EP_NAME.forLanguage(usage.getElement().getLanguage())) == null) continue;
                usagesHandler.correctInnerClassUsage((UsageInfo)usage, this.myOuterClass);
            }
            for (PsiReference reference : referencesToRebind) {
                reference.bindToElement((PsiElement)newClass);
            }
            block9: for (Object usage : usages) {
                PsiElement parent;
                PsiElement element = usage.getElement();
                PsiElement psiElement = parent = element != null ? element.getParent() : null;
                if (!(parent instanceof PsiNewExpression)) continue;
                PsiMethod resolveConstructor = ((PsiNewExpression)parent).resolveConstructor();
                for (PsiMethod method : newClass.getConstructors()) {
                    if (resolveConstructor != method) continue;
                    PsiElement place = usage.getElement();
                    if (place == null) continue block9;
                    VisibilityUtil.escalateVisibility((PsiMember)method, (PsiElement)place);
                    continue block9;
                }
            }
            if (field != null) {
                PsiExpression paramAccessExpression = factory.createExpressionFromText(this.myParameterNameOuterClass, null);
                for (PsiMethod constructor : newClass.getConstructors()) {
                    String text2;
                    PsiExpression expression2;
                    PsiStatement[] statements = constructor.getBody().getStatements();
                    if (statements.length <= 0 || !(statements[0] instanceof PsiExpressionStatement) || !((expression2 = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression) || !"this".equals(text2 = ((PsiMethodCallExpression)expression2).getMethodExpression().getText()) && !"super".equals(text2)) continue;
                    ChangeContextUtil.decodeContextInfo((PsiElement)expression2, this.myOuterClass, paramAccessExpression);
                }
                PsiExpression accessExpression = factory.createExpressionFromText(this.myFieldNameOuterClass, null);
                ChangeContextUtil.decodeContextInfo((PsiElement)newClass, this.myOuterClass, accessExpression);
            } else {
                ChangeContextUtil.decodeContextInfo((PsiElement)newClass, null, null);
            }
            if (this.myOpenInEditor) {
                EditorHelper.openInEditor((PsiElement)newClass);
            }
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
            elementListener.elementMoved((PsiElement)newClass);
            ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
            for (UsageInfo usage : usages) {
                if (!(usage instanceof NonCodeUsageInfo)) continue;
                nonCodeUsages.add((NonCodeUsageInfo)usage);
            }
            this.myNonCodeUsages = nonCodeUsages.toArray(new NonCodeUsageInfo[nonCodeUsages.size()]);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private PsiField addOuterField(PsiField field) {
        PsiMember[] members = (PsiMember[])PsiTreeUtil.getChildrenOfType((PsiElement)this.myInnerClass, PsiMember.class);
        if (members != null) {
            for (PsiMember member : members) {
                if (member.hasModifierProperty("static")) continue;
                return (PsiField)this.myInnerClass.addBefore((PsiElement)field, (PsiElement)member);
            }
        }
        return (PsiField)this.myInnerClass.add((PsiElement)field);
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages != null) {
            RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        }
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            MoveInnerProcessor.$$$reportNull$$$0(5);
        }
        final MultiMap conflicts = new MultiMap();
        final HashMap reported = new HashMap();
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            Visitor() {
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiElement resolved = reference.resolve();
                if (resolved instanceof PsiMember && PsiTreeUtil.isAncestor((PsiElement)MoveInnerProcessor.this.myInnerClass, (PsiElement)resolved, (boolean)true) && MoveInnerProcessor.this.becomesInaccessible((PsiMember)resolved)) {
                    MoveInnerProcessor.registerConflict(reference, resolved, (HashMap<PsiElement, HashSet<PsiElement>>)reported, (MultiMap<PsiElement, String>)conflicts);
                }
            }

            public void visitClass(PsiClass aClass) {
                if (aClass == MoveInnerProcessor.this.myInnerClass) {
                    return;
                }
                super.visitClass(aClass);
            }
        }
        this.myOuterClass.accept((PsiElementVisitor)new Visitor());
        this.myInnerClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolve2 = reference.resolve();
                if (resolve2 instanceof PsiMember && PsiTreeUtil.isAncestor((PsiElement)MoveInnerProcessor.this.myOuterClass, (PsiElement)resolve2, (boolean)true) && !PsiTreeUtil.isAncestor((PsiElement)MoveInnerProcessor.this.myInnerClass, (PsiElement)resolve2, (boolean)false) && MoveInnerProcessor.this.becomesInaccessible((PsiMember)resolve2)) {
                    MoveInnerProcessor.registerConflict(reference, resolve2, (HashMap<PsiElement, HashSet<PsiElement>>)reported, (MultiMap<PsiElement, String>)conflicts);
                }
            }
        });
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, (UsageInfo[])refUsages.get());
    }

    private static void registerConflict(PsiJavaCodeReferenceElement reference, PsiElement resolved, HashMap<PsiElement, HashSet<PsiElement>> reported, MultiMap<PsiElement, String> conflicts) {
        PsiElement container = ConflictsUtil.getContainer((PsiElement)reference);
        HashSet<PsiElement> containerSet = (HashSet<PsiElement>)reported.get((Object)container);
        if (containerSet == null) {
            containerSet = new HashSet<PsiElement>();
            reported.put((Object)container, containerSet);
        }
        if (!containerSet.contains(resolved)) {
            containerSet.add(resolved);
            String placesDescription = containerSet.size() == 1 ? RefactoringUIUtil.getDescription(resolved, true) : "<ol><li>" + StringUtil.join(containerSet, element -> RefactoringUIUtil.getDescription(element, true), (String)"</li><li>") + "</li></ol>";
            String message2 = RefactoringBundle.message((String)"0.will.become.inaccessible.from.1", (Object[])new Object[]{placesDescription, RefactoringUIUtil.getDescription(container, true)});
            conflicts.put((Object)container, Collections.singletonList(message2));
        }
    }

    private boolean becomesInaccessible(PsiMember element) {
        PsiDirectory containingDirectory;
        String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)element.getModifierList());
        if ("private".equals(visibilityModifier)) {
            return true;
        }
        if ("public".equals(visibilityModifier)) {
            return false;
        }
        if ("protected".equals(visibilityModifier) && InheritanceUtil.isInheritorOrSelf((PsiClass)this.myInnerClass, (PsiClass)this.myOuterClass, (boolean)true)) {
            return false;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        if (this.myTargetContainer instanceof PsiDirectory) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)this.myTargetContainer);
            assert (aPackage != null) : this.myTargetContainer;
            return !psiFacade.isInPackage((PsiElement)this.myOuterClass, aPackage);
        }
        PsiFile targetFile = this.myTargetContainer.getContainingFile();
        if (targetFile != null && (containingDirectory = targetFile.getContainingDirectory()) != null) {
            PsiPackage targetPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory);
            assert (targetPackage != null) : this.myTargetContainer;
            return psiFacade.isInPackage((PsiElement)this.myOuterClass, targetPackage);
        }
        return false;
    }

    public void setup(PsiClass innerClass, String className, boolean passOuterClass, String parameterName, boolean searchInComments, boolean searchInNonJava, @NotNull PsiElement targetContainer) {
        if (targetContainer == null) {
            MoveInnerProcessor.$$$reportNull$$$0(6);
        }
        this.myNewClassName = className;
        this.myInnerClass = innerClass;
        this.myDescriptiveName = DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myInnerClass);
        this.myOuterClass = this.myInnerClass.getContainingClass();
        this.myTargetContainer = targetContainer;
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        String string = this.myParameterNameOuterClass = passOuterClass ? parameterName : null;
        if (this.myParameterNameOuterClass != null) {
            this.myFieldNameOuterClass = codeStyleManager.variableNameToPropertyName(this.myParameterNameOuterClass, VariableKind.PARAMETER);
            this.myFieldNameOuterClass = codeStyleManager.propertyNameToVariableName(this.myFieldNameOuterClass, VariableKind.FIELD);
        }
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJava;
    }

    private void addFieldInitializationToConstructors(PsiClass aClass, PsiField field, String parameterName) throws IncorrectOperationException {
        PsiMethod[] constructors = aClass.getConstructors();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        if (constructors.length > 0) {
            for (PsiMethod constructor : constructors) {
                String text2;
                PsiExpression expression2;
                PsiStatement first;
                PsiStatement[] statements;
                PsiCodeBlock body2;
                if (parameterName != null) {
                    PsiParameterList parameterList = constructor.getParameterList();
                    PsiParameter parameter2 = factory.createParameter(parameterName, field.getType());
                    parameterList.addAfter((PsiElement)parameter2, null);
                }
                if ((body2 = constructor.getBody()) == null || (statements = body2.getStatements()).length > 0 && (first = statements[0]) instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression && "this".equals(text2 = ((PsiMethodCallExpression)expression2).getMethodExpression().getText())) continue;
                this.createAssignmentStatement(constructor, field.getName(), parameterName);
            }
        } else {
            PsiMethod constructor = factory.createConstructor();
            if (parameterName != null) {
                PsiParameterList parameterList = constructor.getParameterList();
                PsiParameter parameter3 = factory.createParameter(parameterName, field.getType());
                parameterList.add((PsiElement)parameter3);
            }
            this.createAssignmentStatement(constructor, field.getName(), parameterName);
            aClass.add((PsiElement)constructor);
        }
    }

    private PsiStatement createAssignmentStatement(PsiMethod constructor, String fieldName, String parameterName) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        String pattern = fieldName + "=a;";
        if (fieldName.equals(parameterName)) {
            pattern = "this." + pattern;
        }
        PsiExpressionStatement statement2 = (PsiExpressionStatement)factory.createStatementFromText(pattern, null);
        statement2 = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)statement2);
        PsiCodeBlock body2 = constructor.getBody();
        assert (body2 != null) : constructor;
        statement2 = (PsiExpressionStatement)body2.addAfter((PsiElement)statement2, MoveInnerProcessor.getAnchorElement(body2));
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement2.getExpression();
        PsiReferenceExpression rExpr = (PsiReferenceExpression)assignment.getRExpression();
        assert (rExpr != null) : assignment;
        PsiIdentifier identifier = (PsiIdentifier)rExpr.getReferenceNameElement();
        assert (identifier != null) : assignment;
        identifier.replace((PsiElement)factory.createIdentifier(parameterName));
        return statement2;
    }

    @Nullable
    private static PsiElement getAnchorElement(PsiCodeBlock body2) {
        PsiReferenceExpression methodCall;
        String text2;
        PsiExpression expression2;
        PsiStatement first;
        PsiStatement[] statements = body2.getStatements();
        if (statements.length > 0 && (first = statements[0]) instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression && "super".equals(text2 = (methodCall = ((PsiMethodCallExpression)expression2).getMethodExpression()).getText())) {
            return first;
        }
        return null;
    }

    public PsiClass getInnerClass() {
        return this.myInnerClass;
    }

    public String getNewClassName() {
        return this.myNewClassName;
    }

    public boolean shouldPassParameter() {
        return this.myParameterNameOuterClass != null;
    }

    public String getParameterName() {
        return this.myParameterNameOuterClass;
    }

    public void setOpenInEditor(boolean openInEditor) {
        this.myOpenInEditor = openInEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveInner/MoveInnerProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveInner/MoveInnerProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

