/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.CommonBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.file.PsiPackageBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DirectoryAsPackageRenameHandlerBase<T extends PsiDirectoryContainer>
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.DirectoryAsPackageRenameHandler");

    protected abstract VirtualFile[] occursInPackagePrefixes(T var1);

    protected abstract boolean isIdentifier(String var1, Project var2);

    protected abstract String getQualifiedName(T var1);

    @Nullable
    protected abstract T getPackage(PsiDirectory var1);

    protected abstract BaseRefactoringProcessor createProcessor(String var1, Project var2, PsiDirectory[] var3, boolean var4, boolean var5);

    public boolean isAvailableOnDataContext(DataContext dataContext) {
        PsiElement element = this.adjustForRename(dataContext, PsiElementRenameHandler.getElement(dataContext));
        if (element instanceof PsiDirectory) {
            VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
            Project project2 = element.getProject();
            if (Comparing.equal((Object)project2.getBaseDir(), (Object)virtualFile)) {
                return false;
            }
            if (ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(virtualFile)) {
                return true;
            }
        }
        return false;
    }

    private PsiElement adjustForRename(DataContext dataContext, PsiElement element) {
        Module module2;
        if (element instanceof PsiDirectoryContainer && (module2 = (Module)LangDataKeys.MODULE.getData(dataContext)) != null) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)element).getDirectories(GlobalSearchScope.moduleScope((Module)module2));
            Optional<PsiDirectory> directoryWithPackage = Arrays.stream(directories).filter(directory -> this.getPackage((PsiDirectory)directory) != null).findFirst();
            return directoryWithPackage.orElse(null);
        }
        return element;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            DirectoryAsPackageRenameHandlerBase.$$$reportNull$$$0(0);
        }
        PsiElement element = this.adjustForRename(dataContext, PsiElementRenameHandler.getElement(dataContext));
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement nameSuggestionContext = file2.findElementAt(editor.getCaretModel().getOffset());
        this.doRename(element, project2, nameSuggestionContext, editor);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        PsiElement element;
        if (project2 == null) {
            DirectoryAsPackageRenameHandlerBase.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            DirectoryAsPackageRenameHandlerBase.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = PsiElementRenameHandler.getElement(dataContext);
        }
        PsiElement nameSuggestionContext = element;
        LOG.assertTrue((element = this.adjustForRename(dataContext, element)) != null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        this.doRename(element, project2, nameSuggestionContext, editor);
    }

    private void doRename(PsiElement element, Project project2, PsiElement nameSuggestionContext, Editor editor) {
        String qualifiedName;
        PsiDirectory psiDirectory = (PsiDirectory)element;
        T aPackage = this.getPackage(psiDirectory);
        String string = qualifiedName = aPackage != null ? this.getQualifiedName(aPackage) : "";
        if (aPackage == null || qualifiedName.length() == 0 || !this.isIdentifier(psiDirectory.getName(), project2)) {
            PsiElementRenameHandler.rename(element, project2, nameSuggestionContext, editor);
        } else {
            PsiDirectory[] directories = aPackage.getDirectories();
            VirtualFile[] virtualFiles = this.occursInPackagePrefixes(aPackage);
            if (virtualFiles.length == 0 && directories.length == 1) {
                PsiElementRenameHandler.rename(aPackage, project2, nameSuggestionContext, editor);
            } else {
                ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
                boolean inLib = false;
                for (PsiDirectory directory : directories) {
                    inLib |= !projectFileIndex.isInContent(directory.getVirtualFile());
                }
                PsiDirectory[] projectDirectories = aPackage.getDirectories(GlobalSearchScope.projectScope((Project)project2));
                if (inLib) {
                    Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiDirectory);
                    LOG.assertTrue(module2 != null);
                    PsiDirectory[] moduleDirs = null;
                    if (nameSuggestionContext instanceof PsiPackageBase && (moduleDirs = aPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module2))).length <= 1) {
                        moduleDirs = null;
                    }
                    String promptMessage = "Package '" + aPackage.getName() + "' contains directories in libraries which cannot be renamed. Do you want to rename " + (moduleDirs == null ? "current directory" : "current module directories");
                    if (projectDirectories.length > 0) {
                        PsiDirectory[] psiDirectoryArray;
                        int ret = Messages.showYesNoCancelDialog((Project)project2, (String)(promptMessage + " or all directories in project?"), (String)RefactoringBundle.message((String)"warning.title"), (String)RefactoringBundle.message((String)"rename.current.directory"), (String)RefactoringBundle.message((String)"rename.directories"), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
                        if (ret == 2) {
                            return;
                        }
                        if (ret == 0) {
                            if (moduleDirs == null) {
                                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                                psiDirectoryArray = psiDirectoryArray2;
                                psiDirectoryArray2[0] = psiDirectory;
                            } else {
                                psiDirectoryArray = moduleDirs;
                            }
                        } else {
                            psiDirectoryArray = projectDirectories;
                        }
                        this.renameDirs(project2, nameSuggestionContext, editor, psiDirectory, aPackage, psiDirectoryArray);
                    } else if (Messages.showOkCancelDialog((Project)project2, (String)(promptMessage + "?"), (String)RefactoringBundle.message((String)"warning.title"), (Icon)Messages.getWarningIcon()) == 0) {
                        this.renameDirs(project2, nameSuggestionContext, editor, psiDirectory, aPackage, psiDirectory);
                    }
                } else {
                    StringBuffer message2 = new StringBuffer();
                    RenameUtil.buildPackagePrefixChangedMessage(virtualFiles, message2, qualifiedName);
                    DirectoryAsPackageRenameHandlerBase.buildMultipleDirectoriesInPackageMessage(message2, this.getQualifiedName(aPackage), directories);
                    message2.append(RefactoringBundle.message((String)"directories.and.all.references.to.package.will.be.renamed", (Object[])new Object[]{psiDirectory.getVirtualFile().getPresentableUrl()}));
                    int ret = Messages.showYesNoCancelDialog((Project)project2, (String)message2.toString(), (String)RefactoringBundle.message((String)"warning.title"), (String)RefactoringBundle.message((String)"rename.package.button.text"), (String)RefactoringBundle.message((String)"rename.directory.button.text"), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
                    if (ret == 0) {
                        PsiElementRenameHandler.rename(aPackage, project2, nameSuggestionContext, editor);
                    } else if (ret == 1) {
                        this.renameDirs(project2, nameSuggestionContext, editor, psiDirectory, aPackage, psiDirectory);
                    }
                }
            }
        }
    }

    private void renameDirs(Project project2, PsiElement nameSuggestionContext, Editor editor, PsiDirectory contextDirectory, T aPackage, PsiDirectory ... dirsToRename) {
        RenameDialog dialog2 = new RenameDialog(project2, (PsiElement)contextDirectory, nameSuggestionContext, editor, (PsiDirectoryContainer)aPackage, project2, dirsToRename){
            final /* synthetic */ PsiDirectoryContainer val$aPackage;
            final /* synthetic */ Project val$project;
            final /* synthetic */ PsiDirectory[] val$dirsToRename;
            {
                this.val$aPackage = psiDirectoryContainer;
                this.val$project = project3;
                this.val$dirsToRename = psiDirectoryArray;
                super(project2, psiElement, nameSuggestionContext, editor);
            }

            @Override
            protected void doAction() {
                String newQName = StringUtil.getQualifiedName((String)StringUtil.getPackageName((String)DirectoryAsPackageRenameHandlerBase.this.getQualifiedName(this.val$aPackage)), (String)this.getNewName());
                BaseRefactoringProcessor moveProcessor = DirectoryAsPackageRenameHandlerBase.this.createProcessor(newQName, this.val$project, this.val$dirsToRename, this.isSearchInComments(), this.isSearchInNonJavaFiles());
                this.invokeRefactoring(moveProcessor);
            }
        };
        dialog2.show();
    }

    public static void buildMultipleDirectoriesInPackageMessage(StringBuffer message2, String packageQname, PsiDirectory[] directories) {
        message2.append(RefactoringBundle.message((String)"multiple.directories.correspond.to.package"));
        message2.append(packageQname);
        message2.append(":\n\n");
        ArrayList<PsiDirectory> generated = new ArrayList<PsiDirectory>();
        ArrayList<PsiDirectory> source = new ArrayList<PsiDirectory>();
        for (PsiDirectory directory2 : directories) {
            VirtualFile virtualFile = directory2.getVirtualFile();
            if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)virtualFile, (Project)directory2.getProject())) {
                generated.add(directory2);
                continue;
            }
            source.add(directory2);
        }
        Function directoryPresentation = directory -> directory.getVirtualFile().getPresentableUrl();
        message2.append(StringUtil.join(source, (Function)directoryPresentation, (String)"\n"));
        if (!generated.isEmpty()) {
            message2.append("\n\nalso generated:\n");
            message2.append(StringUtil.join(generated, (Function)directoryPresentation, (String)"\n"));
        }
    }

    public String getActionTitle() {
        return RefactoringBundle.message((String)"rename.directory.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/rename/DirectoryAsPackageRenameHandlerBase";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

