/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenamePsiPackageProcessor;
import com.intellij.refactoring.rename.RenameWithOptionalReferencesDialog;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePsiDirectoryProcessor
extends RenamePsiElementProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PsiDirectory;
    }

    @Override
    public RenameDialog createRenameDialog(Project project2, PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        return new RenameWithOptionalReferencesDialog(project2, element, nameSuggestionContext, editor){

            @Override
            protected boolean getSearchForReferences() {
                return RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY;
            }

            @Override
            protected void setSearchForReferences(boolean value2) {
                RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY = value2;
            }
        };
    }

    @Override
    public String getQualifiedNameAfterRename(PsiElement element, String newName, boolean nonJava) {
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (psiPackage != null) {
            return RenamePsiPackageProcessor.getPackageQualifiedNameAfterRename(psiPackage, newName, nonJava);
        }
        return newName;
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        if (!RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY) {
            List<PsiReference> list2 = Collections.emptyList();
            if (list2 == null) {
                RenamePsiDirectoryProcessor.$$$reportNull$$$0(1);
            }
            return list2;
        }
        Collection collection = ReferencesSearch.search((PsiElement)element).findAll();
        if (collection == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Override
    @Nullable
    public PsiElement getElementToSearchInStringsAndComments(PsiElement element) {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (aPackage != null) {
            return aPackage;
        }
        return null;
    }

    @Override
    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renameDirectory";
    }

    @Override
    public boolean isToSearchInComments(PsiElement element) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element == null) {
            return false;
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element != null) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE = enabled;
        }
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element == null) {
            return false;
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element != null) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE = enabled;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenamePsiDirectoryProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenamePsiDirectoryProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

