/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithBuilder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.refactoring.util.RefactoringUtil;
import java.util.Map;

public class ParameterData {
    private final String myParameterName;
    private final PsiType myType;
    private String myFieldName;
    private String mySetterName;
    private String myDefaultValue;
    private boolean myInsertSetter = true;
    private static final Logger LOG = Logger.getInstance(ParameterData.class);

    public ParameterData(String parameterName, PsiType type2) {
        this.myParameterName = parameterName;
        this.myType = type2;
    }

    public static void createFromConstructor(PsiMethod constructor, String setterPrefix, Map<String, ParameterData> result2) {
        for (PsiParameter parameter2 : constructor.getParameterList().getParameters()) {
            ParameterData.initParameterData(parameter2, setterPrefix, result2);
        }
        PsiMethod chainedConstructor = RefactoringUtil.getChainedConstructor(constructor);
        if (chainedConstructor != null) {
            PsiCodeBlock constructorBody = constructor.getBody();
            LOG.assertTrue(constructorBody != null);
            PsiStatement thisStatement = constructorBody.getStatements()[0];
            PsiExpression thisExpression = ((PsiExpressionStatement)thisStatement).getExpression();
            PsiExpression[] args = ((PsiMethodCallExpression)thisExpression).getArgumentList().getExpressions();
            int i = 0;
            for (PsiParameter parameter3 : chainedConstructor.getParameterList().getParameters()) {
                if (parameter3.isVarArgs()) continue;
                PsiExpression arg = args[i];
                ParameterData parameterData = ParameterData.initParameterData(parameter3, setterPrefix, result2);
                if (!(arg instanceof PsiReferenceExpression) || !(((PsiReferenceExpression)arg).resolve() instanceof PsiParameter)) {
                    parameterData.setDefaultValue(arg.getText());
                }
                ++i;
            }
        }
    }

    private static ParameterData initParameterData(PsiParameter parameter2, String setterPrefix, Map<String, ParameterData> result2) {
        String pureParamName;
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)parameter2.getProject());
        String paramName = parameter2.getName();
        String uniqueParamName = pureParamName = styleManager.variableNameToPropertyName(paramName, VariableKind.PARAMETER);
        ParameterData parameterData = result2.get(uniqueParamName);
        int i = 0;
        while (parameterData != null && !Comparing.equal((Object)parameter2.getType(), (Object)parameterData.getType())) {
            uniqueParamName = pureParamName + i++;
            parameterData = result2.get(uniqueParamName);
        }
        if (parameterData == null) {
            parameterData = new ParameterData(paramName, parameter2.getType());
            parameterData.setFieldName(styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, (String)uniqueParamName, null, (PsiType)parameter2.getType()).names[0]);
            parameterData.setSetterName(PropertyUtilBase.suggestSetterName((String)uniqueParamName, (String)setterPrefix));
            result2.put(uniqueParamName, parameterData);
        }
        return parameterData;
    }

    public PsiType getType() {
        return this.myType;
    }

    public String getFieldName() {
        return this.myFieldName;
    }

    public String getSetterName() {
        return this.mySetterName;
    }

    public String getParamName() {
        return this.myParameterName;
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    public boolean isInsertSetter() {
        return this.myInsertSetter;
    }

    public void setFieldName(String fieldName) {
        this.myFieldName = fieldName;
    }

    public void setSetterName(String setterName) {
        this.mySetterName = setterName;
    }

    public void setDefaultValue(String defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    public void setInsertSetter(boolean insertSetter) {
        this.myInsertSetter = insertSetter;
    }
}

