/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JavaSafeDeleteDelegateImpl
implements JavaSafeDeleteDelegate {
    public void createUsageInfoForParameter(PsiReference reference, List<UsageInfo> usages, PsiParameter parameter2, final PsiMethod method) {
        final int index = method.getParameterList().getParameterIndex(parameter2);
        final PsiElement element = reference.getElement();
        PsiCall call = null;
        if (element instanceof PsiCall) {
            call = (PsiCall)element;
        } else {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiCall) {
                call = (PsiCall)parent;
            } else if (parent instanceof PsiAnonymousClass) {
                call = (PsiNewExpression)parent.getParent();
            }
        }
        if (call != null) {
            PsiExpression[] args;
            PsiExpressionList argList = call.getArgumentList();
            if (argList != null && index < (args = argList.getExpressions()).length) {
                if (!parameter2.isVarArgs()) {
                    usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(args[index], (PsiElement)parameter2));
                } else {
                    for (int i = index; i < args.length; ++i) {
                        usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(args[i], (PsiElement)parameter2));
                    }
                }
            }
        } else if (element instanceof PsiDocMethodOrFieldRef) {
            if (((PsiDocMethodOrFieldRef)element).getSignature() != null) {
                final StringBuffer newText = new StringBuffer();
                newText.append("/** @see #").append(method.getName()).append('(');
                ArrayList<PsiParameter> parameters2 = new ArrayList<PsiParameter>(Arrays.asList(method.getParameterList().getParameters()));
                parameters2.remove(parameter2);
                newText.append(StringUtil.join(parameters2, psiParameter -> psiParameter.getType().getCanonicalText(), (String)","));
                newText.append(")*/");
                usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)parameter2, true){

                    @Override
                    public void deleteElement() throws IncorrectOperationException {
                        PsiDocMethodOrFieldRef.MyReference javadocMethodReference = (PsiDocMethodOrFieldRef.MyReference)element.getReference();
                        if (javadocMethodReference != null) {
                            javadocMethodReference.bindToText(method.getContainingClass(), newText);
                        }
                    }
                });
            }
        } else if (element instanceof PsiMethodReferenceExpression) {
            usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)parameter2, true){

                @Override
                public void deleteElement() throws IncorrectOperationException {
                    PsiExpression[] args;
                    PsiExpressionList expressionList;
                    PsiExpression callExpression = LambdaRefactoringUtil.convertToMethodCallInLambdaBody((PsiMethodReferenceExpression)element);
                    if (callExpression instanceof PsiCallExpression && (expressionList = ((PsiCallExpression)callExpression).getArgumentList()) != null && index < (args = expressionList.getExpressions()).length) {
                        args[index].delete();
                    }
                }
            });
        }
    }
}

