/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.tempWithQuery;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class TempWithQueryHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.tempWithQuery.TempWithQueryHandler");
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"replace.temp.with.query.title");

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            TempWithQueryHandler.$$$reportNull$$$0(0);
        }
        PsiElement element = TargetElementUtil.findTargetElement(editor, 11);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (!(element instanceof PsiLocalVariable)) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.local.name"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.replaceTemp");
            return;
        }
        TempWithQueryHandler.invokeOnVariable(file2, project2, (PsiLocalVariable)element, editor);
    }

    private static void invokeOnVariable(PsiFile file2, Project project2, PsiLocalVariable local, Editor editor) {
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)file2)) {
            return;
        }
        String localName = local.getName();
        PsiExpression initializer = local.getInitializer();
        if (initializer == null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.has.no.initializer", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.replaceTemp");
            return;
        }
        PsiReference[] refs = (PsiReference[])ReferencesSearch.search((PsiElement)local, (SearchScope)GlobalSearchScope.projectScope((Project)project2), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY);
        if (refs.length == 0) {
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.never.used", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message3, (String)REFACTORING_NAME, (String)"refactoring.replaceTemp");
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        ArrayList<PsiReference> array = new ArrayList<PsiReference>();
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        for (PsiReference ref : refs) {
            PsiElement refElement = ref.getElement();
            if (PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refElement))) {
                array.add(ref);
            }
            if (array.isEmpty()) continue;
            PsiReference[] refsForWriting = array.toArray(new PsiReference[array.size()]);
            highlightManager.addOccurrenceHighlights(editor, refsForWriting, attributes, true, null);
            String message4 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message4, (String)REFACTORING_NAME, (String)"refactoring.replaceTemp");
            WindowManager.getInstance().getStatusBar(project2).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return;
        }
        ExtractMethodProcessor processor2 = new ExtractMethodProcessor(project2, editor, new PsiElement[]{initializer}, local.getType(), REFACTORING_NAME, localName, "refactoring.replaceTemp");
        try {
            if (!processor2.prepare()) {
                return;
            }
        }
        catch (PrepareFailedException e) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)e.getMessage(), (String)REFACTORING_NAME, (String)"refactoring.replaceTemp");
            ExtractMethodHandler.highlightPrepareError(e, file2, editor, project2);
            return;
        }
        PsiClass targetClass = processor2.getTargetClass();
        if (targetClass != null && targetClass.isInterface()) {
            String message5 = RefactoringBundle.message((String)"cannot.replace.temp.with.query.in.interface");
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message5, (String)REFACTORING_NAME, (String)"refactoring.replaceTemp");
            return;
        }
        if (processor2.showDialog()) {
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                Runnable action = () -> {
                    try {
                        processor2.doRefactoring();
                        local.normalizeDeclaration();
                        PsiExpression initializer1 = local.getInitializer();
                        PsiExpression[] exprs = new PsiExpression[refs.length];
                        for (int idx = 0; idx < refs.length; ++idx) {
                            PsiElement ref = refs[idx].getElement();
                            exprs[idx] = (PsiExpression)ref.replace((PsiElement)initializer1);
                        }
                        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)local.getParent();
                        declaration2.delete();
                        highlightManager.addOccurrenceHighlights(editor, (PsiElement[])exprs, attributes, true, null);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                };
                PostprocessReformattingAspect.getInstance(project2).postponeFormattingInside(() -> {
                    ApplicationManager.getApplication().runWriteAction(action);
                    DuplicatesImpl.processDuplicates(processor2, project2, editor);
                });
            }, REFACTORING_NAME, null);
        }
        WindowManager.getInstance().getStatusBar(project2).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            TempWithQueryHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            TempWithQueryHandler.$$$reportNull$$$0(2);
        }
        if (elements.length == 1 && elements[0] instanceof PsiLocalVariable && dataContext != null) {
            PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (file2 != null && editor != null) {
                TempWithQueryHandler.invokeOnVariable(file2, project2, (PsiLocalVariable)elements[0], editor);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/tempWithQuery/TempWithQueryHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

