/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeCook;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.typeCook.Settings;
import com.intellij.refactoring.typeCook.TypeCookProcessor;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TypeCookDialog
extends RefactoringDialog {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"generify.title");
    private final PsiElement[] myElements;
    private final JLabel myClassNameLabel = new JLabel();
    private final JCheckBox myCbDropCasts = new JCheckBox();
    private final JCheckBox myCbPreserveRawArrays = new JCheckBox();
    private final JCheckBox myCbLeaveObjectParameterizedTypesRaw = new JCheckBox();
    private final JCheckBox myCbExhaustive = new JCheckBox();
    private final JCheckBox myCbCookObjects = new JCheckBox();
    private final JCheckBox myCbCookToWildcards = new JCheckBox();

    public TypeCookDialog(Project project2, PsiElement[] elements) {
        super(project2, true);
        this.setTitle(REFACTORING_NAME);
        this.init();
        StringBuffer name2 = new StringBuffer();
        this.myElements = elements;
        for (int i = 0; i < elements.length; ++i) {
            PsiElement element = elements[i];
            name2.append(StringUtil.capitalize((String)UsageViewUtil.getType(element)));
            name2.append(" ");
            name2.append(DescriptiveNameUtil.getDescriptiveName((PsiElement)element));
            if (i >= elements.length - 1) continue;
            name2.append("<br>");
        }
        this.myClassNameLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)name2));
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.generify");
    }

    protected JComponent createNorthPanel() {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        if (this.myCbDropCasts.isEnabled()) {
            this.myCbDropCasts.setSelected(JavaRefactoringSettings.getInstance().TYPE_COOK_DROP_CASTS);
        }
        if (this.myCbPreserveRawArrays.isEnabled()) {
            this.myCbPreserveRawArrays.setSelected(JavaRefactoringSettings.getInstance().TYPE_COOK_PRESERVE_RAW_ARRAYS);
        }
        if (this.myCbLeaveObjectParameterizedTypesRaw.isEnabled()) {
            this.myCbLeaveObjectParameterizedTypesRaw.setSelected(JavaRefactoringSettings.getInstance().TYPE_COOK_LEAVE_OBJECT_PARAMETERIZED_TYPES_RAW);
        }
        if (this.myCbExhaustive.isEnabled()) {
            this.myCbExhaustive.setSelected(JavaRefactoringSettings.getInstance().TYPE_COOK_EXHAUSTIVE);
        }
        if (this.myCbCookObjects.isEnabled()) {
            this.myCbCookObjects.setSelected(JavaRefactoringSettings.getInstance().TYPE_COOK_COOK_OBJECTS);
        }
        if (this.myCbCookToWildcards.isEnabled()) {
            this.myCbCookToWildcards.setSelected(JavaRefactoringSettings.getInstance().TYPE_COOK_PRODUCE_WILDCARDS);
        }
        this.myCbDropCasts.setText(RefactoringBundle.message((String)"type.cook.drop.obsolete.casts"));
        this.myCbPreserveRawArrays.setText(RefactoringBundle.message((String)"type.cook.preserve.raw.arrays"));
        this.myCbLeaveObjectParameterizedTypesRaw.setText(RefactoringBundle.message((String)"type.cook.leave.object.parameterized.types.raw"));
        this.myCbExhaustive.setText(RefactoringBundle.message((String)"type.cook.perform.exhaustive.search"));
        this.myCbCookObjects.setText(RefactoringBundle.message((String)"type.cook.generify.objects"));
        this.myCbCookToWildcards.setText(RefactoringBundle.message((String)"type.cook.produce.wildcard.types"));
        gbConstraints.insets = JBUI.insets((int)4, (int)8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        optionsPanel.add((Component)this.myClassNameLabel, gbConstraints);
        gbConstraints.gridx = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridy = 1;
        gbConstraints.fill = 1;
        optionsPanel.add((Component)this.myCbDropCasts, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        optionsPanel.add((Component)this.myCbPreserveRawArrays, gbConstraints);
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 2;
        gbConstraints.gridy = 2;
        optionsPanel.add((Component)this.myCbLeaveObjectParameterizedTypesRaw, gbConstraints);
        ++gbConstraints.gridy;
        optionsPanel.add((Component)this.myCbExhaustive, gbConstraints);
        ++gbConstraints.gridy;
        optionsPanel.add((Component)this.myCbCookObjects, gbConstraints);
        ++gbConstraints.gridy;
        optionsPanel.add((Component)this.myCbCookToWildcards, gbConstraints);
        return optionsPanel;
    }

    @Override
    protected void doAction() {
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        settings.TYPE_COOK_DROP_CASTS = this.myCbDropCasts.isSelected();
        settings.TYPE_COOK_PRESERVE_RAW_ARRAYS = this.myCbPreserveRawArrays.isSelected();
        settings.TYPE_COOK_LEAVE_OBJECT_PARAMETERIZED_TYPES_RAW = this.myCbLeaveObjectParameterizedTypesRaw.isSelected();
        settings.TYPE_COOK_EXHAUSTIVE = this.myCbExhaustive.isSelected();
        settings.TYPE_COOK_COOK_OBJECTS = this.myCbCookObjects.isSelected();
        settings.TYPE_COOK_PRODUCE_WILDCARDS = this.myCbCookToWildcards.isSelected();
        this.invokeRefactoring(new TypeCookProcessor(this.getProject(), this.myElements, this.getSettings()));
    }

    public Settings getSettings() {
        final boolean dropCasts = this.myCbDropCasts.isSelected();
        boolean preserveRawArrays = true;
        final boolean leaveObjectParameterizedTypesRaw = this.myCbLeaveObjectParameterizedTypesRaw.isSelected();
        final boolean exhaustive = this.myCbExhaustive.isSelected();
        final boolean cookObjects = this.myCbCookObjects.isSelected();
        final boolean cookToWildcards = this.myCbCookToWildcards.isSelected();
        return new Settings(){

            @Override
            public boolean dropObsoleteCasts() {
                return dropCasts;
            }

            @Override
            public boolean preserveRawArrays() {
                return true;
            }

            @Override
            public boolean leaveObjectParameterizedTypesRaw() {
                return leaveObjectParameterizedTypesRaw;
            }

            @Override
            public boolean exhaustive() {
                return exhaustive;
            }

            @Override
            public boolean cookObjects() {
                return cookObjects;
            }

            @Override
            public boolean cookToWildcards() {
                return cookToWildcards;
            }
        };
    }
}

