/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.rules.guava.FluentIterableConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaPredicatesUtil {
    private static final Logger LOG = Logger.getInstance(GuavaPredicatesUtil.class);
    static final Set<String> PREDICATES_AND_OR = ContainerUtil.newHashSet((Object[])new String[]{"or", "and"});
    static final String PREDICATES_NOT = "not";
    public static final Set<String> PREDICATES_METHOD_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"alwaysTrue", "alwaysFalse", "isNull", "notNull", "equalTo", "not", "or", "and"});

    @Nullable
    static TypeConversionDescriptorBase tryConvertIfPredicates(PsiMethod method, PsiExpression context) {
        String name2 = method.getName();
        if (name2.equals("alwaysTrue") || name2.equals("alwaysFalse")) {
            return GuavaPredicatesUtil.createConstantPredicate(name2, name2.contains("True"));
        }
        if (name2.equals("isNull") || name2.equals("notNull")) {
            String operation = name2.equals("isNull") ? "==" : "!=";
            return new TypeConversionDescriptorWithLocalVariable(name2, "$x$ -> $x$" + operation + " null");
        }
        if (name2.equals("equalTo")) {
            return new TypeConversionDescriptorWithLocalVariable("equalTo", "$x$ -> java.util.Objects.equals($x$, $v$)");
        }
        if (!GuavaPredicatesUtil.isConvertablePredicatesMethod(method, (PsiMethodCallExpression)context)) {
            return null;
        }
        if (((PsiMethodCallExpression)context).getArgumentList().getExpressions().length == 0) {
            return GuavaPredicatesUtil.createConstantPredicate(name2, name2.equals("and"));
        }
        if (PREDICATES_AND_OR.contains(name2) && GuavaPredicatesUtil.canMigrateAndOrOr((PsiMethodCallExpression)context)) {
            return new AndOrOrConversionDescriptor(GuavaConversionUtil.addTypeParameters(GuavaLambda.PREDICATE.getJavaAnalogueClassQName(), context.getType(), (PsiElement)context));
        }
        if (PREDICATES_NOT.equals(name2)) {
            return new NotConversionDescriptor(GuavaConversionUtil.addTypeParameters(GuavaLambda.PREDICATE.getJavaAnalogueClassQName(), context.getType(), (PsiElement)context));
        }
        return null;
    }

    @NotNull
    private static TypeConversionDescriptorWithLocalVariable createConstantPredicate(String methodName, boolean value2) {
        TypeConversionDescriptorWithLocalVariable typeConversionDescriptorWithLocalVariable = new TypeConversionDescriptorWithLocalVariable(methodName, "$x$ -> " + value2);
        if (typeConversionDescriptorWithLocalVariable == null) {
            GuavaPredicatesUtil.$$$reportNull$$$0(0);
        }
        return typeConversionDescriptorWithLocalVariable;
    }

    public static boolean isConvertablePredicatesMethod(@NotNull PsiMethod method, PsiMethodCallExpression context) {
        PsiParameter parameter2;
        PsiClass psiClass;
        if (method == null) {
            GuavaPredicatesUtil.$$$reportNull$$$0(1);
        }
        if (method.getParameterList().getParametersCount() == 1 && ((psiClass = PsiTypesUtil.getPsiClass((PsiType)(parameter2 = method.getParameterList().getParameters()[0]).getType().getDeepComponentType())) == null || "java.lang.Iterable".equals(psiClass.getQualifiedName()))) {
            return false;
        }
        PsiExpression[] expressions2 = context.getArgumentList().getExpressions();
        return expressions2.length != 1 || !(expressions2[0].getType() instanceof PsiArrayType);
    }

    private static boolean canMigrateAndOrOr(PsiMethodCallExpression expr) {
        PsiMethod method = expr.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiParameterList parameters2 = method.getParameterList();
        if (parameters2.getParametersCount() != 1) {
            return parameters2.getParametersCount() != 0;
        }
        PsiParameter parameter2 = parameters2.getParameters()[0];
        PsiType type2 = parameter2.getType();
        return type2 instanceof PsiEllipsisType;
    }

    private static PsiExpression replaceTypeCast(PsiExpression expression2, PsiElement parent) {
        PsiType type2;
        PsiClass aClass;
        PsiTypeElement typeElement;
        PsiElement parParent = parent.getParent();
        if (parParent instanceof PsiTypeCastExpression && (typeElement = ((PsiTypeCastExpression)parParent).getCastType()) != null && (aClass = PsiTypesUtil.getPsiClass((PsiType)(type2 = typeElement.getType()))) != null && GuavaLambda.PREDICATE.getClassQName().equals(aClass.getQualifiedName())) {
            expression2 = (PsiExpression)parParent.replace((PsiElement)expression2);
        }
        return expression2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicatesUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstantPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicatesUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isConvertablePredicatesMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AndOrOrConversionDescriptor
    extends TypeConversionDescriptorBase {
        private final PsiType myTargetType;

        public AndOrOrConversionDescriptor(PsiType targetType) {
            this.myTargetType = targetType;
        }

        @Override
        public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
            if (evaluator == null) {
                AndOrOrConversionDescriptor.$$$reportNull$$$0(0);
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression2;
            String methodName = methodCall.getMethodExpression().getReferenceName();
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
            if (arguments.length == 1) {
                return (PsiExpression)expression2.replace((PsiElement)GuavaConversionUtil.adjustLambdaContainingExpression(arguments[0], true, this.myTargetType, evaluator));
            }
            LOG.assertTrue(arguments.length != 0);
            StringBuilder replaceBy = new StringBuilder();
            for (int i = 1; i < arguments.length; ++i) {
                PsiExpression argument = arguments[i];
                replaceBy.append(".").append(methodName).append("(").append(GuavaConversionUtil.adjustLambdaContainingExpression(argument, false, this.myTargetType, evaluator).getText()).append(")");
            }
            replaceBy.insert(0, GuavaConversionUtil.adjustLambdaContainingExpression(arguments[0], true, this.myTargetType, evaluator).getText());
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiMethodReferenceExpression) {
                expression2 = GuavaPredicatesUtil.replaceTypeCast(expression2, parent);
            } else if (!GuavaConversionUtil.isJavaLambda(parent, evaluator)) {
                replaceBy.append("::test");
            }
            return (PsiExpression)expression2.replace((PsiElement)elementFactory.createExpressionFromText(replaceBy.toString(), (PsiElement)expression2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicatesUtil$AndOrOrConversionDescriptor", "replace"));
        }
    }

    private static class NotConversionDescriptor
    extends TypeConversionDescriptorBase {
        private final PsiType myTargetType;

        public NotConversionDescriptor(PsiType targetType) {
            this.myTargetType = targetType;
        }

        @Override
        public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
            if (evaluator == null) {
                NotConversionDescriptor.$$$reportNull$$$0(0);
            }
            String newExpressionString = GuavaConversionUtil.adjustLambdaContainingExpression(((PsiMethodCallExpression)expression2).getArgumentList().getExpressions()[0], true, this.myTargetType, evaluator).getText() + ".negate()";
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiMethodReferenceExpression) {
                expression2 = GuavaPredicatesUtil.replaceTypeCast(expression2, parent);
            } else if (!GuavaConversionUtil.isJavaLambda(parent, evaluator)) {
                newExpressionString = newExpressionString + "::test";
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
            PsiExpression convertedExpression = (PsiExpression)expression2.replace((PsiElement)elementFactory.createExpressionFromText(newExpressionString, (PsiElement)expression2));
            convertedExpression = convertedExpression.getParent() instanceof PsiMethodReferenceExpression ? (PsiExpression)convertedExpression.getParent().replace((PsiElement)convertedExpression) : convertedExpression;
            PsiElement maybeTypeCast = convertedExpression.getParent();
            if (maybeTypeCast instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)maybeTypeCast))) {
                convertedExpression = (PsiExpression)maybeTypeCast.replace((PsiElement)((PsiTypeCastExpression)maybeTypeCast).getOperand());
            }
            return convertedExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicatesUtil$NotConversionDescriptor", "replace"));
        }
    }

    private static class TypeConversionDescriptorWithLocalVariable
    extends TypeConversionDescriptor {
        private final String myReplaceByStringTemplate;

        TypeConversionDescriptorWithLocalVariable(String methodName, String replaceByString) {
            super("'Predicates*." + methodName + "(" + (methodName.equals("equalTo") ? "$v$" : "") + ")", null);
            this.myReplaceByStringTemplate = replaceByString;
        }

        @Override
        public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) {
            if (evaluator == null) {
                TypeConversionDescriptorWithLocalVariable.$$$reportNull$$$0(0);
            }
            String chosenName = FluentIterableConversionUtil.chooseName(expression2, TypeConversionDescriptorWithLocalVariable.getIntroducedVariableType(expression2));
            this.setReplaceByString(StringUtil.replace((String)this.myReplaceByStringTemplate, (String)"$x$", (String)chosenName));
            return super.replace(expression2, evaluator);
        }

        private static PsiType getIntroducedVariableType(PsiExpression expression2) {
            PsiType parameter2;
            PsiType[] parameters2;
            PsiType type2 = expression2.getType();
            if (type2 instanceof PsiClassType && (parameters2 = ((PsiClassType)type2).getParameters()).length == 1 && (parameter2 = parameters2[0]) instanceof PsiClassType) {
                return parameter2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicatesUtil$TypeConversionDescriptorWithLocalVariable", "replace"));
        }
    }
}

