/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebDeploymentCredentialsHolder {
    private static final String SFTP_DEPLOYMENT_PREFIX = "sftp://";
    public static final String WEB_SERVER_CREDENTIALS_ID = "WEB_SERVER_CREDENTIALS_ID";
    public static final String WEB_SERVER_CONFIG_ID = "WEB_SERVER_CONFIG_ID";
    public static final String WEB_SERVER_CONFIG_NAME = "WEB_SERVER_CONFIG_NAME";
    private String myCredentialsId;
    private String myWebServerConfigId;
    private String myWebServerConfigName;

    public WebDeploymentCredentialsHolder() {
    }

    public WebDeploymentCredentialsHolder(@NotNull String webServerConfigId, String name2, @NotNull RemoteCredentials remoteCredentials) {
        if (webServerConfigId == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(0);
        }
        if (remoteCredentials == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(1);
        }
        this.myWebServerConfigId = webServerConfigId;
        this.myWebServerConfigName = name2;
        this.myCredentialsId = WebDeploymentCredentialsHolder.constructSftpCredentialsFullPath(remoteCredentials);
    }

    public String getCredentialsId() {
        return this.myCredentialsId;
    }

    @Nullable
    public String getWebServerConfigId() {
        return this.myWebServerConfigId;
    }

    public void setWebServerConfigId(@NotNull String webServerConfigId) {
        if (webServerConfigId == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(2);
        }
        this.myWebServerConfigId = webServerConfigId;
    }

    public String getWebServerConfigName() {
        return this.myWebServerConfigName;
    }

    public void setWebServerConfigName(@NotNull String name2) {
        if (name2 == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(3);
        }
        this.myWebServerConfigName = name2;
    }

    public void load(Element element) {
        this.setWebServerConfigId(element.getAttributeValue(WEB_SERVER_CONFIG_ID));
        this.setWebServerConfigName(StringUtil.notNullize((String)element.getAttributeValue(WEB_SERVER_CONFIG_NAME)));
        this.myCredentialsId = StringUtil.notNullize((String)element.getAttributeValue(WEB_SERVER_CREDENTIALS_ID));
        if (StringUtil.isEmpty((String)this.myCredentialsId)) {
            RemoteCredentialsHolder credentials = new RemoteCredentialsHolder();
            credentials.load(element);
            this.myCredentialsId = WebDeploymentCredentialsHolder.constructSftpCredentialsFullPath(credentials);
        }
    }

    public void save(Element element) {
        element.setAttribute(WEB_SERVER_CONFIG_ID, this.getWebServerConfigId());
        element.setAttribute(WEB_SERVER_CONFIG_NAME, this.getWebServerConfigName());
        element.setAttribute(WEB_SERVER_CREDENTIALS_ID, StringUtil.notNullize((String)this.getCredentialsId()));
    }

    @NotNull
    public WebDeploymentCredentialsHolder copyFrom(@NotNull WebDeploymentCredentialsHolder holder) {
        if (holder == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(4);
        }
        this.setWebServerConfigId(holder.getWebServerConfigId());
        this.setWebServerConfigName(holder.getWebServerConfigName());
        this.myCredentialsId = holder.getCredentialsId();
        WebDeploymentCredentialsHolder webDeploymentCredentialsHolder = this;
        if (webDeploymentCredentialsHolder == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(5);
        }
        return webDeploymentCredentialsHolder;
    }

    @NotNull
    private static String constructSftpCredentialsFullPath(@NotNull RemoteCredentials cred) {
        if (cred == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(6);
        }
        String string = SFTP_DEPLOYMENT_PREFIX + cred.getUserName() + "@" + cred.getHost() + ":" + cred.getLiteralPort();
        if (string == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebDeploymentCredentialsHolder holder = (WebDeploymentCredentialsHolder)o;
        return this.myWebServerConfigId.equals(holder.myWebServerConfigId);
    }

    public int hashCode() {
        return this.myWebServerConfigId.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webServerConfigId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteCredentials";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/WebDeploymentCredentialsHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cred";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/WebDeploymentCredentialsHolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFrom";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "constructSftpCredentialsFullPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setWebServerConfigId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setWebServerConfigName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "constructSftpCredentialsFullPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

