/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployToServerConfigurationType
extends ConfigurationTypeBase {
    private final ServerType<?> myServerType;
    private final MultiSourcesConfigurationFactory myMultiSourcesFactory;
    private final Map<SingletonDeploymentSourceType, SingletonTypeConfigurationFactory> myPerTypeFactories;

    public DeployToServerConfigurationType(@NotNull ServerType<?> serverType) {
        if (serverType == null) {
            DeployToServerConfigurationType.$$$reportNull$$$0(0);
        }
        super(serverType.getId() + "-deploy", serverType.getDeploymentConfigurationTypePresentableName(), "Deploy to " + serverType.getPresentableName() + " run configuration", serverType.getIcon());
        this.myPerTypeFactories = new HashMap<SingletonDeploymentSourceType, SingletonTypeConfigurationFactory>();
        this.myServerType = serverType;
        if (this.myServerType.mayHaveProjectSpecificDeploymentSources()) {
            this.myMultiSourcesFactory = new MultiSourcesConfigurationFactory();
            this.addFactory(this.myMultiSourcesFactory);
        } else {
            this.myMultiSourcesFactory = null;
        }
        for (SingletonDeploymentSourceType next : serverType.getSingletonDeploymentSourceTypes()) {
            SingletonTypeConfigurationFactory nextFactory = new SingletonTypeConfigurationFactory(next);
            this.addFactory(nextFactory);
            this.myPerTypeFactories.put(next, nextFactory);
        }
    }

    @NotNull
    public ConfigurationFactoryEx getFactoryForType(@Nullable DeploymentSourceType<?> sourceType) {
        ConfigurationFactoryEx result2 = null;
        if (sourceType instanceof SingletonDeploymentSourceType && this.myServerType.getSingletonDeploymentSourceTypes().contains(sourceType)) {
            result2 = this.myPerTypeFactories.get(sourceType);
        }
        if (result2 == null) {
            result2 = this.myMultiSourcesFactory;
        }
        assert (result2 != null) : "server type: " + this.myServerType + ", requested source type: " + sourceType;
        MultiSourcesConfigurationFactory multiSourcesConfigurationFactory = result2;
        if (multiSourcesConfigurationFactory == null) {
            DeployToServerConfigurationType.$$$reportNull$$$0(1);
        }
        return multiSourcesConfigurationFactory;
    }

    @Deprecated
    public ConfigurationFactoryEx getFactory() {
        return this.getFactoryForType(null);
    }

    @NotNull
    public ServerType<?> getServerType() {
        ServerType<?> serverType = this.myServerType;
        if (serverType == null) {
            DeployToServerConfigurationType.$$$reportNull$$$0(2);
        }
        return serverType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryForType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class SingletonTypeConfigurationFactory
    extends DeployToServerConfigurationFactory {
        private final SingletonDeploymentSourceType mySourceType;

        public SingletonTypeConfigurationFactory(SingletonDeploymentSourceType sourceType) {
            if (sourceType == null) {
                SingletonTypeConfigurationFactory.$$$reportNull$$$0(0);
            }
            this.mySourceType = sourceType;
        }

        public String getId() {
            return this.mySourceType.getId();
        }

        @Nls
        public String getName() {
            return this.mySourceType.getPresentableName();
        }

        @Override
        @NotNull
        public DeployToServerRunConfiguration createTemplateConfiguration(@NotNull Project project2) {
            if (project2 == null) {
                SingletonTypeConfigurationFactory.$$$reportNull$$$0(1);
            }
            DeployToServerRunConfiguration result2 = super.createTemplateConfiguration(project2);
            result2.lockDeploymentSource(this.mySourceType);
            DeployToServerRunConfiguration deployToServerRunConfiguration = result2;
            if (deployToServerRunConfiguration == null) {
                SingletonTypeConfigurationFactory.$$$reportNull$$$0(2);
            }
            return deployToServerRunConfiguration;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType$SingletonTypeConfigurationFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType$SingletonTypeConfigurationFactory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemplateConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemplateConfiguration";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class MultiSourcesConfigurationFactory
    extends DeployToServerConfigurationFactory {
        public String getId() {
            return DeployToServerConfigurationType.this.getDisplayName();
        }
    }

    public class DeployToServerConfigurationFactory
    extends ConfigurationFactoryEx {
        public DeployToServerConfigurationFactory() {
            super((ConfigurationType)DeployToServerConfigurationType.this);
        }

        public boolean isApplicable(@NotNull Project project2) {
            if (project2 == null) {
                DeployToServerConfigurationFactory.$$$reportNull$$$0(0);
            }
            return DeployToServerConfigurationType.this.myServerType.canAutoDetectConfiguration() || !RemoteServersManager.getInstance().getServers(DeployToServerConfigurationType.this.myServerType).isEmpty();
        }

        public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
            RemoteServer server;
            DeployToServerRunConfiguration deployConfiguration;
            if (configuration == null) {
                DeployToServerConfigurationFactory.$$$reportNull$$$0(1);
            }
            if ((deployConfiguration = (DeployToServerRunConfiguration)configuration).getServerName() == null && (server = (RemoteServer)ContainerUtil.getFirstItem((List)RemoteServersManager.getInstance().getServers(DeployToServerConfigurationType.this.myServerType))) != null) {
                deployConfiguration.setServerName(server.getName());
            }
            if (deployConfiguration.getDeploymentSource() == null) {
                this.setupDeploymentSource(configuration, deployConfiguration);
            }
        }

        private <S extends ServerConfiguration, D extends DeploymentConfiguration> void setupDeploymentSource(@NotNull RunConfiguration configuration, @NotNull DeployToServerRunConfiguration<S, D> deployConfiguration) {
            DeploymentConfigurator<D, S> deploymentConfigurator;
            List sources;
            DeploymentSource source;
            if (configuration == null) {
                DeployToServerConfigurationFactory.$$$reportNull$$$0(2);
            }
            if (deployConfiguration == null) {
                DeployToServerConfigurationFactory.$$$reportNull$$$0(3);
            }
            if ((source = (DeploymentSource)ContainerUtil.getFirstItem((List)(sources = (deploymentConfigurator = deployConfiguration.getDeploymentConfigurator()).getAvailableDeploymentSources()))) != null) {
                deployConfiguration.setDeploymentSource(source);
                deployConfiguration.setDeploymentConfiguration(deploymentConfigurator.createDefaultConfiguration(source));
                DeploymentSourceType type2 = source.getType();
                type2.setBuildBeforeRunTask(configuration, source);
            }
        }

        @NotNull
        public DeployToServerRunConfiguration createTemplateConfiguration(@NotNull Project project2) {
            if (project2 == null) {
                DeployToServerConfigurationFactory.$$$reportNull$$$0(4);
            }
            DeploymentConfigurator deploymentConfigurator = DeployToServerConfigurationType.this.myServerType.createDeploymentConfigurator(project2);
            DeployToServerRunConfiguration deployToServerRunConfiguration = new DeployToServerRunConfiguration(project2, this, "", DeployToServerConfigurationType.this.myServerType, deploymentConfigurator);
            if (deployToServerRunConfiguration == null) {
                DeployToServerConfigurationFactory.$$$reportNull$$$0(5);
            }
            return deployToServerRunConfiguration;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deployConfiguration";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType$DeployToServerConfigurationFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType$DeployToServerConfigurationFactory";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemplateConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "onNewConfigurationCreated";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setupDeploymentSource";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemplateConfiguration";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

