/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.util.CloudDeploymentRuntimeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CloudDeploymentConfiguratorBase<D extends DeploymentConfiguration, S extends ServerConfiguration>
extends DeploymentConfigurator<D, S> {
    private final Project myProject;
    private ServerType<S> myServerType;

    public CloudDeploymentConfiguratorBase(Project project2, ServerType<S> serverType) {
        this.myProject = project2;
        this.myServerType = serverType;
    }

    public static List<CloudDeploymentRuntimeProvider> getDeploymentRuntimeProviders(ServerType<?> serverType) {
        ArrayList<CloudDeploymentRuntimeProvider> result2 = new ArrayList<CloudDeploymentRuntimeProvider>();
        for (CloudDeploymentRuntimeProvider provider : (CloudDeploymentRuntimeProvider[])CloudDeploymentRuntimeProvider.EP_NAME.getExtensions()) {
            ServerType<?> providerServerType = provider.getServerType();
            if (providerServerType != null && providerServerType != serverType) continue;
            result2.add(provider);
        }
        return result2;
    }

    @NotNull
    public List<DeploymentSource> getAvailableDeploymentSources() {
        if (this.myProject.isDefault()) {
            List<DeploymentSource> list2 = Collections.emptyList();
            if (list2 == null) {
                CloudDeploymentConfiguratorBase.$$$reportNull$$$0(0);
            }
            return list2;
        }
        ArrayList<DeploymentSource> result2 = new ArrayList<DeploymentSource>();
        for (CloudDeploymentRuntimeProvider provider : CloudDeploymentConfiguratorBase.getDeploymentRuntimeProviders(this.myServerType)) {
            result2.addAll(provider.getDeploymentSources(this.myProject));
        }
        ArrayList<DeploymentSource> arrayList = result2;
        if (arrayList == null) {
            CloudDeploymentConfiguratorBase.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/CloudDeploymentConfiguratorBase", "getAvailableDeploymentSources"));
    }
}

