/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.filters.TagValueFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;

public class XmlCompilingVisitor
extends XmlRecursiveElementVisitor {
    private final GlobalCompilingVisitor myCompilingVisitor;

    public XmlCompilingVisitor(GlobalCompilingVisitor compilingVisitor) {
        this.myCompilingVisitor = compilingVisitor;
    }

    public void compile(PsiElement[] topLevelElements) {
        for (PsiElement element : topLevelElements) {
            element.accept((PsiElementVisitor)this);
            MatchingHandler matchingHandler = this.myCompilingVisitor.getContext().getPattern().getHandler(element);
            this.myCompilingVisitor.getContext().getPattern().setHandler(element, new TopLevelMatchingHandler(matchingHandler));
        }
    }

    public void visitElement(PsiElement element) {
        this.myCompilingVisitor.handle(element);
        super.visitElement(element);
    }

    public void visitXmlToken(XmlToken token) {
    }

    public void visitXmlText(XmlText text2) {
        super.visitXmlText(text2);
        MatchingHandler handler2 = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)text2);
        handler2.setFilter(TagValueFilter.getInstance());
    }
}

