/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptLog;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.jetbrains.annotations.NotNull;

public class ScriptSupport {
    private final Script script;
    private final ScriptLog myScriptLog;
    private final String myName;

    public ScriptSupport(Project project2, String text2, String name2) {
        this.myScriptLog = new ScriptLog(project2);
        this.myName = name2;
        File scriptFile = new File(text2);
        GroovyShell shell = new GroovyShell();
        try {
            this.script = scriptFile.exists() ? shell.parse(scriptFile) : shell.parse(text2, name2 + "_script.groovy");
        }
        catch (Exception ex) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private static Map<String, Object> buildVariableMap(@NotNull MatchResult result2, @NotNull Map<String, Object> out) {
        String name2;
        if (result2 == null) {
            ScriptSupport.$$$reportNull$$$0(0);
        }
        if (out == null) {
            ScriptSupport.$$$reportNull$$$0(1);
        }
        if ((name2 = result2.getName()) != null && !result2.isMultipleMatch()) {
            ArrayList<PsiElement> list2;
            Object value2 = out.get(name2);
            PsiElement match = StructuralSearchUtil.getPresentableElement(result2.getMatch());
            if (value2 == null) {
                out.put(name2, match);
            } else if (value2 instanceof List) {
                list2 = (ArrayList<PsiElement>)value2;
                list2.add(match);
            } else if (value2 instanceof PsiElement) {
                list2 = new ArrayList<PsiElement>();
                list2.add((PsiElement)value2);
                list2.add(match);
                out.put(name2, list2);
            } else {
                throw new AssertionError();
            }
        }
        if (result2.hasSons()) {
            for (MatchResult son : result2.getAllSons()) {
                ScriptSupport.buildVariableMap(son, out);
            }
        }
        return out;
    }

    public String evaluate(MatchResult result2, PsiElement context) {
        try {
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            variableMap.put("__log__", this.myScriptLog);
            if (result2 != null) {
                ScriptSupport.buildVariableMap(result2, variableMap);
                if (context == null) {
                    context = result2.getMatch();
                }
            }
            context = StructuralSearchUtil.getPresentableElement(context);
            variableMap.put(this.myName, context);
            variableMap.put("__context__", context);
            this.script.setBinding(new Binding(variableMap));
            Object o = this.script.run();
            String string = String.valueOf(o);
            return string;
        }
        catch (GroovyRuntimeException ex) {
            throw new StructuralSearchException(SSRBundle.message("groovy.script.error", ex.getMessage()));
        }
        finally {
            this.script.setBinding(null);
        }
    }

    public static String checkValidScript(String scriptText) {
        try {
            File scriptFile = new File(scriptText);
            GroovyShell shell = new GroovyShell();
            Script script = scriptFile.exists() ? shell.parse(scriptFile) : shell.parse(scriptText);
            return null;
        }
        catch (IOException e) {
            return e.getMessage();
        }
        catch (MultipleCompilationErrorsException e) {
            ErrorCollector errorCollector = e.getErrorCollector();
            List errors = errorCollector.getErrors();
            for (Message error : errors) {
                if (!(error instanceof SyntaxErrorMessage)) continue;
                SyntaxErrorMessage errorMessage = (SyntaxErrorMessage)error;
                SyntaxException cause = errorMessage.getCause();
                return cause.getMessage();
            }
            return e.getMessage();
        }
        catch (CompilationFailedException ex) {
            return ex.getLocalizedMessage();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "out";
                break;
            }
        }
        objectArray[1] = "com/intellij/structuralsearch/impl/matcher/predicates/ScriptSupport";
        objectArray[2] = "buildVariableMap";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

