/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vcs.BranchChangeListener;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.tasks.context.ConfigureBranchContextDialog;
import com.intellij.tasks.context.WorkingContextManager;
import org.jetbrains.annotations.NotNull;

public class BranchContextTracker
implements BranchChangeListener {
    public static final NotificationGroup NOTIFICATION = new NotificationGroup("Branch Context group", NotificationDisplayType.BALLOON, true);
    private final WorkingContextManager myContextManager;
    private final Project myProject;
    private String myLastBranch;

    private BranchContextTracker(Project project2) {
        this.myProject = project2;
        this.myContextManager = WorkingContextManager.getInstance(project2);
        project2.getMessageBus().connect().subscribe(BranchChangeListener.VCS_BRANCH_CHANGED, (Object)this);
    }

    public void branchWillChange(@NotNull String branchName) {
        if (branchName == null) {
            BranchContextTracker.$$$reportNull$$$0(0);
        }
        this.myLastBranch = branchName;
        this.myContextManager.saveContext(BranchContextTracker.getContextName(branchName), null);
    }

    public void branchHasChanged(@NotNull String branchName) {
        if (branchName == null) {
            BranchContextTracker.$$$reportNull$$$0(1);
        }
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        if (!vcsConfiguration.RELOAD_CONTEXT) {
            return;
        }
        String contextName = BranchContextTracker.getContextName(branchName);
        if (!this.myContextManager.hasContext(contextName)) {
            return;
        }
        TransactionGuard.submitTransaction((Disposable)this.myProject, () -> {
            if (branchName == null) {
                BranchContextTracker.$$$reportNull$$$0(4);
            }
            this.switchContext(branchName, contextName);
        });
    }

    private void switchContext(@NotNull String branchName, String contextName) {
        if (branchName == null) {
            BranchContextTracker.$$$reportNull$$$0(2);
        }
        this.myContextManager.clearContext();
        this.myContextManager.loadContext(contextName);
        Notification notification = NOTIFICATION.createNotification("Workspace is restored to how it was in the \u2018" + branchName + "' branch", NotificationType.INFORMATION);
        if (this.myLastBranch != null && this.myContextManager.hasContext(BranchContextTracker.getContextName(this.myLastBranch))) {
            notification.addAction((AnAction)new NotificationAction("Rollback"){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    BranchContextTracker.this.myContextManager.clearContext();
                    BranchContextTracker.this.myContextManager.loadContext(BranchContextTracker.getContextName(BranchContextTracker.this.myLastBranch));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/tasks/context/BranchContextTracker$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        notification.addAction((AnAction)new NotificationAction("Configure..."){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    3.$$$reportNull$$$0(1);
                }
                new ConfigureBranchContextDialog(BranchContextTracker.this.myProject).show();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/tasks/context/BranchContextTracker$3";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).setContextHelpAction(new AnAction("What is a workspace?", "Workspace includes open editors, current run configuration, and breakpoints.", null){

            public void actionPerformed(AnActionEvent e) {
            }
        }).notify(this.myProject);
    }

    @NotNull
    private static String getContextName(String branchName) {
        String string = "__branch_context_" + branchName;
        if (string == null) {
            BranchContextTracker.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/context/BranchContextTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/context/BranchContextTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "branchWillChange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "branchHasChanged";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "switchContext";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$branchHasChanged$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TrackerStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project2) {
            if (project2 == null) {
                TrackerStartupActivity.$$$reportNull$$$0(0);
            }
            new BranchContextTracker(project2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/context/BranchContextTracker$TrackerStartupActivity", "runActivity"));
        }
    }
}

