/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.FileStructureTestFixture;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightFixtureTestCase;
import javax.swing.JTree;

public abstract class FileStructureTestBase
extends CodeInsightFixtureTestCase {
    protected FileStructureTestFixture myPopupFixture;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myPopupFixture = new FileStructureTestFixture(this.myFixture);
    }

    protected void configureDefault() {
        this.myFixture.configureByFile(this.getFileName(this.getFileExtension()));
    }

    protected abstract String getFileExtension();

    @Override
    public void tearDown() throws Exception {
        try {
            Disposer.dispose((Disposable)this.myPopupFixture);
            this.myPopupFixture = null;
        }
        finally {
            super.tearDown();
        }
    }

    private String getFileName(String ext) {
        return this.getTestName(false) + (StringUtil.isEmpty((String)ext) ? "" : "." + ext);
    }

    protected String getTreeFileName() {
        return this.getFileName("tree");
    }

    protected void checkTree(String filter2) {
        this.configureDefault();
        this.myPopupFixture.update();
        this.myPopupFixture.getPopup().setSearchFilterForTests(filter2);
        PlatformTestUtil.waitForPromise(this.myPopupFixture.getPopup().rebuildAndUpdate());
        this.myPopupFixture.getSpeedSearch().findAndSelectElement(filter2);
        this.checkResult();
    }

    protected void checkTree() {
        this.configureDefault();
        this.myPopupFixture.update();
        this.checkResult();
    }

    protected void checkResult() {
        FileStructureTestBase.assertSameLinesWithFile(this.getTestDataPath() + "/" + this.getTreeFileName(), PlatformTestUtil.print((JTree)this.myPopupFixture.getTree(), true).trim());
    }
}

