/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.ref.DebugReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeakHunter {
    public static void checkProjectLeak() throws Exception {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, project2 -> !project2.isDefault() && !project2.isLight());
    }

    public static void checkNonDefaultProjectLeak() throws Exception {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, project2 -> !project2.isDefault());
    }

    public static void checkLeak(@NotNull Object root, @NotNull Class<?> suspectClass) throws AssertionError {
        if (root == null) {
            LeakHunter.$$$reportNull$$$0(0);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(1);
        }
        LeakHunter.checkLeak(root, suspectClass, null);
    }

    public static <T> void checkLeak(@NotNull Collection<Object> roots, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak) throws AssertionError {
        if (roots == null) {
            LeakHunter.$$$reportNull$$$0(2);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(3);
        }
        LeakHunter.processLeaks(roots, suspectClass, isReallyLeak, (leaked, backLink) -> {
            String place = leaked instanceof Project ? PlatformTestCase.getCreationPlace((Project)leaked) : "";
            System.out.println("Found leaked " + leaked.getClass() + ": " + leaked + "; hash: " + System.identityHashCode(leaked) + "; place: " + place);
            System.out.println(backLink);
            System.out.println(";-----");
            throw new AssertionError();
        });
    }

    static <T> void processLeaks(@NotNull Collection<Object> roots, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak, @NotNull PairProcessor<? super T, Object> processor2) throws AssertionError {
        if (roots == null) {
            LeakHunter.$$$reportNull$$$0(4);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            LeakHunter.$$$reportNull$$$0(6);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
        PersistentEnumeratorBase.clearCacheForTests();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (roots == null) {
                LeakHunter.$$$reportNull$$$0(10);
            }
            if (suspectClass == null) {
                LeakHunter.$$$reportNull$$$0(11);
            }
            if (processor2 == null) {
                LeakHunter.$$$reportNull$$$0(12);
            }
            DebugReflectionUtil.walkObjects((int)10000, (Collection)roots, (Class)suspectClass, (Condition)Conditions.alwaysTrue(), (value2, backLink) -> {
                if (processor2 == null) {
                    LeakHunter.$$$reportNull$$$0(13);
                }
                Object leaked = value2;
                if (isReallyLeak == null || isReallyLeak.value(leaked)) {
                    return processor2.process(leaked, backLink);
                }
                return true;
            });
        });
    }

    public static <T> void checkLeak(@NotNull Object root, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak) throws AssertionError {
        if (root == null) {
            LeakHunter.$$$reportNull$$$0(7);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(8);
        }
        LeakHunter.checkLeak(Collections.singletonList(root), suspectClass, isReallyLeak);
    }

    @NotNull
    public static List<Object> allRoots() {
        ClassLoader classLoader = LeakHunter.class.getClassLoader();
        Vector allLoadedClasses = (Vector)ReflectionUtil.getField(classLoader.getClass(), (Object)classLoader, Vector.class, (String)"classes");
        List<Object> list2 = Arrays.asList(ApplicationManager.getApplication(), Disposer.getTree(), IdeEventQueue.getInstance(), LaterInvocator.getLaterInvocatorQueue(), ThreadTracker.getThreads(), allLoadedClasses);
        if (list2 == null) {
            LeakHunter.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspectClass";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LeakHunter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LeakHunter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "allRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkLeak";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processLeaks";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processLeaks$4";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

