/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.TokenWrapper;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.UsefulTestCase;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LexerTestCase
extends UsefulTestCase {
    protected void doTest(@NonNls String text2) {
        this.doTest(text2, null);
    }

    protected void doTest(@NonNls String text2, @Nullable String expected) {
        this.doTest(text2, expected, this.createLexer());
    }

    protected void doTest(@NonNls String text2, @Nullable String expected, @NotNull Lexer lexer) {
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(0);
        }
        String result2 = LexerTestCase.printTokens(text2, 0, lexer);
        if (expected != null) {
            LexerTestCase.assertSameLines(expected, result2);
        } else {
            LexerTestCase.assertSameLinesWithFile(this.getPathToTestDataFile(this.getExpectedFileExtension()), result2);
        }
    }

    @NotNull
    protected String getPathToTestDataFile(String extension) {
        String string = PathManager.getHomePath() + "/" + this.getDirPath() + "/" + this.getTestName(true) + extension;
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected String getExpectedFileExtension() {
        if (".txt" == null) {
            LexerTestCase.$$$reportNull$$$0(2);
        }
        return ".txt";
    }

    protected void checkZeroState(String text2, TokenSet tokenTypes) {
        IElementType type2;
        Lexer lexer = this.createLexer();
        lexer.start((CharSequence)text2);
        while ((type2 = lexer.getTokenType()) != null) {
            if (tokenTypes.contains(type2) && lexer.getState() != 0) {
                LexerTestCase.fail((String)("Non-zero lexer state on token \"" + lexer.getTokenText() + "\" (" + type2 + ") at " + lexer.getTokenStart()));
            }
            lexer.advance();
        }
    }

    protected void checkCorrectRestart(String text2) {
        IElementType type2;
        Lexer mainLexer = this.createLexer();
        String allTokens = LexerTestCase.printTokens(text2, 0, mainLexer);
        Lexer auxLexer = this.createLexer();
        auxLexer.start((CharSequence)text2);
        while ((type2 = auxLexer.getTokenType()) != null) {
            int tokenStart;
            String subTokens;
            if (auxLexer.getState() == 0 && !allTokens.endsWith(subTokens = LexerTestCase.printTokens(text2, tokenStart = auxLexer.getTokenStart(), mainLexer))) {
                LexerTestCase.assertEquals((String)("Restarting impossible from offset " + tokenStart + "; lexer state should not return 0 at this point"), (String)allTokens, (String)subTokens);
            }
            auxLexer.advance();
        }
    }

    protected String printTokens(String text2, int start) {
        return LexerTestCase.printTokens(text2, start, this.createLexer());
    }

    public static String printTokens(CharSequence text2, int start, Lexer lexer) {
        IElementType tokenType;
        lexer.start(text2, start, text2.length());
        StringBuilder result2 = new StringBuilder();
        while ((tokenType = lexer.getTokenType()) != null) {
            result2.append(LexerTestCase.printSingleToken(text2, tokenType, lexer.getTokenStart(), lexer.getTokenEnd()));
            lexer.advance();
        }
        return result2.toString();
    }

    @NotNull
    public static String printTokens(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            LexerTestCase.$$$reportNull$$$0(3);
        }
        CharSequence text2 = iterator.getDocument().getCharsSequence();
        StringBuilder result2 = new StringBuilder();
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            result2.append(LexerTestCase.printSingleToken(text2, tokenType, iterator.getStart(), iterator.getEnd()));
            iterator.advance();
        }
        String string = result2.toString();
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static String printSingleToken(CharSequence fileText, IElementType tokenType, int start, int end) {
        return tokenType + " ('" + LexerTestCase.getTokenText(tokenType, fileText, start, end) + "')\n";
    }

    protected void doFileTest(@NonNls String fileExt) {
        this.doTest(this.loadTestDataFile("." + fileExt));
    }

    @NotNull
    protected String loadTestDataFile(@NonNls String fileExt) {
        String fileName = this.getPathToTestDataFile(fileExt);
        String text2 = "";
        try {
            String fileText = FileUtil.loadFile((File)new File(fileName));
            text2 = StringUtil.convertLineSeparators((String)(this.shouldTrim() ? fileText.trim() : fileText));
        }
        catch (IOException e) {
            LexerTestCase.fail((String)("can't load file " + fileName + ": " + e.getMessage()));
        }
        String string = text2;
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected boolean shouldTrim() {
        return true;
    }

    @NotNull
    private static String getTokenText(IElementType tokenType, CharSequence sequence, int start, int end) {
        if (tokenType instanceof TokenWrapper) {
            String string = ((TokenWrapper)tokenType).getValue();
            if (string == null) {
                LexerTestCase.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = StringUtil.replace((String)sequence.subSequence(start, end).toString(), (String)"\n", (String)"\\n");
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected abstract Lexer createLexer();

    protected abstract String getDirPath();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToTestDataFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFileExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "printTokens";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTestDataFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "printTokens";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

