/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.DefaultASTFactoryImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockEditorFactory;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.mock.MockFileTypeManager;
import com.intellij.mock.MockLanguageFileType;
import com.intellij.mock.MockProjectEx;
import com.intellij.mock.MockPsiDocumentManager;
import com.intellij.mock.MockPsiManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.pom.PomModel;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistryImpl;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.MockSchemeManagerFactory;
import com.intellij.testFramework.PlatformLiteFixture;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AbstractComponentAdapter;

public abstract class ParsingTestCase
extends PlatformLiteFixture {
    protected String myFilePrefix;
    protected String myFileExt;
    protected final String myFullDataPath;
    protected PsiFile myFile;
    private MockPsiManager myPsiManager;
    private PsiFileFactoryImpl myFileFactory;
    protected Language myLanguage;
    private final ParserDefinition[] myDefinitions;
    private final boolean myLowercaseFirstLetter;

    protected ParsingTestCase(@NonNls @NotNull String dataPath, @NotNull String fileExt, ParserDefinition ... definitions) {
        if (dataPath == null) {
            ParsingTestCase.$$$reportNull$$$0(0);
        }
        if (fileExt == null) {
            ParsingTestCase.$$$reportNull$$$0(1);
        }
        if (definitions == null) {
            ParsingTestCase.$$$reportNull$$$0(2);
        }
        this(dataPath, fileExt, false, definitions);
    }

    protected ParsingTestCase(@NonNls @NotNull String dataPath, @NotNull String fileExt, boolean lowercaseFirstLetter, ParserDefinition ... definitions) {
        if (dataPath == null) {
            ParsingTestCase.$$$reportNull$$$0(3);
        }
        if (fileExt == null) {
            ParsingTestCase.$$$reportNull$$$0(4);
        }
        if (definitions == null) {
            ParsingTestCase.$$$reportNull$$$0(5);
        }
        this.myFilePrefix = "";
        this.myDefinitions = definitions;
        this.myFullDataPath = this.getTestDataPath() + "/" + dataPath;
        this.myFileExt = fileExt;
        this.myLowercaseFirstLetter = lowercaseFirstLetter;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.initApplication();
        ComponentAdapter component = ParsingTestCase.getApplication().getPicoContainer().getComponentAdapter((Object)ProgressManager.class.getName());
        if (component == null) {
            ParsingTestCase.getApplication().getPicoContainer().registerComponent((ComponentAdapter)new AbstractComponentAdapter(ProgressManager.class.getName(), Object.class){

                public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
                    return new ProgressManagerImpl();
                }

                public void verify(PicoContainer container) throws PicoIntrospectionException {
                }
            });
        }
        Extensions.registerAreaClass((String)"IDEA_PROJECT", null);
        this.myProject = new MockProjectEx(this.getTestRootDisposable());
        this.myPsiManager = new MockPsiManager(this.myProject);
        this.myFileFactory = new PsiFileFactoryImpl(this.myPsiManager);
        MutablePicoContainer appContainer = ParsingTestCase.getApplication().getPicoContainer();
        ParsingTestCase.registerComponentInstance(appContainer, MessageBus.class, ParsingTestCase.getApplication().getMessageBus());
        ParsingTestCase.registerComponentInstance(appContainer, SchemeManagerFactory.class, new MockSchemeManagerFactory());
        MockEditorFactory editorFactory = new MockEditorFactory();
        ParsingTestCase.registerComponentInstance(appContainer, EditorFactory.class, editorFactory);
        ParsingTestCase.registerComponentInstance(appContainer, FileDocumentManager.class, new MockFileDocumentManagerImpl((Function<CharSequence, Document>)((Function)charSequence -> editorFactory.createDocument((CharSequence)charSequence)), FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY));
        ParsingTestCase.registerComponentInstance(appContainer, PsiDocumentManager.class, new MockPsiDocumentManager());
        this.registerApplicationService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.registerApplicationService(DefaultASTFactory.class, new DefaultASTFactoryImpl());
        this.registerApplicationService(ReferenceProvidersRegistry.class, new ReferenceProvidersRegistryImpl());
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl(this.myProject, new PsiCachedValuesFactory(this.myPsiManager)));
        this.myProject.registerService(PsiManager.class, this.myPsiManager);
        this.myProject.registerService(StartupManager.class, new StartupManagerImpl(this.myProject));
        this.registerExtensionPoint(FileTypeFactory.FILE_TYPE_FACTORY_EP, FileTypeFactory.class);
        this.registerExtensionPoint(MetaLanguage.EP_NAME, MetaLanguage.class);
        for (ParserDefinition definition : this.myDefinitions) {
            this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, definition.getFileNodeType().getLanguage(), (Object)definition);
        }
        if (this.myDefinitions.length > 0) {
            this.configureFromParserDefinition(this.myDefinitions[0], this.myFileExt);
        }
        PomModelImpl pomModel = new PomModelImpl(this.myProject);
        this.myProject.registerService(PomModel.class, pomModel);
        new TreeAspect(pomModel);
    }

    public void configureFromParserDefinition(ParserDefinition definition, String extension) {
        this.myLanguage = definition.getFileNodeType().getLanguage();
        this.myFileExt = extension;
        this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, this.myLanguage, (Object)definition);
        ParsingTestCase.registerComponentInstance(ParsingTestCase.getApplication().getPicoContainer(), FileTypeManager.class, new MockFileTypeManager((FileType)new MockLanguageFileType(this.myLanguage, this.myFileExt)));
    }

    protected <T> void addExplicitExtension(final LanguageExtension<T> instance2, final Language language, final T object) {
        instance2.addExplicitExtension((Object)language, object);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                instance2.removeExplicitExtension((Object)language, object);
            }
        });
    }

    @Override
    protected <T> void registerExtensionPoint(final ExtensionPointName<T> extensionPointName, Class<T> aClass) {
        super.registerExtensionPoint(extensionPointName, aClass);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                Extensions.getRootArea().unregisterExtensionPoint(extensionPointName.getName());
            }
        });
    }

    protected <T> void registerApplicationService(final Class<T> aClass, T object) {
        ParsingTestCase.getApplication().registerService(aClass, object);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                PlatformLiteFixture.getApplication().getPicoContainer().unregisterComponent((Object)aClass.getName());
            }
        });
    }

    @NotNull
    public MockProjectEx getProject() {
        MockProjectEx mockProjectEx = this.myProject;
        if (mockProjectEx == null) {
            ParsingTestCase.$$$reportNull$$$0(6);
        }
        return mockProjectEx;
    }

    public MockPsiManager getPsiManager() {
        return this.myPsiManager;
    }

    @Override
    protected void tearDown() throws Exception {
        this.myFile = null;
        this.myProject = null;
        this.myPsiManager = null;
        this.myFileFactory = null;
        super.tearDown();
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    @NotNull
    public final String getTestName() {
        String string = this.getTestName(this.myLowercaseFirstLetter);
        if (string == null) {
            ParsingTestCase.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected boolean includeRanges() {
        return false;
    }

    protected boolean skipSpaces() {
        return false;
    }

    protected boolean checkAllPsiRoots() {
        return true;
    }

    protected void doTest(boolean checkResult) {
        String name2 = this.getTestName();
        try {
            String text2 = this.loadFile(name2 + "." + this.myFileExt);
            this.myFile = this.createPsiFile(name2, text2);
            ParsingTestCase.ensureParsed(this.myFile);
            ParsingTestCase.assertEquals((String)"light virtual file text mismatch", (String)text2, (String)((LightVirtualFile)this.myFile.getVirtualFile()).getContent().toString());
            ParsingTestCase.assertEquals((String)"virtual file text mismatch", (Object)text2, (Object)LoadTextUtil.loadText(this.myFile.getVirtualFile()));
            ParsingTestCase.assertEquals((String)"doc text mismatch", (String)text2, (String)this.myFile.getViewProvider().getDocument().getText());
            ParsingTestCase.assertEquals((String)"psi text mismatch", (String)text2, (String)this.myFile.getText());
            ParsingTestCase.ensureCorrectReparse(this.myFile);
            if (checkResult) {
                this.checkResult(name2, this.myFile);
            } else {
                ParsingTestCase.toParseTreeText((PsiElement)this.myFile, this.skipSpaces(), this.includeRanges());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doTest(String suffix) throws IOException {
        String name2 = this.getTestName();
        String text2 = this.loadFile(name2 + "." + this.myFileExt);
        this.myFile = this.createPsiFile(name2, text2);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)text2, (String)this.myFile.getText());
        this.checkResult(name2 + suffix, this.myFile);
    }

    protected void doCodeTest(String code2) throws IOException {
        String name2 = this.getTestName();
        this.myFile = this.createPsiFile("a", code2);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)code2, (String)this.myFile.getText());
        this.checkResult(this.myFilePrefix + name2, this.myFile);
    }

    protected PsiFile createPsiFile(String name2, String text2) {
        return this.createFile(name2 + "." + this.myFileExt, text2);
    }

    protected PsiFile createFile(@NonNls String name2, String text2) {
        LightVirtualFile virtualFile = new LightVirtualFile(name2, this.myLanguage, (CharSequence)text2);
        virtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        return this.createFile(virtualFile);
    }

    protected PsiFile createFile(LightVirtualFile virtualFile) {
        return this.myFileFactory.trySetupPsiForFile(virtualFile, this.myLanguage, true, false);
    }

    protected void checkResult(@NonNls String targetDataName, PsiFile file2) throws IOException {
        ParsingTestCase.doCheckResult(this.myFullDataPath, file2, this.checkAllPsiRoots(), targetDataName, this.skipSpaces(), this.includeRanges(), this.allTreesInSingleFile());
    }

    protected boolean allTreesInSingleFile() {
        return false;
    }

    public static void doCheckResult(String testDataDir, PsiFile file2, boolean checkAllPsiRoots, String targetDataName, boolean skipSpaces, boolean printRanges) throws IOException {
        ParsingTestCase.doCheckResult(testDataDir, file2, checkAllPsiRoots, targetDataName, skipSpaces, printRanges, false);
    }

    public static void doCheckResult(String testDataDir, PsiFile file2, boolean checkAllPsiRoots, String targetDataName, boolean skipSpaces, boolean printRanges, boolean allTreesInSingleFile) throws IOException {
        FileViewProvider provider = file2.getViewProvider();
        Set languages = provider.getLanguages();
        if (!checkAllPsiRoots || languages.size() == 1) {
            ParsingTestCase.doCheckResult(testDataDir, targetDataName + ".txt", ParsingTestCase.toParseTreeText((PsiElement)file2, skipSpaces, printRanges).trim());
            return;
        }
        if (allTreesInSingleFile) {
            String expectedName = targetDataName + ".txt";
            StringBuilder sb = new StringBuilder();
            ArrayList languagesList = new ArrayList(languages);
            ContainerUtil.sort(languagesList, Comparator.comparing(Language::getID));
            for (Language language : languagesList) {
                sb.append("Subtree: ").append(language.getDisplayName()).append(" (").append(language.getID()).append(")").append("\n").append(ParsingTestCase.toParseTreeText((PsiElement)provider.getPsi(language), skipSpaces, printRanges).trim()).append("\n").append(StringUtil.repeat((String)"-", (int)80)).append("\n");
            }
            ParsingTestCase.doCheckResult(testDataDir, expectedName, sb.toString());
        } else {
            for (Language language : languages) {
                PsiFile root = provider.getPsi(language);
                String expectedName = targetDataName + "." + language.getID() + ".txt";
                ParsingTestCase.doCheckResult(testDataDir, expectedName, ParsingTestCase.toParseTreeText((PsiElement)root, skipSpaces, printRanges).trim());
            }
        }
    }

    protected void checkResult(String actual) throws IOException {
        String name2 = this.getTestName();
        ParsingTestCase.doCheckResult(this.myFullDataPath, this.myFilePrefix + name2 + ".txt", actual);
    }

    protected void checkResult(@NonNls String targetDataName, String actual) throws IOException {
        ParsingTestCase.doCheckResult(this.myFullDataPath, targetDataName, actual);
    }

    public static void doCheckResult(String fullPath, String targetDataName, String actual) throws IOException {
        String expectedFileName = fullPath + File.separatorChar + targetDataName;
        UsefulTestCase.assertSameLinesWithFile(expectedFileName, actual);
    }

    protected static String toParseTreeText(PsiElement file2, boolean skipSpaces, boolean printRanges) {
        return DebugUtil.psiToString(file2, skipSpaces, printRanges);
    }

    protected String loadFile(@NonNls String name2) throws IOException {
        return ParsingTestCase.loadFileDefault(this.myFullDataPath, name2);
    }

    public static String loadFileDefault(String dir, String name2) throws IOException {
        return FileUtil.loadFile((File)new File(dir, name2), (String)"UTF-8", (boolean)true).trim();
    }

    public static void ensureParsed(PsiFile file2) {
        file2.accept(new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
            }
        });
    }

    public static void ensureCorrectReparse(@NotNull PsiFile file2) {
        if (file2 == null) {
            ParsingTestCase.$$$reportNull$$$0(8);
        }
        String psiToStringDefault = DebugUtil.psiToString((PsiElement)file2, false, false);
        String fileText = file2.getText();
        DiffLog diffLog = new BlockSupportImpl(file2.getProject()).reparseRange(file2, file2.getNode(), TextRange.allOf((String)fileText), fileText, (ProgressIndicator)new EmptyProgressIndicator(), fileText);
        diffLog.performActualPsiChange(file2);
        TestCase.assertEquals((String)psiToStringDefault, (String)DebugUtil.psiToString((PsiElement)file2, false, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExt";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitions";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/ParsingTestCase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/ParsingTestCase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureCorrectReparse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

