/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.testFramework.CpuTimings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Timings {
    private static final int IO_PROBES = 42;
    public static final long CPU_TIMING;
    private static final CpuTimings CPU_TIMING_DATA;
    public static final long IO_TIMING;
    public static final long REFERENCE_CPU_TIMING = 200L;
    public static final long REFERENCE_IO_TIMING = 100L;

    public static int adjustAccordingToMySpeed(int value2, boolean isParallelizable) {
        return Math.max(1, (int)(1.0 * (double)value2 * 200.0 / (double)CPU_TIMING) / 8 * (isParallelizable ? JobSchedulerImpl.CORES_COUNT : 1));
    }

    public static String getStatistics() {
        return String.format("CPU=%d (%d%% reference CPU, sd=%.2f), I/O=%d (%d%% reference IO), %d cores", Timings.CPU_TIMING_DATA.average, CPU_TIMING * 100L / 200L, Timings.CPU_TIMING_DATA.stdDev, IO_TIMING, IO_TIMING * 100L / 100L, Runtime.getRuntime().availableProcessors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        CPU_TIMING_DATA = CpuTimings.calcStableCpuTiming();
        CPU_TIMING = Timings.CPU_TIMING_DATA.average;
        long start = System.currentTimeMillis();
        for (int i = 0; i < 42; ++i) {
            try {
                File tempFile = FileUtil.createTempFile((String)"test", (String)("test" + i));
                try (FileWriter writer = new FileWriter(tempFile);){
                    for (int j = 0; j < 15; ++j) {
                        writer.write("test" + j);
                        writer.flush();
                    }
                }
                try (FileReader reader = new FileReader(tempFile);){
                    while (reader.read() >= 0) {
                    }
                }
                if (i == 41) {
                    try (FileOutputStream stream = new FileOutputStream(tempFile);){
                        stream.getFD().sync();
                    }
                }
                if (tempFile.delete()) continue;
                throw new IOException("Unable to delete: " + tempFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        IO_TIMING = System.currentTimeMillis() - start;
    }
}

