/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.actions.HighlightUsagesAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.DumpLookupElementWeights;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.mock.MockProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.TestActionEvent;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.CodeInsightTestUtil;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.testFramework.utils.inlays.CaretAndInlaysInfo;
import com.intellij.testFramework.utils.inlays.InlayHintsChecker;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JList;
import junit.framework.ComparisonFailure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CodeInsightTestFixtureImpl
extends BaseFixture
implements CodeInsightTestFixture {
    private static final Function<IntentionAction, String> INTENTION_NAME_FUN = intentionAction -> '\"' + intentionAction.getText() + '\"';
    private static final String RAINBOW = "rainbow";
    private static final String FOLD = "fold";
    private final IdeaProjectTestFixture myProjectFixture;
    private final TempDirTestFixture myTempDirFixture;
    private PsiManagerImpl myPsiManager;
    private VirtualFile myFile;
    private Editor myEditor;
    private String myTestDataPath;
    private boolean myEmptyLookup;
    private VirtualFileFilter myVirtualFileFilter;
    private ChooseByNameBase myChooseByNamePopup;
    private boolean myAllowDirt;
    private boolean myCaresAboutInjection;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;

    public CodeInsightTestFixtureImpl(@NotNull IdeaProjectTestFixture projectFixture, @NotNull TempDirTestFixture tempDirTestFixture) {
        if (projectFixture == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(0);
        }
        if (tempDirTestFixture == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(1);
        }
        this.myVirtualFileFilter = new FileTreeAccessFilter();
        this.myCaresAboutInjection = true;
        this.myProjectFixture = projectFixture;
        this.myTempDirFixture = tempDirTestFixture;
    }

    private static void addGutterIconRenderer(GutterMark renderer, int offset, @NotNull SortedMap<Integer, List<GutterMark>> result2) {
        if (result2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(2);
        }
        if (renderer == null) {
            return;
        }
        List renderers = result2.computeIfAbsent(offset, k -> new SmartList());
        renderers.add(renderer);
    }

    private static void removeDuplicatedRangesForInjected(@NotNull List<HighlightInfo> infos) {
        if (infos == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(3);
        }
        Collections.sort(infos, (o1, o2) -> {
            int i = o2.startOffset - o1.startOffset;
            return i != 0 ? i : o1.getSeverity().myVal - o2.getSeverity().myVal;
        });
        HighlightInfo prevInfo = null;
        Iterator<HighlightInfo> it = infos.iterator();
        while (it.hasNext()) {
            HighlightInfo info = it.next();
            if (prevInfo != null && info.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY && info.getDescription() == null && info.startOffset == prevInfo.startOffset && info.endOffset == prevInfo.endOffset) {
                it.remove();
            }
            prevInfo = info.type == HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT ? info : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<HighlightInfo> instantiateAndRun(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull int[] toIgnore, boolean canChangeDocument) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(5);
        }
        if (toIgnore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(6);
        }
        Project project2 = file2.getProject();
        CodeInsightTestFixtureImpl.ensureIndexesUpToDate(project2);
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project2);
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        ProcessCanceledException exception = null;
        int retries = 1000;
        for (int i = 0; i < retries; ++i) {
            ArrayList<HighlightInfo> arrayList;
            int oldDelay = settings.AUTOREPARSE_DELAY;
            try {
                settings.AUTOREPARSE_DELAY = 0;
                ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
                EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
                    if (file2 == null) {
                        CodeInsightTestFixtureImpl.$$$reportNull$$$0(203);
                    }
                    if (editor == null) {
                        CodeInsightTestFixtureImpl.$$$reportNull$$$0(204);
                    }
                    if (toIgnore == null) {
                        CodeInsightTestFixtureImpl.$$$reportNull$$$0(205);
                    }
                    infos.addAll(codeAnalyzer.runPasses(file2, editor.getDocument(), Collections.singletonList(textEditor), toIgnore, canChangeDocument, null));
                }));
                infos.addAll(DaemonCodeAnalyzerEx.getInstanceEx(project2).getFileLevelHighlights(project2, file2));
                ArrayList<HighlightInfo> arrayList2 = infos;
                arrayList = arrayList2;
            }
            catch (ProcessCanceledException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause.getClass() != Throwable.class) {
                    throw e;
                }
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                UIUtil.dispatchAllInvocationEvents();
                exception = e;
                continue;
            }
            finally {
                settings.AUTOREPARSE_DELAY = oldDelay;
            }
            if (arrayList == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        throw new AssertionError("Unable to highlight after " + retries + " retries", exception);
    }

    public static void ensureIndexesUpToDate(@NotNull Project project2) {
        if (project2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(8);
        }
        if (!DumbService.isDumb((Project)project2)) {
            ReadAction.run(() -> {
                if (project2 == null) {
                    CodeInsightTestFixtureImpl.$$$reportNull$$$0(202);
                }
                FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project2, null);
                FileBasedIndex.getInstance().ensureUpToDate(TodoIndex.NAME, project2, null);
            });
        }
    }

    @NotNull
    public static List<IntentionAction> getAvailableIntentions(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(10);
        }
        List list2 = (List)ReadAction.compute(() -> {
            if (editor == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(200);
            }
            if (file2 == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(201);
            }
            return CodeInsightTestFixtureImpl.doGetAvailableIntentions(editor, file2);
        });
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NotNull
    private static List<IntentionAction> doGetAvailableIntentions(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(13);
        }
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.getActionsToShow(editor, file2, intentions, -1);
        ArrayList<IntentionAction> result2 = new ArrayList<IntentionAction>();
        IntentionListStep intentionListStep = new IntentionListStep(null, intentions, editor, file2, file2.getProject());
        for (Map.Entry<IntentionAction, List<IntentionAction>> entry : intentionListStep.getActionsWithSubActions().entrySet()) {
            result2.add(entry.getKey());
            result2.addAll((Collection)entry.getValue());
        }
        List<HighlightInfo> infos = DaemonCodeAnalyzerEx.getInstanceEx(file2.getProject()).getFileLevelHighlights(file2.getProject(), file2);
        for (HighlightInfo info : infos) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair2 : info.quickFixActionRanges) {
                HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair2.first;
                if (!actionInGroup.getAction().isAvailable(file2.getProject(), editor, file2)) continue;
                result2.add(actionInGroup.getAction());
                List<IntentionAction> options = actionInGroup.getOptions((PsiElement)file2, editor);
                if (options == null) continue;
                for (IntentionAction subAction : options) {
                    if (!subAction.isAvailable(file2.getProject(), editor, file2)) continue;
                    result2.add(subAction);
                }
            }
        }
        ArrayList<IntentionAction> arrayList = result2;
        if (arrayList == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        String string = this.myTempDirFixture.getTempDirPath();
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @NotNull
    public TempDirTestFixture getTempDirFixture() {
        TempDirTestFixture tempDirTestFixture = this.myTempDirFixture;
        if (tempDirTestFixture == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(16);
        }
        return tempDirTestFixture;
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourcePath) {
        if (sourcePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(17);
        }
        VirtualFile virtualFile = this.copyFileToProject(sourcePath, sourcePath);
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(18);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourcePath, @NotNull String targetPath) {
        if (sourcePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(19);
        }
        if (targetPath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(20);
        }
        String testDataPath = this.getTestDataPath();
        File sourceFile = FileUtil.findFirstThatExist((String[])new String[]{testDataPath + '/' + sourcePath, sourcePath});
        VirtualFile targetFile = this.myTempDirFixture.getFile(targetPath);
        if (sourceFile == null && targetFile != null && targetPath.equals(sourcePath)) {
            VirtualFile virtualFile = targetFile;
            if (virtualFile == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(21);
            }
            return virtualFile;
        }
        CodeInsightTestFixtureImpl.assertFileEndsWithCaseSensitivePath(sourceFile);
        Assert.assertNotNull((String)("Cannot find source file: " + sourcePath + "; test data path: " + testDataPath), (Object)sourceFile);
        Assert.assertTrue((String)("Not a file: " + sourceFile), (boolean)sourceFile.isFile());
        if (targetFile == null) {
            targetFile = this.myTempDirFixture.createFile(targetPath);
            VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(targetFile, sourcePath);
            targetFile.putUserData(VfsTestUtil.TEST_DATA_FILE_PATH, (Object)sourceFile.getAbsolutePath());
        }
        CodeInsightTestFixtureImpl.copyContent(sourceFile, targetFile);
        VirtualFile virtualFile = targetFile;
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(22);
        }
        return virtualFile;
    }

    private static void assertFileEndsWithCaseSensitivePath(@Nullable File sourceFile) {
        if (sourceFile == null) {
            return;
        }
        try {
            String sourceName = sourceFile.getName();
            File realFile = sourceFile.getCanonicalFile();
            String realFileName = realFile.getName();
            if (sourceName.equalsIgnoreCase(realFileName) && !sourceName.equals(realFileName)) {
                Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + sourceFile.getPath() + "\nreal path " + realFile.getPath()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void copyContent(final File sourceFile, final VirtualFile targetFile) {
        new WriteAction(){

            protected void run(@NotNull Result result2) throws IOException {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                targetFile.setBinaryContent(FileUtil.loadFileBytes((File)sourceFile));
                FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{targetFile});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$1", "run"));
            }
        }.execute();
    }

    @Override
    @NotNull
    public VirtualFile copyDirectoryToProject(@NotNull String sourcePath, @NotNull String targetPath) {
        if (sourcePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(23);
        }
        if (targetPath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(24);
        }
        String testDataPath = this.getTestDataPath();
        File fromFile = new File(testDataPath + "/" + sourcePath);
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            VirtualFile virtualFile = this.myTempDirFixture.copyAll(fromFile.getPath(), targetPath);
            if (virtualFile == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(25);
            }
            return virtualFile;
        }
        File targetFile = new File(this.getTempDirPath() + "/" + targetPath);
        try {
            FileUtil.copyDir((File)fromFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(targetFile);
        Assert.assertNotNull((Object)file2);
        file2.refresh(false, true);
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(26);
        }
        return virtualFile;
    }

    @Override
    public void enableInspections(InspectionProfileEntry ... inspections) {
        if (inspections == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(27);
        }
        this.assertInitialized();
        InspectionsKt.enableInspectionTools(this.getProject(), this.myProjectFixture.getTestRootDisposable(), inspections);
    }

    @Override
    @SafeVarargs
    public final void enableInspections(Class<? extends LocalInspectionTool> ... inspections) {
        if (inspections == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(28);
        }
        this.enableInspections(Arrays.asList(inspections));
    }

    @Override
    public void enableInspections(@NotNull Collection<Class<? extends LocalInspectionTool>> inspections) {
        if (inspections == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(29);
        }
        List<InspectionProfileEntry> tools = InspectionTestUtil.instantiateTools(inspections);
        this.enableInspections(tools.toArray(new InspectionProfileEntry[tools.size()]));
    }

    @Override
    public void disableInspections(InspectionProfileEntry ... inspections) {
        if (inspections == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(30);
        }
        InspectionsKt.disableInspections(this.getProject(), inspections);
    }

    @Override
    public void enableInspections(InspectionToolProvider ... providers2) {
        if (providers2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(31);
        }
        List<Class<? extends LocalInspectionTool>> classes2 = Stream.of(providers2).flatMap(p -> Stream.of(p.getInspectionClasses())).filter(LocalInspectionTool.class::isAssignableFrom).map(c -> {
            Class toolClass = c;
            return toolClass;
        }).collect(Collectors.toList());
        this.enableInspections(classes2);
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(32);
        }
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... paths) {
        if (paths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(33);
        }
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, Stream.of(paths).map(this::copyFileToProject));
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, VirtualFile ... files) {
        if (files == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(34);
        }
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, Stream.of(files));
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, Stream<VirtualFile> files) {
        List data = files.map(file2 -> {
            PsiFile psiFile = this.myPsiManager.findFile((VirtualFile)file2);
            Assert.assertNotNull((Object)psiFile);
            Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
            Assert.assertNotNull((Object)document);
            ExpectedHighlightingData datum = new ExpectedHighlightingData(document, checkWarnings, checkWeakWarnings, checkInfos, psiFile);
            datum.init();
            return Trinity.create((Object)psiFile, (Object)this.createEditor((VirtualFile)file2), (Object)datum);
        }).collect(Collectors.toList());
        long elapsed = 0L;
        for (Trinity trinity : data) {
            this.myEditor = (Editor)trinity.second;
            this.myFile = ((PsiFile)trinity.first).getVirtualFile();
            elapsed += this.collectAndCheckHighlighting((ExpectedHighlightingData)trinity.third);
        }
        return elapsed;
    }

    @Override
    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return this.checkHighlighting(checkWarnings, checkInfos, checkWeakWarnings, false);
    }

    @Override
    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, ignoreExtraHighlighting);
    }

    @Override
    public long checkHighlighting() {
        return this.checkHighlighting(true, false, true);
    }

    @Override
    public long testHighlighting(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(35);
        }
        return this.testHighlighting(true, false, true, filePaths);
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, @NotNull VirtualFile file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(36);
        }
        this.openFileInEditor(file2);
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
    }

    @Override
    @NotNull
    public HighlightTestInfo testFile(String ... filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(37);
        }
        HighlightTestInfo highlightTestInfo = new HighlightTestInfo(this.myProjectFixture.getTestRootDisposable(), filePath){

            @Override
            public HighlightTestInfo doTest() {
                CodeInsightTestFixtureImpl.this.configureByFiles(this.filePaths);
                ExpectedHighlightingData data = new ExpectedHighlightingData(CodeInsightTestFixtureImpl.this.myEditor.getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos, CodeInsightTestFixtureImpl.this.getFile());
                if (this.checkSymbolNames) {
                    data.checkSymbolNames();
                }
                data.init();
                CodeInsightTestFixtureImpl.this.collectAndCheckHighlighting(data);
                return this;
            }
        };
        if (highlightTestInfo == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(38);
        }
        return highlightTestInfo;
    }

    @Override
    public void openFileInEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(39);
        }
        this.myFile = file2;
        this.myEditor = this.createEditor(file2);
    }

    @Override
    public void testInspection(@NotNull String testDir, @NotNull InspectionToolWrapper toolWrapper) {
        if (testDir == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(40);
        }
        if (toolWrapper == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(41);
        }
        VirtualFile sourceDir = this.copyDirectoryToProject(new File(testDir, "src").getPath(), "");
        PsiDirectory psiDirectory = this.getPsiManager().findDirectory(sourceDir);
        Assert.assertNotNull((Object)psiDirectory);
        AnalysisScope scope = new AnalysisScope(psiDirectory);
        scope.invalidate();
        GlobalInspectionContextForTests globalContext = InspectionsKt.createGlobalContextForTool(scope, this.getProject(), Collections.singletonList(toolWrapper));
        InspectionTestUtil.runTool(toolWrapper, scope, globalContext);
        InspectionTestUtil.compareToolResults((GlobalInspectionContextImpl)globalContext, toolWrapper, false, new File(this.getTestDataPath(), testDir).getPath());
    }

    @Override
    @Nullable
    public PsiReference getReferenceAtCaretPosition(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(42);
        }
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return this.getFile().findReferenceAt(this.myEditor.getCaretModel().getOffset());
    }

    @Override
    @NotNull
    public PsiReference getReferenceAtCaretPositionWithAssertion(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(43);
        }
        PsiReference reference = this.getReferenceAtCaretPosition(filePaths);
        Assert.assertNotNull((String)("no reference found at " + this.myEditor.getCaretModel().getLogicalPosition()), (Object)reference);
        PsiReference psiReference = reference;
        if (psiReference == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(44);
        }
        return psiReference;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(45);
        }
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        List<IntentionAction> list2 = this.getAvailableIntentions();
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(46);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAllQuickFixes(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(47);
        }
        if (filePaths.length != 0) {
            this.configureByFilesInner(filePaths);
        }
        List<HighlightInfo> infos = this.doHighlighting();
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        for (HighlightInfo info : infos) {
            if (info.quickFixActionRanges == null) continue;
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair2 : info.quickFixActionRanges) {
                actions.add(((HighlightInfo.IntentionActionDescriptor)pair2.getFirst()).getAction());
            }
        }
        ArrayList<IntentionAction> arrayList = actions;
        if (arrayList == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions() {
        this.doHighlighting();
        List<IntentionAction> list2 = CodeInsightTestFixtureImpl.getAvailableIntentions(this.getHostEditor(), this.getHostFileAtCaret());
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(49);
        }
        return list2;
    }

    private Editor getHostEditor() {
        return InjectedLanguageUtil.getTopLevelEditor(this.getEditor());
    }

    private PsiFile getHostFileAtCaret() {
        return Objects.requireNonNull(PsiUtilBase.getPsiFileInEditor((Editor)this.getHostEditor(), (Project)this.getProject()));
    }

    @Override
    @NotNull
    public List<IntentionAction> filterAvailableIntentions(@NotNull String hint) {
        if (hint == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(50);
        }
        List<IntentionAction> list2 = this.getAvailableIntentions().stream().filter(action -> {
            if (hint == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(199);
            }
            return action.getText().startsWith(hint);
        }).collect(Collectors.toList());
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(51);
        }
        return list2;
    }

    @Override
    @NotNull
    public IntentionAction findSingleIntention(@NotNull String hint) {
        List<IntentionAction> list2;
        if (hint == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(52);
        }
        if ((list2 = this.filterAvailableIntentions(hint)).isEmpty()) {
            Assert.fail((String)("\"" + hint + "\" not in [" + StringUtil.join(this.getAvailableIntentions(), INTENTION_NAME_FUN, (String)", ") + "]"));
        } else if (list2.size() > 1) {
            Assert.fail((String)("Too many intentions found for \"" + hint + "\": [" + StringUtil.join(list2, INTENTION_NAME_FUN, (String)", ") + "]"));
        }
        IntentionAction intentionAction = UsefulTestCase.assertOneElement(list2);
        if (intentionAction == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(53);
        }
        return intentionAction;
    }

    @Override
    public IntentionAction getAvailableIntention(@NotNull String intentionName, String ... filePaths) {
        List<IntentionAction> intentions;
        IntentionAction action;
        if (intentionName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(54);
        }
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(55);
        }
        if ((action = CodeInsightTestUtil.findIntentionByText(intentions = this.getAvailableIntentions(filePaths), intentionName)) == null) {
            System.out.println(intentionName + " not found among " + StringUtil.join(intentions, IntentionAction::getText, (String)","));
        }
        return action;
    }

    @Override
    public void launchAction(@NotNull IntentionAction action) {
        if (action == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(56);
        }
        CodeInsightTestFixtureImpl.invokeIntention(action, this.getHostFileAtCaret(), this.getHostEditor(), action.getText());
    }

    @Override
    public void testCompletion(@NotNull String[] filesBefore, @NotNull String fileAfter) {
        if (filesBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(57);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(58);
        }
        this.testCompletionTyping(filesBefore, "", fileAfter);
    }

    @Override
    public void testCompletionTyping(@NotNull String[] filesBefore, @NotNull String toType, @NotNull String fileAfter) {
        if (filesBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(59);
        }
        if (toType == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(60);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(61);
        }
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        this.complete(CompletionType.BASIC);
        this.type(toType);
        try {
            this.checkResultByFile(fileAfter);
        }
        catch (RuntimeException e) {
            System.out.println("LookupElementStrings = " + this.getLookupElementStrings());
            throw e;
        }
    }

    protected void assertInitialized() {
        Assert.assertNotNull((String)"setUp() hasn't been called", (Object)((Object)this.myPsiManager));
    }

    @Override
    public void testCompletion(@NotNull String fileBefore, @NotNull String fileAfter, String ... additionalFiles) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(62);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(63);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(64);
        }
        this.testCompletionTyping(fileBefore, "", fileAfter, additionalFiles);
    }

    @Override
    public void testCompletionTyping(@NotNull String fileBefore, @NotNull String toType, @NotNull String fileAfter, String ... additionalFiles) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(65);
        }
        if (toType == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(66);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(67);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(68);
        }
        this.testCompletionTyping((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore)), toType, fileAfter);
    }

    @Override
    public void testCompletionVariants(@NotNull String fileBefore, String ... expectedItems) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(69);
        }
        if (expectedItems == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(70);
        }
        this.assertInitialized();
        List<String> result2 = this.getCompletionVariants(fileBefore);
        Assert.assertNotNull(result2);
        UsefulTestCase.assertSameElements(result2, expectedItems);
    }

    @Override
    public List<String> getCompletionVariants(String ... filesBefore) {
        if (filesBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(71);
        }
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        LookupElement[] items = this.complete(CompletionType.BASIC);
        Assert.assertNotNull((String)"No lookup was shown, probably there was only one lookup element that was inserted automatically", (Object)items);
        return this.getLookupElementStrings();
    }

    @Override
    @Nullable
    public List<String> getLookupElementStrings() {
        this.assertInitialized();
        Object[] elements = this.getLookupElements();
        if (elements == null) {
            return null;
        }
        return ContainerUtil.map((Object[])elements, LookupElement::getLookupString);
    }

    @Override
    public void finishLookup(char completionChar) {
        Runnable command = () -> {
            LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(this.getEditor());
            Assert.assertNotNull((Object)lookup);
            lookup.finishLookup(completionChar);
        };
        CommandProcessor.getInstance().executeCommand(this.getProject(), command, null, null);
    }

    @Override
    public void testRename(@NotNull String fileBefore, @NotNull String fileAfter, @NotNull String newName, String ... additionalFiles) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(72);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(73);
        }
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(74);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(75);
        }
        this.assertInitialized();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore)));
        this.testRename(fileAfter, newName);
    }

    @Override
    public void testRename(@NotNull String fileAfter, @NotNull String newName) {
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(76);
        }
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(77);
        }
        this.renameElementAtCaret(newName);
        this.checkResultByFile(fileAfter);
    }

    @Override
    @NotNull
    public PsiElement getElementAtCaret() {
        this.assertInitialized();
        Editor editor = this.getCompletionEditor();
        int findTargetFlags = 3;
        PsiElement element = TargetElementUtil.findTargetElement(editor, findTargetFlags);
        if (element == null && editor instanceof EditorWindow) {
            element = TargetElementUtil.findTargetElement(((EditorWindow)editor).getDelegate(), findTargetFlags);
        }
        if (element == null) {
            Assert.fail((String)("element not found in file " + this.myFile.getName() + " at caret position offset " + this.myEditor.getCaretModel().getOffset() + ", psi structure:\n" + DebugUtil.psiToString((PsiElement)this.getFile(), true, true)));
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(78);
        }
        return psiElement;
    }

    @Override
    public void renameElementAtCaret(@NotNull String newName) {
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(79);
        }
        this.renameElement(this.getElementAtCaret(), newName);
    }

    @Override
    public void renameElementAtCaretUsingHandler(final @NotNull String newName) {
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(80);
        }
        final DataContext editorContext = ((EditorEx)this.myEditor).getDataContext();
        DataContext context = new DataContext(){

            public Object getData(String dataId) {
                return PsiElementRenameHandler.DEFAULT_NAME.getName().equals(dataId) ? newName : editorContext.getData(dataId);
            }
        };
        RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(context);
        Assert.assertNotNull((String)"No handler for this context", (Object)renameHandler);
        renameHandler.invoke(this.getProject(), this.myEditor, this.getFile(), context);
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName) {
        if (element == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(81);
        }
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(82);
        }
        boolean searchInComments = false;
        boolean searchTextOccurrences = false;
        this.renameElement(element, newName, false, false);
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName, boolean searchInComments, boolean searchTextOccurrences) {
        PsiElement substitution;
        if (element == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(83);
        }
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(84);
        }
        if ((substitution = RenamePsiElementProcessor.forElement(element).substituteElementToRename(element, this.myEditor)) == null) {
            return;
        }
        new RenameProcessor(this.getProject(), substitution, newName, searchInComments, searchTextOccurrences).run();
    }

    @Override
    public <T extends PsiElement> T findElementByText(@NotNull String text2, @NotNull Class<T> elementClass) {
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(85);
        }
        if (elementClass == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(86);
        }
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(this.getFile());
        Assert.assertNotNull((Object)document);
        int pos = document.getText().indexOf(text2);
        Assert.assertTrue((String)text2, (pos >= 0 ? 1 : 0) != 0);
        return (T)PsiTreeUtil.getParentOfType((PsiElement)this.getFile().findElementAt(pos), elementClass);
    }

    @Override
    public void type(char c) {
        this.assertInitialized();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            EditorActionManager actionManager = EditorActionManager.getInstance();
            if (c == '\b') {
                this.performEditorAction("EditorBackSpace");
                return;
            }
            if (c == '\n') {
                if (this._performEditorAction("EditorChooseLookupItem")) {
                    return;
                }
                if (this._performEditorAction("NextTemplateVariable")) {
                    return;
                }
                this.performEditorAction("EditorEnter");
                return;
            }
            if (c == '\t') {
                if (this._performEditorAction("EditorChooseLookupItemReplace")) {
                    return;
                }
                if (this._performEditorAction("ExpandLiveTemplateByTab")) {
                    return;
                }
                if (this._performEditorAction("NextTemplateVariable")) {
                    return;
                }
                if (this._performEditorAction("EditorTab")) {
                    return;
                }
            }
            if (c == '\r' && this._performEditorAction("EditorChooseLookupItemCompleteStatement")) {
                return;
            }
            ActionManagerEx.getInstanceEx().fireBeforeEditorTyping(c, this.getEditorDataContext());
            actionManager.getTypedAction().actionPerformed(this.getEditor(), c, this.getEditorDataContext());
        });
    }

    @NotNull
    private DataContext getEditorDataContext() {
        DataContext dataContext = ((EditorEx)this.myEditor).getDataContext();
        if (dataContext == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(87);
        }
        return dataContext;
    }

    @Override
    public void type(@NotNull String s) {
        if (s == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(88);
        }
        for (int i = 0; i < s.length(); ++i) {
            this.type(s.charAt(i));
        }
    }

    @Override
    public void performEditorAction(@NotNull String actionId) {
        if (actionId == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(89);
        }
        this.assertInitialized();
        this._performEditorAction(actionId);
    }

    private boolean _performEditorAction(@NotNull String actionId) {
        if (actionId == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(90);
        }
        DataContext dataContext = this.getEditorDataContext();
        ActionManagerEx managerEx = ActionManagerEx.getInstanceEx();
        AnAction action = managerEx.getAction(actionId);
        AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(), (ActionManager)managerEx, 0);
        action.beforeActionPerformedUpdate(event);
        if (!event.getPresentation().isEnabled()) {
            return false;
        }
        managerEx.fireBeforeActionPerformed(action, dataContext, event);
        ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)event);
        managerEx.fireAfterActionPerformed(action, dataContext, event);
        return true;
    }

    @Override
    @NotNull
    public Presentation testAction(@NotNull AnAction action) {
        if (action == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(91);
        }
        TestActionEvent e = new TestActionEvent(action);
        action.beforeActionPerformedUpdate((AnActionEvent)e);
        if (e.getPresentation().isEnabled() && e.getPresentation().isVisible()) {
            action.actionPerformed((AnActionEvent)e);
        }
        Presentation presentation = e.getPresentation();
        if (presentation == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(92);
        }
        return presentation;
    }

    @Override
    @NotNull
    public Collection<UsageInfo> testFindUsages(String ... fileNames) {
        if (fileNames == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(93);
        }
        this.assertInitialized();
        this.configureByFiles(fileNames);
        int flags = 3;
        PsiElement targetElement = TargetElementUtil.findTargetElement(this.getEditor(), flags);
        Assert.assertNotNull((String)"Cannot find referenced element", (Object)targetElement);
        Collection<UsageInfo> collection = this.findUsages(targetElement);
        if (collection == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(94);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement) {
        if (targetElement == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(95);
        }
        Collection<UsageInfo> collection = this.findUsages(targetElement, null);
        if (collection == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(96);
        }
        return collection;
    }

    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement, @Nullable SearchScope scope) {
        if (targetElement == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(97);
        }
        Project project2 = this.getProject();
        FindUsagesHandler handler2 = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager().getFindUsagesHandler(targetElement, false);
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        Assert.assertNotNull((String)("Cannot find handler for: " + targetElement), (Object)handler2);
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler2.getPrimaryElements(), (Object[])handler2.getSecondaryElements());
        FindUsagesOptions options = handler2.getFindUsagesOptions(null);
        if (scope != null) {
            options.searchScope = scope;
        }
        for (PsiElement psiElement : psiElements) {
            handler2.processElementUsages(psiElement, (Processor<UsageInfo>)processor2, options);
        }
        Collection collection = processor2.getResults();
        if (collection == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(98);
        }
        return collection;
    }

    @Override
    @NotNull
    public RangeHighlighter[] testHighlightUsages(String ... files) {
        if (files == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(99);
        }
        this.configureByFiles(files);
        this.testAction(new HighlightUsagesAction());
        Editor editor = this.getEditor();
        RangeHighlighter[] rangeHighlighterArray = editor.getMarkupModel().getAllHighlighters();
        if (rangeHighlighterArray == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(100);
        }
        return rangeHighlighterArray;
    }

    @Override
    public void moveFile(@NotNull String filePath, @NotNull String to, String ... additionalFiles) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(101);
        }
        if (to == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(102);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(103);
        }
        this.assertInitialized();
        Project project2 = this.getProject();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)filePath)));
        VirtualFile file2 = this.findFileInTempDir(to);
        Assert.assertNotNull((String)("Directory " + to + " not found"), (Object)file2);
        Assert.assertTrue((String)(to + " is not a directory"), (boolean)file2.isDirectory());
        PsiDirectory directory = this.myPsiManager.findDirectory(file2);
        new MoveFilesOrDirectoriesProcessor(project2, new PsiElement[]{this.getFile()}, directory, false, false, null, null).run();
    }

    @Override
    @Nullable
    public GutterMark findGutter(@NotNull String filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(104);
        }
        this.configureByFilesInner(filePath);
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        this.doHighlighting();
        CodeInsightTestFixtureImpl.processGuttersAtCaret(this.myEditor, this.getProject(), (Processor<GutterMark>)processor2);
        return (GutterMark)processor2.getFoundValue();
    }

    @Override
    @NotNull
    public List<GutterMark> findGuttersAtCaret() {
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        this.doHighlighting();
        CodeInsightTestFixtureImpl.processGuttersAtCaret(this.myEditor, this.getProject(), (Processor<GutterMark>)processor2);
        ArrayList<GutterMark> arrayList = new ArrayList<GutterMark>(processor2.getResults());
        if (arrayList == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(105);
        }
        return arrayList;
    }

    public static boolean processGuttersAtCaret(Editor editor, Project project2, @NotNull Processor<GutterMark> processor2) {
        RangeHighlighter[] highlighters;
        if (processor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(106);
        }
        int offset = editor.getCaretModel().getOffset();
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument(editor.getDocument(), project2, true).getAllHighlighters()) {
            GutterIconRenderer renderer = highlighter.getGutterIconRenderer();
            if (renderer == null || editor.getDocument().getLineNumber(offset) != editor.getDocument().getLineNumber(highlighter.getStartOffset()) || processor2.process((Object)renderer)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public List<GutterMark> findAllGutters(@NotNull String filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(107);
        }
        this.configureByFilesInner(filePath);
        List<GutterMark> list2 = this.findAllGutters();
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(108);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<GutterMark> findAllGutters() {
        RangeHighlighter[] highlighters;
        Project project2 = this.getProject();
        TreeMap<Integer, List<GutterMark>> result2 = new TreeMap<Integer, List<GutterMark>>();
        List<HighlightInfo> infos = this.doHighlighting();
        for (HighlightInfo info : infos) {
            CodeInsightTestFixtureImpl.addGutterIconRenderer(info.getGutterIconRenderer(), info.startOffset, result2);
        }
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument(this.myEditor.getDocument(), project2, true).getAllHighlighters()) {
            if (!highlighter.isValid()) continue;
            CodeInsightTestFixtureImpl.addGutterIconRenderer((GutterMark)highlighter.getGutterIconRenderer(), highlighter.getStartOffset(), result2);
        }
        List list2 = ContainerUtil.concat(result2.values());
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(109);
        }
        return list2;
    }

    @Override
    public PsiFile addFileToProject(@NotNull String relativePath, @NotNull String fileText) {
        if (relativePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(110);
        }
        if (fileText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(111);
        }
        this.assertInitialized();
        return this.addFileToProject(this.getTempDirPath(), relativePath, fileText);
    }

    protected PsiFile addFileToProject(final @NotNull String rootPath, final @NotNull String relativePath, final @NotNull String fileText) {
        if (rootPath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(112);
        }
        if (relativePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(113);
        }
        if (fileText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(114);
        }
        VirtualFile file2 = (VirtualFile)new WriteCommandAction<VirtualFile>(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result<VirtualFile> result2) {
                if (result2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                try {
                    if (CodeInsightTestFixtureImpl.this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
                        result2.setResult((Object)CodeInsightTestFixtureImpl.this.myTempDirFixture.createFile(relativePath, fileText));
                    } else {
                        result2.setResult((Object)((HeavyIdeaTestFixture)CodeInsightTestFixtureImpl.this.myProjectFixture).addFileToProject(rootPath, relativePath, fileText).getViewProvider().getVirtualFile());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    PsiManager.getInstance((Project)this.getProject()).dropPsiCaches();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$4", "run"));
            }
        }.execute().getResultObject();
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(file2));
    }

    public <T> void registerExtension(ExtensionsArea area, ExtensionPointName<T> epName, T extension) {
        this.assertInitialized();
        ExtensionPoint extensionPoint = area.getExtensionPoint(epName);
        extensionPoint.registerExtension(extension);
        Disposer.register((Disposable)this.myProjectFixture.getTestRootDisposable(), () -> extensionPoint.unregisterExtension(extension));
    }

    @Override
    @NotNull
    public PsiManager getPsiManager() {
        PsiManagerImpl psiManagerImpl = this.myPsiManager;
        if (psiManagerImpl == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(115);
        }
        return psiManagerImpl;
    }

    @Override
    public LookupElement[] complete(@NotNull CompletionType type2) {
        if (type2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(116);
        }
        return this.complete(type2, 1);
    }

    @Override
    public LookupElement[] complete(@NotNull CompletionType type2, int invocationCount) {
        if (type2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(117);
        }
        this.assertInitialized();
        this.myEmptyLookup = false;
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (type2 == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(197);
            }
            CommandProcessor.getInstance().executeCommand(this.getProject(), () -> {
                if (type2 == null) {
                    CodeInsightTestFixtureImpl.$$$reportNull$$$0(198);
                }
                CodeCompletionHandlerBase handler2 = new CodeCompletionHandlerBase(type2){

                    @Override
                    protected void completionFinished(CompletionProgressIndicator indicator, boolean hasModifiers) {
                        CodeInsightTestFixtureImpl.this.myEmptyLookup = indicator.getLookup().getItems().isEmpty();
                        super.completionFinished(indicator, hasModifiers);
                    }
                };
                Editor editor = this.getCompletionEditor();
                Assert.assertNotNull((Object)editor);
                handler2.invokeCompletion(this.getProject(), editor, invocationCount);
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            }, null, null, this.getEditor().getDocument());
        });
        return this.getLookupElements();
    }

    @Nullable
    protected Editor getCompletionEditor() {
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.getFile());
    }

    @Override
    @Nullable
    public LookupElement[] completeBasic() {
        return this.complete(CompletionType.BASIC);
    }

    @Override
    @NotNull
    public final List<LookupElement> completeBasicAllCarets(@Nullable Character charToTypeAfterCompletion) {
        CaretModel caretModel = this.myEditor.getCaretModel();
        List carets = caretModel.getAllCarets();
        ArrayList<Integer> originalOffsets = new ArrayList<Integer>(carets.size());
        for (Caret caret : carets) {
            originalOffsets.add(caret.getOffset());
        }
        caretModel.removeSecondaryCarets();
        Collections.reverse(originalOffsets);
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        Iterator iterator = originalOffsets.iterator();
        while (iterator.hasNext()) {
            int originalOffset = (Integer)iterator.next();
            caretModel.moveToOffset(originalOffset);
            LookupElement[] lookupElements = this.completeBasic();
            if (charToTypeAfterCompletion != null) {
                this.type(charToTypeAfterCompletion.charValue());
            }
            if (lookupElements == null) continue;
            result2.addAll(Arrays.asList(lookupElements));
        }
        ArrayList<LookupElement> arrayList = result2;
        if (arrayList == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(118);
        }
        return arrayList;
    }

    @Override
    public void saveText(final @NotNull VirtualFile file2, final @NotNull String text2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(119);
        }
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(120);
        }
        new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    6.$$$reportNull$$$0(0);
                }
                VfsUtil.saveText((VirtualFile)file2, (String)text2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$6", "run"));
            }
        }.execute().throwException();
    }

    @Override
    @Nullable
    public LookupElement[] getLookupElements() {
        LookupImpl lookup = this.getLookup();
        if (lookup == null) {
            return this.myEmptyLookup ? LookupElement.EMPTY_ARRAY : null;
        }
        List<LookupElement> list2 = lookup.getItems();
        return list2.toArray(new LookupElement[list2.size()]);
    }

    @Override
    public void checkResult(@NotNull String text2) {
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(121);
        }
        this.checkResult(text2, false);
    }

    @Override
    public void checkResult(final @NotNull String text2, final boolean stripTrailingSpaces) {
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(122);
        }
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    7.$$$reportNull$$$0(0);
                }
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                EditorUtil.fillVirtualSpaceUntilCaret(CodeInsightTestFixtureImpl.this.myEditor);
                CodeInsightTestFixtureImpl.this.checkResult("TEXT", stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromText(text2), CodeInsightTestFixtureImpl.this.getHostFile().getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$7", "run"));
            }
        }.execute();
    }

    @Override
    public void checkResult(final @NotNull String filePath, final @NotNull String text2, final boolean stripTrailingSpaces) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(123);
        }
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(124);
        }
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    8.$$$reportNull$$$0(0);
                }
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                PsiFile psiFile = CodeInsightTestFixtureImpl.this.getFileToCheck(filePath);
                CodeInsightTestFixtureImpl.this.checkResult("TEXT", stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromText(text2), psiFile.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$8", "run"));
            }
        }.execute();
    }

    @Override
    public void checkResultByFile(@NotNull String expectedFile) {
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(125);
        }
        this.checkResultByFile(expectedFile, false);
    }

    @Override
    public void checkResultByFile(@NotNull String expectedFile, boolean ignoreTrailingWhitespaces) {
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(126);
        }
        this.assertInitialized();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (expectedFile == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(196);
            }
            this.checkResultByFile(expectedFile, this.getHostFile(), ignoreTrailingWhitespaces);
        });
    }

    @Override
    public void checkResultByFile(@NotNull String filePath, @NotNull String expectedFile, boolean ignoreTrailingWhitespaces) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(127);
        }
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(128);
        }
        this.assertInitialized();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (expectedFile == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(194);
            }
            if (filePath == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(195);
            }
            this.checkResultByFile(expectedFile, this.getFileToCheck(filePath), ignoreTrailingWhitespaces);
        });
    }

    private PsiFile getFileToCheck(String filePath) {
        String path = filePath.replace(File.separatorChar, '/');
        VirtualFile copy = this.findFileInTempDir(path);
        Assert.assertNotNull((String)("could not find results file " + path), (Object)copy);
        PsiFile psiFile = this.myPsiManager.findFile(copy);
        Assert.assertNotNull((String)copy.getPath(), (Object)psiFile);
        return psiFile;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestRunnerUtil.replaceIdeEventQueueSafely();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            this.myProjectFixture.setUp();
            this.myTempDirFixture.setUp();
            VirtualFile tempDir = this.myTempDirFixture.getFile("");
            Assert.assertNotNull((Object)tempDir);
            PlatformTestCase.synchronizeTempDirVfs(tempDir);
            this.myPsiManager = (PsiManagerImpl)PsiManager.getInstance((Project)this.getProject());
            InspectionsKt.configureInspections((InspectionProfileEntry[])LocalInspectionTool.EMPTY_ARRAY, this.getProject(), this.myProjectFixture.getTestRootDisposable());
            DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.getProject());
            daemonCodeAnalyzer.prepareForTest();
            DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
            CodeInsightTestFixtureImpl.ensureIndexesUpToDate(this.getProject());
            ((StartupManagerImpl)StartupManagerEx.getInstanceEx(this.getProject())).runPostStartupActivities();
        }));
        for (Module module2 : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            ModuleRootManager.getInstance((Module)module2).orderEntries().getAllLibrariesAndSdkClassesRoots();
        }
        if (this.shouldTrackVirtualFilePointers()) {
            this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
        }
    }

    protected boolean shouldTrackVirtualFilePointers() {
        return true;
    }

    @Override
    public void tearDown() throws Exception {
        try {
            EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
                try {
                    DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(true);
                    this.closeOpenFiles();
                    WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.getProject()).makeRootsChange(EmptyRunnable.getInstance(), false, true));
                }
                finally {
                    this.myEditor = null;
                    this.myFile = null;
                    this.myPsiManager = null;
                    this.myChooseByNamePopup = null;
                    try {
                        this.myProjectFixture.tearDown();
                    }
                    finally {
                        this.myTempDirFixture.tearDown();
                    }
                }
            }));
        }
        finally {
            super.tearDown();
            if (this.myVirtualFilePointerTracker != null) {
                this.myVirtualFilePointerTracker.assertPointersAreDisposed();
            }
        }
    }

    private void closeOpenFiles() {
        LookupManager.getInstance(this.getProject()).hideActiveLookup();
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        FileEditorManagerEx.getInstanceEx(this.getProject()).closeAllFiles();
        for (VirtualFile file2 : EditorHistoryManager.getInstance(this.getProject()).getFiles()) {
            EditorHistoryManager.getInstance(this.getProject()).removeFile(file2);
        }
    }

    @NotNull
    private PsiFile[] configureByFilesInner(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(129);
        }
        this.assertInitialized();
        this.myFile = null;
        this.myEditor = null;
        PsiFile[] psiFiles = new PsiFile[filePaths.length];
        for (int i = filePaths.length - 1; i >= 0; --i) {
            psiFiles[i] = this.configureByFileInner(filePaths[i]);
        }
        if (psiFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(130);
        }
        return psiFiles;
    }

    @Override
    public PsiFile configureByFile(@NotNull String file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(131);
        }
        this.configureByFilesInner(file2);
        return this.getFile();
    }

    @Override
    @NotNull
    public PsiFile[] configureByFiles(String ... files) {
        if (files == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(132);
        }
        PsiFile[] psiFileArray = this.configureByFilesInner(files);
        if (psiFileArray == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(133);
        }
        return psiFileArray;
    }

    @Override
    public PsiFile configureByText(final @NotNull FileType fileType, @NotNull String text2) {
        if (fileType == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(134);
        }
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(135);
        }
        this.assertInitialized();
        final String extension = fileType.getDefaultExtension();
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager.getFileTypeByExtension(extension) != fileType) {
            new WriteCommandAction(this.getProject(), new PsiFile[0]){

                protected void run(@NotNull Result result2) throws Exception {
                    if (result2 == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    fileTypeManager.associateExtension(fileType, extension);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$9", "run"));
                }
            }.execute();
        }
        String fileName = "aaa." + extension;
        return this.configureByText(fileName, text2);
    }

    @Override
    public PsiFile configureByText(final @NotNull String fileName, final @NotNull String text2) {
        if (fileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(136);
        }
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(137);
        }
        this.assertInitialized();
        VirtualFile vFile = (VirtualFile)new WriteCommandAction<VirtualFile>(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result<VirtualFile> result2) throws Throwable {
                VirtualFile vFile;
                if (result2 == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (CodeInsightTestFixtureImpl.this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
                    VirtualFile root = LightPlatformTestCase.getSourceRoot();
                    root.refresh(false, false);
                    vFile = root.findOrCreateChildData((Object)this, fileName);
                    Assert.assertNotNull((String)(fileName + " not found in " + root.getPath()), (Object)vFile);
                } else if (CodeInsightTestFixtureImpl.this.myTempDirFixture instanceof TempDirTestFixtureImpl) {
                    File tempFile = ((TempDirTestFixtureImpl)CodeInsightTestFixtureImpl.this.myTempDirFixture).createTempFile(fileName);
                    vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
                    Assert.assertNotNull((String)(tempFile + " not found"), (Object)vFile);
                } else {
                    vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(CodeInsightTestFixtureImpl.this.getTempDirPath(), fileName));
                    Assert.assertNotNull((String)(fileName + " not found in " + CodeInsightTestFixtureImpl.this.getTempDirPath()), (Object)vFile);
                }
                CodeInsightTestFixtureImpl.this.prepareVirtualFile(vFile);
                Document document = FileDocumentManager.getInstance().getCachedDocument(vFile);
                if (document != null) {
                    PsiDocumentManager.getInstance((Project)this.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                VfsUtil.saveText((VirtualFile)vFile, (String)text2);
                result2.setResult((Object)vFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$10", "run"));
            }
        }.execute().getResultObject();
        this.configureInner(vFile, SelectionAndCaretMarkupLoader.fromFile(vFile));
        return this.getFile();
    }

    @Override
    public Document getDocument(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(138);
        }
        this.assertInitialized();
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
    }

    private PsiFile configureByFileInner(@NotNull String filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(139);
        }
        this.assertInitialized();
        VirtualFile file2 = this.copyFileToProject(filePath);
        return this.configureByFileInner(file2);
    }

    @Override
    public PsiFile configureFromTempProjectFile(@NotNull String filePath) {
        VirtualFile fileInTempDir;
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(140);
        }
        if ((fileInTempDir = this.findFileInTempDir(filePath)) == null) {
            throw new IllegalArgumentException("Could not find file in temp dir: " + filePath);
        }
        return this.configureByFileInner(fileInTempDir);
    }

    @Override
    public void configureFromExistingVirtualFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(141);
        }
        this.configureByFileInner(virtualFile);
    }

    private PsiFile configureByFileInner(@NotNull VirtualFile copy) {
        if (copy == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(142);
        }
        return this.configureInner(copy, SelectionAndCaretMarkupLoader.fromFile(copy));
    }

    private PsiFile configureInner(@NotNull VirtualFile copy, @NotNull SelectionAndCaretMarkupLoader loader) {
        if (copy == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(143);
        }
        if (loader == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(144);
        }
        this.assertInitialized();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            if (copy == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(190);
            }
            if (loader == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(191);
            }
            if (!copy.getFileType().isBinary()) {
                try {
                    WriteAction.run(() -> {
                        if (copy == null) {
                            CodeInsightTestFixtureImpl.$$$reportNull$$$0(192);
                        }
                        if (loader == null) {
                            CodeInsightTestFixtureImpl.$$$reportNull$$$0(193);
                        }
                        copy.setBinaryContent(loader.newFileText.getBytes(copy.getCharset()));
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.myFile = copy;
            this.myEditor = this.createEditor(copy);
            if (this.myEditor == null) {
                Assert.fail((String)("editor couldn't be created for: " + copy.getPath() + ", use copyFileToProject() instead of configureByFile()"));
            }
            EditorTestUtil.setCaretsAndSelection(this.myEditor, loader.caretState);
            Module module2 = this.getModule();
            if (module2 != null) {
                for (Facet facet : FacetManager.getInstance((Module)module2).getAllFacets()) {
                    ((FacetManagerListener)module2.getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged(facet);
                }
            }
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            if (this.myCaresAboutInjection) {
                this.setupEditorForInjectedLanguage();
            }
        }));
        return this.getFile();
    }

    protected void prepareVirtualFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(145);
        }
    }

    private void setupEditorForInjectedLanguage() {
        Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.getFile());
        if (editor instanceof EditorWindow) {
            this.myFile = ((EditorWindow)editor).getInjectedFile().getViewProvider().getVirtualFile();
            this.myEditor = editor;
        }
    }

    @Override
    public VirtualFile findFileInTempDir(@NotNull String filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(146);
        }
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            return this.myTempDirFixture.getFile(filePath);
        }
        String fullPath = this.getTempDirPath() + "/" + filePath;
        VirtualFile copy = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath.replace(File.separatorChar, '/'));
        Assert.assertNotNull((String)("file " + fullPath + " not found"), (Object)copy);
        VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(copy, filePath);
        return copy;
    }

    @Nullable
    protected Editor createEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(147);
        }
        Project project2 = this.getProject();
        FileEditorManager instance2 = FileEditorManager.getInstance((Project)project2);
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        Editor editor = instance2.openTextEditor(new OpenFileDescriptor(project2, file2), false);
        EditorTestUtil.waitForLoading(editor);
        if (editor != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
        }
        return editor;
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, false);
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) {
        ExpectedHighlightingData data = new ExpectedHighlightingData(this.myEditor.getDocument(), checkWarnings, checkWeakWarnings, checkInfos, ignoreExtraHighlighting, this.getHostFile());
        data.init();
        return this.collectAndCheckHighlighting(data);
    }

    private PsiFile getHostFile() {
        return InjectedLanguageUtil.getTopLevelFile((PsiElement)this.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long collectAndCheckHighlighting(@NotNull ExpectedHighlightingData data) {
        List<HighlightInfo> infos;
        if (data == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(148);
        }
        Project project2 = this.getProject();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> PsiDocumentManager.getInstance((Project)project2).commitAllDocuments()));
        PsiFileImpl file2 = (PsiFileImpl)this.getHostFile();
        FileElement hardRefToFileElement = file2.calcTreeElement();
        if (!DumbService.isDumb((Project)project2)) {
            CacheManager.SERVICE.getInstance(project2).getFilesWithWord("XXX", (short)2, GlobalSearchScope.allScope((Project)project2), true);
        }
        long start = System.currentTimeMillis();
        VirtualFileFilter fileTreeAccessFilter = this.myVirtualFileFilter;
        Disposable disposable = Disposer.newDisposable();
        if (fileTreeAccessFilter != null) {
            PsiManagerEx.getInstanceEx(project2).setAssertOnFileLoadingFilter(fileTreeAccessFilter, disposable);
        }
        try {
            infos = this.doHighlighting();
            CodeInsightTestFixtureImpl.removeDuplicatedRangesForInjected(infos);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
        long elapsed = System.currentTimeMillis() - start;
        data.checkResult(infos, file2.getText());
        if (data.hasLineMarkers()) {
            Document document = this.getDocument(this.getFile());
            data.checkLineMarkers(DaemonCodeAnalyzerImpl.getLineMarkers(document, this.getProject()), document.getText());
        }
        hardRefToFileElement.hashCode();
        return elapsed;
    }

    public void setVirtualFileFilter(@Nullable VirtualFileFilter filter2) {
        this.myVirtualFileFilter = filter2;
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting() {
        Project project2 = this.getProject();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> PsiDocumentManager.getInstance((Project)project2).commitAllDocuments()));
        PsiFile file2 = this.getFile();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file2 = InjectedLanguageUtil.getTopLevelFile((PsiElement)file2);
        }
        Assert.assertNotNull((Object)file2);
        List<HighlightInfo> list2 = CodeInsightTestFixtureImpl.instantiateAndRun(file2, editor, ArrayUtil.EMPTY_INT_ARRAY, this.myAllowDirt);
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(149);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting(@NotNull HighlightSeverity minimalSeverity) {
        if (minimalSeverity == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(150);
        }
        List list2 = ContainerUtil.filter(this.doHighlighting(), info -> {
            if (minimalSeverity == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(189);
            }
            return info.getSeverity().compareTo(minimalSeverity) >= 0;
        });
        if (list2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(151);
        }
        return list2;
    }

    @Override
    @NotNull
    public String getTestDataPath() {
        String string = this.myTestDataPath;
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(152);
        }
        return string;
    }

    @Override
    public void setTestDataPath(@NotNull String dataPath) {
        if (dataPath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(153);
        }
        this.myTestDataPath = dataPath;
    }

    @Override
    public Project getProject() {
        return this.myProjectFixture.getProject();
    }

    @Override
    public Module getModule() {
        return this.myProjectFixture.getModule();
    }

    @Override
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public int getCaretOffset() {
        return this.myEditor.getCaretModel().getOffset();
    }

    @Override
    public PsiFile getFile() {
        return this.myFile != null ? (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(this.myFile)) : null;
    }

    @Override
    public void allowTreeAccessForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(154);
        }
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForFile(file2);
    }

    @Override
    public void allowTreeAccessForAllFiles() {
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForAllFiles();
    }

    private void checkResultByFile(@NotNull String expectedFile, @NotNull PsiFile originalFile, boolean stripTrailingSpaces) {
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(155);
        }
        if (originalFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(156);
        }
        if (!stripTrailingSpaces) {
            EditorUtil.fillVirtualSpaceUntilCaret(this.myEditor);
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        String fileText = originalFile.getText();
        String path = this.getTestDataPath() + "/" + expectedFile;
        String charset = Optional.ofNullable(originalFile.getVirtualFile()).map(f -> f.getCharset().name()).orElse(null);
        this.checkResult(expectedFile, stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromFile(path, charset), fileText);
    }

    private void checkResult(@NotNull String expectedFile, boolean stripTrailingSpaces, @NotNull SelectionAndCaretMarkupLoader loader, @NotNull String actualText) {
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(157);
        }
        if (loader == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(158);
        }
        if (actualText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(159);
        }
        this.assertInitialized();
        Project project2 = this.getProject();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        UsefulTestCase.doPostponedFormatting(this.getProject());
        if (stripTrailingSpaces) {
            actualText = this.stripTrailingSpaces(actualText);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        String newFileText1 = loader.newFileText;
        if (stripTrailingSpaces) {
            newFileText1 = this.stripTrailingSpaces(newFileText1);
        }
        if (!Comparing.equal((String)newFileText1, (String)(actualText = StringUtil.convertLineSeparators((String)actualText)))) {
            if (loader.filePath != null) {
                throw new FileComparisonFailure(expectedFile, newFileText1, actualText, loader.filePath);
            }
            throw new ComparisonFailure(expectedFile, newFileText1, actualText);
        }
        EditorTestUtil.verifyCaretAndSelectionState(editor, loader.caretState, expectedFile);
    }

    @NotNull
    private String stripTrailingSpaces(@NotNull String actualText) {
        if (actualText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(160);
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)actualText);
        ((DocumentImpl)document).stripTrailingSpaces(this.getProject());
        String string = actualText = document.getText();
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(161);
        }
        return string;
    }

    public void canChangeDocumentDuringHighlighting(boolean canI) {
        this.myAllowDirt = canI;
    }

    @NotNull
    public String getFoldingDescription(boolean withCollapseStatus) {
        CodeFoldingManager.getInstance(this.getProject()).buildInitialFoldings(this.myEditor);
        String string = CodeInsightTestFixtureImpl.getTagsFromSegments(this.myEditor.getDocument().getText(), Arrays.asList(this.myEditor.getFoldingModel().getAllFoldRegions()), FOLD, foldRegion -> "text='" + foldRegion.getPlaceholderText() + "'" + (withCollapseStatus ? " expand='" + foldRegion.isExpanded() + "'" : ""));
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(162);
        }
        return string;
    }

    @NotNull
    public static <T extends Segment> String getTagsFromSegments(@NotNull String text2, @NotNull Collection<T> segments, @NotNull String tagName, @Nullable Function<T, String> attrCalculator) {
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(163);
        }
        if (segments == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(164);
        }
        if (tagName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(165);
        }
        LinkedList<Border> borders = new LinkedList<Border>();
        for (Segment region : segments) {
            String attr = attrCalculator == null ? null : (String)attrCalculator.fun((Object)region);
            borders.add(new Border(true, region.getStartOffset(), attr));
            borders.add(new Border(false, region.getEndOffset(), ""));
        }
        Collections.sort(borders);
        StringBuilder result2 = new StringBuilder(text2);
        for (Border border : borders) {
            StringBuilder info = new StringBuilder();
            info.append('<');
            if (border.isLeftBorder) {
                info.append(tagName);
                if (border.text != null) {
                    info.append(' ').append(border.text);
                }
            } else {
                info.append('/').append(tagName);
            }
            info.append('>');
            result2.insert(border.offset, info);
        }
        String string = result2.toString();
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(166);
        }
        return string;
    }

    private void testFoldingRegions(@NotNull String verificationFileName, @Nullable String destinationFileName, boolean doCheckCollapseStatus) {
        String expectedContent;
        File verificationFile;
        if (verificationFileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(167);
        }
        try {
            verificationFile = new File(verificationFileName);
            expectedContent = FileUtil.loadFile((File)verificationFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertNotNull((Object)expectedContent);
        expectedContent = StringUtil.replace((String)expectedContent, (String)"\r", (String)"");
        String cleanContent = expectedContent.replaceAll("<fold\\stext='[^']*'(\\sexpand='[^']*')*>", "").replace("</fold>", "");
        if (destinationFileName == null) {
            this.configureByText(FileTypeManager.getInstance().getFileTypeByFileName(verificationFileName), cleanContent);
        } else {
            try {
                FileUtil.writeToFile((File)new File(destinationFileName), (String)cleanContent);
                VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(destinationFileName);
                Assert.assertNotNull((Object)file2);
                this.configureFromExistingVirtualFile(file2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String actual = this.getFoldingDescription(doCheckCollapseStatus);
        if (!expectedContent.equals(actual)) {
            throw new FileComparisonFailure(verificationFile.getName(), expectedContent, actual, verificationFile.getPath());
        }
    }

    @Override
    public void testFoldingWithCollapseStatus(@NotNull String verificationFileName) {
        if (verificationFileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(168);
        }
        this.testFoldingRegions(verificationFileName, null, true);
    }

    @Override
    public void testFoldingWithCollapseStatus(@NotNull String verificationFileName, @Nullable String destinationFileName) {
        if (verificationFileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(169);
        }
        this.testFoldingRegions(verificationFileName, destinationFileName, true);
    }

    @Override
    public void testFolding(@NotNull String verificationFileName) {
        if (verificationFileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(170);
        }
        this.testFoldingRegions(verificationFileName, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testRainbow(@NotNull String fileName, @NotNull String text2, boolean isRainbowOn, boolean withColor) {
        if (fileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(171);
        }
        if (text2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(172);
        }
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        boolean isRainbowOnInScheme = RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)globalScheme, null);
        try {
            RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)globalScheme, null, isRainbowOn);
            this.configureByText(fileName, text2.replaceAll("<rainbow(\\scolor='[^']*')?>", "").replace("</rainbow>", ""));
            List highlighting = ContainerUtil.filter(this.doHighlighting(), info -> info.type == RainbowHighlighter.RAINBOW_ELEMENT);
            Assert.assertEquals((Object)text2, (Object)CodeInsightTestFixtureImpl.getTagsFromSegments(this.myEditor.getDocument().getText(), highlighting, RAINBOW, highlightInfo -> {
                if (!withColor) {
                    return null;
                }
                TextAttributes attributes = highlightInfo.getTextAttributes(null, null);
                String color = attributes == null ? "null" : (attributes.getForegroundColor() == null ? "null" : Integer.toHexString(attributes.getForegroundColor().getRGB()));
                return "color='" + color + "'";
            }));
        }
        finally {
            RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)globalScheme, null, isRainbowOnInScheme);
        }
    }

    @Override
    public void testInlays() {
        InlayHintsChecker checker = new InlayHintsChecker(this);
        try {
            checker.setUp();
            checker.checkInlays();
        }
        finally {
            checker.tearDown();
        }
    }

    @Override
    public void checkResultWithInlays(String text2) {
        DocumentImpl checkDocument = new DocumentImpl(text2);
        InlayHintsChecker checker = new InlayHintsChecker(this);
        CaretAndInlaysInfo inlaysAndCaretInfo = checker.extractInlaysAndCaretInfo(checkDocument);
        this.checkResult(checkDocument.getText());
        checker.verifyInlaysAndCaretInfo(inlaysAndCaretInfo, text2);
    }

    @Override
    public void assertPreferredCompletionItems(int selected, String ... expected) {
        if (expected == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(173);
        }
        LookupImpl lookup = this.getLookup();
        Assert.assertNotNull((String)"No lookup is shown", (Object)lookup);
        JList list2 = lookup.getList();
        List<String> strings = this.getLookupElementStrings();
        Assert.assertNotNull(strings);
        List<String> actual = strings.subList(0, Math.min(expected.length, strings.size()));
        if (!actual.equals(Arrays.asList(expected))) {
            UsefulTestCase.assertOrderedEquals(DumpLookupElementWeights.getLookupElementWeights(lookup, false), expected);
        }
        if (selected != list2.getSelectedIndex()) {
            System.out.println(DumpLookupElementWeights.getLookupElementWeights(lookup, false));
        }
        Assert.assertEquals((long)selected, (long)list2.getSelectedIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void testStructureView(@NotNull Consumer<StructureViewComponent> consumer) {
        if (consumer == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(174);
        }
        Assert.assertNotNull((String)"configure first", (Object)this.myFile);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(this.myFile);
        Assert.assertNotNull((String)("editor not opened for " + this.myFile), (Object)this.myFile);
        StructureViewBuilder builder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(this.getFile());
        Assert.assertNotNull((String)("no builder for " + this.myFile), (Object)builder);
        StructureViewComponent component = null;
        try {
            component = (StructureViewComponent)builder.createStructureView(fileEditor, this.getProject());
            PlatformTestUtil.waitForPromise(component.rebuildAndUpdate());
            consumer.consume((Object)component);
            if (component == null) return;
        }
        catch (Throwable throwable) {
            if (component == null) throw throwable;
            Disposer.dispose(component);
            throw throwable;
        }
        Disposer.dispose((Disposable)component);
    }

    @Override
    public void setCaresAboutInjection(boolean caresAboutInjection) {
        this.myCaresAboutInjection = caresAboutInjection;
    }

    @Override
    public LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getActiveLookup(this.myEditor);
    }

    @Override
    @NotNull
    public List<Object> getGotoClassResults(@NotNull String pattern, boolean searchEverywhere, @Nullable PsiElement contextForSorting) {
        if (pattern == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(175);
        }
        ChooseByNameBase chooseByNamePopup = this.getMockChooseByNamePopup(contextForSorting);
        ArrayList<Object> results = new ArrayList<Object>();
        chooseByNamePopup.getProvider().filterElements(chooseByNamePopup, chooseByNamePopup.transformPattern(pattern), searchEverywhere, (ProgressIndicator)new MockProgressIndicator(), (Processor<Object>)new CommonProcessors.CollectProcessor(results));
        ArrayList<Object> arrayList = results;
        if (arrayList == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(176);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Crumb> getBreadcrumbsAtCaret() {
        PsiElement element = this.getFile().findElementAt(this.getCaretOffset());
        if (element == null) {
            List<Crumb> list2 = Collections.emptyList();
            if (list2 == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(177);
            }
            return list2;
        }
        Language language = element.getContainingFile().getLanguage();
        BreadcrumbsProvider provider = BreadcrumbsUtil.getInfoProvider((Language)language);
        if (provider == null) {
            List<Crumb> list3 = Collections.emptyList();
            if (list3 == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(178);
            }
            return list3;
        }
        ArrayList<Crumb.Impl> result2 = new ArrayList<Crumb.Impl>();
        while (element != null) {
            if (provider.acceptElement(element)) {
                result2.add(new Crumb.Impl(provider.getElementIcon(element), provider.getElementInfo(element), provider.getElementTooltip(element)));
            }
            element = provider.getParent(element);
        }
        List list4 = ContainerUtil.reverse(result2);
        if (list4 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(179);
        }
        return list4;
    }

    @NotNull
    private ChooseByNameBase getMockChooseByNamePopup(@Nullable PsiElement contextForSorting) {
        Project project2 = this.getProject();
        if (contextForSorting != null) {
            ChooseByNamePopup chooseByNamePopup = ChooseByNamePopup.createPopup(project2, (ChooseByNameModel)new GotoClassModel2(project2), contextForSorting);
            if (chooseByNamePopup == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(180);
            }
            return chooseByNamePopup;
        }
        if (this.myChooseByNamePopup == null) {
            this.myChooseByNamePopup = ChooseByNamePopup.createPopup(project2, (ChooseByNameModel)new GotoClassModel2(project2), (PsiElement)null);
        }
        ChooseByNameBase chooseByNameBase = this.myChooseByNamePopup;
        if (chooseByNameBase == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(181);
        }
        return chooseByNameBase;
    }

    protected void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        if (this.myEditor instanceof EditorWindow) {
            Document document = ((DocumentWindow)this.myEditor.getDocument()).getDelegate();
            this.myFile = FileDocumentManager.getInstance().getFile(document);
            this.myEditor = ((EditorWindow)this.myEditor).getDelegate();
        }
    }

    public static boolean invokeIntention(@NotNull IntentionAction action, PsiFile file2, Editor editor, String actionText) {
        if (action == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(182);
        }
        Project project2 = file2.getProject();
        ReadonlyStatusHandlerImpl handler2 = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)project2);
        VirtualFile vFile = Objects.requireNonNull(InjectedLanguageUtil.getTopLevelFile((PsiElement)file2)).getVirtualFile();
        CodeInsightTestFixtureImpl.setReadOnly(vFile, true);
        handler2.setClearReadOnlyInTests(true);
        AtomicBoolean result2 = new AtomicBoolean();
        try {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (action == null) {
                    CodeInsightTestFixtureImpl.$$$reportNull$$$0(188);
                }
                try {
                    result2.set(ShowIntentionActionsHandler.chooseActionAndInvoke(file2, editor, action, actionText));
                }
                catch (StubTextInconsistencyException e) {
                    PsiTestUtil.compareStubTexts(e);
                }
            });
            UIUtil.dispatchAllInvocationEvents();
            CodeInsightTestFixtureImpl.checkPsiTextConsistency(project2, vFile);
        }
        catch (AssertionError e) {
            ExceptionUtil.rethrowUnchecked((Throwable)ExceptionUtil.getRootCause((Throwable)((Object)e)));
            throw e;
        }
        finally {
            handler2.setClearReadOnlyInTests(false);
            CodeInsightTestFixtureImpl.setReadOnly(vFile, false);
        }
        return result2.get();
    }

    private static void checkPsiTextConsistency(Project project2, VirtualFile vFile) {
        PsiFile topLevelPsi;
        PsiFile psiFile = topLevelPsi = vFile.isValid() ? PsiManager.getInstance((Project)project2).findFile(vFile) : null;
        if (topLevelPsi != null) {
            PsiTestUtil.checkStubsMatchText(topLevelPsi);
        }
    }

    private static void setReadOnly(VirtualFile vFile, boolean readOnlyStatus) {
        try {
            WriteAction.run(() -> ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)vFile, (boolean)readOnlyStatus));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    @NotNull
    public Disposable getProjectDisposable() {
        Disposable disposable = this.myProjectFixture.getTestRootDisposable();
        if (disposable == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(183);
        }
        return disposable;
    }

    @Deprecated
    public static GlobalInspectionContextForTests createGlobalContextForTool(@NotNull AnalysisScope scope, @NotNull Project project2, @NotNull InspectionManagerEx inspectionManager, InspectionToolWrapper ... toolWrappers) {
        if (scope == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(184);
        }
        if (project2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(185);
        }
        if (inspectionManager == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(186);
        }
        if (toolWrappers == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(187);
        }
        return InspectionsKt.createGlobalContextForTool(scope, project2, Arrays.asList(toolWrappers));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 78: 
            case 87: 
            case 92: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 105: 
            case 108: 
            case 109: 
            case 115: 
            case 118: 
            case 130: 
            case 133: 
            case 149: 
            case 151: 
            case 152: 
            case 161: 
            case 162: 
            case 166: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 183: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 78: 
            case 87: 
            case 92: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 105: 
            case 108: 
            case 109: 
            case 115: 
            case 118: 
            case 130: 
            case 133: 
            case 149: 
            case 151: 
            case 152: 
            case 161: 
            case 162: 
            case 166: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 183: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDirTestFixture";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 36: 
            case 39: 
            case 119: 
            case 131: 
            case 138: 
            case 145: 
            case 147: 
            case 154: 
            case 201: 
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 200: 
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 78: 
            case 87: 
            case 92: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 105: 
            case 108: 
            case 109: 
            case 115: 
            case 118: 
            case 130: 
            case 133: 
            case 149: 
            case 151: 
            case 152: 
            case 161: 
            case 162: 
            case 166: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl";
                break;
            }
            case 8: 
            case 185: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspections";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 32: 
            case 35: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 55: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 34: 
            case 99: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 37: 
            case 101: 
            case 104: 
            case 107: 
            case 123: 
            case 127: 
            case 139: 
            case 140: 
            case 146: 
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDir";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 50: 
            case 52: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionName";
                break;
            }
            case 56: 
            case 91: 
            case 182: 
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 57: 
            case 59: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesBefore";
                break;
            }
            case 58: 
            case 61: 
            case 63: 
            case 67: 
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAfter";
                break;
            }
            case 60: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 62: 
            case 65: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBefore";
                break;
            }
            case 64: 
            case 68: 
            case 75: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalFiles";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedItems";
                break;
            }
            case 74: 
            case 77: 
            case 79: 
            case 80: 
            case 82: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 81: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 85: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 135: 
            case 137: 
            case 163: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 89: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 110: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 111: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 116: 
            case 117: 
            case 197: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 125: 
            case 126: 
            case 128: 
            case 155: 
            case 157: 
            case 194: 
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFile";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 136: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 142: 
            case 143: 
            case 190: 
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 144: 
            case 158: 
            case 191: 
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 150: 
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimalSeverity";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPath";
                break;
            }
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 159: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualText";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segments";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 167: 
            case 168: 
            case 169: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "verificationFileName";
                break;
            }
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateAndRun";
                break;
            }
            case 11: 
            case 46: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableIntentions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetAvailableIntentions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirFixture";
                break;
            }
            case 18: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFileToProject";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDirectoryToProject";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "testFile";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceAtCaretPositionWithAssertion";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllQuickFixes";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAvailableIntentions";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "findSingleIntention";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAtCaret";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorDataContext";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "testAction";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "testFindUsages";
                break;
            }
            case 96: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "testHighlightUsages";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "findGuttersAtCaret";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllGutters";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "completeBasicAllCarets";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "configureByFilesInner";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "configureByFiles";
                break;
            }
            case 149: 
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "doHighlighting";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPath";
                break;
            }
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "stripTrailingSpaces";
                break;
            }
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingDescription";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagsFromSegments";
                break;
            }
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoClassResults";
                break;
            }
            case 177: 
            case 178: 
            case 179: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreadcrumbsAtCaret";
                break;
            }
            case 180: 
            case 181: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockChooseByNamePopup";
                break;
            }
            case 183: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addGutterIconRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatedRangesForInjected";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "instantiateAndRun";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 78: 
            case 87: 
            case 92: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 105: 
            case 108: 
            case 109: 
            case 115: 
            case 118: 
            case 130: 
            case 133: 
            case 149: 
            case 151: 
            case 152: 
            case 161: 
            case 162: 
            case 166: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 183: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureIndexesUpToDate";
                break;
            }
            case 9: 
            case 10: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableIntentions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doGetAvailableIntentions";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyFileToProject";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "copyDirectoryToProject";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "enableInspections";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "disableInspections";
                break;
            }
            case 32: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "testHighlighting";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "testHighlightingAllFiles";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "testFile";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "openFileInEditor";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "testInspection";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAtCaretPosition";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAtCaretPositionWithAssertion";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getAllQuickFixes";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "filterAvailableIntentions";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findSingleIntention";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableIntention";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "launchAction";
                break;
            }
            case 57: 
            case 58: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "testCompletion";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "testCompletionTyping";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "testCompletionVariants";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "testRename";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "renameElementAtCaret";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "renameElementAtCaretUsingHandler";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "findElementByText";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "performEditorAction";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "_performEditorAction";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "testAction";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "testFindUsages";
                break;
            }
            case 95: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "testHighlightUsages";
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "findGutter";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "processGuttersAtCaret";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "findAllGutters";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "addFileToProject";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "complete";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "saveText";
                break;
            }
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 157: 
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "checkResult";
                break;
            }
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "checkResultByFile";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "configureByFilesInner";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "configureByFile";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "configureByFiles";
                break;
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "configureByText";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 139: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "configureByFileInner";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "configureFromTempProjectFile";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "configureFromExistingVirtualFile";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "configureInner";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "prepareVirtualFile";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "findFileInTempDir";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "collectAndCheckHighlighting";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "doHighlighting";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "setTestDataPath";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "allowTreeAccessForFile";
                break;
            }
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "stripTrailingSpaces";
                break;
            }
            case 163: 
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "getTagsFromSegments";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "testFoldingRegions";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "testFoldingWithCollapseStatus";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "testFolding";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "testRainbow";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "assertPreferredCompletionItems";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "testStructureView";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "getGotoClassResults";
                break;
            }
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "invokeIntention";
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "createGlobalContextForTool";
                break;
            }
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeIntention$31";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doHighlighting$25";
                break;
            }
            case 190: 
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "lambda$configureInner$22";
                break;
            }
            case 192: 
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$21";
                break;
            }
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkResultByFile$17";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkResultByFile$16";
                break;
            }
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "lambda$complete$15";
                break;
            }
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$14";
                break;
            }
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterAvailableIntentions$9";
                break;
            }
            case 200: 
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAvailableIntentions$5";
                break;
            }
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "lambda$ensureIndexesUpToDate$4";
                break;
            }
            case 203: 
            case 204: 
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "lambda$instantiateAndRun$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 78: 
            case 87: 
            case 92: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 105: 
            case 108: 
            case 109: 
            case 115: 
            case 118: 
            case 130: 
            case 133: 
            case 149: 
            case 151: 
            case 152: 
            case 161: 
            case 162: 
            case 166: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 183: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Border
    implements Comparable<Border> {
        private final boolean isLeftBorder;
        private final int offset;
        private final String text;

        private Border(boolean isLeftBorder, int offset, String text2) {
            this.isLeftBorder = isLeftBorder;
            this.offset = offset;
            this.text = text2;
        }

        @Override
        public int compareTo(@NotNull Border o) {
            if (o == null) {
                Border.$$$reportNull$$$0(0);
            }
            return this.offset < o.offset ? 1 : -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$Border", "compareTo"));
        }
    }

    private static class SelectionAndCaretMarkupLoader {
        private final String filePath;
        private final String newFileText;
        private final EditorTestUtil.CaretAndSelectionState caretState;

        private SelectionAndCaretMarkupLoader(@NotNull String fileText, String filePath) {
            if (fileText == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(0);
            }
            this.filePath = filePath;
            Document document = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            this.caretState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            this.newFileText = document.getText();
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromFile(@NotNull String path, String charset) {
            if (path == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(1);
            }
            SelectionAndCaretMarkupLoader selectionAndCaretMarkupLoader = SelectionAndCaretMarkupLoader.fromIoSource((ThrowableComputable<String, IOException>)((ThrowableComputable)() -> {
                if (path == null) {
                    SelectionAndCaretMarkupLoader.$$$reportNull$$$0(10);
                }
                return FileUtil.loadFile((File)new File(path), (String)charset);
            }), path);
            if (selectionAndCaretMarkupLoader == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(2);
            }
            return selectionAndCaretMarkupLoader;
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(3);
            }
            SelectionAndCaretMarkupLoader selectionAndCaretMarkupLoader = SelectionAndCaretMarkupLoader.fromIoSource((ThrowableComputable<String, IOException>)((ThrowableComputable)() -> {
                if (file2 == null) {
                    SelectionAndCaretMarkupLoader.$$$reportNull$$$0(9);
                }
                return VfsUtilCore.loadText((VirtualFile)file2);
            }), file2.getPath());
            if (selectionAndCaretMarkupLoader == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(4);
            }
            return selectionAndCaretMarkupLoader;
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromIoSource(@NotNull ThrowableComputable<String, IOException> source, String path) {
            SelectionAndCaretMarkupLoader selectionAndCaretMarkupLoader;
            block3: {
                if (source == null) {
                    SelectionAndCaretMarkupLoader.$$$reportNull$$$0(5);
                }
                try {
                    selectionAndCaretMarkupLoader = new SelectionAndCaretMarkupLoader(StringUtil.convertLineSeparators((String)((String)source.compute())), path);
                    if (selectionAndCaretMarkupLoader != null) break block3;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(6);
            }
            return selectionAndCaretMarkupLoader;
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromText(@NotNull String text2) {
            if (text2 == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(7);
            }
            SelectionAndCaretMarkupLoader selectionAndCaretMarkupLoader = new SelectionAndCaretMarkupLoader(text2, null);
            if (selectionAndCaretMarkupLoader == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(8);
            }
            return selectionAndCaretMarkupLoader;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileText";
                    break;
                }
                case 1: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$SelectionAndCaretMarkupLoader";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$SelectionAndCaretMarkupLoader";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromFile";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromIoSource";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fromFile";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "fromIoSource";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "fromText";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$fromFile$1";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$fromFile$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

