/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testIntegration.TestCreator;
import com.intellij.testIntegration.createTest.CreateTestAction;
import com.intellij.util.IncorrectOperationException;

public class JavaTestCreator
implements TestCreator {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.testIntegration.JavaTestCreator");

    public boolean isAvailable(Project project2, Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = JavaTestCreator.findElement(file2, offset);
        return CreateTestAction.isAvailableForElement(element);
    }

    public void createTest(Project project2, Editor editor, PsiFile file2) {
        try {
            CreateTestAction action = new CreateTestAction();
            PsiElement element = JavaTestCreator.findElement(file2, editor.getCaretModel().getOffset());
            if (CreateTestAction.isAvailableForElement(element)) {
                action.invoke(project2, editor, element);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static PsiElement findElement(PsiFile file2, int offset) {
        PsiElement element = file2.findElementAt(offset);
        if (element == null && offset == file2.getTextLength()) {
            element = file2.findElementAt(offset - 1);
        }
        return element;
    }
}

