/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.MessageView;
import java.util.ArrayList;
import java.util.List;

public class MessageViewImpl
implements MessageView {
    private ToolWindow myToolWindow;
    private final List<Runnable> myPostponedRunnables = new ArrayList<Runnable>();

    public MessageViewImpl(Project project2, StartupManager startupManager, ToolWindowManager toolWindowManager) {
        Runnable runnable2 = () -> {
            this.myToolWindow = toolWindowManager.registerToolWindow(ToolWindowId.MESSAGES_WINDOW, true, ToolWindowAnchor.BOTTOM, (Disposable)project2, true);
            this.myToolWindow.setIcon(AllIcons.Toolwindows.ToolWindowMessages);
            new ContentManagerWatcher(this.myToolWindow, this.getContentManager());
            for (Runnable postponedRunnable : this.myPostponedRunnables) {
                postponedRunnable.run();
            }
            this.myPostponedRunnables.clear();
        };
        if (project2.isInitialized()) {
            runnable2.run();
        } else {
            startupManager.registerPostStartupActivity(runnable2);
        }
    }

    @Override
    public ContentManager getContentManager() {
        return this.myToolWindow.getContentManager();
    }

    @Override
    public void runWhenInitialized(Runnable runnable2) {
        if (this.myToolWindow != null) {
            runnable2.run();
        } else {
            this.myPostponedRunnables.add(runnable2);
        }
    }
}

