/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.GroupedElementsRenderer;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class GroupedItemsListRenderer<E>
extends GroupedElementsRenderer.List
implements ListCellRenderer<E> {
    protected ListItemDescriptor<E> myDescriptor;
    protected JLabel myNextStepLabel;

    public JLabel getNextStepLabel() {
        return this.myNextStepLabel;
    }

    public GroupedItemsListRenderer(ListItemDescriptor<E> descriptor2) {
        this.myDescriptor = descriptor2;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends E> list2, E value2, int index, boolean isSelected, boolean cellHasFocus) {
        String caption = this.myDescriptor.getCaptionAboveOf(value2);
        boolean hasSeparator = this.myDescriptor.hasSeparatorAboveOf(value2);
        if (index == 0 && StringUtil.isEmptyOrSpaces((String)caption)) {
            hasSeparator = false;
        }
        Icon icon = this.myDescriptor.getIconFor(value2);
        JComponent result2 = this.configureComponent(this.myDescriptor.getTextFor(value2), this.myDescriptor.getTooltipFor(value2), icon, icon, isSelected, hasSeparator, caption, -1);
        this.customizeComponent(list2, value2, isSelected);
        return result2;
    }

    protected JComponent createItemComponent() {
        this.createLabel();
        return this.layoutComponent((JComponent)this.myTextLabel);
    }

    protected void createLabel() {
        this.myTextLabel = new ErrorLabel();
        this.myTextLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)1));
        this.myTextLabel.setOpaque(true);
    }

    protected final JComponent layoutComponent(JComponent middleItemComponent) {
        this.myNextStepLabel = new JLabel();
        this.myNextStepLabel.setOpaque(false);
        return JBUI.Panels.simplePanel((Component)middleItemComponent).addToRight((Component)this.myNextStepLabel).withBorder(this.getDefaultItemComponentBorder());
    }

    protected void customizeComponent(JList<? extends E> list2, E value2, boolean isSelected) {
    }
}

