/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.openapi.application.ClipboardAnalyzeListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.unscramble.UnscrambleDialog;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class UnscrambleListener
extends ClipboardAnalyzeListener {
    private static final Pattern STACKTRACE_LINE = Pattern.compile("[\t]*at [[_a-zA-Z0-9]+\\.]+[_a-zA-Z$0-9]+\\.[a-zA-Z0-9_]+\\([A-Za-z0-9_]+\\.java:[\\d]+\\)+[ [~]*\\[[a-zA-Z0-9\\.\\:/]\\]]*");

    @Override
    public boolean canHandle(@NotNull String value2) {
        if (value2 == null) {
            UnscrambleListener.$$$reportNull$$$0(0);
        }
        value2 = UnscrambleDialog.normalizeText(value2);
        int linesCount = 0;
        for (String line : value2.split("\n")) {
            if ((line = line.trim()).length() == 0) continue;
            linesCount = STACKTRACE_LINE.matcher(line = StringUtil.trimEnd((String)line, (String)"\r")).matches() ? ++linesCount : 0;
            if (linesCount <= 2) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void handle(@NotNull Project project2, @NotNull String value2) {
        if (project2 == null) {
            UnscrambleListener.$$$reportNull$$$0(1);
        }
        if (value2 == null) {
            UnscrambleListener.$$$reportNull$$$0(2);
        }
        UnscrambleDialog dialog2 = new UnscrambleDialog(project2);
        dialog2.createNormalizeTextAction().actionPerformed(null);
        if (!DumbService.isDumb((Project)project2)) {
            dialog2.doOKAction();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/unscramble/UnscrambleListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canHandle";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

