/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProviderEx;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaUsageTypeProvider
implements UsageTypeProviderEx {
    public UsageType getUsageType(PsiElement element) {
        return this.getUsageType(element, UsageTarget.EMPTY_ARRAY);
    }

    public UsageType getUsageType(PsiElement element, @NotNull UsageTarget[] targets) {
        UsageType classUsageType;
        if (targets == null) {
            JavaUsageTypeProvider.$$$reportNull$$$0(0);
        }
        if ((classUsageType = JavaUsageTypeProvider.getClassUsageType(element, targets)) != null) {
            return classUsageType;
        }
        UsageType methodUsageType = JavaUsageTypeProvider.getMethodUsageType(element);
        if (methodUsageType != null) {
            return methodUsageType;
        }
        if (element instanceof PsiLiteralExpression) {
            return UsageType.LITERAL_USAGE;
        }
        return null;
    }

    @Nullable
    private static UsageType getMethodUsageType(PsiElement element) {
        PsiMethod containerMethod;
        if (element instanceof PsiReferenceExpression && (containerMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) != null) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            PsiElement p = referenceExpression.getParent();
            if (p instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)p;
                PsiMethod calledMethod = callExpression.resolveMethod();
                if (calledMethod == containerMethod) {
                    return UsageType.RECURSION;
                }
                if (qualifier != null && !(qualifier instanceof PsiThisExpression) && calledMethod != null && Comparing.equal((String)containerMethod.getName(), (String)calledMethod.getName()) && JavaUsageTypeProvider.haveCommonSuperMethod(containerMethod, calledMethod)) {
                    boolean parametersDelegated = JavaUsageTypeProvider.parametersDelegated(containerMethod, callExpression);
                    if (qualifier instanceof PsiSuperExpression) {
                        return parametersDelegated ? UsageType.DELEGATE_TO_SUPER : UsageType.DELEGATE_TO_SUPER_PARAMETERS_CHANGED;
                    }
                    return parametersDelegated ? UsageType.DELEGATE_TO_ANOTHER_INSTANCE : UsageType.DELEGATE_TO_ANOTHER_INSTANCE_PARAMETERS_CHANGED;
                }
            }
        }
        return null;
    }

    private static boolean parametersDelegated(PsiMethod method, PsiMethodCallExpression call) {
        PsiExpression[] arguments;
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != (arguments = call.getArgumentList().getExpressions()).length) {
            return false;
        }
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            PsiExpression argument = arguments[i];
            if (!(argument instanceof PsiReferenceExpression)) {
                return false;
            }
            if (((PsiReferenceExpression)argument).isReferenceTo((PsiElement)parameter2)) continue;
            return false;
        }
        for (PsiParameter parameter3 : parameters2) {
            if (!HighlightControlFlowUtil.isAssigned(parameter3)) continue;
            return false;
        }
        return true;
    }

    private static boolean haveCommonSuperMethod(@NotNull PsiMethod m1, @NotNull PsiMethod m2) {
        PsiMethod me2;
        PsiMethod me1;
        if (m1 == null) {
            JavaUsageTypeProvider.$$$reportNull$$$0(1);
        }
        if (m2 == null) {
            JavaUsageTypeProvider.$$$reportNull$$$0(2);
        }
        ArrayDeque<PsiMethod> supers1Q = new ArrayDeque<PsiMethod>();
        supers1Q.add(m1);
        ArrayDeque<PsiMethod> supers2Q = new ArrayDeque<PsiMethod>();
        supers2Q.add(m2);
        THashSet supers1 = new THashSet();
        THashSet supers2 = new THashSet();
        do {
            if ((me1 = (PsiMethod)supers1Q.poll()) != null) {
                if (supers2.contains(me1)) {
                    return true;
                }
                supers1.add(me1);
                PsiSuperMethodImplUtil.processDirectSuperMethodsSmart(me1, (Processor<PsiMethod>)((Processor)psiMethod -> {
                    supers1Q.add((PsiMethod)psiMethod);
                    return true;
                }));
            }
            if ((me2 = (PsiMethod)supers2Q.poll()) == null) continue;
            if (supers1.contains(me2)) {
                return true;
            }
            supers2.add(me2);
            PsiSuperMethodImplUtil.processDirectSuperMethodsSmart(me2, (Processor<PsiMethod>)((Processor)psiMethod -> {
                supers2Q.add((PsiMethod)psiMethod);
                return true;
            }));
        } while (me1 != null || me2 != null);
        return false;
    }

    @Nullable
    private static UsageType getClassUsageType(@NotNull PsiElement element, @NotNull UsageTarget[] targets) {
        PsiJavaCodeReferenceElement classReference2;
        PsiTypeElement retType;
        PsiReferenceExpression expression2;
        PsiJavaCodeReferenceElement codeReference;
        if (element == null) {
            JavaUsageTypeProvider.$$$reportNull$$$0(3);
        }
        if (targets == null) {
            JavaUsageTypeProvider.$$$reportNull$$$0(4);
        }
        if ((codeReference = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiJavaCodeReferenceElement.class)) != null && JavaUsageTypeProvider.isNestedClassOf(codeReference, targets)) {
            return UsageType.CLASS_NESTED_CLASS_ACCESS;
        }
        if (element.getParent() instanceof PsiAnnotation && element == ((PsiAnnotation)element.getParent()).getNameReferenceElement()) {
            return UsageType.ANNOTATION;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class, (boolean)false) != null) {
            return UsageType.CLASS_IMPORT;
        }
        PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiReferenceList.class);
        if (referenceList != null) {
            if (referenceList.getParent() instanceof PsiClass) {
                return UsageType.CLASS_EXTENDS_IMPLEMENTS_LIST;
            }
            if (referenceList.getParent() instanceof PsiMethod) {
                return UsageType.CLASS_METHOD_THROWS_LIST;
            }
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeParameterList.class) != null || PsiTreeUtil.getParentOfType((PsiElement)element, PsiReferenceParameterList.class) != null) {
            return UsageType.TYPE_PARAMETER;
        }
        PsiTypeCastExpression castExpression = (PsiTypeCastExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeCastExpression.class);
        if (castExpression != null && PsiTreeUtil.isAncestor((PsiElement)castExpression.getCastType(), (PsiElement)element, (boolean)true)) {
            return UsageType.CLASS_CAST_TO;
        }
        PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiInstanceOfExpression.class);
        if (instanceOfExpression != null && PsiTreeUtil.isAncestor((PsiElement)instanceOfExpression.getCheckType(), (PsiElement)element, (boolean)true)) {
            return UsageType.CLASS_INSTANCE_OF;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiClassObjectAccessExpression.class) != null) {
            return UsageType.CLASS_CLASS_OBJECT_ACCESS;
        }
        PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodReferenceExpression.class);
        if (methodReferenceExpression != null && methodReferenceExpression.isConstructor()) {
            PsiElement qualifier = methodReferenceExpression.getQualifier();
            if (qualifier instanceof PsiTypeElement && ((PsiTypeElement)qualifier).getType() instanceof PsiArrayType) {
                return UsageType.CLASS_NEW_ARRAY;
            }
            return UsageType.CLASS_NEW_OPERATOR;
        }
        if (element instanceof PsiReferenceExpression && (expression2 = (PsiReferenceExpression)element).resolve() instanceof PsiClass) {
            return UsageType.CLASS_STATIC_MEMBER_ACCESS;
        }
        PsiParameter psiParameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class);
        if (psiParameter != null) {
            PsiElement scope = psiParameter.getDeclarationScope();
            if (scope instanceof PsiMethod) {
                return UsageType.CLASS_METHOD_PARAMETER_DECLARATION;
            }
            if (scope instanceof PsiCatchSection) {
                return UsageType.CLASS_CATCH_CLAUSE_PARAMETER_DECLARATION;
            }
            if (scope instanceof PsiForeachStatement) {
                return UsageType.CLASS_LOCAL_VAR_DECLARATION;
            }
            return null;
        }
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (psiField != null && PsiTreeUtil.isAncestor((PsiElement)psiField.getTypeElement(), (PsiElement)element, (boolean)true)) {
            return UsageType.CLASS_FIELD_DECLARATION;
        }
        PsiLocalVariable psiLocalVar = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class);
        if (psiLocalVar != null && PsiTreeUtil.isAncestor((PsiElement)psiLocalVar.getTypeElement(), (PsiElement)element, (boolean)true)) {
            return UsageType.CLASS_LOCAL_VAR_DECLARATION;
        }
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (psiMethod != null && (retType = psiMethod.getReturnTypeElement()) != null && PsiTreeUtil.isAncestor((PsiElement)retType, (PsiElement)element, (boolean)true)) {
            return UsageType.CLASS_METHOD_RETURN_TYPE;
        }
        PsiNewExpression psiNewExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
        if (psiNewExpression != null && (classReference2 = psiNewExpression.getClassOrAnonymousClassReference()) != null && PsiTreeUtil.isAncestor((PsiElement)classReference2, (PsiElement)element, (boolean)false)) {
            if (JavaUsageTypeProvider.isAnonymousClassOf(psiNewExpression.getAnonymousClass(), targets)) {
                return UsageType.CLASS_ANONYMOUS_NEW_OPERATOR;
            }
            if (JavaUsageTypeProvider.isNewArrayCreation(psiNewExpression)) {
                return UsageType.CLASS_NEW_ARRAY;
            }
            return UsageType.CLASS_NEW_OPERATOR;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class, (boolean)false) != null) {
            return UsageType.CLASS_IMPORT;
        }
        return null;
    }

    private static boolean isNewArrayCreation(@NotNull PsiNewExpression expression2) {
        if (expression2 == null) {
            JavaUsageTypeProvider.$$$reportNull$$$0(5);
        }
        return expression2.getArrayDimensions().length > 0 || expression2.getArrayInitializer() != null;
    }

    private static boolean isAnonymousClassOf(@Nullable PsiAnonymousClass anonymousClass, @NotNull UsageTarget[] targets) {
        if (targets == null) {
            JavaUsageTypeProvider.$$$reportNull$$$0(6);
        }
        if (anonymousClass == null) {
            return false;
        }
        return JavaUsageTypeProvider.qualifiesToTargetClasses(anonymousClass.getBaseClassReference(), targets);
    }

    private static boolean isNestedClassOf(PsiJavaCodeReferenceElement classReference2, @NotNull UsageTarget[] targets) {
        PsiElement qualifier;
        if (targets == null) {
            JavaUsageTypeProvider.$$$reportNull$$$0(7);
        }
        if ((qualifier = classReference2.getQualifier()) instanceof PsiJavaCodeReferenceElement) {
            return JavaUsageTypeProvider.qualifiesToTargetClasses((PsiJavaCodeReferenceElement)qualifier, targets) && classReference2.resolve() instanceof PsiClass;
        }
        return false;
    }

    private static boolean qualifiesToTargetClasses(@NotNull PsiJavaCodeReferenceElement qualifier, @NotNull UsageTarget[] targets) {
        if (qualifier == null) {
            JavaUsageTypeProvider.$$$reportNull$$$0(8);
        }
        if (targets == null) {
            JavaUsageTypeProvider.$$$reportNull$$$0(9);
        }
        for (UsageTarget target2 : targets) {
            PsiElement element;
            if (!(target2 instanceof PsiElementUsageTarget) || !((element = ((PsiElementUsageTarget)target2).getElement()) instanceof PsiClass) || !Comparing.equal((String)qualifier.getReferenceName(), (String)target2.getName())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/usages/impl/rules/JavaUsageTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUsageType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "haveCommonSuperMethod";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassUsageType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isNewArrayCreation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnonymousClassOf";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isNestedClassOf";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "qualifiesToTargetClasses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

