/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.InitialPatternConditionPlus;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;

public class PatternValuesIndex {
    public static Set<String> buildStringIndex(Collection<ElementPattern<?>> patterns) {
        THashSet result2 = new THashSet();
        PatternValuesIndex.processStringValues(patterns, (elementPattern, value2) -> {
            for (Object o : value2) {
                if (!(o instanceof String)) continue;
                result2.add((Object)((String)o));
            }
            return true;
        });
        return result2;
    }

    public static boolean processStringValues(Collection<ElementPattern<?>> patterns, PairProcessor<ElementPattern<?>, Collection<Object>> valueProcessor) {
        LinkedList<Object> stack = new LinkedList<Object>();
        for (ElementPattern<?> next : patterns) {
            stack.add(next);
            while (!stack.isEmpty()) {
                ElementPattern pattern = (ElementPattern)stack.removeFirst();
                ElementPatternCondition patternCondition = pattern.getCondition();
                InitialPatternCondition initialCondition = patternCondition.getInitialCondition();
                if (initialCondition instanceof InitialPatternConditionPlus) {
                    ContainerUtil.addAllNotNull(stack, (Iterable)((InitialPatternConditionPlus)initialCondition).getPatterns());
                }
                for (PatternCondition condition2 : patternCondition.getConditions()) {
                    if (condition2 instanceof PatternConditionPlus) {
                        stack.add(((PatternConditionPlus)condition2).getValuePattern());
                        continue;
                    }
                    if (!(condition2 instanceof ValuePatternCondition) || valueProcessor.process(next, (Object)((ValuePatternCondition)condition2).getValues())) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

