/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.SequentialTask;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SequentialModalProgressTask
extends Task.Modal {
    private static final Logger LOG = Logger.getInstance(SequentialModalProgressTask.class);
    private static final long DEFAULT_MIN_ITERATION_MIN_TIME = 500L;
    private long myMinIterationTime;
    private final String myTitle;
    private ProgressIndicator myIndicator;
    private SequentialTask myTask;

    public SequentialModalProgressTask(@Nullable Project project2, @NotNull String title) {
        if (title == null) {
            SequentialModalProgressTask.$$$reportNull$$$0(0);
        }
        this(project2, title, true);
    }

    public SequentialModalProgressTask(@Nullable Project project2, @NotNull String title, boolean canBeCancelled) {
        if (title == null) {
            SequentialModalProgressTask.$$$reportNull$$$0(1);
        }
        super(project2, title, canBeCancelled);
        this.myMinIterationTime = 500L;
        this.myTitle = title;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SequentialModalProgressTask.$$$reportNull$$$0(2);
        }
        try {
            this.doRun(indicator);
        }
        catch (Exception e) {
            LOG.info("Unexpected exception occurred during processing sequential task '" + this.myTitle + "'", (Throwable)e);
        }
        finally {
            indicator.stop();
        }
    }

    public void doRun(@NotNull ProgressIndicator indicator) throws InvocationTargetException, InterruptedException {
        SequentialTask task;
        if (indicator == null) {
            SequentialModalProgressTask.$$$reportNull$$$0(3);
        }
        if ((task = this.myTask) == null) {
            return;
        }
        this.myIndicator = indicator;
        indicator.setIndeterminate(false);
        this.prepare(task);
        while (!task.isDone()) {
            if (indicator.isCanceled()) {
                task.stop();
                break;
            }
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (indicator == null) {
                    SequentialModalProgressTask.$$$reportNull$$$0(5);
                }
                long start = System.currentTimeMillis();
                try {
                    while (!task.isDone() && System.currentTimeMillis() - start < this.myMinIterationTime) {
                        task.iteration(indicator);
                    }
                }
                catch (RuntimeException e) {
                    task.stop();
                    throw e;
                }
            });
        }
    }

    public void setMinIterationTime(long minIterationTime) {
        this.myMinIterationTime = minIterationTime;
    }

    public void setTask(@Nullable SequentialTask task) {
        this.myTask = task;
    }

    public ProgressIndicator getIndicator() {
        return this.myIndicator;
    }

    protected void prepare(@NotNull SequentialTask task) {
        if (task == null) {
            SequentialModalProgressTask.$$$reportNull$$$0(4);
        }
        task.prepare();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/SequentialModalProgressTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doRun";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doRun$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class Adapter
    extends SequentialModalProgressTask
    implements SequentialTask {
        public Adapter(@Nullable Project project2, @NotNull String title) {
            if (title == null) {
                Adapter.$$$reportNull$$$0(0);
            }
            super(project2, title);
            this.setTask(this);
        }

        public Adapter(@Nullable Project project2, @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                Adapter.$$$reportNull$$$0(1);
            }
            super(project2, title, canBeCancelled);
        }

        public void prepare() {
        }

        public void stop() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/SequentialModalProgressTask$Adapter", "<init>"));
        }
    }
}

