/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LocalFileUrl;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.io.URLUtil;
import gnu.trove.TObjectHashingStrategy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Urls {
    private static final Logger LOG = Logger.getInstance(Urls.class);
    private static final Pattern URI_PATTERN = Pattern.compile("^([^:/?#]+):(//)?([^/?#]*)([^?#;]*)(.*)");

    @NotNull
    public static Url newUri(@NotNull String scheme2, @NotNull String path) {
        if (scheme2 == null) {
            Urls.$$$reportNull$$$0(0);
        }
        if (path == null) {
            Urls.$$$reportNull$$$0(1);
        }
        UrlImpl urlImpl = new UrlImpl(scheme2, null, path);
        if (urlImpl == null) {
            Urls.$$$reportNull$$$0(2);
        }
        return urlImpl;
    }

    @NotNull
    public static Url newLocalFileUrl(@NotNull String path) {
        if (path == null) {
            Urls.$$$reportNull$$$0(3);
        }
        LocalFileUrl localFileUrl = new LocalFileUrl(FileUtilRt.toSystemIndependentName((String)path));
        if (localFileUrl == null) {
            Urls.$$$reportNull$$$0(4);
        }
        return localFileUrl;
    }

    @NotNull
    public static Url newLocalFileUrl(@NotNull VirtualFile file2) {
        if (file2 == null) {
            Urls.$$$reportNull$$$0(5);
        }
        LocalFileUrl localFileUrl = new LocalFileUrl(file2.getPath());
        if (localFileUrl == null) {
            Urls.$$$reportNull$$$0(6);
        }
        return localFileUrl;
    }

    @NotNull
    public static Url newFromEncoded(@NotNull String url) {
        Url result2;
        if (url == null) {
            Urls.$$$reportNull$$$0(7);
        }
        LOG.assertTrue((result2 = Urls.parseEncoded(url)) != null, (Object)url);
        Url url2 = result2;
        if (url2 == null) {
            Urls.$$$reportNull$$$0(8);
        }
        return url2;
    }

    @Nullable
    public static Url parseEncoded(@NotNull String url) {
        if (url == null) {
            Urls.$$$reportNull$$$0(9);
        }
        return Urls.parse(url, false);
    }

    @NotNull
    public static Url newHttpUrl(@NotNull String authority, @Nullable String path) {
        if (authority == null) {
            Urls.$$$reportNull$$$0(10);
        }
        Url url = Urls.newUrl("http", authority, path);
        if (url == null) {
            Urls.$$$reportNull$$$0(11);
        }
        return url;
    }

    @NotNull
    public static Url newHttpUrl(@NotNull String authority, @Nullable String path, @Nullable String parameters2) {
        if (authority == null) {
            Urls.$$$reportNull$$$0(12);
        }
        UrlImpl urlImpl = new UrlImpl("http", authority, path, parameters2);
        if (urlImpl == null) {
            Urls.$$$reportNull$$$0(13);
        }
        return urlImpl;
    }

    @NotNull
    public static Url newUrl(@NotNull String scheme2, @NotNull String authority, @Nullable String path) {
        if (scheme2 == null) {
            Urls.$$$reportNull$$$0(14);
        }
        if (authority == null) {
            Urls.$$$reportNull$$$0(15);
        }
        UrlImpl urlImpl = new UrlImpl(scheme2, authority, path);
        if (urlImpl == null) {
            Urls.$$$reportNull$$$0(16);
        }
        return urlImpl;
    }

    @NotNull
    public static Url newFromIdea(@NotNull CharSequence url) {
        Url result2;
        if (url == null) {
            Urls.$$$reportNull$$$0(17);
        }
        LOG.assertTrue((result2 = Urls.parseFromIdea(url)) != null, (Object)url);
        Url url2 = result2;
        if (url2 == null) {
            Urls.$$$reportNull$$$0(18);
        }
        return url2;
    }

    @Nullable
    public static Url parseFromIdea(@NotNull CharSequence url) {
        if (url == null) {
            Urls.$$$reportNull$$$0(19);
        }
        int n = url.length();
        for (int i = 0; i < n; ++i) {
            char c = url.charAt(i);
            if (c == ':') {
                return Urls.parseUrl(url);
            }
            if (c != '/' && c != '\\') continue;
            return Urls.newLocalFileUrl(url.toString());
        }
        return Urls.newLocalFileUrl(url.toString());
    }

    @Nullable
    public static Url parse(@NotNull String url, boolean asLocalIfNoScheme) {
        if (url == null) {
            Urls.$$$reportNull$$$0(20);
        }
        if (url.isEmpty()) {
            return null;
        }
        if (asLocalIfNoScheme && !URLUtil.containsScheme((String)url)) {
            return Urls.newLocalFileUrl(url);
        }
        return Urls.parseUrl(VfsUtilCore.toIdeaUrl((String)url));
    }

    @Nullable
    public static URI parseAsJavaUriWithoutParameters(@NotNull String url) {
        Url asUrl;
        if (url == null) {
            Urls.$$$reportNull$$$0(21);
        }
        if ((asUrl = Urls.parseUrl(url)) == null) {
            return null;
        }
        try {
            return Urls.toUriWithoutParameters(asUrl);
        }
        catch (Exception e) {
            LOG.info("Cannot parse url " + url, (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Url parseUrl(@NotNull CharSequence url) {
        boolean hasUrlSeparator;
        CharSequence urlToParse;
        Matcher matcher;
        if (url == null) {
            Urls.$$$reportNull$$$0(22);
        }
        if (!(matcher = URI_PATTERN.matcher(urlToParse = StringUtil.startsWith((CharSequence)url, (CharSequence)"jar:file://") ? url.subSequence("jar:".length(), url.length()) : url)).matches()) {
            return null;
        }
        String scheme2 = matcher.group(1);
        if (urlToParse != url) {
            scheme2 = "jar:" + scheme2;
        }
        String authority = StringUtil.nullize((String)matcher.group(3));
        String path = StringUtil.nullize((String)matcher.group(4));
        boolean bl = hasUrlSeparator = !StringUtil.isEmpty((String)matcher.group(2));
        if (authority == null) {
            if (hasUrlSeparator) {
                authority = "";
            }
        } else if ("file".equals(scheme2) || !hasUrlSeparator) {
            path = path == null ? authority : authority + path;
            String string = authority = hasUrlSeparator ? "" : null;
        }
        if (path != null && (!StringUtil.isEmpty((String)authority) || "file".equals(scheme2))) {
            path = FileUtil.toCanonicalUriPath((String)path);
        }
        return new UrlImpl(scheme2, authority, path, matcher.group(5));
    }

    @NotNull
    public static Url newFromVirtualFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            Urls.$$$reportNull$$$0(23);
        }
        if (file2.isInLocalFileSystem()) {
            Url url = Urls.newUri(file2.getFileSystem().getProtocol(), file2.getPath());
            if (url == null) {
                Urls.$$$reportNull$$$0(24);
            }
            return url;
        }
        Url url = Urls.parseUrl(file2.getUrl());
        Url url2 = url == null ? new UrlImpl(file2.getPath()) : url;
        if (url2 == null) {
            Urls.$$$reportNull$$$0(25);
        }
        return url2;
    }

    public static boolean equalsIgnoreParameters(@NotNull Url url, @NotNull Collection<Url> urls) {
        if (url == null) {
            Urls.$$$reportNull$$$0(26);
        }
        if (urls == null) {
            Urls.$$$reportNull$$$0(27);
        }
        return Urls.equalsIgnoreParameters(url, urls, true);
    }

    public static boolean equalsIgnoreParameters(@NotNull Url url, @NotNull Collection<Url> urls, boolean caseSensitive) {
        if (url == null) {
            Urls.$$$reportNull$$$0(28);
        }
        if (urls == null) {
            Urls.$$$reportNull$$$0(29);
        }
        for (Url otherUrl : urls) {
            if (!Urls.equals(url, otherUrl, caseSensitive, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreParameters(@NotNull Url url, @NotNull VirtualFile file2) {
        if (url == null) {
            Urls.$$$reportNull$$$0(30);
        }
        if (file2 == null) {
            Urls.$$$reportNull$$$0(31);
        }
        if (file2.isInLocalFileSystem()) {
            return url.isInLocalFileSystem() && (SystemInfoRt.isFileSystemCaseSensitive ? url.getPath().equals(file2.getPath()) : url.getPath().equalsIgnoreCase(file2.getPath()));
        }
        if (url.isInLocalFileSystem()) {
            return false;
        }
        Url fileUrl = Urls.parseUrl(file2.getUrl());
        return fileUrl != null && fileUrl.equalsIgnoreParameters(url);
    }

    public static boolean equals(@Nullable Url url1, @Nullable Url url2, boolean caseSensitive, boolean ignoreParameters) {
        if (url1 == null || url2 == null) {
            return url1 == url2;
        }
        Url o1 = ignoreParameters ? url1.trimParameters() : url1;
        Url o2 = ignoreParameters ? url2.trimParameters() : url2;
        return caseSensitive ? o1.equals(o2) : o1.equalsIgnoreCase(o2);
    }

    @NotNull
    public static URI toUriWithoutParameters(@NotNull Url url) {
        URI uRI;
        block4: {
            if (url == null) {
                Urls.$$$reportNull$$$0(32);
            }
            try {
                String externalPath = url.getPath();
                boolean inLocalFileSystem = url.isInLocalFileSystem();
                if (inLocalFileSystem && SystemInfoRt.isWindows && externalPath.charAt(0) != '/') {
                    externalPath = '/' + externalPath;
                }
                if ((uRI = new URI(inLocalFileSystem ? "file" : url.getScheme(), inLocalFileSystem ? "" : url.getAuthority(), externalPath, null, null)) != null) break block4;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            Urls.$$$reportNull$$$0(33);
        }
        return uRI;
    }

    public static TObjectHashingStrategy<Url> getCaseInsensitiveUrlHashingStrategy() {
        return CaseInsensitiveUrlHashingStrategy.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/Urls";
                break;
            }
            case 5: 
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authority";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/Urls";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "newUri";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newLocalFileUrl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "newFromEncoded";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newHttpUrl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "newUrl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "newFromIdea";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "newFromVirtualFile";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "toUriWithoutParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newUri";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 33: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newLocalFileUrl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newFromEncoded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseEncoded";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newHttpUrl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newUrl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "newFromIdea";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseFromIdea";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseAsJavaUriWithoutParameters";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseUrl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "newFromVirtualFile";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "equalsIgnoreParameters";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "toUriWithoutParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CaseInsensitiveUrlHashingStrategy
    implements TObjectHashingStrategy<Url> {
        private static final TObjectHashingStrategy<Url> INSTANCE = new CaseInsensitiveUrlHashingStrategy();

        private CaseInsensitiveUrlHashingStrategy() {
        }

        public int computeHashCode(Url url) {
            return url == null ? 0 : url.hashCodeCaseInsensitive();
        }

        public boolean equals(Url url1, Url url2) {
            return Urls.equals(url1, url2, false, false);
        }
    }
}

