/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.openapi.util.Iconable;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.util.ListWithSelection;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

public class ComboBoxTableCellEditor
extends DefaultCellEditor {
    public static final ComboBoxTableCellEditor INSTANCE = new ComboBoxTableCellEditor();
    private final JComboBox comboBox = (JComboBox)this.getComponent();

    public ComboBoxTableCellEditor() {
        super(new JComboBox(new ListComboBoxModel(Collections.emptyList())));
        this.comboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ComboBoxTableCellEditor.this.cancelCellEditing();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                ComboBoxTableCellEditor.this.cancelCellEditing();
            }
        });
        this.comboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list2, Object value2, int index, boolean selected, boolean hasFocus) {
                this.setIcon(value2 instanceof Iconable ? ((Iconable)value2).getIcon(1) : null);
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
        if (value2 instanceof ListWithSelection) {
            ListWithSelection options = (ListWithSelection)value2;
            this.comboBox.setModel(new ListComboBoxModel((List)options));
            if (options.getSelection() == null) {
                options.selectFirst();
            }
            this.comboBox.setSelectedItem(options.getSelection());
        } else {
            Enum enumValue = (Enum)value2;
            Class enumClass = enumValue.getDeclaringClass();
            ComboBoxModel model = this.comboBox.getModel();
            if (!(model instanceof EnumComboBoxModel) || model.getSize() <= 0 || ((Enum)model.getElementAt(0)).getDeclaringClass() != enumClass) {
                this.comboBox.setModel(new EnumComboBoxModel(enumClass));
            }
            this.comboBox.setSelectedItem(value2);
        }
        return this.comboBox;
    }
}

