/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import com.intellij.vcs.log.util.StopWatch;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainingBranchesGetter {
    private static final Logger LOG = Logger.getInstance(ContainingBranchesGetter.class);
    @NotNull
    private final SequentialLimitedLifoExecutor<Task> myTaskExecutor;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final List<Runnable> myLoadingFinishedListeners;
    @NotNull
    private SLRUMap<CommitId, List<String>> myCache;
    @NotNull
    private Map<VirtualFile, ContainedInBranchCondition> myConditions;
    private int myCurrentBranchesChecksum;

    ContainingBranchesGetter(@NotNull VcsLogData logData, @NotNull Disposable parentDisposable) {
        if (logData == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(1);
        }
        this.myLoadingFinishedListeners = ContainerUtil.newArrayList();
        this.myCache = ContainingBranchesGetter.createCache();
        this.myConditions = ContainerUtil.newHashMap();
        this.myLogData = logData;
        this.myTaskExecutor = new SequentialLimitedLifoExecutor(parentDisposable, 10, task -> {
            List<String> branches = task.getContainingBranches(this.myLogData);
            ApplicationManager.getApplication().invokeLater(() -> {
                ((Task)task).cache.put((Object)new CommitId(((Task)task).hash, ((Task)task).root), (Object)branches);
                this.notifyListeners();
            });
        });
        this.myLogData.addDataPackChangeListener(dataPack -> {
            Collection<VcsRef> currentBranches = dataPack.getRefsModel().getBranches();
            int checksum = currentBranches.hashCode();
            if (this.myCurrentBranchesChecksum != 0 && this.myCurrentBranchesChecksum != checksum) {
                this.clearCache();
            }
            this.myCurrentBranchesChecksum = checksum;
        });
    }

    private void clearCache() {
        this.myCache = ContainingBranchesGetter.createCache();
        this.myTaskExecutor.clear();
        Map<VirtualFile, ContainedInBranchCondition> conditions = this.myConditions;
        this.myConditions = ContainerUtil.newHashMap();
        for (ContainedInBranchCondition c : conditions.values()) {
            c.dispose();
        }
        ApplicationManager.getApplication().invokeLater(this::notifyListeners);
    }

    public void addTaskCompletedListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListeners.add(runnable2);
    }

    public void removeTaskCompletedListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListeners.remove(runnable2);
    }

    private void notifyListeners() {
        LOG.assertTrue(EventQueue.isDispatchThread());
        for (Runnable listener2 : this.myLoadingFinishedListeners) {
            listener2.run();
        }
    }

    @Nullable
    public List<String> requestContainingBranches(@NotNull VirtualFile root, @NotNull Hash hash) {
        if (root == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(4);
        }
        if (hash == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        List<String> refs = this.getContainingBranchesFromCache(root, hash);
        if (refs == null) {
            DataPack dataPack = this.myLogData.getDataPack();
            this.myTaskExecutor.queue(new Task(root, hash, this.myCache, dataPack.getPermanentGraph(), dataPack.getRefsModel()));
        }
        return refs;
    }

    @Nullable
    public List<String> getContainingBranchesFromCache(@NotNull VirtualFile root, @NotNull Hash hash) {
        if (root == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(6);
        }
        if (hash == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        return (List)this.myCache.get((Object)new CommitId(hash, root));
    }

    @Nullable
    public List<String> getContainingBranchesQuickly(@NotNull VirtualFile root, @NotNull Hash hash) {
        if (root == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(8);
        }
        if (hash == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(9);
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        CommitId commitId = new CommitId(hash, root);
        List<String> branches = (List<String>)this.myCache.get((Object)commitId);
        if (branches == null) {
            int nodeId;
            int index = this.myLogData.getCommitIndex(hash, root);
            PermanentGraph<Integer> pg = this.myLogData.getDataPack().getPermanentGraph();
            if (pg instanceof PermanentGraphInfo && (branches = (nodeId = ((PermanentGraphInfo)pg).getPermanentCommitsInfo().getNodeId(index)) < 10000 && ContainingBranchesGetter.canUseGraphForComputation(this.myLogData.getLogProvider(root)) ? this.getContainingBranchesSynchronously(root, hash) : (List)BackgroundTaskUtil.tryComputeFast(indicator -> {
                if (root == null) {
                    ContainingBranchesGetter.$$$reportNull$$$0(26);
                }
                if (hash == null) {
                    ContainingBranchesGetter.$$$reportNull$$$0(27);
                }
                return this.getContainingBranchesSynchronously(root, hash);
            }, 100L)) != null) {
                this.myCache.put((Object)commitId, branches);
            }
        }
        return branches;
    }

    @NotNull
    public Condition<CommitId> getContainedInBranchCondition(@NotNull String branchName, @NotNull VirtualFile root) {
        if (branchName == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(10);
        }
        if (root == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(11);
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        DataPack dataPack = this.myLogData.getDataPack();
        if (dataPack == DataPack.EMPTY) {
            Condition condition2 = Conditions.alwaysFalse();
            if (condition2 == null) {
                ContainingBranchesGetter.$$$reportNull$$$0(12);
            }
            return condition2;
        }
        PermanentGraph<Integer> graph = dataPack.getPermanentGraph();
        RefsModel refs = dataPack.getRefsModel();
        ContainedInBranchCondition condition3 = this.myConditions.get(root);
        if (condition3 == null || !condition3.getBranch().equals(branchName)) {
            VcsRef branchRef = (VcsRef)ContainerUtil.find((Iterable)refs.getBranches(), vcsRef -> {
                if (root == null) {
                    ContainingBranchesGetter.$$$reportNull$$$0(24);
                }
                if (branchName == null) {
                    ContainingBranchesGetter.$$$reportNull$$$0(25);
                }
                return vcsRef.getRoot().equals(root) && vcsRef.getName().equals(branchName);
            });
            if (branchRef == null) {
                Condition condition4 = Conditions.alwaysFalse();
                if (condition4 == null) {
                    ContainingBranchesGetter.$$$reportNull$$$0(13);
                }
                return condition4;
            }
            condition3 = new ContainedInBranchCondition((Condition<Integer>)graph.getContainedInBranchCondition(Collections.singleton(this.myLogData.getCommitIndex(branchRef.getCommitHash(), branchRef.getRoot()))), branchName);
            this.myConditions.put(root, condition3);
        }
        ContainedInBranchCondition containedInBranchCondition = condition3;
        if (containedInBranchCondition == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(14);
        }
        return containedInBranchCondition;
    }

    @NotNull
    private static SLRUMap<CommitId, List<String>> createCache() {
        SLRUMap sLRUMap = new SLRUMap(1000, 1000);
        if (sLRUMap == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(15);
        }
        return sLRUMap;
    }

    @NotNull
    public List<String> getContainingBranchesSynchronously(@NotNull VirtualFile root, @NotNull Hash hash) {
        if (root == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(16);
        }
        if (hash == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(17);
        }
        List<String> list2 = this.doGetContainingBranches(this.myLogData.getDataPack(), root, hash);
        if (list2 == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    private List<String> doGetContainingBranches(@NotNull DataPack dataPack, @NotNull VirtualFile root, @NotNull Hash hash) {
        if (dataPack == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(19);
        }
        if (root == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(20);
        }
        if (hash == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(21);
        }
        List<String> list2 = new Task(root, hash, this.myCache, dataPack.getPermanentGraph(), dataPack.getRefsModel()).getContainingBranches(this.myLogData);
        if (list2 == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(22);
        }
        return list2;
    }

    private static boolean canUseGraphForComputation(@NotNull VcsLogProvider logProvider) {
        if (logProvider == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(23);
        }
        return (Boolean)VcsLogProperties.get((VcsLogProvider)logProvider, (VcsLogProperties.VcsLogProperty)VcsLogProperties.LIGHTWEIGHT_BRANCHES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 16: 
            case 20: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 17: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 10: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/ContainingBranchesGetter";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/ContainingBranchesGetter";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainedInBranchCondition";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createCache";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingBranchesSynchronously";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetContainingBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTaskCompletedListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeTaskCompletedListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "requestContainingBranches";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranchesFromCache";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranchesQuickly";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContainedInBranchCondition";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 22: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranchesSynchronously";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doGetContainingBranches";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "canUseGraphForComputation";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getContainedInBranchCondition$4";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getContainingBranchesQuickly$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ContainedInBranchCondition
    implements Condition<CommitId> {
        @NotNull
        private final Condition<Integer> myCondition;
        @NotNull
        private final String myBranch;
        private volatile boolean isDisposed;

        public ContainedInBranchCondition(@NotNull Condition<Integer> condition2, String branch) {
            if (condition2 == null) {
                ContainedInBranchCondition.$$$reportNull$$$0(0);
            }
            if (branch == null) {
                ContainedInBranchCondition.$$$reportNull$$$0(1);
            }
            this.isDisposed = false;
            this.myCondition = condition2;
            this.myBranch = branch;
        }

        @NotNull
        public String getBranch() {
            String string = this.myBranch;
            if (string == null) {
                ContainedInBranchCondition.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean value(CommitId commitId) {
            if (this.isDisposed) {
                return false;
            }
            return this.myCondition.value((Object)ContainingBranchesGetter.this.myLogData.getCommitIndex(commitId.getHash(), commitId.getRoot()));
        }

        public void dispose() {
            this.isDisposed = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branch";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/ContainingBranchesGetter$ContainedInBranchCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/ContainingBranchesGetter$ContainedInBranchCondition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBranch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Task {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final Hash hash;
        @NotNull
        private final SLRUMap<CommitId, List<String>> cache;
        @NotNull
        private final RefsModel refs;
        @NotNull
        private final PermanentGraph<Integer> graph;

        public Task(@NotNull VirtualFile root, @NotNull Hash hash, @NotNull SLRUMap<CommitId, List<String>> cache, @NotNull PermanentGraph<Integer> graph, @NotNull RefsModel refs) {
            if (root == null) {
                Task.$$$reportNull$$$0(0);
            }
            if (hash == null) {
                Task.$$$reportNull$$$0(1);
            }
            if (cache == null) {
                Task.$$$reportNull$$$0(2);
            }
            if (graph == null) {
                Task.$$$reportNull$$$0(3);
            }
            if (refs == null) {
                Task.$$$reportNull$$$0(4);
            }
            this.root = root;
            this.hash = hash;
            this.cache = cache;
            this.graph = graph;
            this.refs = refs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public List<String> getContainingBranches(@NotNull VcsLogData logData) {
            ArrayList<String> arrayList;
            StopWatch sw;
            block14: {
                ArrayList<String> arrayList2;
                block13: {
                    if (logData == null) {
                        Task.$$$reportNull$$$0(5);
                    }
                    sw = StopWatch.start("get containing branches");
                    try {
                        VcsLogProvider provider = logData.getLogProvider(this.root);
                        if (ContainingBranchesGetter.canUseGraphForComputation(provider)) {
                            Set branchesIndexes = this.graph.getContainingBranches((Object)logData.getCommitIndex(this.hash, this.root));
                            Collection branchesRefs = new HashSet();
                            for (Integer index : branchesIndexes) {
                                this.refs.refsToCommit(index).stream().filter(ref -> ref.getType().isBranch()).forEach(branchesRefs::add);
                            }
                            branchesRefs = ContainerUtil.sorted(branchesRefs, (Comparator)provider.getReferenceManager().getLabelsOrderComparator());
                            ArrayList<String> branchesList = new ArrayList<String>();
                            for (VcsRef ref2 : branchesRefs) {
                                branchesList.add(ref2.getName());
                            }
                            ArrayList<String> arrayList3 = branchesList;
                            arrayList2 = arrayList3;
                            break block13;
                        }
                        ArrayList<String> branches = new ArrayList<String>(provider.getContainingBranches(this.root, this.hash));
                        Collections.sort(branches);
                        ArrayList<String> arrayList4 = branches;
                        arrayList = arrayList4;
                        break block14;
                    }
                    catch (VcsException e) {
                        LOG.warn((Throwable)e);
                        List<String> list2 = Collections.emptyList();
                        List<String> list3 = list2;
                        if (list3 == null) {
                            Task.$$$reportNull$$$0(8);
                        }
                        return list3;
                    }
                }
                if (arrayList2 == null) {
                    Task.$$$reportNull$$$0(6);
                }
                return arrayList2;
            }
            if (arrayList == null) {
                Task.$$$reportNull$$$0(7);
            }
            return arrayList;
            finally {
                sw.report();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hash";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cache";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graph";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refs";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logData";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/ContainingBranchesGetter$Task";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/ContainingBranchesGetter$Task";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainingBranches";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getContainingBranches";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

