/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleTaskController<Request, Result>
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SingleTaskController.class);
    @NotNull
    private final Consumer<Result> myResultHandler;
    @NotNull
    private final Object LOCK;
    private final boolean myCancelRunning;
    @NotNull
    private List<Request> myAwaitingRequests;
    @Nullable
    private ProgressIndicator myRunningTask;
    private boolean myIsDisposed;

    public SingleTaskController(@NotNull Project project2, @NotNull Consumer<Result> handler2, boolean cancelRunning, @NotNull Disposable parent) {
        if (project2 == null) {
            SingleTaskController.$$$reportNull$$$0(0);
        }
        if (handler2 == null) {
            SingleTaskController.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            SingleTaskController.$$$reportNull$$$0(2);
        }
        this.LOCK = new Object();
        this.myIsDisposed = false;
        this.myResultHandler = handler2;
        this.myAwaitingRequests = ContainerUtil.newLinkedList();
        this.myCancelRunning = cancelRunning;
        Disposer.register((Disposable)parent, () -> Disposer.dispose((Disposable)this));
        Disposer.register((Disposable)project2, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void request(@NotNull Request requests) {
        if (requests == null) {
            SingleTaskController.$$$reportNull$$$0(3);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsDisposed) {
                return;
            }
            this.myAwaitingRequests.add(requests);
            LOG.debug("Added requests: " + requests);
            if (this.myRunningTask != null && this.myCancelRunning) {
                this.cancelTask(this.myRunningTask);
            }
            if (this.myRunningTask == null) {
                this.myRunningTask = this.startNewBackgroundTask();
                LOG.debug("Started a new bg task " + this.myRunningTask);
            }
        }
    }

    private void cancelTask(@NotNull ProgressIndicator t) {
        if (t == null) {
            SingleTaskController.$$$reportNull$$$0(4);
        }
        if (t.isRunning()) {
            t.cancel();
            LOG.debug("Canceled task " + this.myRunningTask);
        }
    }

    @NotNull
    protected abstract ProgressIndicator startNewBackgroundTask();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<Request> popRequests() {
        Object object = this.LOCK;
        // MONITORENTER : object
        List<Request> requests = this.myAwaitingRequests;
        this.myAwaitingRequests = ContainerUtil.newLinkedList();
        LOG.debug("Popped requests: " + requests);
        List<Request> list2 = requests;
        // MONITOREXIT : object
        if (list2 != null) return list2;
        SingleTaskController.$$$reportNull$$$0(5);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<Request> peekRequests() {
        Object object = this.LOCK;
        // MONITORENTER : object
        ArrayList requests = ContainerUtil.newArrayList(this.myAwaitingRequests);
        LOG.debug("Peeked requests: " + requests);
        ArrayList arrayList = requests;
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        SingleTaskController.$$$reportNull$$$0(6);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRequests(@NotNull List<Request> requests) {
        if (requests == null) {
            SingleTaskController.$$$reportNull$$$0(7);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myAwaitingRequests.removeAll(requests);
            LOG.debug("Removed requests: " + requests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Request popRequest() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myAwaitingRequests.isEmpty()) {
                return null;
            }
            Request request = this.myAwaitingRequests.remove(0);
            LOG.debug("Popped request: " + request);
            return request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void taskCompleted(@Nullable Result result2) {
        if (result2 != null) {
            this.myResultHandler.consume(result2);
            LOG.debug("Handled result: " + result2);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myAwaitingRequests.isEmpty()) {
                this.myRunningTask = null;
                LOG.debug("No more requests");
            } else {
                this.myRunningTask = this.startNewBackgroundTask();
                LOG.debug("Restarted a bg task " + this.myRunningTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsDisposed) {
                return;
            }
            this.myIsDisposed = true;
            if (this.myRunningTask != null) {
                this.myRunningTask.cancel();
                this.myRunningTask = null;
            }
            this.myAwaitingRequests.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/SingleTaskController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/SingleTaskController";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "popRequests";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "peekRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "request";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cancelTask";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeRequests";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

