/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogProgress
implements Disposable {
    @NotNull
    private final Object myLock;
    @NotNull
    private final List<ProgressListener> myListeners;
    @NotNull
    private final Set<ProgressIndicator> myTasksWithVisibleProgress;
    @NotNull
    private final Set<ProgressIndicator> myTasksWithSilentProgress;
    private boolean myDisposed;

    public VcsLogProgress(@NotNull Project project2, @NotNull Disposable parent) {
        if (project2 == null) {
            VcsLogProgress.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            VcsLogProgress.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myListeners = ContainerUtil.newArrayList();
        this.myTasksWithVisibleProgress = ContainerUtil.newHashSet();
        this.myTasksWithSilentProgress = ContainerUtil.newHashSet();
        this.myDisposed = false;
        Disposer.register((Disposable)parent, () -> Disposer.dispose((Disposable)this));
        Disposer.register((Disposable)project2, (Disposable)this);
    }

    @NotNull
    public ProgressIndicator createProgressIndicator() {
        ProgressIndicator progressIndicator = this.createProgressIndicator(true);
        if (progressIndicator == null) {
            VcsLogProgress.$$$reportNull$$$0(2);
        }
        return progressIndicator;
    }

    @NotNull
    public ProgressIndicator createProgressIndicator(boolean visible) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
            if (emptyProgressIndicator == null) {
                VcsLogProgress.$$$reportNull$$$0(3);
            }
            return emptyProgressIndicator;
        }
        VcsLogProgressIndicator vcsLogProgressIndicator = new VcsLogProgressIndicator(visible);
        if (vcsLogProgressIndicator == null) {
            VcsLogProgress.$$$reportNull$$$0(4);
        }
        return vcsLogProgressIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressIndicatorListener(@NotNull ProgressListener listener2, @Nullable Disposable parentDisposable) {
        if (listener2 == null) {
            VcsLogProgress.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.add(listener2);
            if (parentDisposable != null) {
                Disposer.register((Disposable)parentDisposable, () -> {
                    if (listener2 == null) {
                        VcsLogProgress.$$$reportNull$$$0(11);
                    }
                    this.removeProgressIndicatorListener(listener2);
                });
            }
            if (this.isRunning()) {
                ApplicationManager.getApplication().invokeLater(listener2::progressStarted);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressIndicatorListener(@NotNull ProgressListener listener2) {
        if (listener2 == null) {
            VcsLogProgress.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.remove(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.myLock;
        synchronized (object) {
            return !this.myTasksWithVisibleProgress.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void started(@NotNull VcsLogProgressIndicator indicator) {
        if (indicator == null) {
            VcsLogProgress.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed) {
                indicator.cancel();
                return;
            }
            if (indicator.isVisible()) {
                this.myTasksWithVisibleProgress.add(indicator);
                if (this.myTasksWithVisibleProgress.size() == 1) {
                    this.fireNotification(ProgressListener::progressStarted);
                }
            } else {
                this.myTasksWithSilentProgress.add(indicator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopped(@NotNull VcsLogProgressIndicator indicator) {
        if (indicator == null) {
            VcsLogProgress.$$$reportNull$$$0(8);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (indicator.isVisible()) {
                this.myTasksWithVisibleProgress.remove(indicator);
                if (this.myTasksWithVisibleProgress.isEmpty()) {
                    this.fireNotification(ProgressListener::progressStopped);
                }
            } else {
                this.myTasksWithSilentProgress.remove(indicator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNotification(@NotNull Consumer<ProgressListener> action) {
        if (action == null) {
            VcsLogProgress.$$$reportNull$$$0(9);
        }
        Object object = this.myLock;
        synchronized (object) {
            ArrayList list2 = ContainerUtil.newArrayList(this.myListeners);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (action == null) {
                    VcsLogProgress.$$$reportNull$$$0(10);
                }
                list2.forEach(action);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.myDisposed = true;
            for (ProgressIndicator indicator : this.myTasksWithVisibleProgress) {
                indicator.cancel();
            }
            for (ProgressIndicator indicator : this.myTasksWithSilentProgress) {
                indicator.cancel();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogProgress";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogProgress";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addProgressIndicatorListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeProgressIndicatorListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "started";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "stopped";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fireNotification";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fireNotification$2";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addProgressIndicatorListener$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProgressListener {
        public void progressStarted();

        public void progressStopped();
    }

    private class VcsLogProgressIndicator
    extends AbstractProgressIndicatorBase {
        private final boolean myVisible;

        private VcsLogProgressIndicator(boolean visible) {
            this.myVisible = visible;
        }

        @Override
        public synchronized void start() {
            super.start();
            VcsLogProgress.this.started(this);
        }

        @Override
        public synchronized void stop() {
            super.stop();
            VcsLogProgress.this.stopped(this);
        }

        public boolean isVisible() {
            return this.myVisible;
        }
    }
}

