/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.PersistentUtil;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;

public class VcsLogFullDetailsIndex<T>
implements Disposable {
    protected static final String INDEX = "index";
    @NotNull
    protected final MyMapReduceIndex myMapReduceIndex;
    @NotNull
    private final IndexId<Integer, T> myID;
    @NotNull
    private final String myLogId;
    @NotNull
    private final String myName;
    @NotNull
    protected final DataIndexer<Integer, T, VcsFullCommitDetails> myIndexer;
    @NotNull
    private final FatalErrorHandler myFatalErrorHandler;
    private volatile boolean myDisposed;

    public VcsLogFullDetailsIndex(@NotNull String logId, @NotNull String name2, int version, @NotNull DataIndexer<Integer, T, VcsFullCommitDetails> indexer, @NotNull DataExternalizer<T> externalizer, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (logId == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(1);
        }
        if (indexer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(2);
        }
        if (externalizer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(3);
        }
        if (fatalErrorHandler == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(4);
        }
        if (disposableParent == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(5);
        }
        this.myDisposed = false;
        this.myID = IndexId.create((String)name2);
        this.myName = name2;
        this.myLogId = logId;
        this.myIndexer = indexer;
        this.myFatalErrorHandler = fatalErrorHandler;
        this.myMapReduceIndex = new MyMapReduceIndex(this.myIndexer, externalizer, version);
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    @NotNull
    public TIntHashSet getCommitsWithAnyKey(@NotNull Set<Integer> keys) throws StorageException {
        if (keys == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(6);
        }
        this.checkDisposed();
        TIntHashSet result2 = new TIntHashSet();
        for (Integer key2 : keys) {
            this.iterateCommitIds(key2, (Consumer<Integer>)((Consumer)arg_0 -> ((TIntHashSet)result2).add(arg_0)));
        }
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(7);
        }
        return tIntHashSet;
    }

    @NotNull
    public TIntHashSet getCommitsWithAllKeys(@NotNull Collection<Integer> keys) throws StorageException {
        if (keys == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(8);
        }
        this.checkDisposed();
        TIntHashSet tIntHashSet = InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)this.myMapReduceIndex, keys, k -> {
            ProgressManager.checkCanceled();
            return true;
        }, null, null);
        if (tIntHashSet == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(9);
        }
        return tIntHashSet;
    }

    private void iterateCommitIds(int key2, @NotNull Consumer<Integer> consumer) throws StorageException {
        if (consumer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(10);
        }
        ValueContainer data = this.myMapReduceIndex.getData(key2);
        data.forEach((id, value2) -> {
            if (consumer == null) {
                VcsLogFullDetailsIndex.$$$reportNull$$$0(16);
            }
            consumer.consume((Object)id);
            return true;
        });
    }

    protected void iterateCommitIdsAndValues(int key2, @NotNull ObjIntConsumer<T> consumer) throws StorageException {
        if (consumer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(11);
        }
        this.myMapReduceIndex.getData(key2).forEach((id, value2) -> {
            if (consumer == null) {
                VcsLogFullDetailsIndex.$$$reportNull$$$0(15);
            }
            consumer.accept(value2, id);
            return true;
        });
    }

    protected boolean iterateCommitIdsAndValues(int key2, @NotNull BiPredicate<T, Integer> consumer) throws StorageException {
        if (consumer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(12);
        }
        return this.myMapReduceIndex.getData(key2).forEach((id, value2) -> {
            if (consumer == null) {
                VcsLogFullDetailsIndex.$$$reportNull$$$0(14);
            }
            return consumer.test(value2, id);
        });
    }

    public void update(int commitId, @NotNull VcsFullCommitDetails details) {
        if (details == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(13);
        }
        this.checkDisposed();
        this.myMapReduceIndex.update(commitId, details).compute();
    }

    public void flush() throws StorageException {
        this.checkDisposed();
        this.myMapReduceIndex.flush();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myMapReduceIndex.dispose();
    }

    private void checkDisposed() {
        if (this.myDisposed) {
            throw new ProcessCanceledException();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsWithAnyKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsWithAllKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsWithAnyKey";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsWithAllKeys";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "iterateCommitIds";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "iterateCommitIdsAndValues";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$iterateCommitIdsAndValues$3";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$iterateCommitIdsAndValues$2";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$iterateCommitIds$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyForwardIndex<T>
    implements ForwardIndex<Integer, T> {
        private EmptyForwardIndex() {
        }

        @NotNull
        public InputDataDiffBuilder<Integer, T> getDiffBuilder(int inputId) {
            EmptyInputDataDiffBuilder emptyInputDataDiffBuilder = new EmptyInputDataDiffBuilder(inputId);
            if (emptyInputDataDiffBuilder == null) {
                EmptyForwardIndex.$$$reportNull$$$0(0);
            }
            return emptyInputDataDiffBuilder;
        }

        public void putInputData(int inputId, @NotNull Map<Integer, T> data) {
            if (data == null) {
                EmptyForwardIndex.$$$reportNull$$$0(1);
            }
        }

        public void flush() {
        }

        public void clear() {
        }

        public void close() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$EmptyForwardIndex";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDiffBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$EmptyForwardIndex";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "putInputData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyIndexExtension
    extends IndexExtension<Integer, T, VcsFullCommitDetails> {
        @NotNull
        private final DataIndexer<Integer, T, VcsFullCommitDetails> myIndexer;
        @NotNull
        private final DataExternalizer<T> myExternalizer;
        private final int myVersion;

        public MyIndexExtension(@NotNull DataIndexer<Integer, T, VcsFullCommitDetails> indexer, DataExternalizer<T> externalizer, int version) {
            if (indexer == null) {
                MyIndexExtension.$$$reportNull$$$0(0);
            }
            if (externalizer == null) {
                MyIndexExtension.$$$reportNull$$$0(1);
            }
            this.myIndexer = indexer;
            this.myExternalizer = externalizer;
            this.myVersion = version;
        }

        @NotNull
        public IndexId<Integer, T> getName() {
            IndexId indexId = VcsLogFullDetailsIndex.this.myID;
            if (indexId == null) {
                MyIndexExtension.$$$reportNull$$$0(2);
            }
            return indexId;
        }

        @NotNull
        public DataIndexer<Integer, T, VcsFullCommitDetails> getIndexer() {
            DataIndexer dataIndexer = this.myIndexer;
            if (dataIndexer == null) {
                MyIndexExtension.$$$reportNull$$$0(3);
            }
            return dataIndexer;
        }

        @NotNull
        public KeyDescriptor<Integer> getKeyDescriptor() {
            EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
            if (enumeratorIntegerDescriptor == null) {
                MyIndexExtension.$$$reportNull$$$0(4);
            }
            return enumeratorIntegerDescriptor;
        }

        @NotNull
        public DataExternalizer<T> getValueExternalizer() {
            DataExternalizer dataExternalizer = this.myExternalizer;
            if (dataExternalizer == null) {
                MyIndexExtension.$$$reportNull$$$0(5);
            }
            return dataExternalizer;
        }

        public int getVersion() {
            return this.myVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalizer";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyDescriptor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueExternalizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyMapIndexStorage<T>
    extends MapIndexStorage<Integer, T> {
        public MyMapIndexStorage(@NotNull String name2, @NotNull String logId, @NotNull DataExternalizer<T> externalizer) throws IOException {
            if (name2 == null) {
                MyMapIndexStorage.$$$reportNull$$$0(0);
            }
            if (logId == null) {
                MyMapIndexStorage.$$$reportNull$$$0(1);
            }
            if (externalizer == null) {
                MyMapIndexStorage.$$$reportNull$$$0(2);
            }
            super(PersistentUtil.getStorageFile(VcsLogFullDetailsIndex.INDEX, name2, logId, VcsLogPersistentIndex.getVersion()), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, externalizer, 5000, false);
        }

        protected void checkCanceled() {
            ProgressManager.checkCanceled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "externalizer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapIndexStorage";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyMapReduceIndex
    extends MapReduceIndex<Integer, T, VcsFullCommitDetails> {
        public MyMapReduceIndex(@NotNull DataIndexer<Integer, T, VcsFullCommitDetails> indexer, DataExternalizer<T> externalizer, int version) throws IOException {
            if (indexer == null) {
                MyMapReduceIndex.$$$reportNull$$$0(0);
            }
            if (externalizer == null) {
                MyMapReduceIndex.$$$reportNull$$$0(1);
            }
            super((IndexExtension)new MyIndexExtension(indexer, externalizer, version), new MyMapIndexStorage(VcsLogFullDetailsIndex.this.myName, VcsLogFullDetailsIndex.this.myLogId, externalizer), new EmptyForwardIndex());
        }

        public void checkCanceled() {
            ProgressManager.checkCanceled();
        }

        public void requestRebuild(@NotNull Throwable ex) {
            if (ex == null) {
                MyMapReduceIndex.$$$reportNull$$$0(2);
            }
            VcsLogFullDetailsIndex.this.myFatalErrorHandler.consume((Object)this, ex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalizer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ex";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapReduceIndex";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestRebuild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

