/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.api.elements;

import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphEdge
implements GraphElement {
    @Nullable
    private final Integer myUpNodeIndex;
    @Nullable
    private final Integer myDownNodeIndex;
    @Nullable
    private final Integer myTargetId;
    @NotNull
    private final GraphEdgeType myType;

    public static GraphEdge createNormalEdge(int nodeIndex1, int nodeIndex2, @NotNull GraphEdgeType type2) {
        if (type2 == null) {
            GraphEdge.$$$reportNull$$$0(0);
        }
        assert (type2.isNormalEdge()) : "Unexpected edge type: " + (Object)((Object)type2);
        return new GraphEdge(Math.min(nodeIndex1, nodeIndex2), Math.max(nodeIndex1, nodeIndex2), null, type2);
    }

    public static GraphEdge createEdgeWithTargetId(int nodeIndex, @Nullable Integer targetId, @NotNull GraphEdgeType type2) {
        if (type2 == null) {
            GraphEdge.$$$reportNull$$$0(1);
        }
        switch (type2) {
            case DOTTED_ARROW_UP: {
                return new GraphEdge(null, nodeIndex, targetId, type2);
            }
            case NOT_LOAD_COMMIT: 
            case DOTTED_ARROW_DOWN: {
                return new GraphEdge(nodeIndex, null, targetId, type2);
            }
        }
        throw new AssertionError((Object)("Unexpected edge type: " + (Object)((Object)type2)));
    }

    public GraphEdge(@Nullable Integer upNodeIndex, @Nullable Integer downNodeIndex, @Nullable Integer targetId, @NotNull GraphEdgeType type2) {
        if (type2 == null) {
            GraphEdge.$$$reportNull$$$0(2);
        }
        this.myUpNodeIndex = upNodeIndex;
        this.myDownNodeIndex = downNodeIndex;
        this.myTargetId = targetId;
        this.myType = type2;
    }

    @Nullable
    public Integer getUpNodeIndex() {
        return this.myUpNodeIndex;
    }

    @Nullable
    public Integer getDownNodeIndex() {
        return this.myDownNodeIndex;
    }

    @Nullable
    public Integer getTargetId() {
        return this.myTargetId;
    }

    @NotNull
    public GraphEdgeType getType() {
        GraphEdgeType graphEdgeType = this.myType;
        if (graphEdgeType == null) {
            GraphEdge.$$$reportNull$$$0(3);
        }
        return graphEdgeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphEdge graphEdge = (GraphEdge)o;
        if (this.myType != graphEdge.myType) {
            return false;
        }
        if (this.myUpNodeIndex != null ? !this.myUpNodeIndex.equals(graphEdge.myUpNodeIndex) : graphEdge.myUpNodeIndex != null) {
            return false;
        }
        if (this.myDownNodeIndex != null ? !this.myDownNodeIndex.equals(graphEdge.myDownNodeIndex) : graphEdge.myDownNodeIndex != null) {
            return false;
        }
        return !(this.myTargetId != null ? !this.myTargetId.equals(graphEdge.myTargetId) : graphEdge.myTargetId != null);
    }

    public int hashCode() {
        int result2 = this.myUpNodeIndex != null ? this.myUpNodeIndex.hashCode() : 0;
        result2 = 31 * result2 + (this.myDownNodeIndex != null ? this.myDownNodeIndex.hashCode() : 0);
        result2 = 31 * result2 + (this.myTargetId != null ? this.myTargetId.hashCode() : 0);
        result2 = 31 * result2 + this.myType.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/api/elements/GraphEdge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/api/elements/GraphEdge";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNormalEdge";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createEdgeWithTargetId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

