/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.collapsing.TreeSetNodeIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentGenerator {
    @NotNull
    private final LiteLinearGraph myGraph;
    @NotNull
    private final Condition<Integer> myRedNodes;

    public FragmentGenerator(@NotNull LiteLinearGraph graph, @NotNull Condition<Integer> redNodes) {
        if (graph == null) {
            FragmentGenerator.$$$reportNull$$$0(0);
        }
        if (redNodes == null) {
            FragmentGenerator.$$$reportNull$$$0(1);
        }
        this.myGraph = graph;
        this.myRedNodes = redNodes;
    }

    @NotNull
    public Set<Integer> getMiddleNodes(int upNode, int downNode, boolean strict) {
        Set<Integer> downWalk = this.getWalkNodes(upNode, false, (Condition<Integer>)((Condition)integer -> integer > downNode));
        Set<Integer> upWalk = this.getWalkNodes(downNode, true, (Condition<Integer>)((Condition)integer -> integer < upNode));
        downWalk.retainAll(upWalk);
        if (strict) {
            downWalk.remove(upNode);
            downWalk.remove(downNode);
        }
        Set<Integer> set2 = downWalk;
        if (set2 == null) {
            FragmentGenerator.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @Nullable
    public Integer getNearRedNode(int startNode, int maxWalkSize, boolean isUp) {
        if (this.myRedNodes.value((Object)startNode)) {
            return startNode;
        }
        TreeSetNodeIterator walker = new TreeSetNodeIterator(startNode, isUp);
        while (walker.notEmpty()) {
            Integer next = walker.pop();
            if (this.myRedNodes.value((Object)next)) {
                return next;
            }
            if (maxWalkSize < 0) {
                return null;
            }
            --maxWalkSize;
            walker.addAll(this.getNodes(next, isUp));
        }
        return null;
    }

    @NotNull
    public GreenFragment getGreenFragmentForCollapse(int startNode, int maxWalkSize) {
        if (this.myRedNodes.value((Object)startNode)) {
            GreenFragment greenFragment = new GreenFragment(null, null, Collections.emptySet());
            if (greenFragment == null) {
                FragmentGenerator.$$$reportNull$$$0(3);
            }
            return greenFragment;
        }
        Integer upRedNode = this.getNearRedNode(startNode, maxWalkSize, true);
        Integer downRedNode = this.getNearRedNode(startNode, maxWalkSize, false);
        Set<Integer> upPart = upRedNode != null ? this.getMiddleNodes(upRedNode, startNode, false) : this.getWalkNodes(startNode, true, FragmentGenerator.createStopFunction(maxWalkSize));
        Set<Integer> downPart = downRedNode != null ? this.getMiddleNodes(startNode, downRedNode, false) : this.getWalkNodes(startNode, false, FragmentGenerator.createStopFunction(maxWalkSize));
        Set middleNodes = ContainerUtil.union(upPart, downPart);
        if (upRedNode != null) {
            middleNodes.remove(upRedNode);
        }
        if (downRedNode != null) {
            middleNodes.remove(downRedNode);
        }
        GreenFragment greenFragment = new GreenFragment(upRedNode, downRedNode, middleNodes);
        if (greenFragment == null) {
            FragmentGenerator.$$$reportNull$$$0(4);
        }
        return greenFragment;
    }

    @NotNull
    private Set<Integer> getWalkNodes(int startNode, boolean isUp, Condition<Integer> stopFunction) {
        HashSet<Integer> walkNodes = new HashSet<Integer>();
        TreeSetNodeIterator walker = new TreeSetNodeIterator(startNode, isUp);
        while (walker.notEmpty()) {
            Integer next = walker.pop();
            if (stopFunction.value((Object)next)) continue;
            walkNodes.add(next);
            walker.addAll(this.getNodes(next, isUp));
        }
        HashSet<Integer> hashSet = walkNodes;
        if (hashSet == null) {
            FragmentGenerator.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    private List<Integer> getNodes(int nodeIndex, boolean isUp) {
        List<Integer> list2 = this.myGraph.getNodes(nodeIndex, LiteLinearGraph.NodeFilter.filter(isUp));
        if (list2 == null) {
            FragmentGenerator.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    private static Condition<Integer> createStopFunction(final int maxNodeCount) {
        Condition<Integer> condition2 = new Condition<Integer>(){
            private int count;
            {
                this.count = maxNodeCount;
            }

            public boolean value(Integer integer) {
                --this.count;
                return this.count < 0;
            }
        };
        if (condition2 == null) {
            FragmentGenerator.$$$reportNull$$$0(7);
        }
        return condition2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "redNodes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/FragmentGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/FragmentGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMiddleNodes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGreenFragmentForCollapse";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWalkNodes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createStopFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GreenFragment {
        @Nullable
        private final Integer myUpRedNode;
        @Nullable
        private final Integer myDownRedNode;
        @NotNull
        private final Set<Integer> myMiddleGreenNodes;

        private GreenFragment(@Nullable Integer upRedNode, @Nullable Integer downRedNode, @NotNull Set<Integer> middleGreenNodes) {
            if (middleGreenNodes == null) {
                GreenFragment.$$$reportNull$$$0(0);
            }
            this.myUpRedNode = upRedNode;
            this.myDownRedNode = downRedNode;
            this.myMiddleGreenNodes = middleGreenNodes;
        }

        @Nullable
        public Integer getUpRedNode() {
            return this.myUpRedNode;
        }

        @Nullable
        public Integer getDownRedNode() {
            return this.myDownRedNode;
        }

        @NotNull
        public Set<Integer> getMiddleGreenNodes() {
            Set<Integer> set2 = this.myMiddleGreenNodes;
            if (set2 == null) {
                GreenFragment.$$$reportNull$$$0(1);
            }
            return set2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "middleGreenNodes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/FragmentGenerator$GreenFragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/FragmentGenerator$GreenFragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMiddleGreenNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

