/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeavyAwareExecutor
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExecutingHeavyOrPowerSaveListener myListener;
    private final int myLongActivityDurationMs;

    public HeavyAwareExecutor(@NotNull Project project2, int delayMs, int longActivityDurationMs, @NotNull Disposable parent) {
        if (project2 == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myLongActivityDurationMs = longActivityDurationMs;
        this.myListener = new ExecutingHeavyOrPowerSaveListener(project2, delayMs, this);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void executeOutOfHeavyOrPowerSave(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator indicator) {
        if (task == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(3);
        }
        this.myListener.addTask(() -> {
            if (task == null) {
                HeavyAwareExecutor.$$$reportNull$$$0(7);
            }
            if (indicator == null) {
                HeavyAwareExecutor.$$$reportNull$$$0(8);
            }
            Disposable disposable = Disposer.newDisposable();
            ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task, indicator, () -> Disposer.dispose((Disposable)disposable));
            new CancellingOnHeavyOrPowerSaveListener(this.myProject, indicator, this.myLongActivityDurationMs, disposable);
        });
    }

    public void dispose() {
    }

    public static void executeOutOfHeavyProcessLater(@NotNull Runnable command, int delayMs) {
        if (command == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(4);
        }
        HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> {
            if (command == null) {
                HeavyAwareExecutor.$$$reportNull$$$0(5);
            }
            JobScheduler.getScheduler().schedule(() -> {
                if (command == null) {
                    HeavyAwareExecutor.$$$reportNull$$$0(6);
                }
                if (HeavyProcessLatch.INSTANCE.isRunning()) {
                    HeavyAwareExecutor.executeOutOfHeavyProcessLater(command, delayMs);
                } else {
                    command.run();
                }
            }, (long)delayMs, TimeUnit.MILLISECONDS);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/impl/HeavyAwareExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeOutOfHeavyOrPowerSave";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "executeOutOfHeavyProcessLater";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$executeOutOfHeavyProcessLater$3";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$executeOutOfHeavyOrPowerSave$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExecutingHeavyOrPowerSaveListener
    implements PowerSaveMode.Listener {
        @NotNull
        private final AtomicReference<List<Runnable>> myTasksToRun;
        private final int myDelayMs;

        public ExecutingHeavyOrPowerSaveListener(@NotNull Project project2, int delayMs, @NotNull Disposable parent) {
            if (project2 == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(1);
            }
            this.myTasksToRun = new AtomicReference<ArrayList>(ContainerUtil.newArrayList());
            this.myDelayMs = delayMs;
            project2.getMessageBus().connect(parent).subscribe(PowerSaveMode.TOPIC, (Object)this);
        }

        public void addTask(@NotNull Runnable task) {
            if (task == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(2);
            }
            this.myTasksToRun.getAndUpdate(tasks -> {
                if (task == null) {
                    ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(3);
                }
                return ContainerUtil.concat((List)tasks, Collections.singletonList(task));
            });
            this.tryRun();
        }

        public void powerSaveStateChanged() {
            this.tryRun();
        }

        private void tryRun() {
            if (!PowerSaveMode.isEnabled()) {
                HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> JobScheduler.getScheduler().schedule(() -> {
                    if (!HeavyProcessLatch.INSTANCE.isRunning() && !PowerSaveMode.isEnabled()) {
                        List<Runnable> tasks = this.myTasksToRun.getAndSet(ContainerUtil.newArrayList());
                        tasks.forEach(Runnable::run);
                    } else {
                        this.tryRun();
                    }
                }, (long)this.myDelayMs, TimeUnit.MILLISECONDS));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/HeavyAwareExecutor$ExecutingHeavyOrPowerSaveListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addTask";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$addTask$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CancellingOnHeavyOrPowerSaveListener
    implements HeavyProcessLatch.HeavyProcessListener,
    PowerSaveMode.Listener {
        @NotNull
        private final ProgressIndicator myIndicator;
        private final int myLongActivityDurationMs;
        @Nullable
        private ScheduledFuture<?> myFuture;

        public CancellingOnHeavyOrPowerSaveListener(@NotNull Project project2, @NotNull ProgressIndicator indicator, int logActivityDurationMs, @NotNull Disposable disposable) {
            if (project2 == null) {
                CancellingOnHeavyOrPowerSaveListener.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                CancellingOnHeavyOrPowerSaveListener.$$$reportNull$$$0(1);
            }
            if (disposable == null) {
                CancellingOnHeavyOrPowerSaveListener.$$$reportNull$$$0(2);
            }
            this.myFuture = null;
            this.myIndicator = indicator;
            this.myLongActivityDurationMs = logActivityDurationMs;
            HeavyProcessLatch.INSTANCE.addListener((HeavyProcessLatch.HeavyProcessListener)this, disposable);
            project2.getMessageBus().connect(disposable).subscribe(PowerSaveMode.TOPIC, (Object)this);
            this.scheduleCancel();
            this.powerSaveStateChanged();
        }

        public void processStarted() {
            this.scheduleCancel();
        }

        public void processFinished() {
            this.doNotCancel();
        }

        public void powerSaveStateChanged() {
            if (PowerSaveMode.isEnabled() && this.myIndicator.isRunning()) {
                this.myIndicator.cancel();
            }
        }

        private synchronized void scheduleCancel() {
            if (HeavyProcessLatch.INSTANCE.isRunning() && this.myFuture == null) {
                this.myFuture = JobScheduler.getScheduler().schedule(() -> {
                    if (HeavyProcessLatch.INSTANCE.isRunning() && this.myIndicator.isRunning()) {
                        this.myIndicator.cancel();
                    }
                }, (long)this.myLongActivityDurationMs, TimeUnit.MILLISECONDS);
            }
        }

        private synchronized void doNotCancel() {
            if (!HeavyProcessLatch.INSTANCE.isRunning() && this.myFuture != null) {
                ScheduledFuture<?> future2 = this.myFuture;
                this.myFuture = null;
                future2.cancel(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "disposable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/impl/HeavyAwareExecutor$CancellingOnHeavyOrPowerSaveListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

